/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import drill.shaded.hbase.guava.com.google.common.base.Predicate;
import drill.shaded.hbase.guava.com.google.common.collect.Iterables;
import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.BaseMasterObserver;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestEnableTableHandler {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestEnableTableHandler.class);
    private static final byte[] FAMILYNAME = Bytes.toBytes("fam");

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.getConfiguration().set("hbase.balancer.tablesOnMaster", "hbase:meta");
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.metahandler.count", 10);
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.master.classes", MasterSyncObserver.class.getName());
        TEST_UTIL.startMiniCluster(1);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=300000L)
    public void testEnableTableWithNoRegionServers() throws Exception {
        TableName tableName = TableName.valueOf("testEnableTableWithNoRegionServers");
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster m = cluster.getMaster();
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILYNAME));
        admin.createTable(desc);
        admin.disableTable(tableName);
        TEST_UTIL.waitTableDisabled(tableName.getName());
        admin.enableTable(tableName);
        TEST_UTIL.waitTableEnabled(tableName);
        admin.disableTable(tableName);
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        JVMClusterUtil.RegionServerThread rs = cluster.getRegionServerThreads().get(0);
        rs.getRegionServer().stop("stop");
        cluster.waitForRegionServerToStop(rs.getRegionServer().getServerName(), 10000L);
        TEST_UTIL.waitUntilAllRegionsAssigned(TableName.META_TABLE_NAME);
        LOG.debug((Object)("Now enabling table " + tableName));
        admin.enableTable(tableName);
        Assert.assertTrue((boolean)admin.isTableEnabled(tableName));
        JVMClusterUtil.RegionServerThread rs2 = cluster.startRegionServer();
        LOG.info((Object)("Started new regionserver " + rs2.getRegionServer().getServerName()));
        cluster.waitForRegionServerToStart(rs2.getRegionServer().getServerName().getHostname(), rs2.getRegionServer().getServerName().getPort(), 60000L);
        List<HRegionInfo> regions = TEST_UTIL.getHBaseAdmin().getTableRegions(tableName);
        Assert.assertEquals((long)1L, (long)regions.size());
        for (HRegionInfo hRegionInfo : regions) {
            TEST_UTIL.getHBaseAdmin().assign(hRegionInfo.getEncodedNameAsBytes());
        }
        LOG.debug((Object)("Waiting for table assigned " + tableName));
        TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
        List<HRegionInfo> onlineRegions = admin.getOnlineRegions(rs2.getRegionServer().getServerName());
        for (HRegionInfo hri : onlineRegions) {
            LOG.info((Object)("Online " + hri));
        }
        ArrayList<HRegionInfo> arrayList = this.filterTableRegions(tableName, onlineRegions);
        Assert.assertEquals((long)1L, (long)arrayList.size());
    }

    private ArrayList<HRegionInfo> filterTableRegions(final TableName tableName, List<HRegionInfo> onlineRegions) {
        return Lists.newArrayList(Iterables.filter(onlineRegions, new Predicate<HRegionInfo>(){

            @Override
            public boolean apply(HRegionInfo input) {
                return input.getTable().equals(tableName);
            }
        }));
    }

    @Test(timeout=300000L)
    public void testDisableTableAndRestart() throws Exception {
        TableName tableName = TableName.valueOf("testDisableTableAndRestart");
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILYNAME));
        admin.createTable(desc);
        admin.disableTable(tableName);
        TEST_UTIL.waitTableDisabled(tableName.getName());
        TEST_UTIL.getHBaseCluster().shutdown();
        TEST_UTIL.getHBaseCluster().waitUntilShutDown();
        TEST_UTIL.restartHBaseCluster(2);
        admin.enableTable(tableName);
        TEST_UTIL.waitTableEnabled(tableName);
    }

    @Test(timeout=60000L)
    public void testDeleteForSureClearsAllTableRowsFromMeta() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf("testDeleteForSureClearsAllTableRowsFromMeta");
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILYNAME));
        try {
            TestEnableTableHandler.createTable(TEST_UTIL, desc, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Got an exception while creating " + tableName));
        }
        try (Table metaTable = TEST_UTIL.getConnection().getTable(TableName.META_TABLE_NAME);){
            Object object;
            try (ResultScanner scanner = metaTable.getScanner(MetaTableAccessor.getScanForTableName(tableName));){
                object = scanner.iterator();
                if (object.hasNext()) {
                    Result result = (Result)object.next();
                    Delete d = new Delete(result.getRow());
                    d.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                    LOG.info((Object)("Mangled: " + d));
                    metaTable.delete(d);
                }
            }
            admin.disableTable(tableName);
            TEST_UTIL.waitTableDisabled(tableName.getName());
            try {
                TestEnableTableHandler.deleteTable(TEST_UTIL, tableName);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Got an exception while deleting " + tableName));
            }
            int rowCount = 0;
            ResultScanner scanner = metaTable.getScanner(MetaTableAccessor.getScanForTableName(tableName));
            object = null;
            try {
                for (Result result : scanner) {
                    LOG.info((Object)("Found when none expected: " + result));
                    ++rowCount;
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (scanner != null) {
                    if (object != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
            Assert.assertEquals((long)0L, (long)rowCount);
        }
    }

    public static void createTable(HBaseTestingUtility testUtil, HTableDescriptor htd, byte[][] splitKeys) throws Exception {
        TestEnableTableHandler.createTable(testUtil, testUtil.getHBaseAdmin(), htd, splitKeys);
    }

    public static void createTable(HBaseTestingUtility testUtil, HBaseAdmin admin, HTableDescriptor htd, byte[][] splitKeys) throws Exception {
        MasterSyncObserver observer = (MasterSyncObserver)testUtil.getHBaseCluster().getMaster().getMasterCoprocessorHost().findCoprocessor(MasterSyncObserver.class.getName());
        observer.tableCreationLatch = new CountDownLatch(1);
        if (splitKeys != null) {
            admin.createTable(htd, splitKeys);
        } else {
            admin.createTable(htd);
        }
        observer.tableCreationLatch.await();
        observer.tableCreationLatch = null;
        testUtil.waitUntilAllRegionsAssigned(htd.getTableName());
    }

    public static void deleteTable(HBaseTestingUtility testUtil, TableName tableName) throws Exception {
        TestEnableTableHandler.deleteTable(testUtil, testUtil.getHBaseAdmin(), tableName);
    }

    public static void deleteTable(HBaseTestingUtility testUtil, HBaseAdmin admin, TableName tableName) throws Exception {
        MasterSyncObserver observer = (MasterSyncObserver)testUtil.getHBaseCluster().getMaster().getMasterCoprocessorHost().findCoprocessor(MasterSyncObserver.class.getName());
        observer.tableDeletionLatch = new CountDownLatch(1);
        try {
            admin.disableTable(tableName);
        }
        catch (Exception e) {
            LOG.debug((Object)("Table: " + tableName + " already disabled, so just deleting it."));
        }
        admin.deleteTable(tableName);
        observer.tableDeletionLatch.await();
        observer.tableDeletionLatch = null;
    }

    public static class MasterSyncObserver
    extends BaseMasterObserver {
        volatile CountDownLatch tableCreationLatch = null;
        volatile CountDownLatch tableDeletionLatch = null;

        @Override
        public void postCreateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
            if (this.tableCreationLatch != null) {
                this.tableCreationLatch.countDown();
            }
        }

        @Override
        public void postDeleteTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
            if (this.tableDeletionLatch != null) {
                this.tableDeletionLatch.countDown();
            }
        }
    }
}

