/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.balancer.MetricsBalancerSourceImpl;
import org.apache.hadoop.hbase.master.balancer.MetricsStochasticBalancerSource;
import org.apache.hadoop.hbase.metrics.Interns;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;

@InterfaceAudience.Private
public class MetricsStochasticBalancerSourceImpl
extends MetricsBalancerSourceImpl
implements MetricsStochasticBalancerSource {
    private static final String TABLE_FUNCTION_SEP = "_";
    private static final float MRU_LOAD_FACTOR = 0.75f;
    private int metricsSize = 1000;
    private int mruCap = MetricsStochasticBalancerSourceImpl.calcMruCap(this.metricsSize);
    private Map<String, Map<String, Double>> stochasticCosts = new LinkedHashMap<String, Map<String, Double>>(this.mruCap, 0.75f, true){
        private static final long serialVersionUID = 8204713453436906599L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Map<String, Double>> eldest) {
            return this.size() > MetricsStochasticBalancerSourceImpl.this.mruCap;
        }
    };
    private Map<String, String> costFunctionDescs = new ConcurrentHashMap<String, String>();

    private static int calcMruCap(int metricsSize) {
        return (int)Math.ceil((float)metricsSize / 0.75f) + 1;
    }

    @Override
    public void updateMetricsSize(int size) {
        if (size > 0) {
            this.metricsSize = size;
            this.mruCap = MetricsStochasticBalancerSourceImpl.calcMruCap(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStochasticCost(String tableName, String costFunctionName, String functionDesc, Double cost) {
        if (tableName == null || costFunctionName == null || cost == null) {
            return;
        }
        if (functionDesc != null) {
            this.costFunctionDescs.put(costFunctionName, functionDesc);
        }
        Map<String, Map<String, Double>> map = this.stochasticCosts;
        synchronized (map) {
            Map<String, Double> costs = this.stochasticCosts.get(tableName);
            if (costs == null) {
                costs = new ConcurrentHashMap<String, Double>();
            }
            costs.put(costFunctionName, cost);
            this.stochasticCosts.put(tableName, costs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder metricsRecordBuilder = metricsCollector.addRecord(this.metricsName);
        if (this.stochasticCosts != null) {
            Map<String, Map<String, Double>> map = this.stochasticCosts;
            synchronized (map) {
                for (Map.Entry<String, Map<String, Double>> tableEntry : this.stochasticCosts.entrySet()) {
                    for (Map.Entry<String, Double> costEntry : tableEntry.getValue().entrySet()) {
                        String attrName = tableEntry.getKey() + TABLE_FUNCTION_SEP + costEntry.getKey();
                        Double cost = costEntry.getValue();
                        String functionDesc = this.costFunctionDescs.get(costEntry.getKey());
                        if (functionDesc == null) {
                            functionDesc = costEntry.getKey();
                        }
                        metricsRecordBuilder.addGauge(Interns.info(attrName, functionDesc), cost.doubleValue());
                    }
                }
            }
        }
        this.metricsRegistry.snapshot(metricsRecordBuilder, all);
    }
}

