/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestMasterFailoverBalancerPersistence {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static MiniHBaseCluster cluster;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(4, 1);
        cluster = TEST_UTIL.getHBaseCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=240000L)
    public void testMasterFailoverBalancerPersistence() throws Exception {
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        HMaster active = cluster.getMaster();
        ClusterStatus clusterStatus = active.getClusterStatus();
        Assert.assertTrue((boolean)clusterStatus.isBalancerOn());
        active = this.killActiveAndWaitForNewActive(cluster);
        clusterStatus = active.getClusterStatus();
        Assert.assertTrue((boolean)clusterStatus.isBalancerOn());
        active.balanceSwitch(false);
        active = this.killActiveAndWaitForNewActive(cluster);
        clusterStatus = active.getClusterStatus();
        Assert.assertFalse((boolean)clusterStatus.isBalancerOn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testReadReplicaMappingAfterMasterFailover() throws Exception {
        byte[] FAMILY = Bytes.toBytes("testFamily");
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        HMaster active = cluster.getMaster();
        TableName tableName = TableName.valueOf("testReadReplicaMappingAfterMasterFailover");
        HTableDescriptor hdt = TEST_UTIL.createTableDescriptor(tableName.getNameAsString());
        hdt.setRegionReplication(2);
        HTable ht = null;
        try {
            ht = TEST_UTIL.createTable(hdt, (byte[][])new byte[][]{FAMILY}, TEST_UTIL.getConfiguration());
            RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
            List<HRegionLocation> allRegionLocations = locator.getAllRegionLocations();
            Assert.assertTrue((allRegionLocations.size() == 2 ? 1 : 0) != 0);
            ArrayList<HRegionInfo> parentRegion = new ArrayList<HRegionInfo>();
            parentRegion.add(allRegionLocations.get(0).getRegionInfo());
            Map<ServerName, List<HRegionInfo>> currentAssign = active.getAssignmentManager().getRegionStates().getRegionAssignments(parentRegion);
            Collection<List<HRegionInfo>> c = currentAssign.values();
            int count = 0;
            for (List<HRegionInfo> l : c) {
                count += l.size();
            }
            Assert.assertEquals((long)2L, (long)count);
            active = this.killActiveAndWaitForNewActive(cluster);
            Map<ServerName, List<HRegionInfo>> currentAssignNew = active.getAssignmentManager().getRegionStates().getRegionAssignments(parentRegion);
            Collection<List<HRegionInfo>> cNew = currentAssignNew.values();
            count = 0;
            for (List<HRegionInfo> l : cNew) {
                count += l.size();
            }
            Assert.assertEquals((long)2L, (long)count);
        }
        finally {
            if (ht != null) {
                TEST_UTIL.deleteTable(tableName.getName());
            }
        }
    }

    private HMaster killActiveAndWaitForNewActive(MiniHBaseCluster cluster) throws InterruptedException, IOException {
        int activeIndex = this.getActiveMasterIndex(cluster);
        HMaster active = cluster.getMaster();
        cluster.stopMaster(activeIndex);
        cluster.waitOnMaster(activeIndex);
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        HMaster newActive = cluster.getMaster();
        Assert.assertFalse((active == newActive ? 1 : 0) != 0);
        return newActive;
    }

    private int getActiveMasterIndex(MiniHBaseCluster cluster) throws MasterNotRunningException {
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        for (int i = 0; i < masterThreads.size(); ++i) {
            if (!masterThreads.get(i).getMaster().isActiveMaster()) continue;
            return i;
        }
        throw new MasterNotRunningException();
    }
}

