/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import drill.shaded.hbase.guava.com.google.common.collect.ImmutableList;
import drill.shaded.hbase.guava.com.google.common.collect.ImmutableMap;
import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import drill.shaded.hbase.guava.com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.MultiTableSnapshotInputFormatImpl;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Objects;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestMultiTableSnapshotInputFormatImpl {
    private MultiTableSnapshotInputFormatImpl subject;
    private Map<String, Collection<Scan>> snapshotScans;
    private Path restoreDir;
    private Configuration conf;
    private Path rootDir;

    @Before
    public void setUp() throws Exception {
        this.subject = (MultiTableSnapshotInputFormatImpl)Mockito.spy((Object)new MultiTableSnapshotInputFormatImpl());
        ((MultiTableSnapshotInputFormatImpl)Mockito.doNothing().when((Object)this.subject)).restoreSnapshot((Configuration)Matchers.any(Configuration.class), (String)Matchers.any(String.class), (Path)Matchers.any(Path.class), (Path)Matchers.any(Path.class), (FileSystem)Matchers.any(FileSystem.class));
        this.conf = new Configuration();
        this.rootDir = new Path("file:///test-root-dir");
        FSUtils.setRootDir(this.conf, this.rootDir);
        this.snapshotScans = ImmutableMap.of("snapshot1", ImmutableList.of(new Scan(Bytes.toBytes("1"), Bytes.toBytes("2"))), "snapshot2", ImmutableList.of(new Scan(Bytes.toBytes("3"), Bytes.toBytes("4")), new Scan(Bytes.toBytes("5"), Bytes.toBytes("6"))));
        this.restoreDir = new Path(FSUtils.getRootDir(this.conf), "restore-dir");
    }

    public void callSetInput() throws IOException {
        this.subject.setInput(this.conf, this.snapshotScans, this.restoreDir);
    }

    public Map<String, Collection<ScanWithEquals>> toScanWithEquals(Map<String, Collection<Scan>> snapshotScans) throws IOException {
        HashMap<String, Collection<ScanWithEquals>> rtn = Maps.newHashMap();
        for (Map.Entry<String, Collection<Scan>> entry : snapshotScans.entrySet()) {
            ArrayList<ScanWithEquals> scans = Lists.newArrayList();
            for (Scan scan : entry.getValue()) {
                scans.add(new ScanWithEquals(scan));
            }
            rtn.put(entry.getKey(), scans);
        }
        return rtn;
    }

    @Test
    public void testSetInputSetsSnapshotToScans() throws Exception {
        this.callSetInput();
        Map<String, Collection<Scan>> actual = this.subject.getSnapshotsToScans(this.conf);
        Map<String, Collection<ScanWithEquals>> actualWithEquals = this.toScanWithEquals(actual);
        Map<String, Collection<ScanWithEquals>> expectedWithEquals = this.toScanWithEquals(this.snapshotScans);
        Assert.assertEquals(expectedWithEquals, actualWithEquals);
    }

    @Test
    public void testSetInputPushesRestoreDirectories() throws Exception {
        this.callSetInput();
        Map<String, Path> restoreDirs = this.subject.getSnapshotDirs(this.conf);
        Assert.assertEquals(this.snapshotScans.keySet(), restoreDirs.keySet());
    }

    @Test
    public void testSetInputCreatesRestoreDirectoriesUnderRootRestoreDir() throws Exception {
        this.callSetInput();
        Map<String, Path> restoreDirs = this.subject.getSnapshotDirs(this.conf);
        for (Path snapshotDir : restoreDirs.values()) {
            Assert.assertEquals((String)("Expected " + snapshotDir + " to be a child of " + this.restoreDir), (Object)this.restoreDir, (Object)snapshotDir.getParent());
        }
    }

    @Test
    public void testSetInputRestoresSnapshots() throws Exception {
        this.callSetInput();
        Map<String, Path> snapshotDirs = this.subject.getSnapshotDirs(this.conf);
        for (Map.Entry<String, Path> entry : snapshotDirs.entrySet()) {
            ((MultiTableSnapshotInputFormatImpl)Mockito.verify((Object)this.subject)).restoreSnapshot((Configuration)Matchers.eq((Object)this.conf), (String)Matchers.eq((Object)entry.getKey()), (Path)Matchers.eq((Object)this.rootDir), (Path)Matchers.eq((Object)entry.getValue()), (FileSystem)Matchers.any(FileSystem.class));
        }
    }

    public static class ScanWithEquals {
        private final String startRow;
        private final String stopRow;

        public ScanWithEquals(Scan scan) throws IOException {
            this.startRow = Bytes.toStringBinary(scan.getStartRow());
            this.stopRow = Bytes.toStringBinary(scan.getStopRow());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.startRow == null ? 0 : this.startRow.hashCode());
            result = 31 * result + (this.stopRow == null ? 0 : this.stopRow.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScanWithEquals other = (ScanWithEquals)obj;
            if (this.startRow == null ? other.startRow != null : !this.startRow.equals(other.startRow)) {
                return false;
            }
            return !(this.stopRow == null ? other.stopRow != null : !this.stopRow.equals(other.stopRow));
        }

        public String toString() {
            return Objects.toStringHelper(this).add("startRow", this.startRow).add("stopRow", this.stopRow).toString();
        }
    }
}

