/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.mapreduce.ImportTsv;
import org.apache.hadoop.hbase.mapreduce.TextSortReducer;
import org.apache.hadoop.hbase.mapreduce.TsvImporterTextMapper;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={LargeTests.class})
public class TestImportTsv
implements Configurable {
    private static final Log LOG = LogFactory.getLog(TestImportTsv.class);
    protected static final String NAME = TestImportTsv.class.getSimpleName();
    protected static HBaseTestingUtility util = new HBaseTestingUtility();
    protected static final String DELETE_AFTER_LOAD_CONF = NAME + ".deleteAfterLoad";
    protected static final String FORCE_COMBINER_CONF = NAME + ".forceCombiner";
    private final String FAMILY = "FAM";
    private String table;
    private Map<String, String> args;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    public Configuration getConf() {
        return util.getConfiguration();
    }

    public void setConf(Configuration conf) {
        throw new IllegalArgumentException("setConf not supported");
    }

    @BeforeClass
    public static void provisionCluster() throws Exception {
        util.setJobWithoutMRCluster();
        util.startMiniCluster();
    }

    @AfterClass
    public static void releaseCluster() throws Exception {
        util.shutdownMiniCluster();
    }

    @Before
    public void setup() throws Exception {
        this.table = "test-" + UUID.randomUUID();
        this.args = new HashMap<String, String>();
        this.args.put("importtsv.columns", "HBASE_ROW_KEY,FAM:A,FAM:B");
        this.args.put("importtsv.separator", "\u001b");
    }

    @Test
    public void testMROnTable() throws Exception {
        util.createTable(TableName.valueOf(this.table), "FAM");
        this.doMROnTableTest(null, 1);
        util.deleteTable(this.table);
    }

    @Test
    public void testMROnTableWithTimestamp() throws Exception {
        util.createTable(TableName.valueOf(this.table), "FAM");
        this.args.put("importtsv.columns", "HBASE_ROW_KEY,HBASE_TS_KEY,FAM:A,FAM:B");
        this.args.put("importtsv.separator", ",");
        String data = "KEY,1234,VALUE1,VALUE2\n";
        this.doMROnTableTest(data, 1);
        util.deleteTable(this.table);
    }

    @Test
    public void testMROnTableWithCustomMapper() throws Exception {
        util.createTable(TableName.valueOf(this.table), "FAM");
        this.args.put("importtsv.mapper.class", "org.apache.hadoop.hbase.mapreduce.TsvImporterCustomTestMapper");
        this.doMROnTableTest(null, 3);
        util.deleteTable(this.table);
    }

    @Test
    public void testBulkOutputWithoutAnExistingTable() throws Exception {
        Path hfiles = new Path(util.getDataTestDirOnTestFS(this.table), "hfiles");
        this.args.put("importtsv.bulk.output", hfiles.toString());
        this.doMROnTableTest(null, 3);
        util.deleteTable(this.table);
    }

    @Test
    public void testBulkOutputWithAnExistingTable() throws Exception {
        util.createTable(TableName.valueOf(this.table), "FAM");
        Path hfiles = new Path(util.getDataTestDirOnTestFS(this.table), "hfiles");
        this.args.put("importtsv.bulk.output", hfiles.toString());
        this.doMROnTableTest(null, 3);
        util.deleteTable(this.table);
    }

    @Test
    public void testBulkOutputWithAnExistingTableNoStrictTrue() throws Exception {
        util.createTable(TableName.valueOf(this.table), "FAM");
        Path hfiles = new Path(util.getDataTestDirOnTestFS(this.table), "hfiles");
        this.args.put("importtsv.bulk.output", hfiles.toString());
        this.args.put("no.strict", "true");
        this.doMROnTableTest(null, 3);
        util.deleteTable(this.table);
    }

    @Test
    public void testJobConfigurationsWithTsvImporterTextMapper() throws Exception {
        Path bulkOutputPath = new Path(util.getDataTestDirOnTestFS(this.table), "hfiles");
        String INPUT_FILE = "InputFile1.csv";
        String[] args = new String[]{"-Dimporttsv.mapper.class=org.apache.hadoop.hbase.mapreduce.TsvImporterTextMapper", "-Dimporttsv.columns=HBASE_ROW_KEY,FAM:A,FAM:B", "-Dimporttsv.separator=,", "-Dimporttsv.bulk.output=" + bulkOutputPath.toString(), this.table, INPUT_FILE};
        Configuration conf = new Configuration(util.getConfiguration());
        GenericOptionsParser opts = new GenericOptionsParser(conf, args);
        args = opts.getRemainingArgs();
        Assert.assertEquals((String)"running test job configuration failed.", (long)0L, (long)ToolRunner.run((Configuration)conf, (Tool)new ImportTsv(){

            @Override
            public int run(String[] args) throws Exception {
                Job job = 1.createSubmittableJob(this.getConf(), args);
                Assert.assertTrue((boolean)job.getMapperClass().equals(TsvImporterTextMapper.class));
                Assert.assertTrue((boolean)job.getReducerClass().equals(TextSortReducer.class));
                Assert.assertTrue((boolean)job.getMapOutputValueClass().equals(Text.class));
                return 0;
            }
        }, (String[])args));
        util.deleteTable(this.table);
    }

    @Test
    public void testBulkOutputWithTsvImporterTextMapper() throws Exception {
        Path bulkOutputPath = new Path(util.getDataTestDirOnTestFS(this.table), "hfiles");
        this.args.put("importtsv.mapper.class", "org.apache.hadoop.hbase.mapreduce.TsvImporterTextMapper");
        this.args.put("importtsv.bulk.output", bulkOutputPath.toString());
        String data = "KEY\u001bVALUE4\u001bVALUE8\n";
        this.doMROnTableTest(data, 4);
        util.deleteTable(this.table);
    }

    @Test
    public void testWithoutAnExistingTableAndCreateTableSetToNo() throws Exception {
        String[] args = new String[]{this.table, "/inputFile"};
        Configuration conf = new Configuration(util.getConfiguration());
        conf.set("importtsv.columns", "HBASE_ROW_KEY,FAM:A");
        conf.set("importtsv.bulk.output", "/output");
        conf.set("create.table", "no");
        this.exception.expect(TableNotFoundException.class);
        Assert.assertEquals((String)"running test job configuration failed.", (long)0L, (long)ToolRunner.run((Configuration)conf, (Tool)new ImportTsv(){

            @Override
            public int run(String[] args) throws Exception {
                2.createSubmittableJob(this.getConf(), args);
                return 0;
            }
        }, (String[])args));
    }

    @Test
    public void testMRWithoutAnExistingTable() throws Exception {
        String[] args = new String[]{this.table, "/inputFile"};
        this.exception.expect(TableNotFoundException.class);
        Assert.assertEquals((String)"running test job configuration failed.", (long)0L, (long)ToolRunner.run((Configuration)new Configuration(util.getConfiguration()), (Tool)new ImportTsv(){

            @Override
            public int run(String[] args) throws Exception {
                3.createSubmittableJob(this.getConf(), args);
                return 0;
            }
        }, (String[])args));
    }

    @Test
    public void testJobConfigurationsWithDryMode() throws Exception {
        Path bulkOutputPath = new Path(util.getDataTestDirOnTestFS(this.table), "hfiles");
        String INPUT_FILE = "InputFile1.csv";
        String[] argsArray = new String[]{"-Dimporttsv.columns=HBASE_ROW_KEY,FAM:A,FAM:B", "-Dimporttsv.separator=,", "-Dimporttsv.bulk.output=" + bulkOutputPath.toString(), "-Dimporttsv.dry.run=true", this.table, INPUT_FILE};
        Assert.assertEquals((String)"running test job configuration failed.", (long)0L, (long)ToolRunner.run((Configuration)new Configuration(util.getConfiguration()), (Tool)new ImportTsv(){

            @Override
            public int run(String[] args) throws Exception {
                Job job = 4.createSubmittableJob(this.getConf(), args);
                Assert.assertTrue((boolean)job.getOutputFormatClass().equals(NullOutputFormat.class));
                return 0;
            }
        }, (String[])argsArray));
        util.deleteTable(this.table);
    }

    @Test
    public void testDryModeWithoutBulkOutputAndTableExists() throws Exception {
        util.createTable(TableName.valueOf(this.table), "FAM");
        this.args.put("importtsv.dry.run", "true");
        this.doMROnTableTest(null, 1);
        util.deleteTable(this.table);
    }

    @Test
    public void testDryModeWithoutBulkOutputAndTableDoesNotExists() throws Exception {
        this.args.put("importtsv.dry.run", "true");
        this.exception.expect(TableNotFoundException.class);
        this.doMROnTableTest(null, 1);
    }

    @Test
    public void testDryModeWithBulkOutputAndTableExists() throws Exception {
        util.createTable(TableName.valueOf(this.table), "FAM");
        Path hfiles = new Path(util.getDataTestDirOnTestFS(this.table), "hfiles");
        this.args.put("importtsv.bulk.output", hfiles.toString());
        this.args.put("importtsv.dry.run", "true");
        this.doMROnTableTest(null, 1);
        util.deleteTable(this.table);
    }

    @Test
    public void testDryModeWithBulkOutputAndTableDoesNotExistsCreateTableSetToNo() throws Exception {
        Path hfiles = new Path(util.getDataTestDirOnTestFS(this.table), "hfiles");
        this.args.put("importtsv.bulk.output", hfiles.toString());
        this.args.put("importtsv.dry.run", "true");
        this.args.put("create.table", "no");
        this.exception.expect(TableNotFoundException.class);
        this.doMROnTableTest(null, 1);
    }

    @Test
    public void testDryModeWithBulkModeAndTableDoesNotExistsCreateTableSetToYes() throws Exception {
        Path hfiles = new Path(util.getDataTestDirOnTestFS(this.table), "hfiles");
        this.args.put("importtsv.bulk.output", hfiles.toString());
        this.args.put("importtsv.dry.run", "true");
        this.args.put("create.table", "yes");
        this.doMROnTableTest(null, 1);
        this.exception.expect(TableNotFoundException.class);
        util.deleteTable(this.table);
    }

    @Test
    public void testTsvImporterTextMapperWithInvalidData() throws Exception {
        Path bulkOutputPath = new Path(util.getDataTestDirOnTestFS(this.table), "hfiles");
        this.args.put("importtsv.mapper.class", "org.apache.hadoop.hbase.mapreduce.TsvImporterTextMapper");
        this.args.put("importtsv.bulk.output", bulkOutputPath.toString());
        this.args.put("importtsv.columns", "HBASE_ROW_KEY,HBASE_TS_KEY,FAM:A,FAM:B");
        this.args.put("importtsv.separator", ",");
        String data = "KEY,1234,VALUE1,VALUE2\nKEY\nKEY,1235,VALUE1,VALUE2\n";
        this.doMROnTableTest(data, 1, 4);
        util.deleteTable(this.table);
    }

    @Test
    public void testSkipEmptyColumns() throws Exception {
        Path bulkOutputPath = new Path(util.getDataTestDirOnTestFS(this.table), "hfiles");
        this.args.put("importtsv.bulk.output", bulkOutputPath.toString());
        this.args.put("importtsv.columns", "HBASE_ROW_KEY,HBASE_TS_KEY,FAM:A,FAM:B");
        this.args.put("importtsv.separator", ",");
        this.args.put("importtsv.skip.empty.columns", "true");
        String data = "KEY,1234,VALUE1,VALUE2\nKEY,1235,,VALUE2\n";
        TestImportTsv.doMROnTableTest(util, this.table, "FAM", data, this.args, 1, 3);
        util.deleteTable(this.table);
    }

    private Tool doMROnTableTest(String data, int valueMultiplier, int expectedKVCount) throws Exception {
        return TestImportTsv.doMROnTableTest(util, this.table, "FAM", data, this.args, valueMultiplier, expectedKVCount);
    }

    private Tool doMROnTableTest(String data, int valueMultiplier) throws Exception {
        return TestImportTsv.doMROnTableTest(util, this.table, "FAM", data, this.args, valueMultiplier, -1);
    }

    protected static Tool doMROnTableTest(HBaseTestingUtility util, String table, String family, String data, Map<String, String> args) throws Exception {
        return TestImportTsv.doMROnTableTest(util, table, family, data, args, 1, -1);
    }

    protected static Tool doMROnTableTest(HBaseTestingUtility util, String table, String family, String data, Map<String, String> args, int valueMultiplier, int expectedKVCount) throws Exception {
        boolean isDryRun;
        Configuration conf = new Configuration(util.getConfiguration());
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path inputPath = fs.makeQualified(new Path(util.getDataTestDirOnTestFS(table), "input.dat"));
        FSDataOutputStream op = fs.create(inputPath, true);
        if (data == null) {
            data = "KEY\u001bVALUE1\u001bVALUE2\n";
        }
        op.write(Bytes.toBytes(data));
        op.close();
        LOG.debug((Object)String.format("Wrote test data to file: %s", inputPath));
        if (conf.getBoolean(FORCE_COMBINER_CONF, true)) {
            LOG.debug((Object)"Forcing combiner.");
            conf.setInt("mapreduce.map.combine.minspills", 1);
        }
        Object[] argsArray = new String[args.size() + 2];
        Iterator<Map.Entry<String, String>> it = args.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry<String, String> pair = it.next();
            argsArray[i] = "-D" + pair.getKey() + "=" + pair.getValue();
            ++i;
        }
        argsArray[i] = table;
        argsArray[i + 1] = inputPath.toString();
        ImportTsv tool = new ImportTsv();
        LOG.debug((Object)("Running ImportTsv with arguments: " + Arrays.toString(argsArray)));
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)conf, (Tool)tool, (String[])argsArray));
        boolean bl = isDryRun = args.containsKey("importtsv.dry.run") && "true".equalsIgnoreCase(args.get("importtsv.dry.run"));
        if (args.containsKey("importtsv.bulk.output")) {
            if (isDryRun) {
                Assert.assertFalse((String)String.format("Dry run mode, %s should not have been created.", "importtsv.bulk.output"), (boolean)fs.exists(new Path("importtsv.bulk.output")));
            } else {
                TestImportTsv.validateHFiles(fs, args.get("importtsv.bulk.output"), family, expectedKVCount);
            }
        } else {
            TestImportTsv.validateTable(conf, TableName.valueOf(table), family, valueMultiplier, isDryRun);
        }
        if (conf.getBoolean(DELETE_AFTER_LOAD_CONF, true)) {
            LOG.debug((Object)"Deleting test subdirectory");
            util.cleanupDataTestDirOnTestFS(table);
        }
        return tool;
    }

    private static void validateTable(Configuration conf, TableName tableName, String family, int valueMultiplier, boolean isDryRun) throws IOException {
        LOG.debug((Object)"Validating table.");
        HTable table = new HTable(conf, tableName);
        boolean verified = false;
        long pause = conf.getLong("hbase.client.pause", 5000L);
        int numRetries = conf.getInt("hbase.client.retries.number", 5);
        for (int i = 0; i < numRetries; ++i) {
            try {
                Scan scan = new Scan();
                scan.addFamily(Bytes.toBytes(family));
                ResultScanner resScanner = table.getScanner(scan);
                int numRows = 0;
                for (Result res : resScanner) {
                    ++numRows;
                    Assert.assertEquals((long)2L, (long)res.size());
                    List<Cell> kvs = res.listCells();
                    Assert.assertTrue((boolean)CellUtil.matchingRow(kvs.get(0), Bytes.toBytes("KEY")));
                    Assert.assertTrue((boolean)CellUtil.matchingRow(kvs.get(1), Bytes.toBytes("KEY")));
                    Assert.assertTrue((boolean)CellUtil.matchingValue(kvs.get(0), Bytes.toBytes("VALUE" + valueMultiplier)));
                    Assert.assertTrue((boolean)CellUtil.matchingValue(kvs.get(1), Bytes.toBytes("VALUE" + 2 * valueMultiplier)));
                }
                if (isDryRun) {
                    Assert.assertEquals((long)0L, (long)numRows);
                } else {
                    Assert.assertEquals((long)1L, (long)numRows);
                }
                verified = true;
                break;
            }
            catch (NullPointerException nullPointerException) {
                try {
                    Thread.sleep(pause);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        table.close();
        Assert.assertTrue((boolean)verified);
    }

    private static void validateHFiles(FileSystem fs, String outputPath, String family, int expectedKVCount) throws IOException {
        LOG.debug((Object)"Validating HFiles.");
        HashSet<String> configFamilies = new HashSet<String>();
        configFamilies.add(family);
        HashSet<String> foundFamilies = new HashSet<String>();
        int actualKVCount = 0;
        for (FileStatus cfStatus : fs.listStatus(new Path(outputPath), (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter())) {
            String[] elements = cfStatus.getPath().toString().split("/");
            String cf = elements[elements.length - 1];
            foundFamilies.add(cf);
            Assert.assertTrue((String)String.format("HFile output contains a column family (%s) not present in input families (%s)", cf, configFamilies), (boolean)configFamilies.contains(cf));
            for (FileStatus hfile : fs.listStatus(cfStatus.getPath())) {
                Assert.assertTrue((String)String.format("HFile %s appears to contain no data.", hfile.getPath()), (hfile.getLen() > 0L ? 1 : 0) != 0);
                if (expectedKVCount <= -1) continue;
                actualKVCount += TestImportTsv.getKVCountFromHfile(fs, hfile.getPath());
            }
        }
        Assert.assertTrue((String)String.format("HFile output does not contain the input family '%s'.", family), (boolean)foundFamilies.contains(family));
        if (expectedKVCount > -1) {
            Assert.assertTrue((String)String.format("KV count in ouput hfile=<%d> doesn't match with expected KV count=<%d>", actualKVCount, expectedKVCount), (actualKVCount == expectedKVCount ? 1 : 0) != 0);
        }
    }

    private static int getKVCountFromHfile(FileSystem fs, Path p) throws IOException {
        Configuration conf = util.getConfiguration();
        HFile.Reader reader = HFile.createReader(fs, p, new CacheConfig(conf), conf);
        reader.loadFileInfo();
        HFileScanner scanner = reader.getScanner(false, false);
        scanner.seekTo();
        int count = 0;
        do {
            ++count;
        } while (scanner.next());
        reader.close();
        return count;
    }
}

