/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class KeyValueSerialization
implements Serialization<KeyValue> {
    public boolean accept(Class<?> c) {
        return KeyValue.class.isAssignableFrom(c);
    }

    public KeyValueDeserializer getDeserializer(Class<KeyValue> t) {
        return new KeyValueDeserializer();
    }

    public KeyValueSerializer getSerializer(Class<KeyValue> c) {
        return new KeyValueSerializer();
    }

    public static class KeyValueSerializer
    implements Serializer<KeyValue> {
        private DataOutputStream dos;

        public void close() throws IOException {
            this.dos.close();
        }

        public void open(OutputStream os) throws IOException {
            this.dos = new DataOutputStream(os);
        }

        public void serialize(KeyValue kv) throws IOException {
            KeyValue.write(kv, this.dos);
        }
    }

    public static class KeyValueDeserializer
    implements Deserializer<KeyValue> {
        private DataInputStream dis;

        public void close() throws IOException {
            this.dis.close();
        }

        public KeyValue deserialize(KeyValue ignore) throws IOException {
            return KeyValue.create(this.dis);
        }

        public void open(InputStream is) throws IOException {
            this.dis = new DataInputStream(is);
        }
    }
}

