/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ipc.BlockingRpcClient;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.SimpleRpcScheduler;
import org.apache.hadoop.hbase.ipc.TestProtobufRpcServiceImpl;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={RPCTests.class, SmallTests.class})
public class TestRpcHandlerException {
    private static final Configuration CONF = HBaseConfiguration.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testRpcScheduler() throws IOException, InterruptedException {
        PriorityFunction qosFunction = (PriorityFunction)Mockito.mock(PriorityFunction.class);
        AbortServer abortable = new AbortServer();
        SimpleRpcScheduler scheduler = new SimpleRpcScheduler(CONF, 2, 0, 0, qosFunction, abortable, 0);
        TestRpcServer rpcServer = new TestRpcServer(scheduler);
        try (BlockingRpcClient client = new BlockingRpcClient(CONF);){
            rpcServer.start();
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub(client, rpcServer.getListenerAddress());
            stub.echo(null, TestProtos.EchoRequestProto.newBuilder().setMessage("hello").build());
        }
        catch (Throwable e) {
            assert (abortable.isAborted());
        }
        finally {
            rpcServer.stop();
        }
    }

    private class AbortServer
    implements Abortable {
        private boolean aborted = false;

        private AbortServer() {
        }

        @Override
        public void abort(String why, Throwable e) {
            this.aborted = true;
        }

        @Override
        public boolean isAborted() {
            return this.aborted;
        }
    }

    private static class TestRpcServer
    extends RpcServer {
        TestRpcServer(RpcScheduler scheduler) throws IOException {
            super(null, "testRpcServer", Lists.newArrayList(new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)), new InetSocketAddress("localhost", 0), CONF, scheduler);
        }
    }
}

