/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.BlockingService;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Private
public class TestProtobufRpcServiceImpl
implements TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface {
    public static final BlockingService SERVICE = TestRpcServiceProtos.TestProtobufRpcProto.newReflectiveBlockingService(new TestProtobufRpcServiceImpl());

    public static TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface newBlockingStub(RpcClient client, InetSocketAddress addr) throws IOException {
        return TestProtobufRpcServiceImpl.newBlockingStub(client, addr, User.getCurrent());
    }

    public static TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface newBlockingStub(RpcClient client, InetSocketAddress addr, User user) throws IOException {
        return TestRpcServiceProtos.TestProtobufRpcProto.newBlockingStub(client.createBlockingRpcChannel(ServerName.valueOf(addr.getHostName(), addr.getPort(), System.currentTimeMillis()), user, 0));
    }

    public static TestRpcServiceProtos.TestProtobufRpcProto.Interface newStub(RpcClient client, InetSocketAddress addr) throws IOException {
        return TestRpcServiceProtos.TestProtobufRpcProto.newStub(client.createRpcChannel(ServerName.valueOf(addr.getHostName(), addr.getPort(), System.currentTimeMillis()), User.getCurrent(), 0));
    }

    @Override
    public TestProtos.EmptyResponseProto ping(RpcController controller, TestProtos.EmptyRequestProto request) throws ServiceException {
        return TestProtos.EmptyResponseProto.getDefaultInstance();
    }

    @Override
    public TestProtos.EchoResponseProto echo(RpcController controller, TestProtos.EchoRequestProto request) throws ServiceException {
        if (controller instanceof HBaseRpcController) {
            HBaseRpcController pcrc = (HBaseRpcController)controller;
            CellScanner cellScanner = pcrc.cellScanner();
            ArrayList<Cell> list = null;
            if (cellScanner != null) {
                list = new ArrayList<Cell>();
                try {
                    while (cellScanner.advance()) {
                        list.add(cellScanner.current());
                    }
                }
                catch (IOException e) {
                    throw new ServiceException((Throwable)e);
                }
            }
            cellScanner = CellUtil.createCellScanner(list);
            pcrc.setCellScanner(cellScanner);
        }
        return TestProtos.EchoResponseProto.newBuilder().setMessage(request.getMessage()).build();
    }

    @Override
    public TestProtos.EmptyResponseProto error(RpcController controller, TestProtos.EmptyRequestProto request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("server error!"));
    }

    @Override
    public TestProtos.EmptyResponseProto pause(RpcController controller, TestProtos.PauseRequestProto request) throws ServiceException {
        Threads.sleepWithoutInterrupt(request.getMs());
        return TestProtos.EmptyResponseProto.getDefaultInstance();
    }

    @Override
    public TestProtos.AddrResponseProto addr(RpcController controller, TestProtos.EmptyRequestProto request) throws ServiceException {
        return TestProtos.AddrResponseProto.newBuilder().setAddr(RpcServer.getRemoteAddress().getHostAddress()).build();
    }
}

