/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcExecutor;
import org.apache.hadoop.hbase.util.ReflectionUtils;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
@InterfaceStability.Evolving
public class BalancedQueueRpcExecutor
extends RpcExecutor {
    private static final Log LOG = LogFactory.getLog(BalancedQueueRpcExecutor.class);
    private final RpcExecutor.QueueBalancer balancer;

    public BalancedQueueRpcExecutor(String name, int handlerCount, int maxQueueLength, PriorityFunction priority, Configuration conf, Abortable abortable) {
        this(name, handlerCount, conf.get("hbase.ipc.server.callqueue.type", "fifo"), maxQueueLength, priority, conf, abortable);
    }

    public BalancedQueueRpcExecutor(String name, int handlerCount, String callQueueType, int maxQueueLength, PriorityFunction priority, Configuration conf, Abortable abortable) {
        super(name, handlerCount, callQueueType, maxQueueLength, priority, conf, abortable);
        this.balancer = BalancedQueueRpcExecutor.getBalancer(this.numCallQueues);
        this.initializeQueues(this.numCallQueues);
    }

    @Deprecated
    public BalancedQueueRpcExecutor(String name, int handlerCount, int numQueues, int maxQueueLength) {
        this(name, handlerCount, numQueues, maxQueueLength, null, null);
    }

    @Deprecated
    public BalancedQueueRpcExecutor(String name, int handlerCount, int numQueues, int maxQueueLength, Configuration conf, Abortable abortable) {
        this(name, handlerCount, numQueues, conf, abortable, LinkedBlockingQueue.class, maxQueueLength);
    }

    @Deprecated
    public BalancedQueueRpcExecutor(String name, int handlerCount, int numQueues, Class<? extends BlockingQueue> queueClass, Object ... initargs) {
        this(name, handlerCount, numQueues, null, null, queueClass, initargs);
    }

    @Deprecated
    public BalancedQueueRpcExecutor(String name, int handlerCount, int numQueues, Configuration conf, Abortable abortable, Class<? extends BlockingQueue> queueClass, Object ... initargs) {
        super(name, Math.max(handlerCount, numQueues), numQueues, conf, abortable);
        this.balancer = BalancedQueueRpcExecutor.getBalancer(numQueues);
        this.initializeQueues(numQueues, queueClass, initargs);
        LOG.debug((Object)(name + " queues=" + numQueues + " handlerCount=" + handlerCount));
    }

    @Deprecated
    protected void initializeQueues(int numQueues, Class<? extends BlockingQueue> queueClass, Object ... initargs) {
        if (initargs.length > 0) {
            this.currentQueueLimit = (Integer)initargs[0];
            initargs[0] = Math.max((Integer)initargs[0], 250);
        }
        for (int i = 0; i < numQueues; ++i) {
            this.queues.add(ReflectionUtils.newInstance(queueClass, initargs));
        }
    }

    @Override
    public boolean dispatch(CallRunner callTask) throws InterruptedException {
        int queueIndex = this.balancer.getNextQueue();
        BlockingQueue queue = (BlockingQueue)this.queues.get(queueIndex);
        if (queue.size() >= this.currentQueueLimit) {
            return false;
        }
        return queue.offer(callTask);
    }
}

