/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.encoding.TestDataBlockEncoders;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSeekToBlockWithEncoders {
    static final byte[] HFILEBLOCK_DUMMY_HEADER = new byte[33];

    @Test
    public void testSeekToBlockWithNonMatchingSeekKey() throws IOException {
        ArrayList<KeyValue> sampleKv = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv1);
        KeyValue kv2 = new KeyValue(Bytes.toBytes("aab"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv2);
        KeyValue kv3 = new KeyValue(Bytes.toBytes("aac"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv3);
        KeyValue kv4 = new KeyValue(Bytes.toBytes("aad"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv4);
        KeyValue kv5 = new KeyValue(Bytes.toBytes("bba"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv5);
        KeyValue toSeek = new KeyValue(Bytes.toBytes("aae"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        this.seekToTheKey(kv4, sampleKv, toSeek);
    }

    @Test
    public void testSeekingToBlockWithBiggerNonLength1() throws IOException {
        ArrayList<KeyValue> sampleKv = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv1);
        KeyValue kv2 = new KeyValue(Bytes.toBytes("aab"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv2);
        KeyValue kv3 = new KeyValue(Bytes.toBytes("aac"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv3);
        KeyValue kv4 = new KeyValue(Bytes.toBytes("aad"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv4);
        KeyValue kv5 = new KeyValue(Bytes.toBytes("aaddd"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv5);
        KeyValue toSeek = new KeyValue(Bytes.toBytes("aaaa"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        this.seekToTheKey(kv1, sampleKv, toSeek);
    }

    @Test
    public void testSeekingToBlockToANotAvailableKey() throws IOException {
        ArrayList<KeyValue> sampleKv = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv1);
        KeyValue kv2 = new KeyValue(Bytes.toBytes("aab"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv2);
        KeyValue kv3 = new KeyValue(Bytes.toBytes("aac"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv3);
        KeyValue kv4 = new KeyValue(Bytes.toBytes("aade"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv4);
        KeyValue kv5 = new KeyValue(Bytes.toBytes("bbbcd"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv5);
        KeyValue toSeek = new KeyValue(Bytes.toBytes("bbbce"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        this.seekToTheKey(kv5, sampleKv, toSeek);
    }

    @Test
    public void testSeekToBlockWithDecreasingCommonPrefix() throws IOException {
        ArrayList<KeyValue> sampleKv = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(Bytes.toBytes("row10aaa"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv1);
        KeyValue kv2 = new KeyValue(Bytes.toBytes("row10aaa"), Bytes.toBytes("f1"), Bytes.toBytes("q2"), Bytes.toBytes("val"));
        sampleKv.add(kv2);
        KeyValue kv3 = new KeyValue(Bytes.toBytes("row10aaa"), Bytes.toBytes("f1"), Bytes.toBytes("q3"), Bytes.toBytes("val"));
        sampleKv.add(kv3);
        KeyValue kv4 = new KeyValue(Bytes.toBytes("row11baa"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv4);
        KeyValue toSeek = KeyValueUtil.createLastOnRow(kv3.getRowArray(), kv3.getRowOffset(), kv3.getRowLength(), null, 0, 0, null, 0, 0);
        this.seekToTheKey(kv3, sampleKv, toSeek);
    }

    @Test
    public void testSeekToBlockWithDiffQualifer() throws IOException {
        ArrayList<KeyValue> sampleKv = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv1);
        KeyValue kv2 = new KeyValue(Bytes.toBytes("aab"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv2);
        KeyValue kv4 = new KeyValue(Bytes.toBytes("aac"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv4);
        KeyValue kv5 = new KeyValue(Bytes.toBytes("aac"), Bytes.toBytes("f1"), Bytes.toBytes("q2"), Bytes.toBytes("val"));
        sampleKv.add(kv5);
        KeyValue toSeek = new KeyValue(Bytes.toBytes("aac"), Bytes.toBytes("f1"), Bytes.toBytes("q2"), Bytes.toBytes("val"));
        this.seekToTheKey(kv5, sampleKv, toSeek);
    }

    @Test
    public void testSeekToBlockWithDiffQualiferOnSameRow() throws IOException {
        ArrayList<KeyValue> sampleKv = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv1);
        KeyValue kv2 = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("q2"), Bytes.toBytes("val"));
        sampleKv.add(kv2);
        KeyValue kv4 = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("q3"), Bytes.toBytes("val"));
        sampleKv.add(kv4);
        KeyValue kv5 = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("q4"), Bytes.toBytes("val"));
        sampleKv.add(kv5);
        KeyValue kv6 = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("q5"), Bytes.toBytes("val"));
        sampleKv.add(kv6);
        KeyValue toSeek = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("q5"), Bytes.toBytes("val"));
        this.seekToTheKey(kv6, sampleKv, toSeek);
    }

    @Test
    public void testSeekToBlockWithDiffQualiferOnSameRow1() throws IOException {
        ArrayList<KeyValue> sampleKv = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv1);
        KeyValue kv2 = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("q2"), Bytes.toBytes("val"));
        sampleKv.add(kv2);
        KeyValue kv4 = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("q3"), Bytes.toBytes("val"));
        sampleKv.add(kv4);
        KeyValue kv5 = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("q4"), Bytes.toBytes("val"));
        sampleKv.add(kv5);
        KeyValue kv6 = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("z5"), Bytes.toBytes("val"));
        sampleKv.add(kv6);
        KeyValue toSeek = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("q5"), Bytes.toBytes("val"));
        this.seekToTheKey(kv5, sampleKv, toSeek);
    }

    @Test
    public void testSeekToBlockWithDiffQualiferOnSameRowButDescendingInSize() throws IOException {
        ArrayList<KeyValue> sampleKv = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("qual1"), Bytes.toBytes("val"));
        sampleKv.add(kv1);
        KeyValue kv2 = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("qual2"), Bytes.toBytes("val"));
        sampleKv.add(kv2);
        KeyValue kv4 = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("qual3"), Bytes.toBytes("val"));
        sampleKv.add(kv4);
        KeyValue kv5 = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("qual4"), Bytes.toBytes("val"));
        sampleKv.add(kv5);
        KeyValue kv6 = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("qz"), Bytes.toBytes("val"));
        sampleKv.add(kv6);
        KeyValue toSeek = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("f1"), Bytes.toBytes("qz"), Bytes.toBytes("val"));
        this.seekToTheKey(kv6, sampleKv, toSeek);
    }

    @Test
    public void testSeekToBlockWithDiffFamilyAndQualifer() throws IOException {
        ArrayList<KeyValue> sampleKv = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(Bytes.toBytes("aaa"), Bytes.toBytes("fam1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv1);
        KeyValue kv2 = new KeyValue(Bytes.toBytes("aab"), Bytes.toBytes("fam1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv2);
        KeyValue kv4 = new KeyValue(Bytes.toBytes("aac"), Bytes.toBytes("fam1"), Bytes.toBytes("q1"), Bytes.toBytes("val"));
        sampleKv.add(kv4);
        KeyValue kv5 = new KeyValue(Bytes.toBytes("aac"), Bytes.toBytes("fam1"), Bytes.toBytes("q2"), Bytes.toBytes("val"));
        sampleKv.add(kv5);
        KeyValue toSeek = new KeyValue(Bytes.toBytes("aac"), Bytes.toBytes("fam2"), Bytes.toBytes("q2"), Bytes.toBytes("val"));
        this.seekToTheKey(kv5, sampleKv, toSeek);
    }

    private void seekToTheKey(KeyValue expected, List<KeyValue> kvs, KeyValue toSeek) throws IOException {
        ArrayList<DataBlockEncoder.EncodedSeeker> encodedSeekers = new ArrayList<DataBlockEncoder.EncodedSeeker>();
        for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
            if (encoding.getEncoder() == null || encoding == DataBlockEncoding.PREFIX_TREE) continue;
            DataBlockEncoder encoder = encoding.getEncoder();
            HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(false).withIncludesMvcc(false).withIncludesTags(false).withCompression(Compression.Algorithm.NONE).build();
            HFileBlockEncodingContext encodingContext = encoder.newDataBlockEncodingContext(encoding, HFILEBLOCK_DUMMY_HEADER, meta);
            ByteBuffer encodedBuffer = TestDataBlockEncoders.encodeKeyValues(encoding, kvs, encodingContext);
            DataBlockEncoder.EncodedSeeker seeker = encoder.createSeeker(KeyValue.COMPARATOR, encoder.newDataBlockDecodingContext(meta));
            seeker.setCurrentBuffer(encodedBuffer);
            encodedSeekers.add(seeker);
        }
        this.checkSeekingConsistency(encodedSeekers, toSeek, expected);
    }

    private void checkSeekingConsistency(List<DataBlockEncoder.EncodedSeeker> encodedSeekers, KeyValue keyValue, KeyValue expected) {
        for (DataBlockEncoder.EncodedSeeker seeker : encodedSeekers) {
            seeker.seekToKeyInBlock(new KeyValue.KeyOnlyKeyValue(keyValue.getBuffer(), keyValue.getKeyOffset(), keyValue.getKeyLength()), false);
            Cell keyValue2 = seeker.getKeyValue();
            Assert.assertEquals((Object)expected, (Object)keyValue2);
            seeker.rewind();
        }
    }
}

