/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.protobuf.generated.ColumnAggregationWithNullResponseProtos;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.Bytes;

public class ColumnAggregationEndpointNullResponse
extends ColumnAggregationWithNullResponseProtos.ColumnAggregationServiceNullResponse
implements Coprocessor,
CoprocessorService {
    private static final Log LOG = LogFactory.getLog(ColumnAggregationEndpointNullResponse.class);
    private RegionCoprocessorEnvironment env = null;

    @Override
    public Service getService() {
        return this;
    }

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        if (env instanceof RegionCoprocessorEnvironment) {
            this.env = (RegionCoprocessorEnvironment)env;
            return;
        }
        throw new CoprocessorException("Must be loaded on a table region!");
    }

    @Override
    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sum(RpcController controller, ColumnAggregationWithNullResponseProtos.ColumnAggregationNullResponseSumRequest request, RpcCallback<ColumnAggregationWithNullResponseProtos.ColumnAggregationNullResponseSumResponse> done) {
        byte[] qualifier;
        Scan scan = new Scan();
        byte[] family = request.getFamily().toByteArray();
        byte[] byArray = qualifier = request.hasQualifier() ? request.getQualifier().toByteArray() : null;
        if (request.hasQualifier()) {
            scan.addColumn(family, qualifier);
        } else {
            scan.addFamily(family);
        }
        int sumResult = 0;
        InternalScanner scanner = null;
        try {
            Region region = this.env.getRegion();
            if (Bytes.equals(region.getRegionInfo().getEndKey(), HConstants.EMPTY_END_ROW)) {
                done.run(null);
                return;
            }
            scanner = region.getScanner(scan);
            ArrayList<Cell> curVals = new ArrayList<Cell>();
            boolean hasMore = false;
            do {
                curVals.clear();
                hasMore = scanner.next(curVals);
                for (Cell kv : curVals) {
                    if (!CellUtil.matchingQualifier(kv, qualifier)) continue;
                    sumResult += Bytes.toInt(kv.getValueArray(), kv.getValueOffset());
                }
            } while (hasMore);
        }
        catch (IOException e) {
            ResponseConverter.setControllerException(controller, e);
            sumResult = -1;
            LOG.info((Object)"Setting sum result to -1 to indicate error", (Throwable)e);
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (IOException e) {
                    ResponseConverter.setControllerException(controller, e);
                    sumResult = -1;
                    LOG.info((Object)"Setting sum result to -1 to indicate error", (Throwable)e);
                }
            }
        }
        done.run((Object)ColumnAggregationWithNullResponseProtos.ColumnAggregationNullResponseSumResponse.newBuilder().setSum(sumResult).build());
        LOG.info((Object)("Returning sum " + sumResult + " for region " + Bytes.toStringBinary(this.env.getRegion().getRegionInfo().getRegionName())));
    }
}

