/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.HBaseRpcControllerImpl;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestScanWithoutFetchingData {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf("test");
    private static final byte[] CF = Bytes.toBytes("cf");
    private static final byte[] CQ = Bytes.toBytes("cq");
    private static final int COUNT = 10;
    private static HRegionInfo HRI;
    private static ClientProtos.ClientService.BlockingInterface STUB;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
        try (HTable table = UTIL.createTable(TABLE_NAME, CF);){
            for (int i = 0; i < 10; ++i) {
                table.put(new Put(Bytes.toBytes(i)).addColumn(CF, CQ, Bytes.toBytes(i)));
            }
        }
        HRI = UTIL.getHBaseAdmin().getTableRegions(TABLE_NAME).get(0);
        STUB = ((ConnectionManager.HConnectionImplementation)UTIL.getConnection()).getClient(UTIL.getHBaseCluster().getRegionServer(0).getServerName());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    private void assertResult(int row, Result result) {
        Assert.assertEquals((long)row, (long)Bytes.toInt(result.getRow()));
        Assert.assertEquals((long)row, (long)Bytes.toInt(result.getValue(CF, CQ)));
    }

    @Test
    public void test() throws ServiceException, IOException {
        Result[] results;
        int i;
        Scan scan = new Scan();
        ClientProtos.ScanRequest req = RequestConverter.buildScanRequest(HRI.getRegionName(), scan, 0, false);
        HBaseRpcControllerImpl hrc = new HBaseRpcControllerImpl();
        ClientProtos.ScanResponse resp = STUB.scan(hrc, req);
        Assert.assertTrue((boolean)resp.getMoreResults());
        Assert.assertTrue((boolean)resp.getMoreResultsInRegion());
        Assert.assertEquals((long)0L, (long)ResponseConverter.getResults(hrc.cellScanner(), resp).length);
        long scannerId = resp.getScannerId();
        int nextCallSeq = 0;
        for (i = 0; i < 5; ++i) {
            req = RequestConverter.buildScanRequest(scannerId, 1, false, nextCallSeq++, false, false, -1);
            hrc.reset();
            resp = STUB.scan(hrc, req);
            Assert.assertTrue((boolean)resp.getMoreResults());
            Assert.assertTrue((boolean)resp.getMoreResultsInRegion());
            results = ResponseConverter.getResults(hrc.cellScanner(), resp);
            Assert.assertEquals((long)1L, (long)results.length);
            this.assertResult(i, results[0]);
        }
        req = RequestConverter.buildScanRequest(scannerId, 0, false, nextCallSeq++, false, false, -1);
        hrc.reset();
        resp = STUB.scan(hrc, req);
        Assert.assertTrue((boolean)resp.getMoreResults());
        Assert.assertTrue((boolean)resp.getMoreResultsInRegion());
        Assert.assertEquals((long)0L, (long)ResponseConverter.getResults(hrc.cellScanner(), resp).length);
        for (i = 5; i < 10; ++i) {
            req = RequestConverter.buildScanRequest(scannerId, 1, false, nextCallSeq++, false, false, -1);
            hrc.reset();
            resp = STUB.scan(hrc, req);
            Assert.assertTrue((boolean)resp.getMoreResults());
            Assert.assertEquals((Object)(i != 9 ? 1 : 0), (Object)resp.getMoreResultsInRegion());
            results = ResponseConverter.getResults(hrc.cellScanner(), resp);
            Assert.assertEquals((long)1L, (long)results.length);
            this.assertResult(i, results[0]);
        }
        req = RequestConverter.buildScanRequest(scannerId, 0, true, false);
        resp = STUB.scan(null, req);
    }
}

