/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.math.BigDecimal;
import java.util.List;
import java.util.NavigableMap;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.StoppableImplementation;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.util.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MediumTests.class})
public class TestMetaScanner {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Connection connection;

    public void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(1);
        this.connection = TEST_UTIL.getConnection();
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMetaScanner() throws Exception {
        this.LOG.info((Object)"Starting testMetaScanner");
        this.setUp();
        TableName TABLENAME = TableName.valueOf("testMetaScanner");
        byte[] FAMILY = Bytes.toBytes("family");
        byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes("region_a"), Bytes.toBytes("region_b")};
        TEST_UTIL.createTable(TABLENAME, FAMILY, (byte[][])SPLIT_KEYS);
        HTable table = (HTable)this.connection.getTable(TABLENAME);
        TEST_UTIL.countRows(table);
        MetaScanner.MetaScannerVisitor visitor = (MetaScanner.MetaScannerVisitor)Mockito.mock(MetaScanner.MetaScannerVisitor.class);
        ((MetaScanner.MetaScannerVisitor)Mockito.doReturn((Object)true).when((Object)visitor)).processRow((Result)Matchers.anyObject());
        MetaScanner.metaScan(this.connection, visitor, TABLENAME);
        ((MetaScanner.MetaScannerVisitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)3))).processRow((Result)Matchers.anyObject());
        Mockito.reset((Object[])new MetaScanner.MetaScannerVisitor[]{visitor});
        ((MetaScanner.MetaScannerVisitor)Mockito.doReturn((Object)true).when((Object)visitor)).processRow((Result)Matchers.anyObject());
        MetaScanner.metaScan(this.connection, visitor, TABLENAME, HConstants.EMPTY_BYTE_ARRAY, 1000);
        ((MetaScanner.MetaScannerVisitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)3))).processRow((Result)Matchers.anyObject());
        Mockito.reset((Object[])new MetaScanner.MetaScannerVisitor[]{visitor});
        ((MetaScanner.MetaScannerVisitor)Mockito.doReturn((Object)true).when((Object)visitor)).processRow((Result)Matchers.anyObject());
        MetaScanner.metaScan(this.connection, visitor, TABLENAME, Bytes.toBytes("region_ac"), 1000);
        ((MetaScanner.MetaScannerVisitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)2))).processRow((Result)Matchers.anyObject());
        Mockito.reset((Object[])new MetaScanner.MetaScannerVisitor[]{visitor});
        ((MetaScanner.MetaScannerVisitor)Mockito.doReturn((Object)true).when((Object)visitor)).processRow((Result)Matchers.anyObject());
        MetaScanner.metaScan(this.connection, visitor, TABLENAME, Bytes.toBytes("region_ac"), 1);
        ((MetaScanner.MetaScannerVisitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)1))).processRow((Result)Matchers.anyObject());
        try {
            MetaScanner.metaScan(this.connection, visitor, TABLENAME, Bytes.toBytes("region_ac"), 1, TableName.valueOf("invalidMeta"));
            Assert.fail((String)"Passed invalid meta table name but it is not honored");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        table.close();
    }

    @Test
    public void testConcurrentMetaScannerAndCatalogJanitor() throws Throwable {
        TEST_UTIL.getConfiguration().setLong("hbase.catalogjanitor.interval", 500L);
        this.setUp();
        long runtime = 30000L;
        this.LOG.info((Object)"Starting testConcurrentMetaScannerAndCatalogJanitor");
        final TableName TABLENAME = TableName.valueOf("testConcurrentMetaScannerAndCatalogJanitor");
        byte[] FAMILY = Bytes.toBytes("family");
        TEST_UTIL.createTable(TABLENAME, FAMILY);
        class RegionMetaSplitter
        extends StoppableImplementation
        implements Runnable {
            Random random = new Random();
            Throwable ex = null;

            RegionMetaSplitter() {
            }

            @Override
            public void run() {
                while (!this.isStopped()) {
                    try {
                        List<HRegionInfo> regions = MetaScanner.listAllRegions(TEST_UTIL.getConfiguration(), TestMetaScanner.this.connection, false);
                        HRegionInfo parent = regions.get(this.random.nextInt(regions.size()));
                        if (parent == null || !TABLENAME.equals(parent.getTable())) continue;
                        long startKey = 0L;
                        long endKey = Long.MAX_VALUE;
                        byte[] start = parent.getStartKey();
                        byte[] end = parent.getEndKey();
                        if (!Bytes.equals(HConstants.EMPTY_START_ROW, parent.getStartKey())) {
                            startKey = Bytes.toLong(parent.getStartKey());
                        }
                        if (!Bytes.equals(HConstants.EMPTY_END_ROW, parent.getEndKey())) {
                            endKey = Bytes.toLong(parent.getEndKey());
                        }
                        if (startKey == endKey) continue;
                        long midKey = BigDecimal.valueOf(startKey).add(BigDecimal.valueOf(endKey)).divideToIntegralValue(BigDecimal.valueOf(2L)).longValue();
                        HRegionInfo splita = new HRegionInfo(TABLENAME, start, Bytes.toBytes(midKey));
                        HRegionInfo splitb = new HRegionInfo(TABLENAME, Bytes.toBytes(midKey), end);
                        MetaTableAccessor.splitRegion(TestMetaScanner.this.connection, parent, splita, splitb, ServerName.valueOf("fooserver", 1, 0L), 1);
                        Threads.sleep(this.random.nextInt(200));
                    }
                    catch (Throwable e) {
                        this.ex = e;
                        Assert.fail((String)StringUtils.stringifyException((Throwable)e));
                    }
                }
            }

            void rethrowExceptionIfAny() throws Throwable {
                if (this.ex != null) {
                    throw this.ex;
                }
            }
        }
        RegionMetaSplitter regionMetaSplitter = new RegionMetaSplitter();
        class MetaScannerVerifier
        extends StoppableImplementation
        implements Runnable {
            Random random = new Random();
            Throwable ex = null;

            MetaScannerVerifier() {
            }

            @Override
            public void run() {
                while (!this.isStopped()) {
                    try {
                        NavigableMap<HRegionInfo, ServerName> regions = MetaScanner.allTableRegions(TestMetaScanner.this.connection, TABLENAME);
                        TestMetaScanner.this.LOG.info((Object)"-------");
                        byte[] lastEndKey = HConstants.EMPTY_START_ROW;
                        for (HRegionInfo hri : regions.navigableKeySet()) {
                            long startKey = 0L;
                            long endKey = Long.MAX_VALUE;
                            if (!Bytes.equals(HConstants.EMPTY_START_ROW, hri.getStartKey())) {
                                startKey = Bytes.toLong(hri.getStartKey());
                            }
                            if (!Bytes.equals(HConstants.EMPTY_END_ROW, hri.getEndKey())) {
                                endKey = Bytes.toLong(hri.getEndKey());
                            }
                            TestMetaScanner.this.LOG.info((Object)("start:" + startKey + " end:" + endKey + " hri:" + hri));
                            Assert.assertTrue((String)("lastEndKey=" + Bytes.toString(lastEndKey) + ", startKey=" + Bytes.toString(hri.getStartKey())), (boolean)Bytes.equals(lastEndKey, hri.getStartKey()));
                            lastEndKey = hri.getEndKey();
                        }
                        Assert.assertTrue((boolean)Bytes.equals(lastEndKey, HConstants.EMPTY_END_ROW));
                        TestMetaScanner.this.LOG.info((Object)"-------");
                        Threads.sleep(10 + this.random.nextInt(50));
                    }
                    catch (Throwable e) {
                        this.ex = e;
                        Assert.fail((String)StringUtils.stringifyException((Throwable)e));
                    }
                }
            }

            void rethrowExceptionIfAny() throws Throwable {
                if (this.ex != null) {
                    throw this.ex;
                }
            }
        }
        MetaScannerVerifier metaScannerVerifier = new MetaScannerVerifier();
        Thread regionMetaSplitterThread = new Thread(regionMetaSplitter);
        Thread metaScannerVerifierThread = new Thread(metaScannerVerifier);
        regionMetaSplitterThread.start();
        metaScannerVerifierThread.start();
        Threads.sleep(30000L);
        regionMetaSplitter.stop("test finished");
        metaScannerVerifier.stop("test finished");
        regionMetaSplitterThread.join();
        metaScannerVerifierThread.join();
        regionMetaSplitter.rethrowExceptionIfAny();
        metaScannerVerifier.rethrowExceptionIfAny();
    }
}

