/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestConnectionImplementation {
    private static HBaseTestingUtility testUtil;
    private static ConnectionManager.HConnectionImplementation conn;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        testUtil = HBaseTestingUtility.createLocalHTU();
        testUtil.startMiniCluster();
        conn = (ConnectionManager.HConnectionImplementation)testUtil.getConnection();
    }

    @AfterClass
    public static void teardownAfterClass() throws Exception {
        conn.close();
        testUtil.shutdownMiniCluster();
    }

    @Test(expected=UnknownHostException.class)
    public void testGetAdminBadHostname() throws Exception {
        ServerName master = testUtil.getHBaseCluster().getMaster().getServerName();
        try {
            conn.getAdmin(master);
        }
        catch (UnknownHostException uhe) {
            Assert.fail((String)"Obtaining admin to the cluster master should have succeeded");
        }
        ServerName badHost = ServerName.valueOf("unknownhost.invalid:16000", System.currentTimeMillis());
        conn.getAdmin(badHost);
        Assert.fail((String)"Obtaining admin to unresolvable hostname should have failed");
    }

    @Test(expected=UnknownHostException.class)
    public void testGetClientBadHostname() throws Exception {
        ServerName rs = testUtil.getHBaseCluster().getRegionServer(0).getServerName();
        try {
            conn.getClient(rs);
        }
        catch (UnknownHostException uhe) {
            Assert.fail((String)"Obtaining client to the cluster regionserver should have succeeded");
        }
        ServerName badHost = ServerName.valueOf("unknownhost.invalid:16020", System.currentTimeMillis());
        conn.getAdmin(badHost);
        Assert.fail((String)"Obtaining client to unresolvable hostname should have failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocateRegionsWithRegionReplicas() throws IOException {
        int regionReplication = 3;
        byte[] family = Bytes.toBytes("cf");
        TableName tableName = TableName.valueOf("testLocateRegionsWithRegionReplicas");
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(family));
        desc.setRegionReplication(regionReplication);
        testUtil.getConnection().getAdmin().createTable(desc);
        try (ConnectionManager.HConnectionImplementation con = (ConnectionManager.HConnectionImplementation)ConnectionFactory.createConnection(testUtil.getConfiguration());){
            List<HRegionLocation> locations = con.locateRegions(tableName, false, false);
            Assert.assertEquals((long)regionReplication, (long)locations.size());
            HashSet<Integer> expectedReplicaIds = new HashSet<Integer>(Arrays.asList(0, 1, 2));
            for (HRegionLocation location : locations) {
                Assert.assertTrue((boolean)expectedReplicaIds.remove(location.getRegionInfo().getReplicaId()));
            }
        }
        finally {
            testUtil.deleteTable(tableName);
        }
    }
}

