/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompoundConfiguration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCompoundConfiguration
extends TestCase {
    private Configuration baseConf;
    private int baseConfSize;

    protected void setUp() throws Exception {
        this.baseConf = new Configuration();
        this.baseConf.set("A", "1");
        this.baseConf.setInt("B", 2);
        this.baseConf.set("C", "3");
        this.baseConfSize = this.baseConf.size();
    }

    @Test
    public void testBasicFunctionality() throws ClassNotFoundException {
        CompoundConfiguration compoundConf = new CompoundConfiguration().add(this.baseConf);
        TestCompoundConfiguration.assertEquals((String)"1", (String)compoundConf.get("A"));
        TestCompoundConfiguration.assertEquals((int)2, (int)compoundConf.getInt("B", 0));
        TestCompoundConfiguration.assertEquals((int)3, (int)compoundConf.getInt("C", 0));
        TestCompoundConfiguration.assertEquals((int)0, (int)compoundConf.getInt("D", 0));
        TestCompoundConfiguration.assertEquals(CompoundConfiguration.class, compoundConf.getClassByName(CompoundConfiguration.class.getName()));
        try {
            compoundConf.getClassByName("bad_class_name");
            TestCompoundConfiguration.fail((String)"Trying to load bad_class_name should throw an exception");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testPut() {
        CompoundConfiguration compoundConf = new CompoundConfiguration().add(this.baseConf);
        TestCompoundConfiguration.assertEquals((String)"1", (String)compoundConf.get("A"));
        TestCompoundConfiguration.assertEquals((int)2, (int)compoundConf.getInt("B", 0));
        TestCompoundConfiguration.assertEquals((int)3, (int)compoundConf.getInt("C", 0));
        TestCompoundConfiguration.assertEquals((int)0, (int)compoundConf.getInt("D", 0));
        compoundConf.set("A", "1337");
        compoundConf.set("string", "stringvalue");
        TestCompoundConfiguration.assertEquals((int)1337, (int)compoundConf.getInt("A", 0));
        TestCompoundConfiguration.assertEquals((String)"stringvalue", (String)compoundConf.get("string"));
        TestCompoundConfiguration.assertEquals((String)"1", (String)this.baseConf.get("A"));
        TestCompoundConfiguration.assertNull((Object)this.baseConf.get("string"));
        this.baseConf.set("setInParent", "fromParent");
        TestCompoundConfiguration.assertEquals((String)"fromParent", (String)compoundConf.get("setInParent"));
    }

    @Test
    public void testWithConfig() {
        Configuration conf = new Configuration();
        conf.set("B", "2b");
        conf.set("C", "33");
        conf.set("D", "4");
        CompoundConfiguration compoundConf = new CompoundConfiguration().add(this.baseConf).add(conf);
        TestCompoundConfiguration.assertEquals((String)"1", (String)compoundConf.get("A"));
        TestCompoundConfiguration.assertEquals((String)"2b", (String)compoundConf.get("B"));
        TestCompoundConfiguration.assertEquals((int)33, (int)compoundConf.getInt("C", 0));
        TestCompoundConfiguration.assertEquals((String)"4", (String)compoundConf.get("D"));
        TestCompoundConfiguration.assertEquals((int)4, (int)compoundConf.getInt("D", 0));
        TestCompoundConfiguration.assertNull((Object)compoundConf.get("E"));
        TestCompoundConfiguration.assertEquals((int)6, (int)compoundConf.getInt("F", 6));
        int cnt = 0;
        Iterator<Map.Entry<String, String>> iterator = compoundConf.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            ++cnt;
            if (entry.getKey().equals("B")) {
                TestCompoundConfiguration.assertEquals((String)"2b", (String)entry.getValue());
                continue;
            }
            if (!entry.getKey().equals("G")) continue;
            TestCompoundConfiguration.assertEquals(null, (String)entry.getValue());
        }
        TestCompoundConfiguration.assertEquals((int)(this.baseConfSize + 1), (int)cnt);
    }

    private ImmutableBytesWritable strToIbw(String s) {
        return new ImmutableBytesWritable(Bytes.toBytes(s));
    }

    @Test
    public void testWithIbwMap() {
        HashMap<ImmutableBytesWritable, ImmutableBytesWritable> map = new HashMap<ImmutableBytesWritable, ImmutableBytesWritable>();
        map.put(this.strToIbw("B"), this.strToIbw("2b"));
        map.put(this.strToIbw("C"), this.strToIbw("33"));
        map.put(this.strToIbw("D"), this.strToIbw("4"));
        map.put(this.strToIbw("G"), null);
        CompoundConfiguration compoundConf = new CompoundConfiguration().add(this.baseConf).addWritableMap(map);
        TestCompoundConfiguration.assertEquals((String)"1", (String)compoundConf.get("A"));
        TestCompoundConfiguration.assertEquals((String)"2b", (String)compoundConf.get("B"));
        TestCompoundConfiguration.assertEquals((int)33, (int)compoundConf.getInt("C", 0));
        TestCompoundConfiguration.assertEquals((String)"4", (String)compoundConf.get("D"));
        TestCompoundConfiguration.assertEquals((int)4, (int)compoundConf.getInt("D", 0));
        TestCompoundConfiguration.assertNull((Object)compoundConf.get("E"));
        TestCompoundConfiguration.assertEquals((int)6, (int)compoundConf.getInt("F", 6));
        TestCompoundConfiguration.assertNull((Object)compoundConf.get("G"));
        int cnt = 0;
        Iterator<Map.Entry<String, String>> iterator = compoundConf.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            ++cnt;
            if (entry.getKey().equals("B")) {
                TestCompoundConfiguration.assertEquals((String)"2b", (String)entry.getValue());
                continue;
            }
            if (!entry.getKey().equals("G")) continue;
            TestCompoundConfiguration.assertEquals(null, (String)entry.getValue());
        }
        TestCompoundConfiguration.assertEquals((int)(this.baseConfSize + 2), (int)cnt);
        CompoundConfiguration conf2 = new CompoundConfiguration();
        conf2.set("X", "modification");
        conf2.set("D", "not4");
        TestCompoundConfiguration.assertEquals((String)"modification", (String)conf2.get("X"));
        TestCompoundConfiguration.assertEquals((String)"not4", (String)conf2.get("D"));
        conf2.addWritableMap(map);
        TestCompoundConfiguration.assertEquals((String)"4", (String)conf2.get("D"));
    }

    @Test
    public void testWithStringMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("B", "2b");
        map.put("C", "33");
        map.put("D", "4");
        map.put("G", null);
        CompoundConfiguration compoundConf = new CompoundConfiguration().addStringMap(map);
        TestCompoundConfiguration.assertEquals((String)"2b", (String)compoundConf.get("B"));
        TestCompoundConfiguration.assertEquals((int)33, (int)compoundConf.getInt("C", 0));
        TestCompoundConfiguration.assertEquals((String)"4", (String)compoundConf.get("D"));
        TestCompoundConfiguration.assertEquals((int)4, (int)compoundConf.getInt("D", 0));
        TestCompoundConfiguration.assertNull((Object)compoundConf.get("E"));
        TestCompoundConfiguration.assertEquals((int)6, (int)compoundConf.getInt("F", 6));
        TestCompoundConfiguration.assertNull((Object)compoundConf.get("G"));
        int cnt = 0;
        Iterator<Map.Entry<String, String>> iterator = compoundConf.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            ++cnt;
            if (entry.getKey().equals("B")) {
                TestCompoundConfiguration.assertEquals((String)"2b", (String)entry.getValue());
                continue;
            }
            if (!entry.getKey().equals("G")) continue;
            TestCompoundConfiguration.assertEquals(null, (String)entry.getValue());
        }
        TestCompoundConfiguration.assertEquals((int)4, (int)cnt);
        CompoundConfiguration conf2 = new CompoundConfiguration();
        conf2.set("X", "modification");
        conf2.set("D", "not4");
        TestCompoundConfiguration.assertEquals((String)"modification", (String)conf2.get("X"));
        TestCompoundConfiguration.assertEquals((String)"not4", (String)conf2.get("D"));
        conf2.addStringMap(map);
        TestCompoundConfiguration.assertEquals((String)"4", (String)conf2.get("D"));
    }

    @Test
    public void testLaterConfigsOverrideEarlier() {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("A", "2");
        map1.put("D", "5");
        HashMap<String, String> map2 = new HashMap<String, String>();
        String newValueForA = "3";
        String newValueForB = "4";
        map2.put("A", newValueForA);
        map2.put("B", newValueForB);
        CompoundConfiguration compoundConf = new CompoundConfiguration().addStringMap(map1).add(this.baseConf);
        TestCompoundConfiguration.assertEquals((String)"1", (String)compoundConf.get("A"));
        TestCompoundConfiguration.assertEquals((String)"5", (String)compoundConf.get("D"));
        compoundConf.addStringMap(map2);
        TestCompoundConfiguration.assertEquals((String)newValueForA, (String)compoundConf.get("A"));
        TestCompoundConfiguration.assertEquals((String)newValueForB, (String)compoundConf.get("B"));
        TestCompoundConfiguration.assertEquals((String)"5", (String)compoundConf.get("D"));
        int cnt = 0;
        Iterator<Map.Entry<String, String>> iterator = compoundConf.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            ++cnt;
            if (entry.getKey().equals("A")) {
                TestCompoundConfiguration.assertEquals((String)newValueForA, (String)entry.getValue());
                continue;
            }
            if (!entry.getKey().equals("B")) continue;
            TestCompoundConfiguration.assertEquals((String)newValueForB, (String)entry.getValue());
        }
        TestCompoundConfiguration.assertEquals((int)(this.baseConfSize + 1), (int)cnt);
    }
}

