/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math.random.RandomData;
import org.apache.commons.math.random.RandomDataImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.PerformanceEvaluationCommons;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

@Deprecated
public class MapFilePerformanceEvaluation {
    protected final Configuration conf;
    private static final int ROW_LENGTH = 10;
    private static final int ROW_COUNT = 100000;
    private static final Log LOG = LogFactory.getLog((String)MapFilePerformanceEvaluation.class.getName());

    public MapFilePerformanceEvaluation(Configuration c) {
        this.conf = c;
    }

    static ImmutableBytesWritable format(int i, ImmutableBytesWritable w) {
        String v = Integer.toString(i);
        w.set(Bytes.toBytes("0000000000".substring(v.length()) + v));
        return w;
    }

    private void runBenchmarks() throws Exception {
        Path mf;
        final FileSystem fs = FileSystem.get((Configuration)this.conf);
        if (fs.exists(mf = fs.makeQualified(new Path("performanceevaluation.mapfile")))) {
            fs.delete(mf, true);
        }
        this.runBenchmark(new SequentialWriteBenchmark(this.conf, fs, mf, 100000), 100000);
        PerformanceEvaluationCommons.concurrentReads(new Runnable(){

            @Override
            public void run() {
                try {
                    MapFilePerformanceEvaluation.this.runBenchmark(new UniformRandomSmallScan(MapFilePerformanceEvaluation.this.conf, fs, mf, 100000), 100000);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        PerformanceEvaluationCommons.concurrentReads(new Runnable(){

            @Override
            public void run() {
                try {
                    MapFilePerformanceEvaluation.this.runBenchmark(new UniformRandomReadBenchmark(MapFilePerformanceEvaluation.this.conf, fs, mf, 100000), 100000);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        PerformanceEvaluationCommons.concurrentReads(new Runnable(){

            @Override
            public void run() {
                try {
                    MapFilePerformanceEvaluation.this.runBenchmark(new GaussianRandomReadBenchmark(MapFilePerformanceEvaluation.this.conf, fs, mf, 100000), 100000);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        PerformanceEvaluationCommons.concurrentReads(new Runnable(){

            @Override
            public void run() {
                try {
                    MapFilePerformanceEvaluation.this.runBenchmark(new SequentialReadBenchmark(MapFilePerformanceEvaluation.this.conf, fs, mf, 100000), 100000);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected void runBenchmark(RowOrientedBenchmark benchmark, int rowCount) throws Exception {
        LOG.info((Object)("Running " + benchmark.getClass().getSimpleName() + " for " + rowCount + " rows."));
        long elapsedTime = benchmark.run();
        LOG.info((Object)("Running " + benchmark.getClass().getSimpleName() + " for " + rowCount + " rows took " + elapsedTime + "ms."));
    }

    public static void main(String[] args) throws Exception {
        new MapFilePerformanceEvaluation(HBaseConfiguration.create()).runBenchmarks();
    }

    static class GaussianRandomReadBenchmark
    extends ReadBenchmark {
        private RandomData randomData = new RandomDataImpl();

        public GaussianRandomReadBenchmark(Configuration conf, FileSystem fs, Path mf, int totalRows) {
            super(conf, fs, mf, totalRows);
        }

        @Override
        void doRow(int i) throws Exception {
            ImmutableBytesWritable k = this.getGaussianRandomRow();
            ImmutableBytesWritable r = (ImmutableBytesWritable)this.reader.get((WritableComparable)k, (Writable)this.value);
            PerformanceEvaluationCommons.assertValueSize(r.getLength(), 10);
        }

        private ImmutableBytesWritable getGaussianRandomRow() {
            int r = (int)this.randomData.nextGaussian((double)this.totalRows / 2.0, (double)this.totalRows / 10.0);
            return MapFilePerformanceEvaluation.format(r, this.key);
        }
    }

    static class UniformRandomSmallScan
    extends ReadBenchmark {
        private Random random = new Random();

        public UniformRandomSmallScan(Configuration conf, FileSystem fs, Path mf, int totalRows) {
            super(conf, fs, mf, totalRows / 10);
        }

        @Override
        void doRow(int i) throws Exception {
            ImmutableBytesWritable ibw = this.getRandomRow();
            WritableComparable wc = this.reader.getClosest((WritableComparable)ibw, (Writable)this.value);
            if (wc == null) {
                throw new NullPointerException();
            }
            PerformanceEvaluationCommons.assertKey(ibw.get(), ((ImmutableBytesWritable)wc).get());
            for (int ii = 0; ii < 29; ++ii) {
                this.reader.next((WritableComparable)this.key, (Writable)this.value);
                PerformanceEvaluationCommons.assertValueSize(this.value.getLength(), 10);
            }
        }

        private ImmutableBytesWritable getRandomRow() {
            return MapFilePerformanceEvaluation.format(this.random.nextInt(this.totalRows), this.key);
        }
    }

    static class UniformRandomReadBenchmark
    extends ReadBenchmark {
        private Random random = new Random();

        public UniformRandomReadBenchmark(Configuration conf, FileSystem fs, Path mf, int totalRows) {
            super(conf, fs, mf, totalRows);
        }

        @Override
        void doRow(int i) throws Exception {
            ImmutableBytesWritable k = this.getRandomRow();
            ImmutableBytesWritable r = (ImmutableBytesWritable)this.reader.get((WritableComparable)k, (Writable)this.value);
            PerformanceEvaluationCommons.assertValueSize(r.getLength(), 10);
        }

        private ImmutableBytesWritable getRandomRow() {
            return MapFilePerformanceEvaluation.format(this.random.nextInt(this.totalRows), this.key);
        }
    }

    static class SequentialReadBenchmark
    extends ReadBenchmark {
        ImmutableBytesWritable verify = new ImmutableBytesWritable();

        public SequentialReadBenchmark(Configuration conf, FileSystem fs, Path mf, int totalRows) {
            super(conf, fs, mf, totalRows);
        }

        @Override
        void doRow(int i) throws Exception {
            this.reader.next((WritableComparable)this.key, (Writable)this.value);
            PerformanceEvaluationCommons.assertKey(this.key.get(), MapFilePerformanceEvaluation.format(i, this.verify).get());
            PerformanceEvaluationCommons.assertValueSize(10, this.value.getLength());
        }

        @Override
        protected int getReportingPeriod() {
            return this.totalRows;
        }
    }

    static abstract class ReadBenchmark
    extends RowOrientedBenchmark {
        ImmutableBytesWritable key = new ImmutableBytesWritable();
        ImmutableBytesWritable value = new ImmutableBytesWritable();
        protected MapFile.Reader reader;

        public ReadBenchmark(Configuration conf, FileSystem fs, Path mf, int totalRows) {
            super(conf, fs, mf, totalRows);
        }

        @Override
        void setUp() throws Exception {
            this.reader = new MapFile.Reader(this.fs, this.mf.toString(), this.conf);
        }

        @Override
        void tearDown() throws Exception {
            this.reader.close();
        }
    }

    static class SequentialWriteBenchmark
    extends RowOrientedBenchmark {
        protected MapFile.Writer writer;
        private Random random = new Random();
        private byte[] bytes = new byte[10];
        private ImmutableBytesWritable key = new ImmutableBytesWritable();
        private ImmutableBytesWritable value = new ImmutableBytesWritable();

        public SequentialWriteBenchmark(Configuration conf, FileSystem fs, Path mf, int totalRows) {
            super(conf, fs, mf, totalRows);
        }

        @Override
        void setUp() throws Exception {
            this.writer = new MapFile.Writer(this.conf, this.fs, this.mf.toString(), ImmutableBytesWritable.class, ImmutableBytesWritable.class);
        }

        @Override
        void doRow(int i) throws Exception {
            this.value.set(this.generateValue());
            this.writer.append((WritableComparable)MapFilePerformanceEvaluation.format(i, this.key), (Writable)this.value);
        }

        private byte[] generateValue() {
            this.random.nextBytes(this.bytes);
            return this.bytes;
        }

        @Override
        protected int getReportingPeriod() {
            return this.totalRows;
        }

        @Override
        void tearDown() throws Exception {
            this.writer.close();
        }
    }

    static abstract class RowOrientedBenchmark {
        protected final Configuration conf;
        protected final FileSystem fs;
        protected final Path mf;
        protected final int totalRows;

        public RowOrientedBenchmark(Configuration conf, FileSystem fs, Path mf, int totalRows) {
            this.conf = conf;
            this.fs = fs;
            this.mf = mf;
            this.totalRows = totalRows;
        }

        void setUp() throws Exception {
        }

        abstract void doRow(int var1) throws Exception;

        protected int getReportingPeriod() {
            return this.totalRows / 10;
        }

        void tearDown() throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long run() throws Exception {
            long elapsedTime;
            this.setUp();
            long startTime = System.currentTimeMillis();
            try {
                for (int i = 0; i < this.totalRows; ++i) {
                    if (i > 0 && i % this.getReportingPeriod() == 0) {
                        LOG.info((Object)("Processed " + i + " rows."));
                    }
                    this.doRow(i);
                }
                elapsedTime = System.currentTimeMillis() - startTime;
            }
            finally {
                this.tearDown();
            }
            return elapsedTime;
        }
    }
}

