/*
 * Decompiled with CFR 0.152.
 */
package drill.shaded.hbase.guava.com.google.common.collect;

import drill.shaded.hbase.guava.com.google.common.annotations.GwtCompatible;
import drill.shaded.hbase.guava.com.google.common.collect.ImmutableCollection;
import drill.shaded.hbase.guava.com.google.common.collect.ImmutableList;
import drill.shaded.hbase.guava.com.google.common.collect.ImmutableMap;
import drill.shaded.hbase.guava.com.google.common.collect.ImmutableSet;
import drill.shaded.hbase.guava.com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;

@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableMap<K, V>
extends ImmutableMap<K, V> {
    final transient K singleKey;
    final transient V singleValue;

    SingletonImmutableMap(K singleKey, V singleValue) {
        this.singleKey = singleKey;
        this.singleValue = singleValue;
    }

    SingletonImmutableMap(Map.Entry<K, V> entry) {
        this(entry.getKey(), entry.getValue());
    }

    @Override
    public V get(@Nullable Object key) {
        return this.singleKey.equals(key) ? (V)this.singleValue : null;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.singleKey.equals(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.singleValue.equals(value);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return ImmutableSet.of(Maps.immutableEntry(this.singleKey, this.singleValue));
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return ImmutableSet.of(this.singleKey);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return ImmutableList.of(this.singleValue);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        Map that;
        if (object == this) {
            return true;
        }
        if (object instanceof Map && (that = (Map)object).size() == 1) {
            Map.Entry entry = that.entrySet().iterator().next();
            return this.singleKey.equals(entry.getKey()) && this.singleValue.equals(entry.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.singleKey.hashCode() ^ this.singleValue.hashCode();
    }
}

