/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.vint;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class UFIntTool {
    private static final int NUM_BITS_IN_LONG = 64;
    private static final long[] MASKS = new long[]{255L, 65280L, 0xFF0000L, 0xFF000000L, 0xFF00000000L, 0xFF0000000000L, 0xFF000000000000L, -72057594037927936L};

    public static long maxValueForNumBytes(int numBytes) {
        return (1L << numBytes * 8) - 1L;
    }

    public static int numBytes(long value) {
        if (value == 0L) {
            return 1;
        }
        return (71 - Long.numberOfLeadingZeros(value)) / 8;
    }

    public static byte[] getBytes(int outputWidth, long value) {
        byte[] bytes = new byte[outputWidth];
        UFIntTool.writeBytes(outputWidth, value, bytes, 0);
        return bytes;
    }

    public static void writeBytes(int outputWidth, long value, byte[] bytes, int offset) {
        bytes[offset + outputWidth - 1] = (byte)value;
        for (int i = outputWidth - 2; i >= 0; --i) {
            bytes[offset + i] = (byte)(value >>> (outputWidth - i - 1) * 8);
        }
    }

    public static void writeBytes(int outputWidth, long value, OutputStream os) throws IOException {
        for (int i = outputWidth - 1; i >= 0; --i) {
            os.write((byte)((value & MASKS[i]) >>> 8 * i));
        }
    }

    public static long fromBytes(byte[] bytes) {
        long value = 0L;
        value |= (long)(bytes[0] & 0xFF);
        for (int i = 1; i < bytes.length; ++i) {
            value <<= 8;
            value |= (long)(bytes[i] & 0xFF);
        }
        return value;
    }

    public static long fromBytes(byte[] bytes, int offset, int width) {
        long value = 0L;
        value |= (long)(bytes[0 + offset] & 0xFF);
        for (int i = 1; i < width; ++i) {
            value <<= 8;
            value |= (long)(bytes[i + offset] & 0xFF);
        }
        return value;
    }
}

