/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import drill.shaded.hbase.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.AbstractByteRange;
import org.apache.hadoop.hbase.util.PositionedByteRange;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class AbstractPositionedByteRange
extends AbstractByteRange
implements PositionedByteRange {
    protected int position = 0;
    protected int limit = 0;

    @Override
    public abstract PositionedByteRange unset();

    @Override
    public PositionedByteRange set(int capacity) {
        this.position = 0;
        super.set(capacity);
        this.limit = capacity;
        return this;
    }

    @Override
    public PositionedByteRange set(byte[] bytes) {
        this.position = 0;
        super.set(bytes);
        this.limit = bytes.length;
        return this;
    }

    @Override
    public PositionedByteRange set(byte[] bytes, int offset, int length) {
        this.position = 0;
        super.set(bytes, offset, length);
        this.limit = length;
        return this;
    }

    @Override
    public PositionedByteRange setOffset(int offset) {
        this.position = 0;
        super.setOffset(offset);
        return this;
    }

    @Override
    public PositionedByteRange setLength(int length) {
        this.position = Math.min(this.position, length);
        super.setLength(length);
        return this;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public PositionedByteRange setPosition(int position) {
        this.position = position;
        return this;
    }

    @Override
    public int getRemaining() {
        return this.length - this.position;
    }

    @Override
    public byte peek() {
        return this.bytes[this.offset + this.position];
    }

    @Override
    public byte get() {
        return this.get(this.position++);
    }

    @Override
    public PositionedByteRange get(byte[] dst) {
        if (0 == dst.length) {
            return this;
        }
        return this.get(dst, 0, dst.length);
    }

    @Override
    public PositionedByteRange get(byte[] dst, int offset, int length) {
        if (0 == length) {
            return this;
        }
        super.get(this.position, dst, offset, length);
        this.position += length;
        return this;
    }

    @Override
    public abstract PositionedByteRange put(byte var1);

    @Override
    public abstract PositionedByteRange put(byte[] var1);

    @Override
    public abstract PositionedByteRange put(byte[] var1, int var2, int var3);

    @Override
    public abstract PositionedByteRange putInt(int var1, int var2);

    @Override
    public abstract PositionedByteRange putLong(int var1, long var2);

    @Override
    public abstract PositionedByteRange putShort(int var1, short var2);

    @Override
    public abstract PositionedByteRange putInt(int var1);

    @Override
    public abstract PositionedByteRange putLong(long var1);

    @Override
    public abstract PositionedByteRange putShort(short var1);

    @Override
    public abstract int putVLong(int var1, long var2);

    @Override
    public abstract int putVLong(long var1);

    @VisibleForTesting
    PositionedByteRange flip() {
        this.clearHashCache();
        this.length = this.position;
        this.position = this.offset;
        return this;
    }

    @VisibleForTesting
    PositionedByteRange clear() {
        this.clearHashCache();
        this.position = 0;
        this.length = this.bytes.length - this.offset;
        return this;
    }

    @Override
    public PositionedByteRange get(int index, byte[] dst) {
        super.get(index, dst);
        return this;
    }

    @Override
    public PositionedByteRange get(int index, byte[] dst, int offset, int length) {
        super.get(index, dst, offset, length);
        return this;
    }

    @Override
    public short getShort() {
        short s = this.getShort(this.position);
        this.position += 2;
        return s;
    }

    @Override
    public int getInt() {
        int i = this.getInt(this.position);
        this.position += 4;
        return i;
    }

    @Override
    public long getLong() {
        long l = this.getLong(this.position);
        this.position += 8;
        return l;
    }

    @Override
    public long getVLong() {
        long p = this.getVLong(this.position);
        this.position += AbstractPositionedByteRange.getVLongSize(p);
        return p;
    }

    @Override
    public abstract PositionedByteRange put(int var1, byte var2);

    @Override
    public abstract PositionedByteRange put(int var1, byte[] var2);

    @Override
    public abstract PositionedByteRange put(int var1, byte[] var2, int var3, int var4);

    @Override
    public abstract PositionedByteRange deepCopy();

    @Override
    public abstract PositionedByteRange shallowCopy();

    @Override
    public abstract PositionedByteRange shallowCopySubRange(int var1, int var2);

    @Override
    public PositionedByteRange setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }
}

