/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ChainWALEntryFilter;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ScopeWALEntryFilter;
import org.apache.hadoop.hbase.replication.SystemTableWALEntryFilter;
import org.apache.hadoop.hbase.replication.TableCfWALEntryFilter;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKey;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestReplicationWALEntryFilters {
    static byte[] a = new byte[]{97};
    static byte[] b = new byte[]{98};
    static byte[] c = new byte[]{99};
    static byte[] d = new byte[]{100};
    WALEntryFilter nullFilter = new WALEntryFilter(){

        @Override
        public WAL.Entry filter(WAL.Entry entry) {
            return null;
        }
    };
    WALEntryFilter passFilter = new WALEntryFilter(){

        @Override
        public WAL.Entry filter(WAL.Entry entry) {
            return entry;
        }
    };

    @Test
    public void testSystemTableWALEntryFilter() {
        SystemTableWALEntryFilter filter = new SystemTableWALEntryFilter();
        WALKey key1 = new WALKey(HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes(), TableName.META_TABLE_NAME);
        WAL.Entry metaEntry = new WAL.Entry(key1, null);
        Assert.assertNull((Object)filter.filter(metaEntry));
        WALKey key2 = new WALKey(new byte[0], TableName.NAMESPACE_TABLE_NAME);
        WAL.Entry nsEntry = new WAL.Entry(key2, null);
        Assert.assertNull((Object)filter.filter(nsEntry));
        WALKey key3 = new WALKey(new byte[0], TableName.valueOf("foo"));
        WAL.Entry userEntry = new WAL.Entry(key3, null);
        this.assertEquals(userEntry, filter.filter(userEntry));
    }

    @Test
    public void testScopeWALEntryFilter() {
        ScopeWALEntryFilter filter = new ScopeWALEntryFilter();
        WAL.Entry userEntry = this.createEntry(a, b);
        WAL.Entry userEntryA = this.createEntry(new byte[][]{a});
        WAL.Entry userEntryB = this.createEntry(new byte[][]{b});
        WAL.Entry userEntryEmpty = this.createEntry(new byte[0][]);
        this.assertEquals(null, filter.filter(userEntry));
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        userEntry = this.createEntry(a, b);
        userEntry.getKey().setScopes(scopes);
        this.assertEquals(null, filter.filter(userEntry));
        scopes = new TreeMap(Bytes.BYTES_COMPARATOR);
        scopes.put(c, 1);
        userEntry = this.createEntry(a, b);
        userEntry.getKey().setScopes(scopes);
        this.assertEquals(userEntryEmpty, filter.filter(userEntry));
        scopes = new TreeMap(Bytes.BYTES_COMPARATOR);
        scopes.put(a, 0);
        userEntry = this.createEntry(a, b);
        userEntry.getKey().setScopes(scopes);
        this.assertEquals(userEntryEmpty, filter.filter(userEntry));
        scopes.put(b, 0);
        this.assertEquals(userEntryEmpty, filter.filter(userEntry));
        scopes = new TreeMap(Bytes.BYTES_COMPARATOR);
        scopes.put(a, 1);
        userEntry = this.createEntry(a, b);
        userEntry.getKey().setScopes(scopes);
        this.assertEquals(userEntryA, filter.filter(userEntry));
        scopes.put(b, 0);
        this.assertEquals(userEntryA, filter.filter(userEntry));
        scopes = new TreeMap(Bytes.BYTES_COMPARATOR);
        scopes.put(b, 1);
        userEntry = this.createEntry(a, b);
        userEntry.getKey().setScopes(scopes);
        this.assertEquals(userEntryB, filter.filter(userEntry));
        scopes.put(a, 0);
        this.assertEquals(userEntryB, filter.filter(userEntry));
        scopes = new TreeMap(Bytes.BYTES_COMPARATOR);
        scopes.put(b, 1);
        userEntry = this.createEntry(a, b);
        userEntry.getKey().setScopes(scopes);
        this.assertEquals(userEntryB, filter.filter(userEntry));
        scopes.put(a, 0);
        this.assertEquals(userEntryB, filter.filter(userEntry));
    }

    @Test
    public void testChainWALEntryFilter() {
        WAL.Entry userEntry = this.createEntry(a, b, c);
        ChainWALEntryFilter filter = new ChainWALEntryFilter(this.passFilter);
        this.assertEquals(this.createEntry(a, b, c), filter.filter(userEntry));
        filter = new ChainWALEntryFilter(this.passFilter, this.passFilter);
        this.assertEquals(this.createEntry(a, b, c), filter.filter(userEntry));
        filter = new ChainWALEntryFilter(this.passFilter, this.passFilter, this.passFilter);
        this.assertEquals(this.createEntry(a, b, c), filter.filter(userEntry));
        filter = new ChainWALEntryFilter(this.nullFilter);
        this.assertEquals(null, filter.filter(userEntry));
        filter = new ChainWALEntryFilter(this.nullFilter, this.passFilter);
        this.assertEquals(null, filter.filter(userEntry));
        filter = new ChainWALEntryFilter(this.passFilter, this.nullFilter);
        this.assertEquals(null, filter.filter(userEntry));
        filter = new ChainWALEntryFilter(this.nullFilter, this.passFilter, this.nullFilter);
        this.assertEquals(null, filter.filter(userEntry));
        filter = new ChainWALEntryFilter(this.nullFilter, this.nullFilter);
        this.assertEquals(null, filter.filter(userEntry));
        filter = new ChainWALEntryFilter(new ChainWALEntryFilter(this.passFilter, new ChainWALEntryFilter(this.passFilter, this.passFilter), new ChainWALEntryFilter(this.passFilter), new ChainWALEntryFilter(this.passFilter)), new ChainWALEntryFilter(this.passFilter));
        this.assertEquals(this.createEntry(a, b, c), filter.filter(userEntry));
        filter = new ChainWALEntryFilter(new ChainWALEntryFilter(this.passFilter, new ChainWALEntryFilter(this.passFilter, new ChainWALEntryFilter(this.nullFilter))), new ChainWALEntryFilter(this.passFilter));
        this.assertEquals(null, filter.filter(userEntry));
    }

    @Test
    public void testTableCfWALEntryFilter() {
        ReplicationPeer peer = (ReplicationPeer)Mockito.mock(ReplicationPeer.class);
        Mockito.when(peer.getTableCFs()).thenReturn(null);
        WAL.Entry userEntry = this.createEntry(a, b, c);
        TableCfWALEntryFilter filter = new TableCfWALEntryFilter(peer);
        this.assertEquals(this.createEntry(a, b, c), filter.filter(userEntry));
        userEntry = this.createEntry(a, b, c);
        HashMap<TableName, ArrayList<String>> tableCfs = new HashMap<TableName, ArrayList<String>>();
        Mockito.when(peer.getTableCFs()).thenReturn(tableCfs);
        filter = new TableCfWALEntryFilter(peer);
        this.assertEquals(null, filter.filter(userEntry));
        userEntry = this.createEntry(a, b, c);
        tableCfs = new HashMap();
        tableCfs.put(TableName.valueOf("bar"), null);
        Mockito.when(peer.getTableCFs()).thenReturn(tableCfs);
        filter = new TableCfWALEntryFilter(peer);
        this.assertEquals(null, filter.filter(userEntry));
        userEntry = this.createEntry(a, b, c);
        tableCfs = new HashMap();
        tableCfs.put(TableName.valueOf("foo"), Lists.newArrayList("a"));
        Mockito.when(peer.getTableCFs()).thenReturn(tableCfs);
        filter = new TableCfWALEntryFilter(peer);
        this.assertEquals(this.createEntry(new byte[][]{a}), filter.filter(userEntry));
        userEntry = this.createEntry(a, b, c, d);
        tableCfs = new HashMap();
        tableCfs.put(TableName.valueOf("foo"), Lists.newArrayList("a", "c"));
        Mockito.when(peer.getTableCFs()).thenReturn(tableCfs);
        filter = new TableCfWALEntryFilter(peer);
        this.assertEquals(this.createEntry(a, c), filter.filter(userEntry));
    }

    private WAL.Entry createEntry(byte[] ... kvs) {
        WALKey key1 = new WALKey(new byte[0], TableName.valueOf("foo"));
        WALEdit edit1 = new WALEdit();
        for (byte[] kv : kvs) {
            edit1.add(new KeyValue(kv, kv, kv));
        }
        return new WAL.Entry(key1, edit1);
    }

    private void assertEquals(WAL.Entry e1, WAL.Entry e2) {
        Assert.assertEquals((Object)(e1 == null ? 1 : 0), (Object)(e2 == null ? 1 : 0));
        if (e1 == null) {
            return;
        }
        Assert.assertEquals((Object)(e1.getEdit() == null ? 1 : 0), (Object)(e2.getEdit() == null ? 1 : 0));
        if (e1.getEdit() == null) {
            return;
        }
        ArrayList<Cell> cells1 = e1.getEdit().getCells();
        ArrayList<Cell> cells2 = e2.getEdit().getCells();
        Assert.assertEquals((long)cells1.size(), (long)cells2.size());
        for (int i = 0; i < cells1.size(); ++i) {
            KeyValue.COMPARATOR.compare((Cell)cells1.get(i), (Cell)cells2.get(i));
        }
    }
}

