/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestReplicationChangingPeerRegionservers
extends TestReplicationBase {
    private static final Log LOG = LogFactory.getLog(TestReplicationChangingPeerRegionservers.class);

    @Before
    public void setUp() throws Exception {
        for (JVMClusterUtil.RegionServerThread r : utility1.getHBaseCluster().getRegionServerThreads()) {
            utility1.getHBaseAdmin().rollWALWriter(r.getRegionServer().getServerName());
        }
        utility1.deleteTableData(tableName);
        Scan scan = new Scan();
        int lastCount = 0;
        for (int i = 0; i < 10; ++i) {
            if (i == 9) {
                Assert.fail((String)"Waited too much time for truncate");
            }
            ResultScanner scanner = htable2.getScanner(scan);
            Result[] res = scanner.next(1000);
            scanner.close();
            if (res.length == 0) break;
            if (res.length < lastCount) {
                --i;
            }
            lastCount = res.length;
            LOG.info((Object)("Still got " + res.length + " rows"));
            Thread.sleep(500L);
        }
    }

    @Test(timeout=300000L)
    public void testChangingNumberOfPeerRegionServers() throws IOException, InterruptedException {
        LOG.info((Object)"testSimplePutDelete");
        MiniHBaseCluster peerCluster = utility2.getMiniHBaseCluster();
        this.doPutTest(Bytes.toBytes(1));
        int rsToStop = peerCluster.getServerWithMeta() == 0 ? 1 : 0;
        peerCluster.stopRegionServer(rsToStop);
        peerCluster.waitOnRegionServer(rsToStop);
        Assert.assertEquals((long)1L, (long)peerCluster.getRegionServerThreads().size());
        this.doPutTest(Bytes.toBytes(2));
        peerCluster.startRegionServer();
        Assert.assertEquals((long)2L, (long)peerCluster.getRegionServerThreads().size());
        this.doPutTest(Bytes.toBytes(3));
    }

    private void doPutTest(byte[] row) throws IOException, InterruptedException {
        Put put = new Put(row);
        put.add(famName, row, row);
        if (htable1 == null) {
            htable1 = utility1.getConnection().getTable(tableName);
        }
        htable1.put(put);
        Get get = new Get(row);
        for (int i = 0; i < 10; ++i) {
            Result res;
            if (i == 9) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if ((res = htable2.get(get)).size() != 0) {
                Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                break;
            }
            LOG.info((Object)"Row not available");
            Thread.sleep(500L);
        }
    }
}

