/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={SmallTests.class})
public class TestScanner {
    @Rule
    public TestName name = new TestName();
    private final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = HBaseTestingUtility.createLocalHTU();
    private static final byte[] FIRST_ROW = HConstants.EMPTY_START_ROW;
    private static final byte[][] COLS = new byte[][]{HConstants.CATALOG_FAMILY};
    private static final byte[][] EXPLICIT_COLS = new byte[][]{HConstants.REGIONINFO_QUALIFIER, HConstants.SERVER_QUALIFIER};
    static final HTableDescriptor TESTTABLEDESC = new HTableDescriptor(TableName.valueOf("testscanner"));
    public static final HRegionInfo REGION_INFO;
    private static final byte[] ROW_KEY;
    private static final long START_CODE = Long.MAX_VALUE;
    private HRegion r;
    private HBaseTestCase.HRegionIncommon region;
    private byte[] firstRowBytes = HBaseTestingUtility.START_KEY_BYTES;
    private byte[] secondRowBytes = (byte[])HBaseTestingUtility.START_KEY_BYTES.clone();
    private byte[] thirdRowBytes;
    private final byte[] col1;
    private final byte[] col2;

    public TestScanner() {
        int n = HBaseTestingUtility.START_KEY_BYTES.length - 1;
        this.secondRowBytes[n] = (byte)(this.secondRowBytes[n] + 1);
        this.thirdRowBytes = (byte[])HBaseTestingUtility.START_KEY_BYTES.clone();
        int n2 = HBaseTestingUtility.START_KEY_BYTES.length - 1;
        this.thirdRowBytes[n2] = (byte)(this.thirdRowBytes[n2] + 2);
        this.col1 = Bytes.toBytes("column1");
        this.col2 = Bytes.toBytes("column2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStopRow() throws Exception {
        byte[] startrow = Bytes.toBytes("bbb");
        byte[] stoprow = Bytes.toBytes("ccc");
        try {
            this.r = TEST_UTIL.createLocalHRegion(TESTTABLEDESC, null, null);
            HBaseTestCase.addContent(this.r, HConstants.CATALOG_FAMILY);
            ArrayList<Cell> results = new ArrayList<Cell>();
            Scan scan = new Scan(Bytes.toBytes("abc"), Bytes.toBytes("abd"));
            scan.addFamily(HConstants.CATALOG_FAMILY);
            RegionScanner s = this.r.getScanner(scan);
            int count = 0;
            while (s.next(results)) {
                ++count;
            }
            s.close();
            Assert.assertEquals((long)0L, (long)count);
            scan = new Scan(startrow, stoprow);
            scan.addFamily(HConstants.CATALOG_FAMILY);
            s = this.r.getScanner(scan);
            count = 0;
            Cell kv = null;
            results = new ArrayList();
            boolean first = true;
            while (s.next(results)) {
                kv = (Cell)results.get(0);
                if (first) {
                    Assert.assertTrue((boolean)CellUtil.matchingRow(kv, startrow));
                    first = false;
                }
                ++count;
            }
            Assert.assertTrue((Bytes.BYTES_COMPARATOR.compare(stoprow, CellUtil.cloneRow(kv)) > 0 ? 1 : 0) != 0);
            Assert.assertTrue((count > 10 ? 1 : 0) != 0);
            s.close();
        }
        finally {
            HRegion.closeHRegion(this.r);
        }
    }

    void rowPrefixFilter(Scan scan) throws IOException {
        ArrayList<Cell> results = new ArrayList<Cell>();
        scan.addFamily(HConstants.CATALOG_FAMILY);
        RegionScanner s = this.r.getScanner(scan);
        boolean hasMore = true;
        while (hasMore) {
            hasMore = s.next(results);
            for (Cell kv : results) {
                Assert.assertEquals((long)97L, (long)CellUtil.cloneRow(kv)[0]);
                Assert.assertEquals((long)98L, (long)CellUtil.cloneRow(kv)[1]);
            }
            results.clear();
        }
        s.close();
    }

    void rowInclusiveStopFilter(Scan scan, byte[] stopRow) throws IOException {
        ArrayList<Cell> results = new ArrayList<Cell>();
        scan.addFamily(HConstants.CATALOG_FAMILY);
        RegionScanner s = this.r.getScanner(scan);
        boolean hasMore = true;
        while (hasMore) {
            hasMore = s.next(results);
            for (Cell kv : results) {
                Assert.assertTrue((Bytes.compareTo(CellUtil.cloneRow(kv), stopRow) <= 0 ? 1 : 0) != 0);
            }
            results.clear();
        }
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilters() throws IOException {
        try {
            this.r = TEST_UTIL.createLocalHRegion(TESTTABLEDESC, null, null);
            HBaseTestCase.addContent(this.r, HConstants.CATALOG_FAMILY);
            byte[] prefix = Bytes.toBytes("ab");
            FilterBase newFilter = new PrefixFilter(prefix);
            Scan scan = new Scan();
            scan.setFilter(newFilter);
            this.rowPrefixFilter(scan);
            byte[] stopRow = Bytes.toBytes("bbc");
            newFilter = new WhileMatchFilter(new InclusiveStopFilter(stopRow));
            scan = new Scan();
            scan.setFilter(newFilter);
            this.rowInclusiveStopFilter(scan, stopRow);
        }
        finally {
            HRegion.closeHRegion(this.r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRaceBetweenClientAndTimeout() throws Exception {
        try {
            this.r = TEST_UTIL.createLocalHRegion(TESTTABLEDESC, null, null);
            HBaseTestCase.addContent(this.r, HConstants.CATALOG_FAMILY);
            Scan scan = new Scan();
            RegionScanner s = this.r.getScanner(scan);
            ArrayList<Cell> results = new ArrayList<Cell>();
            try {
                s.next(results);
                s.close();
                s.next(results);
                Assert.fail((String)"We don't want anything more, we should be failing");
            }
            catch (UnknownScannerException ex) {
                HRegion.closeHRegion(this.r);
                return;
            }
        }
        finally {
            HRegion.closeHRegion(this.r);
        }
    }

    @Test
    public void testScanner() throws IOException {
        try {
            this.r = TEST_UTIL.createLocalHRegion(TESTTABLEDESC, null, null);
            this.region = new HBaseTestCase.HRegionIncommon(this.r);
            Put put = new Put(ROW_KEY, System.currentTimeMillis());
            put.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, REGION_INFO.toByteArray());
            this.region.put(put);
            this.scan(false, null);
            this.getRegionInfo();
            this.r.close();
            this.r = HRegion.openHRegion(this.r, null);
            this.region = new HBaseTestCase.HRegionIncommon(this.r);
            this.scan(false, null);
            this.getRegionInfo();
            String address = "127.0.0.1:" + HBaseTestingUtility.randomFreePort();
            put = new Put(ROW_KEY, System.currentTimeMillis());
            put.add(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes(address));
            this.region.put(put);
            this.scan(true, address.toString());
            this.getRegionInfo();
            this.region.flushcache();
            this.scan(true, address.toString());
            this.getRegionInfo();
            this.r.close();
            this.r = HRegion.openHRegion(this.r, null);
            this.region = new HBaseTestCase.HRegionIncommon(this.r);
            this.scan(true, address.toString());
            this.getRegionInfo();
            address = "bar.foo.com:4321";
            put = new Put(ROW_KEY, System.currentTimeMillis());
            put.add(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes(address));
            this.region.put(put);
            this.scan(true, address.toString());
            this.getRegionInfo();
            this.region.flushcache();
            this.scan(true, address.toString());
            this.getRegionInfo();
            this.r.close();
            this.r = HRegion.openHRegion(this.r, null);
            this.region = new HBaseTestCase.HRegionIncommon(this.r);
            this.scan(true, address.toString());
            this.getRegionInfo();
        }
        finally {
            HRegion.closeHRegion(this.r);
        }
    }

    private void validateRegionInfo(byte[] regionBytes) throws IOException {
        HRegionInfo info = HRegionInfo.parseFromOrNull(regionBytes);
        Assert.assertEquals((long)REGION_INFO.getRegionId(), (long)info.getRegionId());
        Assert.assertEquals((long)0L, (long)info.getStartKey().length);
        Assert.assertEquals((long)0L, (long)info.getEndKey().length);
        Assert.assertEquals((long)0L, (long)Bytes.compareTo(info.getRegionName(), REGION_INFO.getRegionName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(boolean validateStartcode, String serverName) throws IOException {
        InternalScanner scanner = null;
        Scan scan = null;
        ArrayList<Cell> results = new ArrayList<Cell>();
        byte[][][] scanColumns = new byte[][][]{COLS, EXPLICIT_COLS};
        for (int i = 0; i < scanColumns.length; ++i) {
            try {
                scan = new Scan(FIRST_ROW);
                for (int ii = 0; ii < EXPLICIT_COLS.length; ++ii) {
                    scan.addColumn(COLS[0], EXPLICIT_COLS[ii]);
                }
                scanner = this.r.getScanner(scan);
                while (scanner.next(results)) {
                    Assert.assertTrue((boolean)this.hasColumn(results, HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER));
                    byte[] val = CellUtil.cloneValue(this.getColumn(results, HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER));
                    this.validateRegionInfo(val);
                    if (validateStartcode) {
                        Assert.assertNotNull((Object)val);
                        Assert.assertFalse((val.length == 0 ? 1 : 0) != 0);
                        long startCode = Bytes.toLong(val);
                        Assert.assertEquals((long)Long.MAX_VALUE, (long)startCode);
                    }
                    if (serverName == null) continue;
                    Assert.assertTrue((boolean)this.hasColumn(results, HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER));
                    val = CellUtil.cloneValue(this.getColumn(results, HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER));
                    Assert.assertNotNull((Object)val);
                    Assert.assertFalse((val.length == 0 ? 1 : 0) != 0);
                    String server = Bytes.toString(val);
                    Assert.assertEquals((long)0L, (long)server.compareTo(serverName));
                }
                continue;
            }
            finally {
                InternalScanner s = scanner;
                scanner = null;
                if (s != null) {
                    s.close();
                }
            }
        }
    }

    private boolean hasColumn(List<Cell> kvs, byte[] family, byte[] qualifier) {
        for (Cell kv : kvs) {
            if (!CellUtil.matchingFamily(kv, family) || !CellUtil.matchingQualifier(kv, qualifier)) continue;
            return true;
        }
        return false;
    }

    private Cell getColumn(List<Cell> kvs, byte[] family, byte[] qualifier) {
        for (Cell kv : kvs) {
            if (!CellUtil.matchingFamily(kv, family) || !CellUtil.matchingQualifier(kv, qualifier)) continue;
            return kv;
        }
        return null;
    }

    private void getRegionInfo() throws IOException {
        Get get = new Get(ROW_KEY);
        get.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        Result result = this.region.get(get);
        byte[] bytes = result.value();
        this.validateRegionInfo(bytes);
    }

    @Test
    public void testScanAndSyncFlush() throws Exception {
        this.r = TEST_UTIL.createLocalHRegion(TESTTABLEDESC, null, null);
        HBaseTestCase.HRegionIncommon hri = new HBaseTestCase.HRegionIncommon(this.r);
        try {
            this.LOG.info((Object)("Added: " + HBaseTestCase.addContent(hri, Bytes.toString(HConstants.CATALOG_FAMILY), Bytes.toString(HConstants.REGIONINFO_QUALIFIER))));
            int count = this.count(hri, -1, false);
            Assert.assertEquals((long)count, (long)this.count(hri, 100, false));
        }
        catch (Exception e) {
            this.LOG.error((Object)"Failed", (Throwable)e);
            throw e;
        }
        finally {
            HRegion.closeHRegion(this.r);
        }
    }

    @Test
    public void testScanAndRealConcurrentFlush() throws Exception {
        this.r = TEST_UTIL.createLocalHRegion(TESTTABLEDESC, null, null);
        HBaseTestCase.HRegionIncommon hri = new HBaseTestCase.HRegionIncommon(this.r);
        try {
            this.LOG.info((Object)("Added: " + HBaseTestCase.addContent(hri, Bytes.toString(HConstants.CATALOG_FAMILY), Bytes.toString(HConstants.REGIONINFO_QUALIFIER))));
            int count = this.count(hri, -1, false);
            Assert.assertEquals((long)count, (long)this.count(hri, 100, true));
        }
        catch (Exception e) {
            this.LOG.error((Object)"Failed", (Throwable)e);
            throw e;
        }
        finally {
            HRegion.closeHRegion(this.r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanAndConcurrentMajorCompact() throws Exception {
        HTableDescriptor htd = TEST_UTIL.createTableDescriptor(this.name.getMethodName());
        this.r = TEST_UTIL.createLocalHRegion(htd, null, null);
        HBaseTestCase.HRegionIncommon hri = new HBaseTestCase.HRegionIncommon(this.r);
        try {
            HBaseTestCase.addContent(hri, Bytes.toString(HBaseTestingUtility.fam1), Bytes.toString(this.col1), this.firstRowBytes, this.secondRowBytes);
            HBaseTestCase.addContent(hri, Bytes.toString(HBaseTestingUtility.fam2), Bytes.toString(this.col1), this.firstRowBytes, this.secondRowBytes);
            Delete dc = new Delete(this.firstRowBytes);
            dc.deleteColumns(HBaseTestingUtility.fam1, this.col1);
            this.r.delete(dc);
            this.r.flush(true);
            HBaseTestCase.addContent(hri, Bytes.toString(HBaseTestingUtility.fam1), Bytes.toString(this.col1), this.secondRowBytes, this.thirdRowBytes);
            HBaseTestCase.addContent(hri, Bytes.toString(HBaseTestingUtility.fam2), Bytes.toString(this.col1), this.secondRowBytes, this.thirdRowBytes);
            this.r.flush(true);
            RegionScanner s = this.r.getScanner(new Scan());
            this.r.compact(true);
            ArrayList<Cell> results = new ArrayList<Cell>();
            s.next(results);
            Assert.assertTrue((String)("result is not correct, keyValues : " + results), (results.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)CellUtil.matchingRow((Cell)results.get(0), this.firstRowBytes));
            Assert.assertTrue((boolean)CellUtil.matchingFamily((Cell)results.get(0), HBaseTestingUtility.fam2));
            results = new ArrayList();
            s.next(results);
            Assert.assertTrue((results.size() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)CellUtil.matchingRow((Cell)results.get(0), this.secondRowBytes));
            Assert.assertTrue((boolean)CellUtil.matchingFamily((Cell)results.get(0), HBaseTestingUtility.fam1));
            Assert.assertTrue((boolean)CellUtil.matchingFamily((Cell)results.get(1), HBaseTestingUtility.fam2));
        }
        finally {
            HRegion.closeHRegion(this.r);
        }
    }

    private int count(final HBaseTestCase.HRegionIncommon hri, int flushIndex, boolean concurrent) throws IOException {
        this.LOG.info((Object)"Taking out counting scan");
        HBaseTestCase.ScannerIncommon s = hri.getScanner(HConstants.CATALOG_FAMILY, EXPLICIT_COLS, HConstants.EMPTY_START_ROW, Long.MAX_VALUE);
        ArrayList<Cell> values = new ArrayList<Cell>();
        int count = 0;
        boolean justFlushed = false;
        while (s.next(values)) {
            if (justFlushed) {
                this.LOG.info((Object)"after next() just after next flush");
                justFlushed = false;
            }
            if (flushIndex != ++count) continue;
            this.LOG.info((Object)("Starting flush at flush index " + flushIndex));
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        hri.flushcache();
                        TestScanner.this.LOG.info((Object)"Finishing flush");
                    }
                    catch (IOException e) {
                        TestScanner.this.LOG.info((Object)"Failed flush cache");
                    }
                }
            };
            if (concurrent) {
                t.start();
            } else {
                t.run();
            }
            this.LOG.info((Object)"Continuing on after kicking off background flush");
            justFlushed = true;
        }
        s.close();
        this.LOG.info((Object)("Found " + count + " items"));
        return count;
    }

    static {
        TESTTABLEDESC.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY).setMaxVersions(10).setBlockCacheEnabled(false).setBlocksize(8192));
        REGION_INFO = new HRegionInfo(TESTTABLEDESC.getTableName(), HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY);
        ROW_KEY = REGION_INFO.getRegionName();
    }
}

