/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestCompactSplitThread {
    private static final Log LOG = LogFactory.getLog(TestCompactSplitThread.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final TableName tableName = TableName.valueOf(this.getClass().getSimpleName());
    private final byte[] family = Bytes.toBytes("f");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThreadPoolSizeTuning() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.regionserver.thread.compaction.large", 3);
        conf.setInt("hbase.regionserver.thread.compaction.small", 4);
        conf.setInt("hbase.regionserver.thread.split", 5);
        conf.setInt("hbase.regionserver.thread.merge", 6);
        TEST_UTIL.startMiniCluster(1);
        Connection conn = ConnectionFactory.createConnection(conf);
        try {
            HTableDescriptor htd = new HTableDescriptor(this.tableName);
            htd.addFamily(new HColumnDescriptor(this.family));
            htd.setCompactionEnabled(false);
            TEST_UTIL.getHBaseAdmin().createTable(htd);
            TEST_UTIL.waitTableAvailable(this.tableName);
            HRegionServer regionServer = TEST_UTIL.getRSForFirstRegionInTable(this.tableName);
            Assert.assertEquals((long)3L, (long)regionServer.compactSplitThread.getLargeCompactionThreadNum());
            Assert.assertEquals((long)4L, (long)regionServer.compactSplitThread.getSmallCompactionThreadNum());
            Assert.assertEquals((long)5L, (long)regionServer.compactSplitThread.getSplitThreadNum());
            Assert.assertEquals((long)6L, (long)regionServer.compactSplitThread.getMergeThreadNum());
            conf.setInt("hbase.regionserver.thread.compaction.large", 4);
            conf.setInt("hbase.regionserver.thread.compaction.small", 5);
            conf.setInt("hbase.regionserver.thread.split", 6);
            conf.setInt("hbase.regionserver.thread.merge", 7);
            try {
                regionServer.compactSplitThread.onConfigurationChange(conf);
            }
            catch (IllegalArgumentException iae) {
                Assert.fail((String)"Update bigger configuration failed!");
            }
            Assert.assertEquals((long)4L, (long)regionServer.compactSplitThread.getLargeCompactionThreadNum());
            Assert.assertEquals((long)5L, (long)regionServer.compactSplitThread.getSmallCompactionThreadNum());
            Assert.assertEquals((long)6L, (long)regionServer.compactSplitThread.getSplitThreadNum());
            Assert.assertEquals((long)7L, (long)regionServer.compactSplitThread.getMergeThreadNum());
            conf.setInt("hbase.regionserver.thread.compaction.large", 2);
            conf.setInt("hbase.regionserver.thread.compaction.small", 3);
            conf.setInt("hbase.regionserver.thread.split", 4);
            conf.setInt("hbase.regionserver.thread.merge", 5);
            try {
                regionServer.compactSplitThread.onConfigurationChange(conf);
            }
            catch (IllegalArgumentException iae) {
                Assert.fail((String)"Update smaller configuration failed!");
            }
            Assert.assertEquals((long)2L, (long)regionServer.compactSplitThread.getLargeCompactionThreadNum());
            Assert.assertEquals((long)3L, (long)regionServer.compactSplitThread.getSmallCompactionThreadNum());
            Assert.assertEquals((long)4L, (long)regionServer.compactSplitThread.getSplitThreadNum());
            Assert.assertEquals((long)5L, (long)regionServer.compactSplitThread.getMergeThreadNum());
        }
        finally {
            conn.close();
            TEST_UTIL.shutdownMiniCluster();
        }
    }
}

