/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ProcedureFairRunQueues<TKey, TQueue extends FairObject> {
    private ConcurrentSkipListMap<TKey, TQueue> objMap = new ConcurrentSkipListMap();
    private final ReentrantLock lock = new ReentrantLock();
    private final int quantum;
    private Map.Entry<TKey, TQueue> current = null;
    private int currentQuantum = 0;

    public ProcedureFairRunQueues(int quantum) {
        this.quantum = quantum;
    }

    public TQueue get(TKey key) {
        return (TQueue)((FairObject)this.objMap.get(key));
    }

    public TQueue add(TKey key, TQueue queue) {
        FairObject oldq = (FairObject)this.objMap.putIfAbsent(key, queue);
        return (TQueue)(oldq != null ? oldq : queue);
    }

    public TQueue remove(TKey key) {
        FairObject queue = (FairObject)this.objMap.get(key);
        if (queue != null) {
            this.lock.lock();
            try {
                queue = (FairObject)this.objMap.remove(key);
                if (this.current != null && queue == this.current.getValue()) {
                    this.currentQuantum = 0;
                    this.current = null;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return (TQueue)queue;
    }

    public void clear() {
        this.lock.lock();
        try {
            this.currentQuantum = 0;
            this.current = null;
            this.objMap.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TQueue poll() {
        this.lock.lock();
        try {
            FairObject queue;
            if (this.currentQuantum == 0) {
                if (this.nextObject() == null) {
                    TQueue TQueue = null;
                    return TQueue;
                }
                queue = (FairObject)this.current.getValue();
                this.currentQuantum = this.calculateQuantum(queue) - 1;
            } else {
                --this.currentQuantum;
                queue = (FairObject)this.current.getValue();
            }
            if (!queue.isAvailable()) {
                Map.Entry<TKey, TQueue> last = this.current;
                do {
                    if (this.nextObject() != null) continue;
                    TQueue TQueue = null;
                    return TQueue;
                } while (this.current.getValue() != last.getValue() && !((FairObject)this.current.getValue()).isAvailable());
                queue = (FairObject)this.current.getValue();
                this.currentQuantum = this.calculateQuantum(queue) - 1;
            }
            FairObject fairObject = queue;
            return (TQueue)fairObject;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        for (Map.Entry<TKey, TQueue> entry : this.objMap.entrySet()) {
            builder.append(entry.getKey());
            builder.append(':');
            builder.append(entry.getValue());
        }
        builder.append('}');
        return builder.toString();
    }

    private Map.Entry<TKey, TQueue> nextObject() {
        Map.Entry<TKey, TQueue> next = null;
        if (this.current != null) {
            next = this.objMap.higherEntry(this.current.getKey());
        }
        this.current = next != null ? next : this.objMap.firstEntry();
        return this.current;
    }

    private int calculateQuantum(TQueue fairObject) {
        return Math.max(1, fairObject.getPriority() * this.quantum);
    }

    public static interface FairObject {
        public boolean isAvailable();

        public int getPriority();
    }
}

