/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.TagUsage;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestReseekTo {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @Test
    public void testReseekTo() throws Exception {
        this.testReseekToInternals(TagUsage.NO_TAG);
        this.testReseekToInternals(TagUsage.ONLY_TAG);
        this.testReseekToInternals(TagUsage.PARTIAL_TAG);
    }

    private void testReseekToInternals(TagUsage tagUsage) throws IOException {
        long start;
        String value;
        Integer key;
        int i;
        Path ncTFile = new Path(TEST_UTIL.getDataTestDir(), "basic.hfile");
        FSDataOutputStream fout = TEST_UTIL.getTestFileSystem().create(ncTFile);
        if (tagUsage != TagUsage.NO_TAG) {
            TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        }
        CacheConfig cacheConf = new CacheConfig(TEST_UTIL.getConfiguration());
        HFileContext context = new HFileContextBuilder().withBlockSize(4000).build();
        HFile.Writer writer = HFile.getWriterFactory(TEST_UTIL.getConfiguration(), cacheConf).withOutputStream(fout).withFileContext(context).withComparator(KeyValue.COMPARATOR).create();
        int numberOfKeys = 1000;
        String valueString = "Value";
        ArrayList<Integer> keyList = new ArrayList<Integer>();
        ArrayList<String> valueList = new ArrayList<String>();
        for (int key2 = 0; key2 < numberOfKeys; ++key2) {
            Tag[] tags;
            Tag t;
            KeyValue kv;
            String value2 = valueString + key2;
            keyList.add(key2);
            valueList.add(value2);
            if (tagUsage == TagUsage.NO_TAG) {
                kv = new KeyValue(Bytes.toBytes(key2), Bytes.toBytes("family"), Bytes.toBytes("qual"), Bytes.toBytes(value2));
                writer.append(kv);
                continue;
            }
            if (tagUsage == TagUsage.ONLY_TAG) {
                t = new Tag(1, "myTag1");
                tags = new Tag[]{t};
                kv = new KeyValue(Bytes.toBytes(key2), Bytes.toBytes("family"), Bytes.toBytes("qual"), Long.MAX_VALUE, Bytes.toBytes(value2), tags);
                writer.append(kv);
                continue;
            }
            if (key2 % 4 == 0) {
                t = new Tag(1, "myTag1");
                tags = new Tag[]{t};
                kv = new KeyValue(Bytes.toBytes(key2), Bytes.toBytes("family"), Bytes.toBytes("qual"), Long.MAX_VALUE, Bytes.toBytes(value2), tags);
                writer.append(kv);
                continue;
            }
            kv = new KeyValue(Bytes.toBytes(key2), Bytes.toBytes("family"), Bytes.toBytes("qual"), Long.MAX_VALUE, Bytes.toBytes(value2));
            writer.append(kv);
        }
        writer.close();
        fout.close();
        HFile.Reader reader = HFile.createReader(TEST_UTIL.getTestFileSystem(), ncTFile, cacheConf, TEST_UTIL.getConfiguration());
        reader.loadFileInfo();
        HFileScanner scanner = reader.getScanner(false, true);
        scanner.seekTo();
        for (i = 0; i < keyList.size(); ++i) {
            key = (Integer)keyList.get(i);
            value = (String)valueList.get(i);
            start = System.nanoTime();
            scanner.seekTo(new KeyValue(Bytes.toBytes(key), Bytes.toBytes("family"), Bytes.toBytes("qual"), Bytes.toBytes(value)));
            Assert.assertEquals((Object)value, (Object)scanner.getValueString());
        }
        scanner.seekTo();
        for (i = 0; i < keyList.size(); i += 10) {
            key = (Integer)keyList.get(i);
            value = (String)valueList.get(i);
            start = System.nanoTime();
            scanner.reseekTo(new KeyValue(Bytes.toBytes(key), Bytes.toBytes("family"), Bytes.toBytes("qual"), Bytes.toBytes(value)));
            Assert.assertEquals((String)("i is " + i), (Object)value, (Object)scanner.getValueString());
        }
        reader.close();
    }
}

