/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileWriterV2;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHFileWriterV2 {
    private static final Log LOG = LogFactory.getLog(TestHFileWriterV2.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Configuration conf;
    private FileSystem fs;
    private static final String COLUMN_FAMILY_NAME = "_-myColumnFamily-_";
    private static final int MIN_ROW_OR_QUALIFIER_LENGTH = 64;
    private static final int MAX_ROW_OR_QUALIFIER_LENGTH = 128;

    @Before
    public void setUp() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        this.fs = FileSystem.get((Configuration)this.conf);
    }

    @Test
    public void testHFileFormatV2() throws IOException {
        Path hfilePath = new Path(TEST_UTIL.getDataTestDir(), "testHFileFormatV2");
        Compression.Algorithm compressAlgo = Compression.Algorithm.GZ;
        int entryCount = 10000;
        this.writeDataAndReadFromHFile(hfilePath, compressAlgo, 10000, false);
    }

    @Test
    public void testMidKeyInHFile() throws IOException {
        Path hfilePath = new Path(TEST_UTIL.getDataTestDir(), "testMidKeyInHFile");
        Compression.Algorithm compressAlgo = Compression.Algorithm.NONE;
        int entryCount = 50000;
        this.writeDataAndReadFromHFile(hfilePath, compressAlgo, entryCount, true);
    }

    private void writeDataAndReadFromHFile(Path hfilePath, Compression.Algorithm compressAlgo, int entryCount, boolean findMidKey) throws IOException {
        long curBlockPos;
        HFileBlock block;
        HFileContext context = new HFileContextBuilder().withBlockSize(4096).withCompression(compressAlgo).build();
        HFileWriterV2 writer = (HFileWriterV2)new HFileWriterV2.WriterFactoryV2(this.conf, new CacheConfig(this.conf)).withPath(this.fs, hfilePath).withFileContext(context).create();
        Random rand = new Random(9713312L);
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>(entryCount);
        for (int i = 0; i < entryCount; ++i) {
            byte[] keyBytes = TestHFileWriterV2.randomOrderedKey(rand, i);
            byte[] valueBytes = TestHFileWriterV2.randomValue(rand);
            KeyValue keyValue = new KeyValue(keyBytes, null, null, valueBytes);
            writer.append(keyValue);
            keyValues.add(keyValue);
        }
        writer.appendMetaBlock("CAPITAL_OF_USA", (Writable)new Text("Washington, D.C."));
        writer.appendMetaBlock("CAPITAL_OF_RUSSIA", (Writable)new Text("Moscow"));
        writer.appendMetaBlock("CAPITAL_OF_FRANCE", (Writable)new Text("Paris"));
        writer.close();
        FSDataInputStream fsdis = this.fs.open(hfilePath);
        long fileSize = this.fs.getFileStatus(hfilePath).getLen();
        FixedFileTrailer trailer = FixedFileTrailer.readFromStream(fsdis, fileSize);
        Assert.assertEquals((long)2L, (long)trailer.getMajorVersion());
        Assert.assertEquals((long)entryCount, (long)trailer.getEntryCount());
        HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(true).withIncludesMvcc(false).withIncludesTags(false).withCompression(compressAlgo).build();
        HFileBlock.FSReaderImpl blockReader = new HFileBlock.FSReaderImpl(fsdis, fileSize, meta);
        KeyValue.KVComparator comparator = trailer.createComparator();
        HFileBlockIndex.BlockIndexReader dataBlockIndexReader = new HFileBlockIndex.BlockIndexReader(comparator, trailer.getNumDataIndexLevels());
        HFileBlockIndex.BlockIndexReader metaBlockIndexReader = new HFileBlockIndex.BlockIndexReader(KeyValue.RAW_COMPARATOR, 1);
        HFileBlock.BlockIterator blockIter = blockReader.blockRange(trailer.getLoadOnOpenDataOffset(), fileSize - (long)trailer.getTrailerSize());
        dataBlockIndexReader.readMultiLevelIndexRoot(blockIter.nextBlockWithBlockType(BlockType.ROOT_INDEX), trailer.getDataIndexCount());
        if (findMidKey) {
            byte[] midkey = dataBlockIndexReader.midkey();
            Assert.assertNotNull((String)"Midkey should not be null", (Object)midkey);
        }
        metaBlockIndexReader.readRootIndex(blockIter.nextBlockWithBlockType(BlockType.ROOT_INDEX).getByteStream(), trailer.getMetaIndexCount());
        HFile.FileInfo fileInfo = new HFile.FileInfo();
        fileInfo.read(blockIter.nextBlockWithBlockType(BlockType.FILE_INFO).getByteStream());
        byte[] keyValueFormatVersion = fileInfo.get(HFileWriterV2.KEY_VALUE_VERSION);
        boolean includeMemstoreTS = keyValueFormatVersion != null && Bytes.toInt(keyValueFormatVersion) > 0;
        int entriesRead = 0;
        int blocksRead = 0;
        long memstoreTS = 0L;
        fsdis.seek(0L);
        for (curBlockPos = 0L; curBlockPos <= trailer.getLastDataBlockOffset(); curBlockPos += (long)block.getOnDiskSizeWithHeader()) {
            block = blockReader.readBlockData(curBlockPos, -1L, -1, false);
            Assert.assertEquals((Object)((Object)BlockType.DATA), (Object)((Object)block.getBlockType()));
            if (meta.isCompressedOrEncrypted()) {
                Assert.assertFalse((boolean)block.isUnpacked());
                block = block.unpack(meta, blockReader);
            }
            ByteBuffer buf = block.getBufferWithoutHeader();
            while (buf.hasRemaining()) {
                int keyLen = buf.getInt();
                int valueLen = buf.getInt();
                byte[] key = new byte[keyLen];
                buf.get(key);
                byte[] value = new byte[valueLen];
                buf.get(value);
                if (includeMemstoreTS) {
                    ByteArrayInputStream byte_input = new ByteArrayInputStream(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
                    DataInputStream data_input = new DataInputStream(byte_input);
                    memstoreTS = WritableUtils.readVLong((DataInput)data_input);
                    buf.position(buf.position() + WritableUtils.getVIntSize((long)memstoreTS));
                }
                Assert.assertTrue((Bytes.compareTo(key, ((KeyValue)keyValues.get(entriesRead)).getKey()) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((Bytes.compareTo(value, ((KeyValue)keyValues.get(entriesRead)).getValue()) == 0 ? 1 : 0) != 0);
                ++entriesRead;
            }
            ++blocksRead;
        }
        LOG.info((Object)("Finished reading: entries=" + entriesRead + ", blocksRead=" + blocksRead));
        Assert.assertEquals((long)entryCount, (long)entriesRead);
        int metaCounter = 0;
        while (fsdis.getPos() < trailer.getLoadOnOpenDataOffset()) {
            LOG.info((Object)("Current offset: " + fsdis.getPos() + ", scanning until " + trailer.getLoadOnOpenDataOffset()));
            HFileBlock block2 = blockReader.readBlockData(curBlockPos, -1L, -1, false).unpack(meta, blockReader);
            Assert.assertEquals((Object)((Object)BlockType.META), (Object)((Object)block2.getBlockType()));
            Text t = new Text();
            ByteBuffer buf = block2.getBufferWithoutHeader();
            if (Writables.getWritable(buf.array(), buf.arrayOffset(), buf.limit(), (Writable)t) == null) {
                throw new IOException("Failed to deserialize block " + this + " into a " + t.getClass().getSimpleName());
            }
            Text expectedText = metaCounter == 0 ? new Text("Paris") : (metaCounter == 1 ? new Text("Moscow") : new Text("Washington, D.C."));
            Assert.assertEquals((Object)expectedText, (Object)t);
            LOG.info((Object)("Read meta block data: " + t));
            ++metaCounter;
            curBlockPos += (long)block2.getOnDiskSizeWithHeader();
        }
        fsdis.close();
    }

    public static byte[] randomOrderedKey(Random rand, int i) {
        StringBuilder k = new StringBuilder();
        for (int bitIndex = 31; bitIndex >= 0; --bitIndex) {
            if ((i & 1 << bitIndex) == 0) {
                k.append("a");
                continue;
            }
            k.append("b");
        }
        for (int j = 0; j < rand.nextInt(50); ++j) {
            k.append(TestHFileWriterV2.randomReadableChar(rand));
        }
        byte[] keyBytes = k.toString().getBytes();
        return keyBytes;
    }

    public static byte[] randomOrderedFixedLengthKey(Random rand, int i, int suffixLength) {
        StringBuilder k = new StringBuilder();
        for (int bitIndex = 31; bitIndex >= 0; --bitIndex) {
            if ((i & 1 << bitIndex) == 0) {
                k.append("a");
                continue;
            }
            k.append("b");
        }
        for (int j = 0; j < suffixLength; ++j) {
            k.append(TestHFileWriterV2.randomReadableChar(rand));
        }
        byte[] keyBytes = k.toString().getBytes();
        return keyBytes;
    }

    public static byte[] randomValue(Random rand) {
        StringBuilder v = new StringBuilder();
        for (int j = 0; j < 1 + rand.nextInt(2000); ++j) {
            v.append((char)(32 + rand.nextInt(95)));
        }
        byte[] valueBytes = v.toString().getBytes();
        return valueBytes;
    }

    public static byte[] randomFixedLengthValue(Random rand, int valueLength) {
        StringBuilder v = new StringBuilder();
        for (int j = 0; j < valueLength; ++j) {
            v.append((char)(32 + rand.nextInt(95)));
        }
        byte[] valueBytes = v.toString().getBytes();
        return valueBytes;
    }

    public static final char randomReadableChar(Random rand) {
        int i = rand.nextInt(63);
        if (i < 26) {
            return (char)(65 + i);
        }
        if ((i -= 26) < 26) {
            return (char)(97 + i);
        }
        if ((i -= 26) < 10) {
            return (char)(48 + i);
        }
        assert ((i -= 10) == 0);
        return '_';
    }

    public static byte[] randomRowOrQualifier(Random rand) {
        StringBuilder field = new StringBuilder();
        int fieldLen = 64 + rand.nextInt(65);
        for (int i = 0; i < fieldLen; ++i) {
            field.append(TestHFileWriterV2.randomReadableChar(rand));
        }
        return field.toString().getBytes();
    }

    public static KeyValue randomKeyValue(Random rand) {
        return new KeyValue(TestHFileWriterV2.randomRowOrQualifier(rand), COLUMN_FAMILY_NAME.getBytes(), TestHFileWriterV2.randomRowOrQualifier(rand), TestHFileWriterV2.randomValue(rand));
    }
}

