/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMultiRowRangeFilter {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final Log LOG = LogFactory.getLog(this.getClass());
    private byte[] family = Bytes.toBytes("family");
    private byte[] qf = Bytes.toBytes("qf");
    private byte[] value = Bytes.toBytes("val");
    private byte[] tableName;
    private int numRows = 100;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRanges() throws IOException {
        byte[] key1Start = new byte[]{-3};
        byte[] key1End = new byte[]{-2};
        byte[] key2Start = new byte[]{5};
        byte[] key2End = new byte[]{6};
        byte[] badKey = new byte[]{-10};
        MultiRowRangeFilter filter = new MultiRowRangeFilter(Arrays.asList(new MultiRowRangeFilter.RowRange(key1Start, true, key1End, false), new MultiRowRangeFilter.RowRange(key2Start, true, key2End, false)));
        filter.filterRowKey(badKey, 0, 1);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT), (Object)((Object)filter.filterKeyValue(null)));
    }

    @Test
    public void testOutOfOrderScannerNextException() throws Exception {
        MultiRowRangeFilter filter = new MultiRowRangeFilter(Arrays.asList(new MultiRowRangeFilter.RowRange(Bytes.toBytes("b"), true, Bytes.toBytes("c"), true), new MultiRowRangeFilter.RowRange(Bytes.toBytes("d"), true, Bytes.toBytes("e"), true)));
        filter.filterRowKey(Bytes.toBytes("a"), 0, 1);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT), (Object)((Object)filter.filterKeyValue(null)));
        filter.filterRowKey(Bytes.toBytes("b"), 0, 1);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)filter.filterKeyValue(null)));
        filter.filterRowKey(Bytes.toBytes("c"), 0, 1);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)filter.filterKeyValue(null)));
        filter.filterRowKey(Bytes.toBytes("d"), 0, 1);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)filter.filterKeyValue(null)));
        filter.filterRowKey(Bytes.toBytes("e"), 0, 1);
        Assert.assertEquals((Object)((Object)Filter.ReturnCode.INCLUDE), (Object)((Object)filter.filterKeyValue(null)));
    }

    @Test
    public void testMergeAndSortWithEmptyStartRow() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(""), true, Bytes.toBytes(20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(15), true, Bytes.toBytes(40), false));
        List<MultiRowRangeFilter.RowRange> actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(""), true, Bytes.toBytes(40), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testMergeAndSortWithEmptyStopRow() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(10), true, Bytes.toBytes(20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(15), true, Bytes.toBytes(""), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(30), true, Bytes.toBytes(70), false));
        List<MultiRowRangeFilter.RowRange> actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(10), true, Bytes.toBytes(""), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testMergeAndSortWithEmptyStartRowAndStopRow() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(10), true, Bytes.toBytes(20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(""), true, Bytes.toBytes(""), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(30), true, Bytes.toBytes(70), false));
        List<MultiRowRangeFilter.RowRange> actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(""), true, Bytes.toBytes(""), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMultiRowRangeWithoutRange() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        new MultiRowRangeFilter(ranges);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMultiRowRangeWithInvalidRange() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(10), true, Bytes.toBytes(20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(80), true, Bytes.toBytes(20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(30), true, Bytes.toBytes(70), false));
        new MultiRowRangeFilter(ranges);
    }

    @Test
    public void testMergeAndSortWithoutOverlap() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(10), true, Bytes.toBytes(20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(30), true, Bytes.toBytes(40), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(60), true, Bytes.toBytes(70), false));
        List<MultiRowRangeFilter.RowRange> actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(10), true, Bytes.toBytes(20), false));
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(30), true, Bytes.toBytes(40), false));
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(60), true, Bytes.toBytes(70), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testMergeAndSortWithOverlap() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(10), true, Bytes.toBytes(20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(15), true, Bytes.toBytes(40), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(20), true, Bytes.toBytes(30), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(30), true, Bytes.toBytes(50), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(30), true, Bytes.toBytes(70), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(90), true, Bytes.toBytes(100), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(95), true, Bytes.toBytes(100), false));
        List<MultiRowRangeFilter.RowRange> actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(10), true, Bytes.toBytes(70), false));
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(90), true, Bytes.toBytes(100), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testMergeAndSortWithStartRowInclusive() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(10), true, Bytes.toBytes(20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(20), true, Bytes.toBytes(""), false));
        List<MultiRowRangeFilter.RowRange> actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(10), true, Bytes.toBytes(""), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testMergeAndSortWithRowExclusive() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(10), true, Bytes.toBytes(20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(20), false, Bytes.toBytes(""), false));
        List<MultiRowRangeFilter.RowRange> actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(10), true, Bytes.toBytes(20), false));
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(20), false, Bytes.toBytes(""), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testMergeAndSortWithRowInclusive() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(10), true, Bytes.toBytes(20), true));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(20), false, Bytes.toBytes(""), false));
        List<MultiRowRangeFilter.RowRange> actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(10), true, Bytes.toBytes(""), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    public void assertRangesEqual(List<MultiRowRangeFilter.RowRange> expected, List<MultiRowRangeFilter.RowRange> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertTrue((boolean)Bytes.equals(expected.get(i).getStartRow(), actual.get(i).getStartRow()));
            Assert.assertTrue((expected.get(i).isStartRowInclusive() == actual.get(i).isStartRowInclusive() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Bytes.equals(expected.get(i).getStopRow(), actual.get(i).getStopRow()));
            Assert.assertTrue((expected.get(i).isStopRowInclusive() == actual.get(i).isStopRowInclusive() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMultiRowRangeFilterWithRangeOverlap() throws IOException {
        this.tableName = Bytes.toBytes("testMultiRowRangeFilterWithRangeOverlap");
        HTable ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.setMaxVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(10), true, Bytes.toBytes(20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(15), true, Bytes.toBytes(40), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(65), true, Bytes.toBytes(75), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(60), true, null, false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(60), true, Bytes.toBytes(80), false));
        MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
        scan.setFilter(filter);
        int resultsSize = this.getResultsSize(ht, scan);
        this.LOG.info((Object)("found " + resultsSize + " results"));
        List<Cell> results1 = this.getScanResult(Bytes.toBytes(10), Bytes.toBytes(40), ht);
        List<Cell> results2 = this.getScanResult(Bytes.toBytes(60), Bytes.toBytes(""), ht);
        Assert.assertEquals((long)(results1.size() + results2.size()), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testMultiRowRangeFilterWithoutRangeOverlap() throws IOException {
        this.tableName = Bytes.toBytes("testMultiRowRangeFilterWithoutRangeOverlap");
        HTable ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.setMaxVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(30), true, Bytes.toBytes(40), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(10), true, Bytes.toBytes(20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(60), true, Bytes.toBytes(70), false));
        MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
        scan.setFilter(filter);
        int resultsSize = this.getResultsSize(ht, scan);
        this.LOG.info((Object)("found " + resultsSize + " results"));
        List<Cell> results1 = this.getScanResult(Bytes.toBytes(10), Bytes.toBytes(20), ht);
        List<Cell> results2 = this.getScanResult(Bytes.toBytes(30), Bytes.toBytes(40), ht);
        List<Cell> results3 = this.getScanResult(Bytes.toBytes(60), Bytes.toBytes(70), ht);
        Assert.assertEquals((long)(results1.size() + results2.size() + results3.size()), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testMultiRowRangeFilterWithEmptyStartRow() throws IOException {
        this.tableName = Bytes.toBytes("testMultiRowRangeFilterWithEmptyStartRow");
        HTable ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.setMaxVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(""), true, Bytes.toBytes(10), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(30), true, Bytes.toBytes(40), false));
        MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
        scan.setFilter(filter);
        int resultsSize = this.getResultsSize(ht, scan);
        List<Cell> results1 = this.getScanResult(Bytes.toBytes(""), Bytes.toBytes(10), ht);
        List<Cell> results2 = this.getScanResult(Bytes.toBytes(30), Bytes.toBytes(40), ht);
        Assert.assertEquals((long)(results1.size() + results2.size()), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testMultiRowRangeFilterWithEmptyStopRow() throws IOException {
        this.tableName = Bytes.toBytes("testMultiRowRangeFilterWithEmptyStopRow");
        HTable ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.setMaxVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(10), true, Bytes.toBytes(""), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(30), true, Bytes.toBytes(40), false));
        MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
        scan.setFilter(filter);
        int resultsSize = this.getResultsSize(ht, scan);
        List<Cell> results1 = this.getScanResult(Bytes.toBytes(10), Bytes.toBytes(""), ht);
        Assert.assertEquals((long)results1.size(), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testMultiRowRangeFilterWithInclusive() throws IOException {
        this.tableName = Bytes.toBytes("testMultiRowRangeFilterWithInclusive");
        HTable ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.setMaxVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(10), true, Bytes.toBytes(20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(20), true, Bytes.toBytes(40), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(65), true, Bytes.toBytes(75), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(60), true, null, false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(60), true, Bytes.toBytes(80), false));
        MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
        scan.setFilter(filter);
        int resultsSize = this.getResultsSize(ht, scan);
        this.LOG.info((Object)("found " + resultsSize + " results"));
        List<Cell> results1 = this.getScanResult(Bytes.toBytes(10), Bytes.toBytes(40), ht);
        List<Cell> results2 = this.getScanResult(Bytes.toBytes(60), Bytes.toBytes(""), ht);
        Assert.assertEquals((long)(results1.size() + results2.size()), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testMultiRowRangeFilterWithExclusive() throws IOException {
        this.tableName = Bytes.toBytes("testMultiRowRangeFilterWithExclusive");
        HTable ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.setMaxVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(10), true, Bytes.toBytes(20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(20), false, Bytes.toBytes(40), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(65), true, Bytes.toBytes(75), false));
        MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
        scan.setFilter(filter);
        int resultsSize = this.getResultsSize(ht, scan);
        this.LOG.info((Object)("found " + resultsSize + " results"));
        List<Cell> results1 = this.getScanResult(Bytes.toBytes(10), Bytes.toBytes(40), ht);
        List<Cell> results2 = this.getScanResult(Bytes.toBytes(65), Bytes.toBytes(75), ht);
        Assert.assertEquals((long)(results1.size() - 1 + results2.size()), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testMultiRowRangeWithFilterListAndOperator() throws IOException {
        this.tableName = Bytes.toBytes("TestMultiRowRangeFilterWithFilterListAndOperator");
        HTable ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.setMaxVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges1 = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges1.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(10), true, Bytes.toBytes(20), false));
        ranges1.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(30), true, Bytes.toBytes(40), false));
        ranges1.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(60), true, Bytes.toBytes(70), false));
        MultiRowRangeFilter filter1 = new MultiRowRangeFilter(ranges1);
        ArrayList<MultiRowRangeFilter.RowRange> ranges2 = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges2.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(20), true, Bytes.toBytes(40), false));
        ranges2.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(80), true, Bytes.toBytes(90), false));
        MultiRowRangeFilter filter2 = new MultiRowRangeFilter(ranges2);
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        filterList.addFilter(filter1);
        filterList.addFilter(filter2);
        scan.setFilter(filterList);
        int resultsSize = this.getResultsSize(ht, scan);
        this.LOG.info((Object)("found " + resultsSize + " results"));
        List<Cell> results1 = this.getScanResult(Bytes.toBytes(30), Bytes.toBytes(40), ht);
        Assert.assertEquals((long)results1.size(), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testMultiRowRangeWithFilterListOrOperator() throws IOException {
        this.tableName = Bytes.toBytes("TestMultiRowRangeFilterWithFilterListOrOperator");
        HTable ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.setMaxVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges1 = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges1.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(30), true, Bytes.toBytes(40), false));
        ranges1.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(10), true, Bytes.toBytes(20), false));
        ranges1.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(60), true, Bytes.toBytes(70), false));
        MultiRowRangeFilter filter1 = new MultiRowRangeFilter(ranges1);
        ArrayList<MultiRowRangeFilter.RowRange> ranges2 = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges2.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(20), true, Bytes.toBytes(40), false));
        ranges2.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(80), true, Bytes.toBytes(90), false));
        MultiRowRangeFilter filter2 = new MultiRowRangeFilter(ranges2);
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        filterList.addFilter(filter1);
        filterList.addFilter(filter2);
        scan.setFilter(filterList);
        int resultsSize = this.getResultsSize(ht, scan);
        this.LOG.info((Object)("found " + resultsSize + " results"));
        List<Cell> results1 = this.getScanResult(Bytes.toBytes(10), Bytes.toBytes(40), ht);
        List<Cell> results2 = this.getScanResult(Bytes.toBytes(60), Bytes.toBytes(70), ht);
        List<Cell> results3 = this.getScanResult(Bytes.toBytes(80), Bytes.toBytes(90), ht);
        Assert.assertEquals((long)(results1.size() + results2.size() + results3.size()), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testOneRowRange() throws IOException {
        this.tableName = Bytes.toBytes("testOneRowRange");
        HTable ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        ArrayList<MultiRowRangeFilter.RowRange> rowRangesList = new ArrayList<MultiRowRangeFilter.RowRange>();
        rowRangesList.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(50), true, Bytes.toBytes(50), true));
        Scan scan = new Scan();
        scan.setFilter(new MultiRowRangeFilter(rowRangesList));
        int resultsSize = this.getResultsSize(ht, scan);
        Assert.assertEquals((long)1L, (long)resultsSize);
        rowRangesList.clear();
        rowRangesList.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(50), true, Bytes.toBytes(51), false));
        scan = new Scan();
        scan.setFilter(new MultiRowRangeFilter(rowRangesList));
        resultsSize = this.getResultsSize(ht, scan);
        Assert.assertEquals((long)1L, (long)resultsSize);
        rowRangesList.clear();
        rowRangesList.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes(50), true, Bytes.toBytes(51), true));
        scan = new Scan();
        scan.setFilter(new MultiRowRangeFilter(rowRangesList));
        resultsSize = this.getResultsSize(ht, scan);
        Assert.assertEquals((long)2L, (long)resultsSize);
        ht.close();
    }

    private void generateRows(int numberOfRows, HTable ht, byte[] family, byte[] qf, byte[] value) throws IOException {
        for (int i = 0; i < numberOfRows; ++i) {
            byte[] row = Bytes.toBytes(i);
            Put p = new Put(row);
            p.add(family, qf, value);
            ht.put(p);
        }
        TEST_UTIL.flush();
    }

    private List<Cell> getScanResult(byte[] startRow, byte[] stopRow, HTable ht) throws IOException {
        Result r;
        Scan scan = new Scan();
        scan.setMaxVersions();
        if (!Bytes.toString(startRow).isEmpty()) {
            scan.setStartRow(startRow);
        }
        if (!Bytes.toString(stopRow).isEmpty()) {
            scan.setStopRow(stopRow);
        }
        ResultScanner scanner = ht.getScanner(scan);
        ArrayList<Cell> kvList = new ArrayList<Cell>();
        while ((r = scanner.next()) != null) {
            for (Cell kv : r.listCells()) {
                kvList.add(kv);
            }
        }
        scanner.close();
        return kvList;
    }

    private int getResultsSize(HTable ht, Scan scan) throws IOException {
        Result r;
        ResultScanner scanner = ht.getScanner(scan);
        ArrayList<Cell> results = new ArrayList<Cell>();
        while ((r = scanner.next()) != null) {
            for (Cell kv : r.listCells()) {
                results.add(kv);
            }
        }
        scanner.close();
        return results.size();
    }
}

