/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MultiRowRangeFilter
extends FilterBase {
    private List<RowRange> rangeList;
    private static final int ROW_BEFORE_FIRST_RANGE = -1;
    private boolean EXCLUSIVE = false;
    private boolean done = false;
    private boolean initialized = false;
    private int index;
    private RowRange range;
    private Filter.ReturnCode currentReturnCode;

    public MultiRowRangeFilter(List<RowRange> list) throws IOException {
        this.rangeList = MultiRowRangeFilter.sortAndMerge(list);
    }

    @Override
    public boolean filterAllRemaining() {
        return this.done;
    }

    public List<RowRange> getRowRanges() {
        return this.rangeList;
    }

    @Override
    public boolean filterRowKey(byte[] buffer, int offset, int length) {
        if (!this.initialized || !this.range.contains(buffer, offset, length)) {
            byte[] rowkey = new byte[length];
            System.arraycopy(buffer, offset, rowkey, 0, length);
            this.index = this.getNextRangeIndex(rowkey);
            if (this.index >= this.rangeList.size()) {
                this.done = true;
                this.currentReturnCode = Filter.ReturnCode.NEXT_ROW;
                return false;
            }
            this.range = this.index != -1 ? this.rangeList.get(this.index) : this.rangeList.get(0);
            if (this.EXCLUSIVE) {
                this.EXCLUSIVE = false;
                this.currentReturnCode = Filter.ReturnCode.NEXT_ROW;
                return false;
            }
            if (!this.initialized) {
                this.currentReturnCode = this.index != -1 ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.SEEK_NEXT_USING_HINT;
                this.initialized = true;
            } else {
                this.currentReturnCode = this.range.contains(buffer, offset, length) ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.SEEK_NEXT_USING_HINT;
            }
        } else {
            this.currentReturnCode = Filter.ReturnCode.INCLUDE;
        }
        return false;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell ignored) {
        return this.currentReturnCode;
    }

    @Override
    public Cell getNextCellHint(Cell currentKV) {
        return KeyValueUtil.createFirstOnRow(this.range.startRow);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.MultiRowRangeFilter.Builder builder = FilterProtos.MultiRowRangeFilter.newBuilder();
        for (RowRange range : this.rangeList) {
            if (range == null) continue;
            FilterProtos.RowRange.Builder rangebuilder = FilterProtos.RowRange.newBuilder();
            if (range.startRow != null) {
                rangebuilder.setStartRow(ByteStringer.wrap(range.startRow));
            }
            rangebuilder.setStartRowInclusive(range.startRowInclusive);
            if (range.stopRow != null) {
                rangebuilder.setStopRow(ByteStringer.wrap(range.stopRow));
            }
            rangebuilder.setStopRowInclusive(range.stopRowInclusive);
            builder.addRowRangeList(rangebuilder.build());
        }
        return builder.build().toByteArray();
    }

    public static MultiRowRangeFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.MultiRowRangeFilter proto;
        try {
            proto = FilterProtos.MultiRowRangeFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        int length = proto.getRowRangeListCount();
        List<FilterProtos.RowRange> rangeProtos = proto.getRowRangeListList();
        ArrayList<RowRange> rangeList = new ArrayList<RowRange>(length);
        for (FilterProtos.RowRange rangeProto : rangeProtos) {
            RowRange range = new RowRange(rangeProto.hasStartRow() ? rangeProto.getStartRow().toByteArray() : null, rangeProto.getStartRowInclusive(), rangeProto.hasStopRow() ? rangeProto.getStopRow().toByteArray() : null, rangeProto.getStopRowInclusive());
            rangeList.add(range);
        }
        try {
            return new MultiRowRangeFilter(rangeList);
        }
        catch (IOException e) {
            throw new DeserializationException("Fail to instantiate the MultiRowRangeFilter", e);
        }
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiRowRangeFilter)) {
            return false;
        }
        MultiRowRangeFilter other = (MultiRowRangeFilter)o;
        if (this.rangeList.size() != other.rangeList.size()) {
            return false;
        }
        for (int i = 0; i < this.rangeList.size(); ++i) {
            RowRange thisRange = this.rangeList.get(i);
            RowRange otherRange = other.rangeList.get(i);
            if (Bytes.equals(thisRange.startRow, otherRange.startRow) && Bytes.equals(thisRange.stopRow, otherRange.stopRow) && thisRange.startRowInclusive == otherRange.startRowInclusive && thisRange.stopRowInclusive == otherRange.stopRowInclusive) continue;
            return false;
        }
        return true;
    }

    private int getNextRangeIndex(byte[] rowKey) {
        RowRange temp = new RowRange(rowKey, true, null, true);
        int index = Collections.binarySearch(this.rangeList, temp);
        if (index < 0) {
            int insertionPosition = -index - 1;
            if (insertionPosition != 0 && this.rangeList.get(insertionPosition - 1).contains(rowKey)) {
                return insertionPosition - 1;
            }
            if (insertionPosition == 0 && !this.rangeList.get(insertionPosition).contains(rowKey)) {
                return -1;
            }
            if (!this.initialized) {
                this.initialized = true;
            }
            return insertionPosition;
        }
        if (!this.rangeList.get(index).startRowInclusive) {
            this.EXCLUSIVE = true;
        }
        return index;
    }

    public static List<RowRange> sortAndMerge(List<RowRange> ranges) {
        if (ranges.size() == 0) {
            throw new IllegalArgumentException("No ranges found.");
        }
        ArrayList<RowRange> invalidRanges = new ArrayList<RowRange>();
        ArrayList<RowRange> newRanges = new ArrayList<RowRange>(ranges.size());
        Collections.sort(ranges);
        if (ranges.get(0).isValid()) {
            if (ranges.size() == 1) {
                newRanges.add(ranges.get(0));
            }
        } else {
            invalidRanges.add(ranges.get(0));
        }
        byte[] lastStartRow = ranges.get(0).startRow;
        boolean lastStartRowInclusive = ranges.get(0).startRowInclusive;
        byte[] lastStopRow = ranges.get(0).stopRow;
        boolean lastStopRowInclusive = ranges.get(0).stopRowInclusive;
        for (int i = 1; i < ranges.size(); ++i) {
            RowRange range = ranges.get(i);
            if (!range.isValid()) {
                invalidRanges.add(range);
            }
            if (Bytes.equals(lastStopRow, HConstants.EMPTY_BYTE_ARRAY)) {
                newRanges.add(new RowRange(lastStartRow, lastStartRowInclusive, lastStopRow, lastStopRowInclusive));
                break;
            }
            if (Bytes.compareTo(lastStopRow, range.startRow) > 0 || Bytes.compareTo(lastStopRow, range.startRow) == 0 && (lastStopRowInclusive || range.isStartRowInclusive())) {
                if (Bytes.equals(range.stopRow, HConstants.EMPTY_BYTE_ARRAY)) {
                    newRanges.add(new RowRange(lastStartRow, lastStartRowInclusive, range.stopRow, range.stopRowInclusive));
                    break;
                }
                if (Bytes.compareTo(lastStopRow, range.stopRow) >= 0) {
                    if (Bytes.compareTo(lastStopRow, range.stopRow) == 0 && (lastStopRowInclusive || range.stopRowInclusive)) {
                        lastStopRowInclusive = true;
                    }
                    if (i + 1 != ranges.size()) continue;
                    newRanges.add(new RowRange(lastStartRow, lastStartRowInclusive, lastStopRow, lastStopRowInclusive));
                    continue;
                }
                lastStopRow = range.stopRow;
                lastStopRowInclusive = range.stopRowInclusive;
                if (i + 1 < ranges.size()) {
                    if (!(range = ranges.get(++i)).isValid()) {
                        invalidRanges.add(range);
                    }
                } else {
                    newRanges.add(new RowRange(lastStartRow, lastStartRowInclusive, lastStopRow, lastStopRowInclusive));
                    break;
                }
                while ((Bytes.compareTo(lastStopRow, range.startRow) > 0 || Bytes.compareTo(lastStopRow, range.startRow) == 0 && (lastStopRowInclusive || range.startRowInclusive)) && !Bytes.equals(range.stopRow, HConstants.EMPTY_BYTE_ARRAY)) {
                    if (Bytes.compareTo(lastStopRow, range.stopRow) >= 0) {
                        if (lastStopRowInclusive || range.stopRowInclusive) {
                            lastStopRowInclusive = true;
                        }
                        if (++i >= ranges.size()) break;
                        range = ranges.get(i);
                        if (range.isValid()) continue;
                        invalidRanges.add(range);
                        continue;
                    }
                    lastStopRow = range.stopRow;
                    lastStopRowInclusive = range.stopRowInclusive;
                    if (++i >= ranges.size()) break;
                    range = ranges.get(i);
                    if (range.isValid()) continue;
                    invalidRanges.add(range);
                }
                if (Bytes.equals(range.stopRow, HConstants.EMPTY_BYTE_ARRAY)) {
                    if (Bytes.compareTo(lastStopRow, range.startRow) < 0 || Bytes.compareTo(lastStopRow, range.startRow) == 0 && !lastStopRowInclusive && !range.startRowInclusive) {
                        newRanges.add(new RowRange(lastStartRow, lastStartRowInclusive, lastStopRow, lastStopRowInclusive));
                        newRanges.add(range);
                    } else {
                        newRanges.add(new RowRange(lastStartRow, lastStartRowInclusive, range.stopRow, range.stopRowInclusive));
                        break;
                    }
                }
                newRanges.add(new RowRange(lastStartRow, lastStartRowInclusive, lastStopRow, lastStopRowInclusive));
                if (i + 1 == ranges.size()) {
                    newRanges.add(range);
                }
                lastStartRow = range.startRow;
                lastStartRowInclusive = range.startRowInclusive;
                lastStopRow = range.stopRow;
                lastStopRowInclusive = range.stopRowInclusive;
                continue;
            }
            newRanges.add(new RowRange(lastStartRow, lastStartRowInclusive, lastStopRow, lastStopRowInclusive));
            if (i + 1 == ranges.size()) {
                newRanges.add(range);
            }
            lastStartRow = range.startRow;
            lastStartRowInclusive = range.startRowInclusive;
            lastStopRow = range.stopRow;
            lastStopRowInclusive = range.stopRowInclusive;
        }
        for (int j = i; j < ranges.size(); ++j) {
            if (ranges.get(j).isValid()) continue;
            invalidRanges.add(ranges.get(j));
        }
        if (invalidRanges.size() != 0) {
            MultiRowRangeFilter.throwExceptionForInvalidRanges(invalidRanges, true);
        }
        if (newRanges.size() == 0) {
            throw new IllegalArgumentException("No valid ranges found.");
        }
        return newRanges;
    }

    private static void throwExceptionForInvalidRanges(List<RowRange> invalidRanges, boolean details) {
        StringBuilder sb = new StringBuilder();
        sb.append(invalidRanges.size()).append(" invaild ranges.\n");
        if (details) {
            for (RowRange range : invalidRanges) {
                sb.append("Invalid range: start row => " + Bytes.toString(range.startRow) + ", stop row => " + Bytes.toString(range.stopRow)).append('\n');
            }
        }
        throw new IllegalArgumentException(sb.toString());
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class RowRange
    implements Comparable<RowRange> {
        private byte[] startRow;
        private boolean startRowInclusive = true;
        private byte[] stopRow;
        private boolean stopRowInclusive = false;

        public RowRange() {
        }

        public RowRange(String startRow, boolean startRowInclusive, String stopRow, boolean stopRowInclusive) {
            this(startRow == null || startRow.isEmpty() ? HConstants.EMPTY_BYTE_ARRAY : Bytes.toBytes(startRow), startRowInclusive, stopRow == null || stopRow.isEmpty() ? HConstants.EMPTY_BYTE_ARRAY : Bytes.toBytes(stopRow), stopRowInclusive);
        }

        public RowRange(byte[] startRow, boolean startRowInclusive, byte[] stopRow, boolean stopRowInclusive) {
            this.startRow = startRow == null ? HConstants.EMPTY_BYTE_ARRAY : startRow;
            this.startRowInclusive = startRowInclusive;
            this.stopRow = stopRow == null ? HConstants.EMPTY_BYTE_ARRAY : stopRow;
            this.stopRowInclusive = stopRowInclusive;
        }

        public byte[] getStartRow() {
            return this.startRow;
        }

        public byte[] getStopRow() {
            return this.stopRow;
        }

        public boolean isStartRowInclusive() {
            return this.startRowInclusive;
        }

        public boolean isStopRowInclusive() {
            return this.stopRowInclusive;
        }

        public boolean contains(byte[] row) {
            return this.contains(row, 0, row.length);
        }

        public boolean contains(byte[] buffer, int offset, int length) {
            if (this.startRowInclusive) {
                if (this.stopRowInclusive) {
                    return Bytes.compareTo(buffer, offset, length, this.startRow, 0, this.startRow.length) >= 0 && (Bytes.equals(this.stopRow, HConstants.EMPTY_BYTE_ARRAY) || Bytes.compareTo(buffer, offset, length, this.stopRow, 0, this.stopRow.length) <= 0);
                }
                return Bytes.compareTo(buffer, offset, length, this.startRow, 0, this.startRow.length) >= 0 && (Bytes.equals(this.stopRow, HConstants.EMPTY_BYTE_ARRAY) || Bytes.compareTo(buffer, offset, length, this.stopRow, 0, this.stopRow.length) < 0);
            }
            if (this.stopRowInclusive) {
                return Bytes.compareTo(buffer, offset, length, this.startRow, 0, this.startRow.length) > 0 && (Bytes.equals(this.stopRow, HConstants.EMPTY_BYTE_ARRAY) || Bytes.compareTo(buffer, offset, length, this.stopRow, 0, this.stopRow.length) <= 0);
            }
            return Bytes.compareTo(buffer, offset, length, this.startRow, 0, this.startRow.length) > 0 && (Bytes.equals(this.stopRow, HConstants.EMPTY_BYTE_ARRAY) || Bytes.compareTo(buffer, offset, length, this.stopRow, 0, this.stopRow.length) < 0);
        }

        @Override
        public int compareTo(RowRange other) {
            return Bytes.compareTo(this.startRow, other.startRow);
        }

        public boolean isValid() {
            return Bytes.equals(this.startRow, HConstants.EMPTY_BYTE_ARRAY) || Bytes.equals(this.stopRow, HConstants.EMPTY_BYTE_ARRAY) || Bytes.compareTo(this.startRow, this.stopRow) < 0 || Bytes.compareTo(this.startRow, this.stopRow) == 0 && this.stopRowInclusive;
        }
    }
}

