/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class FilterTestingCluster {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf = null;
    private static HBaseAdmin admin = null;
    private static List<String> createdTables = new ArrayList<String>();

    protected static void createTable(String tableName, String columnFamilyName) {
        Assert.assertNotNull((String)"HBaseAdmin is not initialized successfully.", (Object)admin);
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(tableName));
        HColumnDescriptor colDef = new HColumnDescriptor(Bytes.toBytes(columnFamilyName));
        desc.addFamily(colDef);
        try {
            admin.createTable(desc);
            createdTables.add(tableName);
            Assert.assertTrue((String)"Fail to create the table", (boolean)admin.tableExists(tableName));
        }
        catch (IOException e) {
            Assert.assertNull((String)"Exception found while creating table", (Object)e);
        }
    }

    protected static Table openTable(String tableName) throws IOException {
        HTable table = new HTable(conf, tableName);
        Assert.assertTrue((String)"Fail to create the table", (boolean)admin.tableExists(tableName));
        return table;
    }

    private static void deleteTables() {
        if (admin != null) {
            for (String tableName : createdTables) {
                try {
                    if (!admin.tableExists(tableName)) continue;
                    admin.disableTable(tableName);
                    admin.deleteTable(tableName);
                }
                catch (IOException e) {
                    Assert.assertNull((String)"Exception found deleting the table", (Object)e);
                }
            }
        }
    }

    private static void initialize(Configuration conf) {
        FilterTestingCluster.conf = HBaseConfiguration.create(conf);
        FilterTestingCluster.conf.setInt("hbase.client.retries.number", 1);
        try {
            admin = new HBaseAdmin(conf);
        }
        catch (MasterNotRunningException e) {
            Assert.assertNull((String)"Master is not running", (Object)e);
        }
        catch (ZooKeeperConnectionException e) {
            Assert.assertNull((String)"Cannot connect to Zookeeper", (Object)e);
        }
        catch (IOException e) {
            Assert.assertNull((String)"IOException", (Object)e);
        }
    }

    @BeforeClass
    public static void setUp() throws Exception {
        ((Log4JLogger)RpcServer.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)AbstractRpcClient.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)ScannerCallable.LOG).getLogger().setLevel(Level.ALL);
        TEST_UTIL.startMiniCluster(1);
        FilterTestingCluster.initialize(TEST_UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        FilterTestingCluster.deleteTables();
        TEST_UTIL.shutdownMiniCluster();
    }
}

