/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.regionserver.SplitTransactionFactory;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestCoprocessorInterface {
    @Rule
    public TestName name = new TestName();
    static final Log LOG = LogFactory.getLog(TestCoprocessorInterface.class);
    private static final HBaseTestingUtility TEST_UTIL = HBaseTestingUtility.createLocalHTU();
    static final Path DIR = TEST_UTIL.getDataTestDir();

    @Test
    public void testSharedData() throws IOException {
        int i;
        TableName tableName = TableName.valueOf(this.name.getMethodName());
        byte[][] families = new byte[][]{HBaseTestingUtility.fam1, HBaseTestingUtility.fam2, HBaseTestingUtility.fam3};
        Configuration hc = this.initSplit();
        Region region = this.initHRegion(tableName, this.name.getMethodName(), hc, new Class[0], families);
        for (int i2 = 0; i2 < 3; ++i2) {
            HBaseTestCase.addContent(region, HBaseTestingUtility.fam3);
            region.flush(true);
        }
        region.compact(false);
        byte[] splitRow = ((HRegion)region).checkSplit();
        Assert.assertNotNull((Object)splitRow);
        Region[] regions = this.split(region, splitRow);
        for (int i3 = 0; i3 < regions.length; ++i3) {
            regions[i3] = this.reopenRegion(regions[i3], CoprocessorImpl.class, CoprocessorII.class);
        }
        Coprocessor c = regions[0].getCoprocessorHost().findCoprocessor(CoprocessorImpl.class.getName());
        Coprocessor c2 = regions[0].getCoprocessorHost().findCoprocessor(CoprocessorII.class.getName());
        Object o = ((CoprocessorImpl)c).getSharedData().get("test1");
        Object o2 = ((CoprocessorII)c2).getSharedData().get("test2");
        Assert.assertNotNull((Object)o);
        Assert.assertNotNull((Object)o2);
        Assert.assertFalse((((CoprocessorImpl)c).getSharedData() == ((CoprocessorII)c2).getSharedData() ? 1 : 0) != 0);
        for (i = 1; i < regions.length; ++i) {
            c = regions[i].getCoprocessorHost().findCoprocessor(CoprocessorImpl.class.getName());
            c2 = regions[i].getCoprocessorHost().findCoprocessor(CoprocessorII.class.getName());
            Assert.assertTrue((((CoprocessorImpl)c).getSharedData().get("test1") == o ? 1 : 0) != 0);
            Assert.assertTrue((((CoprocessorII)c2).getSharedData().get("test2") == o2 ? 1 : 0) != 0);
        }
        for (i = 0; i < regions.length; ++i) {
            try {
                byte[] r = regions[i].getRegionInfo().getStartKey();
                if (r == null || r.length <= 0) {
                    r = new byte[]{0};
                }
                Get g = new Get(r);
                regions[i].get(g);
                Assert.fail();
            }
            catch (DoNotRetryIOException doNotRetryIOException) {
                // empty catch block
            }
            Assert.assertNull((Object)regions[i].getCoprocessorHost().findCoprocessor(CoprocessorII.class.getName()));
        }
        c = regions[0].getCoprocessorHost().findCoprocessor(CoprocessorImpl.class.getName());
        Assert.assertTrue((((CoprocessorImpl)c).getSharedData().get("test1") == o ? 1 : 0) != 0);
        c2 = null;
        c = null;
        System.gc();
        region = this.reopenRegion(regions[0], CoprocessorImpl.class, CoprocessorII.class);
        c = region.getCoprocessorHost().findCoprocessor(CoprocessorImpl.class.getName());
        Assert.assertTrue((((CoprocessorImpl)c).getSharedData().get("test1") == o ? 1 : 0) != 0);
        c2 = region.getCoprocessorHost().findCoprocessor(CoprocessorII.class.getName());
        Object o3 = ((CoprocessorII)c2).getSharedData().get("test2");
        Assert.assertFalse((o3 == o2 ? 1 : 0) != 0);
    }

    @Test
    public void testCoprocessorInterface() throws IOException {
        TableName tableName = TableName.valueOf(this.name.getMethodName());
        byte[][] families = new byte[][]{HBaseTestingUtility.fam1, HBaseTestingUtility.fam2, HBaseTestingUtility.fam3};
        Configuration hc = this.initSplit();
        Region region = this.initHRegion(tableName, this.name.getMethodName(), hc, new Class[]{CoprocessorImpl.class}, families);
        for (int i = 0; i < 3; ++i) {
            HBaseTestCase.addContent(region, HBaseTestingUtility.fam3);
            region.flush(true);
        }
        region.compact(false);
        byte[] splitRow = ((HRegion)region).checkSplit();
        Assert.assertNotNull((Object)splitRow);
        Region[] regions = this.split(region, splitRow);
        for (int i = 0; i < regions.length; ++i) {
            regions[i] = this.reopenRegion(regions[i], CoprocessorImpl.class);
        }
        HRegion.closeHRegion((HRegion)region);
        Coprocessor c = region.getCoprocessorHost().findCoprocessor(CoprocessorImpl.class.getName());
        Scan s = new Scan();
        RegionScanner scanner = regions[0].getCoprocessorHost().postScannerOpen(s, regions[0].getScanner(s));
        Assert.assertTrue((boolean)(scanner instanceof CustomScanner));
        scanner.next(new ArrayList<Cell>());
        Assert.assertTrue((String)"Coprocessor not started", (boolean)((CoprocessorImpl)c).wasStarted());
        Assert.assertTrue((String)"Coprocessor not stopped", (boolean)((CoprocessorImpl)c).wasStopped());
        Assert.assertTrue((boolean)((CoprocessorImpl)c).wasOpened());
        Assert.assertTrue((boolean)((CoprocessorImpl)c).wasClosed());
        Assert.assertTrue((boolean)((CoprocessorImpl)c).wasFlushed());
        Assert.assertTrue((boolean)((CoprocessorImpl)c).wasCompacted());
        Assert.assertTrue((boolean)((CoprocessorImpl)c).wasSplit());
        for (int i = 0; i < regions.length; ++i) {
            HRegion.closeHRegion((HRegion)regions[i]);
            c = region.getCoprocessorHost().findCoprocessor(CoprocessorImpl.class.getName());
            Assert.assertTrue((String)"Coprocessor not started", (boolean)((CoprocessorImpl)c).wasStarted());
            Assert.assertTrue((String)"Coprocessor not stopped", (boolean)((CoprocessorImpl)c).wasStopped());
            Assert.assertTrue((boolean)((CoprocessorImpl)c).wasOpened());
            Assert.assertTrue((boolean)((CoprocessorImpl)c).wasClosed());
            Assert.assertTrue((boolean)((CoprocessorImpl)c).wasCompacted());
        }
    }

    Region reopenRegion(Region closedRegion, Class<?> ... implClasses) throws IOException {
        Region r = HRegion.openHRegion(closedRegion, null);
        Configuration conf = TEST_UTIL.getConfiguration();
        RegionCoprocessorHost host = new RegionCoprocessorHost(r, null, conf);
        ((HRegion)r).setCoprocessorHost(host);
        for (Class<?> implClass : implClasses) {
            host.load(implClass, 0x3FFFFFFF, conf);
        }
        host.preOpen();
        host.postOpen();
        return r;
    }

    Region initHRegion(TableName tableName, String callingMethod, Configuration conf, Class<?>[] implClasses, byte[][] families) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            htd.addFamily(new HColumnDescriptor(family));
        }
        HRegionInfo info = new HRegionInfo(tableName, null, null, false);
        Path path = new Path(DIR + callingMethod);
        HRegion r = HRegion.createHRegion(info, path, conf, htd);
        RegionCoprocessorHost host = new RegionCoprocessorHost(r, null, conf);
        r.setCoprocessorHost(host);
        for (Class<?> implClass : implClasses) {
            host.load(implClass, 0x3FFFFFFF, conf);
            Coprocessor c = host.findCoprocessor(implClass.getName());
            Assert.assertNotNull((Object)c);
        }
        host.preOpen();
        host.postOpen();
        return r;
    }

    Configuration initSplit() {
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compactionThreshold", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.master.lease.thread.wakefrequency", 5000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.scanner.timeout.period", 10000);
        TEST_UTIL.getConfiguration().setLong("hbase.client.pause", 15000L);
        TEST_UTIL.getConfiguration().setLong("hbase.hregion.max.filesize", 131072L);
        TEST_UTIL.getConfiguration().setBoolean("hbase.testing.nocluster", true);
        TEST_UTIL.getConfiguration().setBoolean("hbase.coprocessor.abortonerror", false);
        return TEST_UTIL.getConfiguration();
    }

    private Region[] split(Region r, byte[] splitRow) throws IOException {
        Region[] regions = new Region[2];
        SplitTransaction st = new SplitTransactionFactory(TEST_UTIL.getConfiguration()).create(r, splitRow);
        int i = 0;
        if (!st.prepare()) {
            Assert.assertTrue((boolean)false);
        }
        try {
            Server mockServer = (Server)Mockito.mock(Server.class);
            Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)TEST_UTIL.getConfiguration());
            PairOfSameType<Region> daughters = st.execute(mockServer, null);
            Iterator<Region> iterator = daughters.iterator();
            while (iterator.hasNext()) {
                Region each_daughter;
                regions[i] = each_daughter = iterator.next();
                ++i;
            }
        }
        catch (IOException ioe) {
            LOG.info((Object)("Split transaction of " + r.getRegionInfo().getRegionNameAsString() + " failed:" + ioe.getMessage()));
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            LOG.info((Object)("Failed rollback of failed split of " + r.getRegionInfo().getRegionNameAsString() + e.getMessage()));
        }
        Assert.assertTrue((i == 2 ? 1 : 0) != 0);
        return regions;
    }

    public static class CoprocessorII
    extends BaseRegionObserver {
        private ConcurrentMap<String, Object> sharedData;

        @Override
        public void start(CoprocessorEnvironment e) {
            this.sharedData = ((RegionCoprocessorEnvironment)e).getSharedData();
            this.sharedData.putIfAbsent("test2", new Object());
        }

        @Override
        public void stop(CoprocessorEnvironment e) {
            this.sharedData = null;
        }

        @Override
        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            if (1 / 0 == 1) {
                e.complete();
            }
        }

        Map<String, Object> getSharedData() {
            return this.sharedData;
        }
    }

    public static class CoprocessorImpl
    extends BaseRegionObserver {
        private boolean startCalled;
        private boolean stopCalled;
        private boolean preOpenCalled;
        private boolean postOpenCalled;
        private boolean preCloseCalled;
        private boolean postCloseCalled;
        private boolean preCompactCalled;
        private boolean postCompactCalled;
        private boolean preFlushCalled;
        private boolean postFlushCalled;
        private boolean preSplitCalled;
        private boolean postSplitCalled;
        private boolean preSplitWithSplitRowCalled;
        private ConcurrentMap<String, Object> sharedData;

        @Override
        public void start(CoprocessorEnvironment e) {
            this.sharedData = ((RegionCoprocessorEnvironment)e).getSharedData();
            this.sharedData.putIfAbsent("test1", new Object());
            this.startCalled = true;
        }

        @Override
        public void stop(CoprocessorEnvironment e) {
            this.sharedData = null;
            this.stopCalled = true;
        }

        @Override
        public void preOpen(ObserverContext<RegionCoprocessorEnvironment> e) {
            this.preOpenCalled = true;
        }

        @Override
        public void postOpen(ObserverContext<RegionCoprocessorEnvironment> e) {
            this.postOpenCalled = true;
        }

        @Override
        public void preClose(ObserverContext<RegionCoprocessorEnvironment> e, boolean abortRequested) {
            this.preCloseCalled = true;
        }

        @Override
        public void postClose(ObserverContext<RegionCoprocessorEnvironment> e, boolean abortRequested) {
            this.postCloseCalled = true;
        }

        @Override
        public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, InternalScanner scanner, ScanType scanType) {
            this.preCompactCalled = true;
            return scanner;
        }

        @Override
        public void postCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, StoreFile resultFile) {
            this.postCompactCalled = true;
        }

        @Override
        public void preFlush(ObserverContext<RegionCoprocessorEnvironment> e) {
            this.preFlushCalled = true;
        }

        @Override
        public void postFlush(ObserverContext<RegionCoprocessorEnvironment> e) {
            this.postFlushCalled = true;
        }

        @Override
        public void preSplit(ObserverContext<RegionCoprocessorEnvironment> e) {
            this.preSplitCalled = true;
        }

        @Override
        public void preSplit(ObserverContext<RegionCoprocessorEnvironment> c, byte[] splitRow) throws IOException {
            this.preSplitWithSplitRowCalled = true;
        }

        @Override
        public void postSplit(ObserverContext<RegionCoprocessorEnvironment> e, Region l, Region r) {
            this.postSplitCalled = true;
        }

        @Override
        public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan, RegionScanner s) throws IOException {
            return new CustomScanner(s);
        }

        boolean wasStarted() {
            return this.startCalled;
        }

        boolean wasStopped() {
            return this.stopCalled;
        }

        boolean wasOpened() {
            return this.preOpenCalled && this.postOpenCalled;
        }

        boolean wasClosed() {
            return this.preCloseCalled && this.postCloseCalled;
        }

        boolean wasFlushed() {
            return this.preFlushCalled && this.postFlushCalled;
        }

        boolean wasCompacted() {
            return this.preCompactCalled && this.postCompactCalled;
        }

        boolean wasSplit() {
            return this.preSplitCalled && this.postSplitCalled && this.preSplitWithSplitRowCalled;
        }

        Map<String, Object> getSharedData() {
            return this.sharedData;
        }
    }

    private static class CustomScanner
    implements RegionScanner {
        private RegionScanner delegate;

        public CustomScanner(RegionScanner delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean next(List<Cell> results) throws IOException {
            return this.delegate.next(results);
        }

        @Override
        public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
            return this.delegate.next(result, scannerContext);
        }

        @Override
        public boolean nextRaw(List<Cell> result) throws IOException {
            return this.delegate.nextRaw(result);
        }

        @Override
        public boolean nextRaw(List<Cell> result, ScannerContext context) throws IOException {
            return this.delegate.nextRaw(result, context);
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public HRegionInfo getRegionInfo() {
            return this.delegate.getRegionInfo();
        }

        @Override
        public boolean isFilterDone() throws IOException {
            return this.delegate.isFilterDone();
        }

        @Override
        public boolean reseek(byte[] row) throws IOException {
            return false;
        }

        @Override
        public long getMaxResultSize() {
            return this.delegate.getMaxResultSize();
        }

        @Override
        public long getMvccReadPoint() {
            return this.delegate.getMvccReadPoint();
        }

        @Override
        public int getBatch() {
            return this.delegate.getBatch();
        }
    }
}

