/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableMultiplexer;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestHTableMultiplexer {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] FAMILY = Bytes.toBytes("testFamily");
    private static byte[] QUALIFIER = Bytes.toBytes("testQualifier");
    private static byte[] VALUE1 = Bytes.toBytes("testValue1");
    private static byte[] VALUE2 = Bytes.toBytes("testValue2");
    private static int SLAVES = 3;
    private static int PER_REGIONSERVER_QUEUE_SIZE = 100000;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(SLAVES);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private static void checkExistence(HTable htable, byte[] row, byte[] family, byte[] quality) throws Exception {
        Result r;
        Get get = new Get(row);
        get.addColumn(FAMILY, QUALIFIER);
        int nbTry = 0;
        do {
            Assert.assertTrue((String)("Fail to get from " + htable.getName() + " after " + nbTry + " tries"), (nbTry < 50 ? 1 : 0) != 0);
            ++nbTry;
            Thread.sleep(100L);
        } while ((r = htable.get(get)) == null || r.getValue(FAMILY, QUALIFIER) == null);
        Assert.assertEquals((String)"value", (Object)Bytes.toStringBinary(VALUE1), (Object)Bytes.toStringBinary(r.getValue(FAMILY, QUALIFIER)));
    }

    @Test
    public void testHTableMultiplexer() throws Exception {
        byte[] row;
        int i;
        TableName TABLE_1 = TableName.valueOf("testHTableMultiplexer_1");
        TableName TABLE_2 = TableName.valueOf("testHTableMultiplexer_2");
        int NUM_REGIONS = 10;
        int VERSION = 3;
        HTableMultiplexer multiplexer = new HTableMultiplexer(TEST_UTIL.getConfiguration(), PER_REGIONSERVER_QUEUE_SIZE);
        HTable htable1 = TEST_UTIL.createTable(TABLE_1, (byte[][])new byte[][]{FAMILY}, 3, Bytes.toBytes("aaaaa"), Bytes.toBytes("zzzzz"), 10);
        HTable htable2 = TEST_UTIL.createTable(TABLE_2, (byte[][])new byte[][]{FAMILY}, 3, Bytes.toBytes("aaaaa"), Bytes.toBytes("zzzzz"), 10);
        TEST_UTIL.waitUntilAllRegionsAssigned(TABLE_1);
        TEST_UTIL.waitUntilAllRegionsAssigned(TABLE_2);
        byte[][] startRows = htable1.getStartKeys();
        byte[][] endRows = htable1.getEndKeys();
        for (int i2 = 0; i2 < 10; ++i2) {
            byte[] row2 = startRows[i2];
            if (row2 == null || row2.length <= 0) continue;
            Put put = new Put(row2).add(FAMILY, QUALIFIER, VALUE1);
            boolean success = multiplexer.put(TABLE_1, put);
            Assert.assertTrue((String)"multiplexer.put returns", (boolean)success);
            put = new Put(row2).add(FAMILY, QUALIFIER, VALUE1);
            success = multiplexer.put(TABLE_2, put);
            Assert.assertTrue((String)"multiplexer.put failed", (boolean)success);
            this.LOG.info((Object)("Put for " + Bytes.toStringBinary(startRows[i2]) + " @ iteration " + (i2 + 1)));
            TestHTableMultiplexer.checkExistence(htable1, startRows[i2], FAMILY, QUALIFIER);
            TestHTableMultiplexer.checkExistence(htable2, startRows[i2], FAMILY, QUALIFIER);
        }
        ArrayList<Put> multiput = new ArrayList<Put>();
        for (i = 0; i < 10; ++i) {
            row = endRows[i];
            if (row == null || row.length <= 0) continue;
            Put put = new Put(row);
            put.add(FAMILY, QUALIFIER, VALUE2);
            multiput.add(put);
        }
        List<Put> failedPuts = multiplexer.put(TABLE_1, multiput);
        Assert.assertTrue((failedPuts == null ? 1 : 0) != 0);
        for (i = 0; i < 10; ++i) {
            Result r;
            row = endRows[i];
            if (row == null || row.length <= 0) continue;
            Get get = new Get(row);
            get.addColumn(FAMILY, QUALIFIER);
            int nbTry = 0;
            do {
                Assert.assertTrue((nbTry++ < 50 ? 1 : 0) != 0);
                Thread.sleep(100L);
            } while ((r = htable1.get(get)) == null || r.getValue(FAMILY, QUALIFIER) == null || Bytes.compareTo(VALUE2, r.getValue(FAMILY, QUALIFIER)) != 0);
        }
    }
}

