/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.FailureInfo;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.PreemptiveFastFailInterceptor;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.exceptions.PreemptiveFastFailException;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.test.LoadTestKVGenerator;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestFastFail {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] FAMILY = Bytes.toBytes("testFamily");
    private static final Random random = new Random();
    private static int SLAVES = 3;
    private static byte[] QUALIFIER = Bytes.toBytes("testQualifier");
    private static final int SLEEPTIME = 5000;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(SLAVES);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        MyPreemptiveFastFailInterceptor.numBraveSouls.set(0);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testFastFail() throws IOException, InterruptedException {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        String tableName = "testClientRelearningExperiment";
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(Bytes.toBytes("testClientRelearningExperiment")));
        desc.addFamily(new HColumnDescriptor(FAMILY));
        admin.createTable(desc, Bytes.toBytes("aaaa"), Bytes.toBytes("zzzz"), 32);
        long numRows = 1000L;
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setLong("hbase.client.operation.timeout", 500000L);
        conf.setInt("hbase.client.pause", 500);
        conf.setBoolean("hbase.client.fast.fail.mode.enabled", true);
        conf.setLong("hbase.client.fastfail.threshold", 0L);
        conf.setClass("hbase.client.fast.fail.interceptor.impl", MyPreemptiveFastFailInterceptor.class, PreemptiveFastFailInterceptor.class);
        final Connection connection = ConnectionFactory.createConnection(conf);
        ArrayList<Put> puts = new ArrayList<Put>();
        for (long i = 0L; i < 1000L; ++i) {
            byte[] rowKey = this.longToByteArrayKey(i);
            Put put = new Put(rowKey);
            byte[] value = rowKey;
            put.add(FAMILY, QUALIFIER, value);
            puts.add(put);
        }
        try (Table table = connection.getTable(TableName.valueOf("testClientRelearningExperiment"));){
            table.put(puts);
            this.LOG.info((Object)"Written all puts.");
        }
        int nThreads = 100;
        ExecutorService service = Executors.newFixedThreadPool(nThreads);
        final CountDownLatch continueOtherHalf = new CountDownLatch(1);
        final CountDownLatch doneHalfway = new CountDownLatch(nThreads);
        final AtomicInteger numSuccessfullThreads = new AtomicInteger(0);
        final AtomicInteger numFailedThreads = new AtomicInteger(0);
        final AtomicLong totalTimeTaken = new AtomicLong(0L);
        final AtomicInteger numBlockedWorkers = new AtomicInteger(0);
        final AtomicInteger numPreemptiveFastFailExceptions = new AtomicInteger(0);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        for (int i = 0; i < nThreads; ++i) {
            futures.add(service.submit(new Callable<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public Boolean call() throws Exception {
                    try (Table table = connection.getTable(TableName.valueOf("testClientRelearningExperiment"));){
                        Thread.sleep(Math.abs(random.nextInt()) % 250);
                        byte[] row = TestFastFail.this.longToByteArrayKey(Math.abs(random.nextLong()) % 1000L);
                        Get g = new Get(row);
                        g.addColumn(FAMILY, QUALIFIER);
                        try {
                            table.get(g);
                        }
                        catch (Exception e) {
                            TestFastFail.this.LOG.debug((Object)"Get failed : ", (Throwable)e);
                            doneHalfway.countDown();
                            Boolean bl = false;
                            if (table == null) return bl;
                            if (var2_3 == null) {
                                table.close();
                                return bl;
                            }
                            try {
                                table.close();
                                return bl;
                            }
                            catch (Throwable throwable) {
                                var2_3.addSuppressed(throwable);
                                return bl;
                            }
                        }
                        doneHalfway.countDown();
                        continueOtherHalf.await();
                        long startTime = System.currentTimeMillis();
                        g = new Get(row);
                        g.addColumn(FAMILY, QUALIFIER);
                        try {
                            table.get(g);
                            numSuccessfullThreads.addAndGet(1);
                        }
                        catch (Exception e) {
                            if (e instanceof PreemptiveFastFailException) {
                                numPreemptiveFastFailExceptions.addAndGet(1);
                            }
                            numFailedThreads.addAndGet(1);
                            Boolean bl = false;
                            if (table == null) return bl;
                            if (var2_3 == null) {
                                table.close();
                                return bl;
                            }
                            try {
                                table.close();
                                return bl;
                            }
                            catch (Throwable throwable) {
                                var2_3.addSuppressed(throwable);
                                return bl;
                            }
                        }
                        finally {
                            long enTime = System.currentTimeMillis();
                            totalTimeTaken.addAndGet(enTime - startTime);
                            if (enTime - startTime >= 5000L) {
                                numBlockedWorkers.addAndGet(1);
                            }
                        }
                        Boolean bl = true;
                        return bl;
                    }
                    catch (Exception e) {
                        TestFastFail.this.LOG.error((Object)"Caught unknown exception", (Throwable)e);
                        doneHalfway.countDown();
                        return false;
                    }
                }
            }));
        }
        doneHalfway.await();
        ClusterStatus status = TEST_UTIL.getHBaseCluster().getClusterStatus();
        for (int i = 0; i < SLAVES; ++i) {
            HRegionServer server = TEST_UTIL.getHBaseCluster().getRegionServer(i);
            List<Region> regions = server.getOnlineRegions(TableName.META_TABLE_NAME);
            if (regions.size() > 0) continue;
            server.getRpcServer().stop();
            server.stop("Testing");
        }
        continueOtherHalf.countDown();
        Thread.sleep(10000L);
        TEST_UTIL.getHBaseCluster().restoreClusterStatus(status);
        int numThreadsReturnedFalse = 0;
        int numThreadsReturnedTrue = 0;
        int numThreadsThrewExceptions = 0;
        for (Future future : futures) {
            try {
                numThreadsReturnedTrue += (Boolean)future.get() != false ? 1 : 0;
                numThreadsReturnedFalse += (Boolean)future.get() != false ? 0 : 1;
            }
            catch (Exception e) {
                ++numThreadsThrewExceptions;
            }
        }
        this.LOG.debug((Object)("numThreadsReturnedFalse:" + numThreadsReturnedFalse + " numThreadsReturnedTrue:" + numThreadsReturnedTrue + " numThreadsThrewExceptions:" + numThreadsThrewExceptions + " numFailedThreads:" + numFailedThreads.get() + " numSuccessfullThreads:" + numSuccessfullThreads.get() + " numBlockedWorkers:" + numBlockedWorkers.get() + " totalTimeWaited: " + totalTimeTaken.get() / (numBlockedWorkers.get() == 0 ? Long.MAX_VALUE : (long)numBlockedWorkers.get()) + " numPFFEs: " + numPreemptiveFastFailExceptions.get()));
        Assert.assertEquals((String)"The expected number of all the successfull and the failed threads should equal the total number of threads that we spawned", (long)nThreads, (long)(numFailedThreads.get() + numSuccessfullThreads.get()));
        Assert.assertEquals((String)"All the failures should be coming from the secondput failure", (long)numFailedThreads.get(), (long)numThreadsReturnedFalse);
        Assert.assertEquals((String)"Number of threads that threw execution exceptions otherwise should be 0", (long)numThreadsThrewExceptions, (long)0L);
        Assert.assertEquals((String)"The regionservers that returned true should equal to the number of successful threads", (long)numThreadsReturnedTrue, (long)numSuccessfullThreads.get());
        Assert.assertTrue((String)"There should be atleast one thread that retried instead of failing", (MyPreemptiveFastFailInterceptor.numBraveSouls.get() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("There should be atleast one PreemptiveFastFail exception, otherwise, the test makes little sense.numPreemptiveFastFailExceptions: " + numPreemptiveFastFailExceptions.get()), (numPreemptiveFastFailExceptions.get() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Only few thread should ideally be waiting for the dead regionserver to be coming back. numBlockedWorkers:" + numBlockedWorkers.get() + " threads that retried : " + MyPreemptiveFastFailInterceptor.numBraveSouls.get()), (numBlockedWorkers.get() <= MyPreemptiveFastFailInterceptor.numBraveSouls.get() ? 1 : 0) != 0);
    }

    private byte[] longToByteArrayKey(long rowKey) {
        return LoadTestKVGenerator.md5PrefixedKey(rowKey).getBytes();
    }

    public static class MyPreemptiveFastFailInterceptor
    extends PreemptiveFastFailInterceptor {
        public static AtomicInteger numBraveSouls = new AtomicInteger();

        @Override
        protected boolean shouldRetryInspiteOfFastFail(FailureInfo fInfo) {
            boolean ret = super.shouldRetryInspiteOfFastFail(fInfo);
            if (ret) {
                numBraveSouls.addAndGet(1);
            }
            return ret;
        }

        public MyPreemptiveFastFailInterceptor(Configuration conf) {
            super(conf);
        }
    }
}

