/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptor;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptorContext;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptorFactory;
import org.apache.hadoop.hbase.exceptions.PreemptiveFastFailException;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Private
public class RpcRetryingCaller<T> {
    public static final Log LOG = LogFactory.getLog(RpcRetryingCaller.class);
    private long globalStartTime;
    private static final int MIN_RPC_TIMEOUT = 2000;
    private final int startLogErrorsCnt;
    private final long pause;
    private final int retries;
    private final int rpcTimeout;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final RetryingCallerInterceptor interceptor;
    private final RetryingCallerInterceptorContext context;

    public RpcRetryingCaller(long pause, int retries, int startLogErrorsCnt) {
        this(pause, retries, RetryingCallerInterceptorFactory.NO_OP_INTERCEPTOR, startLogErrorsCnt, 0);
    }

    public RpcRetryingCaller(long pause, int retries, RetryingCallerInterceptor interceptor, int startLogErrorsCnt, int rpcTimeout) {
        this.pause = pause;
        this.retries = retries;
        this.interceptor = interceptor;
        this.context = interceptor.createEmptyContext();
        this.startLogErrorsCnt = startLogErrorsCnt;
        this.rpcTimeout = rpcTimeout;
    }

    private int getRemainingTime(int callTimeout) {
        if (callTimeout <= 0) {
            return 0;
        }
        if (callTimeout == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int remainingTime = (int)((long)callTimeout - (EnvironmentEdgeManager.currentTime() - this.globalStartTime));
        if (remainingTime < 2000) {
            remainingTime = 2000;
        }
        return remainingTime;
    }

    private int getTimeout(int callTimeout) {
        int timeout = this.getRemainingTime(callTimeout);
        if (timeout <= 0 || this.rpcTimeout > 0 && this.rpcTimeout < timeout) {
            timeout = this.rpcTimeout;
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        AtomicBoolean atomicBoolean = this.cancelled;
        synchronized (atomicBoolean) {
            this.cancelled.set(true);
            this.cancelled.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T callWithRetries(RetryingCallable<T> callable, int callTimeout) throws IOException, RuntimeException {
        ArrayList<RetriesExhaustedException.ThrowableWithExtraContext> exceptions = new ArrayList<RetriesExhaustedException.ThrowableWithExtraContext>();
        this.globalStartTime = EnvironmentEdgeManager.currentTime();
        this.context.clear();
        int tries = 0;
        while (true) {
            long expectedSleep;
            Serializable t3;
            try {
                callable.prepare(tries != 0);
                this.interceptor.intercept(this.context.prepare(callable, tries));
                T t2 = callable.call(this.getTimeout(callTimeout));
                return t2;
            }
            catch (PreemptiveFastFailException e) {
                throw e;
            }
            catch (Throwable t3) {
                ExceptionUtil.rethrowIfInterrupt(t3);
                if (tries > this.startLogErrorsCnt) {
                    LOG.info((Object)("Call exception, tries=" + tries + ", retries=" + this.retries + ", started=" + (EnvironmentEdgeManager.currentTime() - this.globalStartTime) + " ms ago, cancelled=" + this.cancelled.get() + ", msg=" + callable.getExceptionMessageAdditionalDetail()));
                }
                this.interceptor.handleFailure(this.context, t3);
                t3 = RpcRetryingCaller.translateException(t3);
                callable.throwable((Throwable)t3, this.retries != 1);
                RetriesExhaustedException.ThrowableWithExtraContext qt = new RetriesExhaustedException.ThrowableWithExtraContext((Throwable)t3, EnvironmentEdgeManager.currentTime(), this.toString());
                exceptions.add(qt);
                if (tries >= this.retries - 1) {
                    throw new RetriesExhaustedException(tries, exceptions);
                }
                expectedSleep = callable.sleep(this.pause, tries);
                long duration = this.singleCallDuration(expectedSleep);
                if (duration > (long)callTimeout) {
                    String msg = "callTimeout=" + callTimeout + ", callDuration=" + duration + ": " + callable.getExceptionMessageAdditionalDetail();
                    throw (SocketTimeoutException)new SocketTimeoutException(msg).initCause((Throwable)t3);
                }
            }
            finally {
                this.interceptor.updateFailureInfo(this.context);
            }
            try {
                if (expectedSleep > 0L) {
                    t3 = this.cancelled;
                    synchronized (t3) {
                        if (this.cancelled.get()) {
                            return null;
                        }
                        this.cancelled.wait(expectedSleep);
                    }
                }
                if (this.cancelled.get()) {
                    return null;
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("Interrupted after " + tries + " tries  on " + this.retries);
            }
            ++tries;
        }
    }

    private long singleCallDuration(long expectedSleep) {
        return EnvironmentEdgeManager.currentTime() - this.globalStartTime + expectedSleep;
    }

    public T callWithoutRetries(RetryingCallable<T> callable, int callTimeout) throws IOException, RuntimeException {
        this.globalStartTime = EnvironmentEdgeManager.currentTime();
        try {
            callable.prepare(false);
            return callable.call(callTimeout);
        }
        catch (Throwable t) {
            Throwable t2 = RpcRetryingCaller.translateException(t);
            ExceptionUtil.rethrowIfInterrupt(t2);
            if (t2 instanceof IOException) {
                throw (IOException)t2;
            }
            throw new RuntimeException(t2);
        }
    }

    static Throwable translateException(Throwable t) throws DoNotRetryIOException {
        if (t instanceof UndeclaredThrowableException && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof RemoteException) {
            t = ((RemoteException)t).unwrapRemoteException();
        }
        if (t instanceof LinkageError) {
            throw new DoNotRetryIOException(t);
        }
        if (t instanceof ServiceException) {
            ServiceException se = (ServiceException)t;
            Throwable cause = se.getCause();
            if (cause != null && cause instanceof DoNotRetryIOException) {
                throw (DoNotRetryIOException)cause;
            }
            t = cause;
            RpcRetryingCaller.translateException(t);
        } else if (t instanceof DoNotRetryIOException) {
            throw (DoNotRetryIOException)t;
        }
        return t;
    }

    public String toString() {
        return "RpcRetryingCaller{globalStartTime=" + this.globalStartTime + ", pause=" + this.pause + ", retries=" + this.retries + '}';
    }
}

