/*
 * Decompiled with CFR 0.152.
 */
package drill.shaded.hbase.guava.com.google.common.collect;

import drill.shaded.hbase.guava.com.google.common.annotations.GwtCompatible;
import drill.shaded.hbase.guava.com.google.common.annotations.VisibleForTesting;
import drill.shaded.hbase.guava.com.google.common.base.Function;
import drill.shaded.hbase.guava.com.google.common.base.Objects;
import drill.shaded.hbase.guava.com.google.common.base.Preconditions;
import drill.shaded.hbase.guava.com.google.common.collect.AbstractIndexedListIterator;
import drill.shaded.hbase.guava.com.google.common.collect.AbstractIterator;
import drill.shaded.hbase.guava.com.google.common.collect.ImmutableCollection;
import drill.shaded.hbase.guava.com.google.common.collect.ImmutableList;
import drill.shaded.hbase.guava.com.google.common.collect.ImmutableMap;
import drill.shaded.hbase.guava.com.google.common.collect.ImmutableMapEntrySet;
import drill.shaded.hbase.guava.com.google.common.collect.ImmutableSet;
import drill.shaded.hbase.guava.com.google.common.collect.ImmutableTable;
import drill.shaded.hbase.guava.com.google.common.collect.Iterables;
import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import drill.shaded.hbase.guava.com.google.common.collect.Maps;
import drill.shaded.hbase.guava.com.google.common.collect.Table;
import drill.shaded.hbase.guava.com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@GwtCompatible
abstract class RegularImmutableTable<R, C, V>
extends ImmutableTable<R, C, V> {
    private final ImmutableSet<Table.Cell<R, C, V>> cellSet;
    private static final Function<Table.Cell<Object, Object, Object>, Object> GET_VALUE_FUNCTION = new Function<Table.Cell<Object, Object, Object>, Object>(){

        @Override
        public Object apply(Table.Cell<Object, Object, Object> from) {
            return from.getValue();
        }
    };
    @Nullable
    private volatile transient ImmutableList<V> valueList;

    private RegularImmutableTable(ImmutableSet<Table.Cell<R, C, V>> cellSet) {
        this.cellSet = cellSet;
    }

    private Function<Table.Cell<R, C, V>, V> getValueFunction() {
        return GET_VALUE_FUNCTION;
    }

    @Override
    public final ImmutableCollection<V> values() {
        ImmutableList<V> result = this.valueList;
        if (result == null) {
            this.valueList = result = ImmutableList.copyOf(Iterables.transform(this.cellSet(), this.getValueFunction()));
        }
        return result;
    }

    @Override
    public final int size() {
        return this.cellSet().size();
    }

    @Override
    public final boolean containsValue(@Nullable Object value) {
        return ((ImmutableCollection)this.values()).contains(value);
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public final ImmutableSet<Table.Cell<R, C, V>> cellSet() {
        return this.cellSet;
    }

    static final <R, C, V> RegularImmutableTable<R, C, V> forCells(List<Table.Cell<R, C, V>> cells, final @Nullable Comparator<? super R> rowComparator, final @Nullable Comparator<? super C> columnComparator) {
        Preconditions.checkNotNull(cells);
        if (rowComparator != null || columnComparator != null) {
            Comparator comparator = new Comparator<Table.Cell<R, C, V>>(){

                @Override
                public int compare(Table.Cell<R, C, V> cell1, Table.Cell<R, C, V> cell2) {
                    int rowCompare;
                    int n = rowCompare = rowComparator == null ? 0 : rowComparator.compare(cell1.getRowKey(), cell2.getRowKey());
                    if (rowCompare != 0) {
                        return rowCompare;
                    }
                    return columnComparator == null ? 0 : columnComparator.compare(cell1.getColumnKey(), cell2.getColumnKey());
                }
            };
            Collections.sort(cells, comparator);
        }
        return RegularImmutableTable.forCellsInternal(cells, rowComparator, columnComparator);
    }

    static final <R, C, V> RegularImmutableTable<R, C, V> forCells(Iterable<Table.Cell<R, C, V>> cells) {
        return RegularImmutableTable.forCellsInternal(cells, null, null);
    }

    private static final <R, C, V> RegularImmutableTable<R, C, V> forCellsInternal(Iterable<Table.Cell<R, C, V>> cells, @Nullable Comparator<? super R> rowComparator, @Nullable Comparator<? super C> columnComparator) {
        ImmutableSet.Builder cellSetBuilder = ImmutableSet.builder();
        ImmutableSet.Builder rowSpaceBuilder = ImmutableSet.builder();
        ImmutableSet.Builder columnSpaceBuilder = ImmutableSet.builder();
        for (Table.Cell<R, C, V> cell : cells) {
            cellSetBuilder.add(cell);
            rowSpaceBuilder.add(cell.getRowKey());
            columnSpaceBuilder.add(cell.getColumnKey());
        }
        ImmutableCollection cellSet = cellSetBuilder.build();
        ImmutableSet rowSpace = rowSpaceBuilder.build();
        if (rowComparator != null) {
            ArrayList rowList = Lists.newArrayList(rowSpace);
            Collections.sort(rowList, rowComparator);
            rowSpace = ImmutableSet.copyOf(rowList);
        }
        ImmutableSet columnSpace = columnSpaceBuilder.build();
        if (columnComparator != null) {
            ArrayList columnList = Lists.newArrayList(columnSpace);
            Collections.sort(columnList, columnComparator);
            columnSpace = ImmutableSet.copyOf(columnList);
        }
        return cellSet.size() > rowSpace.size() * columnSpace.size() / 2 ? new DenseImmutableTable(cellSet, rowSpace, columnSpace) : new SparseImmutableTable(cellSet, rowSpace, columnSpace);
    }

    @Immutable
    @VisibleForTesting
    static final class DenseImmutableTable<R, C, V>
    extends RegularImmutableTable<R, C, V> {
        private final ImmutableMap<R, Integer> rowKeyToIndex;
        private final ImmutableMap<C, Integer> columnKeyToIndex;
        private final ImmutableMap<R, Map<C, V>> rowMap;
        private final ImmutableMap<C, Map<R, V>> columnMap;
        private final int[] rowCounts;
        private final int[] columnCounts;
        private final V[][] values;

        private static <E> ImmutableMap<E, Integer> makeIndex(ImmutableSet<E> set) {
            ImmutableMap.Builder indexBuilder = ImmutableMap.builder();
            int i = 0;
            for (Object key : set) {
                indexBuilder.put(key, i);
                ++i;
            }
            return indexBuilder.build();
        }

        DenseImmutableTable(ImmutableSet<Table.Cell<R, C, V>> cellSet, ImmutableSet<R> rowSpace, ImmutableSet<C> columnSpace) {
            super(cellSet);
            Object[][] array = new Object[rowSpace.size()][columnSpace.size()];
            this.values = array;
            this.rowKeyToIndex = DenseImmutableTable.makeIndex(rowSpace);
            this.columnKeyToIndex = DenseImmutableTable.makeIndex(columnSpace);
            this.rowCounts = new int[this.rowKeyToIndex.size()];
            this.columnCounts = new int[this.columnKeyToIndex.size()];
            for (Table.Cell cell : cellSet) {
                int columnIndex;
                Object rowKey = cell.getRowKey();
                Object columnKey = cell.getColumnKey();
                int rowIndex = this.rowKeyToIndex.get(rowKey);
                V existingValue = this.values[rowIndex][columnIndex = this.columnKeyToIndex.get(columnKey).intValue()];
                Preconditions.checkArgument(existingValue == null, "duplicate key: (%s, %s)", rowKey, columnKey);
                this.values[rowIndex][columnIndex] = cell.getValue();
                int n = rowIndex;
                this.rowCounts[n] = this.rowCounts[n] + 1;
                int n2 = columnIndex;
                this.columnCounts[n2] = this.columnCounts[n2] + 1;
            }
            this.rowMap = new RowMap();
            this.columnMap = new ColumnMap();
        }

        @Override
        public ImmutableMap<R, V> column(C columnKey) {
            Integer columnIndex = this.columnKeyToIndex.get(Preconditions.checkNotNull(columnKey));
            if (columnIndex == null) {
                return ImmutableMap.of();
            }
            return new Column(columnIndex);
        }

        @Override
        public ImmutableSet<C> columnKeySet() {
            return this.columnKeyToIndex.keySet();
        }

        @Override
        public ImmutableMap<C, Map<R, V>> columnMap() {
            return this.columnMap;
        }

        @Override
        public boolean contains(@Nullable Object rowKey, @Nullable Object columnKey) {
            return this.get(rowKey, columnKey) != null;
        }

        @Override
        public boolean containsColumn(@Nullable Object columnKey) {
            return this.columnKeyToIndex.containsKey(columnKey);
        }

        @Override
        public boolean containsRow(@Nullable Object rowKey) {
            return this.rowKeyToIndex.containsKey(rowKey);
        }

        @Override
        public V get(@Nullable Object rowKey, @Nullable Object columnKey) {
            Integer rowIndex = this.rowKeyToIndex.get(rowKey);
            Integer columnIndex = this.columnKeyToIndex.get(columnKey);
            return rowIndex == null || columnIndex == null ? null : (V)this.values[rowIndex][columnIndex];
        }

        @Override
        public ImmutableMap<C, V> row(R rowKey) {
            Preconditions.checkNotNull(rowKey);
            Integer rowIndex = this.rowKeyToIndex.get(rowKey);
            if (rowIndex == null) {
                return ImmutableMap.of();
            }
            return new Row(rowIndex);
        }

        @Override
        public ImmutableSet<R> rowKeySet() {
            return this.rowKeyToIndex.keySet();
        }

        @Override
        public ImmutableMap<R, Map<C, V>> rowMap() {
            return this.rowMap;
        }

        private final class ColumnMap
        extends ImmutableArrayMap<C, Map<R, V>> {
            private ColumnMap() {
                super(DenseImmutableTable.this.columnCounts.length);
            }

            @Override
            ImmutableMap<C, Integer> keyToIndex() {
                return DenseImmutableTable.this.columnKeyToIndex;
            }

            @Override
            Map<R, V> getValue(int keyIndex) {
                return new Column(keyIndex);
            }

            @Override
            boolean isPartialView() {
                return false;
            }
        }

        private final class RowMap
        extends ImmutableArrayMap<R, Map<C, V>> {
            private RowMap() {
                super(DenseImmutableTable.this.rowCounts.length);
            }

            @Override
            ImmutableMap<R, Integer> keyToIndex() {
                return DenseImmutableTable.this.rowKeyToIndex;
            }

            @Override
            Map<C, V> getValue(int keyIndex) {
                return new Row(keyIndex);
            }

            @Override
            boolean isPartialView() {
                return false;
            }
        }

        private final class Column
        extends ImmutableArrayMap<R, V> {
            private final int columnIndex;

            Column(int columnIndex) {
                super(DenseImmutableTable.this.columnCounts[columnIndex]);
                this.columnIndex = columnIndex;
            }

            @Override
            ImmutableMap<R, Integer> keyToIndex() {
                return DenseImmutableTable.this.rowKeyToIndex;
            }

            @Override
            V getValue(int keyIndex) {
                return DenseImmutableTable.this.values[keyIndex][this.columnIndex];
            }

            @Override
            boolean isPartialView() {
                return true;
            }
        }

        private final class Row
        extends ImmutableArrayMap<C, V> {
            private final int rowIndex;

            Row(int rowIndex) {
                super(DenseImmutableTable.this.rowCounts[rowIndex]);
                this.rowIndex = rowIndex;
            }

            @Override
            ImmutableMap<C, Integer> keyToIndex() {
                return DenseImmutableTable.this.columnKeyToIndex;
            }

            @Override
            V getValue(int keyIndex) {
                return DenseImmutableTable.this.values[this.rowIndex][keyIndex];
            }

            @Override
            boolean isPartialView() {
                return true;
            }
        }
    }

    private static abstract class ImmutableArrayMap<K, V>
    extends ImmutableMap<K, V> {
        private final int size;

        ImmutableArrayMap(int size) {
            this.size = size;
        }

        abstract ImmutableMap<K, Integer> keyToIndex();

        private boolean isFull() {
            return this.size == this.keyToIndex().size();
        }

        K getKey(int index) {
            return (K)((ImmutableCollection)((Object)this.keyToIndex().keySet())).asList().get(index);
        }

        @Nullable
        abstract V getValue(int var1);

        @Override
        ImmutableSet<K> createKeySet() {
            return this.isFull() ? this.keyToIndex().keySet() : super.createKeySet();
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public V get(@Nullable Object key) {
            Integer keyIndex = this.keyToIndex().get(key);
            return keyIndex == null ? null : (V)this.getValue(keyIndex);
        }

        @Override
        ImmutableSet<Map.Entry<K, V>> createEntrySet() {
            if (this.isFull()) {
                return new ImmutableMapEntrySet<K, V>(){

                    @Override
                    ImmutableMap<K, V> map() {
                        return ImmutableArrayMap.this;
                    }

                    @Override
                    public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
                        return new AbstractIndexedListIterator<Map.Entry<K, V>>(this.size()){

                            @Override
                            protected Map.Entry<K, V> get(int index) {
                                return Maps.immutableEntry(ImmutableArrayMap.this.getKey(index), ImmutableArrayMap.this.getValue(index));
                            }
                        };
                    }
                };
            }
            return new ImmutableMapEntrySet<K, V>(){

                @Override
                ImmutableMap<K, V> map() {
                    return ImmutableArrayMap.this;
                }

                @Override
                public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
                    return new AbstractIterator<Map.Entry<K, V>>(){
                        private int index = -1;
                        private final int maxIndex;
                        {
                            this.maxIndex = ImmutableArrayMap.this.keyToIndex().size();
                        }

                        @Override
                        protected Map.Entry<K, V> computeNext() {
                            ++this.index;
                            while (this.index < this.maxIndex) {
                                Object value = ImmutableArrayMap.this.getValue(this.index);
                                if (value != null) {
                                    return Maps.immutableEntry(ImmutableArrayMap.this.getKey(this.index), value);
                                }
                                ++this.index;
                            }
                            return (Map.Entry)this.endOfData();
                        }
                    };
                }
            };
        }
    }

    @Immutable
    @VisibleForTesting
    static final class SparseImmutableTable<R, C, V>
    extends RegularImmutableTable<R, C, V> {
        private final ImmutableMap<R, Map<C, V>> rowMap;
        private final ImmutableMap<C, Map<R, V>> columnMap;

        private static final <A, B, V> Map<A, ImmutableMap.Builder<B, V>> makeIndexBuilder(ImmutableSet<A> keySpace) {
            LinkedHashMap indexBuilder = Maps.newLinkedHashMap();
            for (Object key : keySpace) {
                indexBuilder.put(key, ImmutableMap.builder());
            }
            return indexBuilder;
        }

        private static final <A, B, V> ImmutableMap<A, Map<B, V>> buildIndex(Map<A, ImmutableMap.Builder<B, V>> indexBuilder) {
            return ImmutableMap.copyOf(Maps.transformValues(indexBuilder, new Function<ImmutableMap.Builder<B, V>, Map<B, V>>(){

                @Override
                public Map<B, V> apply(ImmutableMap.Builder<B, V> from) {
                    return from.build();
                }
            }));
        }

        SparseImmutableTable(ImmutableSet<Table.Cell<R, C, V>> cellSet, ImmutableSet<R> rowSpace, ImmutableSet<C> columnSpace) {
            super(cellSet);
            Map rowIndexBuilder = SparseImmutableTable.makeIndexBuilder(rowSpace);
            Map columnIndexBuilder = SparseImmutableTable.makeIndexBuilder(columnSpace);
            for (Table.Cell cell : cellSet) {
                Object rowKey = cell.getRowKey();
                Object columnKey = cell.getColumnKey();
                Object value = cell.getValue();
                rowIndexBuilder.get(rowKey).put(columnKey, value);
                columnIndexBuilder.get(columnKey).put(rowKey, value);
            }
            this.rowMap = SparseImmutableTable.buildIndex(rowIndexBuilder);
            this.columnMap = SparseImmutableTable.buildIndex(columnIndexBuilder);
        }

        @Override
        public ImmutableMap<R, V> column(C columnKey) {
            Preconditions.checkNotNull(columnKey);
            return Objects.firstNonNull((ImmutableMap)this.columnMap.get(columnKey), ImmutableMap.of());
        }

        @Override
        public ImmutableSet<C> columnKeySet() {
            return this.columnMap.keySet();
        }

        @Override
        public ImmutableMap<C, Map<R, V>> columnMap() {
            return this.columnMap;
        }

        @Override
        public ImmutableMap<C, V> row(R rowKey) {
            Preconditions.checkNotNull(rowKey);
            return Objects.firstNonNull((ImmutableMap)this.rowMap.get(rowKey), ImmutableMap.of());
        }

        @Override
        public ImmutableSet<R> rowKeySet() {
            return this.rowMap.keySet();
        }

        @Override
        public ImmutableMap<R, Map<C, V>> rowMap() {
            return this.rowMap;
        }

        @Override
        public boolean contains(@Nullable Object rowKey, @Nullable Object columnKey) {
            Map<C, V> row = this.rowMap.get(rowKey);
            return row != null && row.containsKey(columnKey);
        }

        @Override
        public boolean containsColumn(@Nullable Object columnKey) {
            return this.columnMap.containsKey(columnKey);
        }

        @Override
        public boolean containsRow(@Nullable Object rowKey) {
            return this.rowMap.containsKey(rowKey);
        }

        @Override
        public V get(@Nullable Object rowKey, @Nullable Object columnKey) {
            Map<C, V> row = this.rowMap.get(rowKey);
            return row == null ? null : (V)row.get(columnKey);
        }
    }
}

