/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.PoolMap;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={TestRoundRobinPoolType.class, TestThreadLocalPoolType.class, TestReusablePoolType.class})
@Category(value={SmallTests.class})
public class TestPoolMap {

    @Category(value={SmallTests.class})
    public static class TestReusablePoolType
    extends TestPoolType {
        @Override
        protected PoolMap.PoolType getPoolType() {
            return PoolMap.PoolType.Reusable;
        }

        public void testSingleThreadedClient() throws InterruptedException, ExecutionException {
            String randomKey = String.valueOf(this.random.nextInt());
            String randomValue = String.valueOf(this.random.nextInt());
            this.runThread(randomKey, randomValue, randomValue);
            TestReusablePoolType.assertEquals((int)0, (int)this.poolMap.size(randomKey));
        }

        public void testMultiThreadedClients() throws InterruptedException, ExecutionException {
            String randomValue;
            for (int i = 0; i < 3; ++i) {
                String randomKey = String.valueOf(this.random.nextInt());
                randomValue = String.valueOf(this.random.nextInt());
                this.runThread(randomKey, randomValue, randomValue);
                TestReusablePoolType.assertEquals((int)0, (int)this.poolMap.size(randomKey));
            }
            this.poolMap.clear();
            String randomKey = String.valueOf(this.random.nextInt());
            for (int i = 0; i < 2; ++i) {
                randomValue = String.valueOf(this.random.nextInt());
                this.runThread(randomKey, randomValue, randomValue);
                TestReusablePoolType.assertEquals((int)0, (int)this.poolMap.size(randomKey));
            }
            TestReusablePoolType.assertEquals((int)0, (int)this.poolMap.size(randomKey));
        }

        public void testPoolCap() throws InterruptedException, ExecutionException {
            String randomKey = String.valueOf(this.random.nextInt());
            ArrayList<String> randomValues = new ArrayList<String>();
            for (int i = 0; i < 6; ++i) {
                String randomValue = String.valueOf(this.random.nextInt());
                randomValues.add(randomValue);
                this.runThread(randomKey, randomValue, randomValue);
            }
            TestReusablePoolType.assertEquals((int)0, (int)this.poolMap.size(randomKey));
        }
    }

    @Category(value={SmallTests.class})
    public static class TestThreadLocalPoolType
    extends TestPoolType {
        @Override
        protected PoolMap.PoolType getPoolType() {
            return PoolMap.PoolType.ThreadLocal;
        }

        public void testSingleThreadedClient() throws InterruptedException, ExecutionException {
            String randomKey = String.valueOf(this.random.nextInt());
            String randomValue = String.valueOf(this.random.nextInt());
            this.runThread(randomKey, randomValue, randomValue);
            TestThreadLocalPoolType.assertEquals((int)1, (int)this.poolMap.size(randomKey));
        }

        public void testMultiThreadedClients() throws InterruptedException, ExecutionException {
            String randomValue;
            for (int i = 0; i < 3; ++i) {
                String randomKey = String.valueOf(this.random.nextInt());
                randomValue = String.valueOf(this.random.nextInt());
                this.runThread(randomKey, randomValue, randomValue);
                TestThreadLocalPoolType.assertEquals((int)1, (int)this.poolMap.size(randomKey));
            }
            String randomKey = String.valueOf(this.random.nextInt());
            for (int i = 0; i < 3; ++i) {
                randomValue = String.valueOf(this.random.nextInt());
                this.runThread(randomKey, randomValue, randomValue);
                TestThreadLocalPoolType.assertEquals((int)(i + 1), (int)this.poolMap.size(randomKey));
            }
        }

        public void testPoolCap() throws InterruptedException, ExecutionException {
            String randomKey = String.valueOf(this.random.nextInt());
            for (int i = 0; i < 6; ++i) {
                String randomValue = String.valueOf(this.random.nextInt());
                this.runThread(randomKey, randomValue, randomValue);
            }
            TestThreadLocalPoolType.assertEquals((int)6, (int)this.poolMap.size(randomKey));
        }
    }

    @Category(value={SmallTests.class})
    public static class TestRoundRobinPoolType
    extends TestPoolType {
        @Override
        protected PoolMap.PoolType getPoolType() {
            return PoolMap.PoolType.RoundRobin;
        }

        public void testSingleThreadedClient() throws InterruptedException, ExecutionException {
            String randomKey = String.valueOf(this.random.nextInt());
            String randomValue = String.valueOf(this.random.nextInt());
            this.runThread(randomKey, randomValue, null);
            TestRoundRobinPoolType.assertEquals((int)1, (int)this.poolMap.size(randomKey));
        }

        public void testMultiThreadedClients() throws InterruptedException, ExecutionException {
            String randomValue;
            for (int i = 0; i < 3; ++i) {
                String randomKey = String.valueOf(this.random.nextInt());
                randomValue = String.valueOf(this.random.nextInt());
                this.runThread(randomKey, randomValue, null);
                TestRoundRobinPoolType.assertEquals((int)1, (int)this.poolMap.size(randomKey));
            }
            this.poolMap.clear();
            String randomKey = String.valueOf(this.random.nextInt());
            for (int i = 0; i < 2; ++i) {
                randomValue = String.valueOf(this.random.nextInt());
                this.runThread(randomKey, randomValue, null);
                TestRoundRobinPoolType.assertEquals((int)(i + 1), (int)this.poolMap.size(randomKey));
            }
            TestRoundRobinPoolType.assertEquals((int)2, (int)this.poolMap.size(randomKey));
        }

        public void testPoolCap() throws InterruptedException, ExecutionException {
            String randomKey = String.valueOf(this.random.nextInt());
            ArrayList<String> randomValues = new ArrayList<String>();
            for (int i = 0; i < 6; ++i) {
                String randomValue = String.valueOf(this.random.nextInt());
                randomValues.add(randomValue);
                if (i < 2) {
                    this.runThread(randomKey, randomValue, null);
                    continue;
                }
                this.runThread(randomKey, randomValue, (String)randomValues.get((i - 3 + 1) % 3));
            }
            TestRoundRobinPoolType.assertEquals((int)3, (int)this.poolMap.size(randomKey));
        }
    }

    public static abstract class TestPoolType
    extends TestCase {
        protected PoolMap<String, String> poolMap;
        protected Random random = new Random();
        protected static final int POOL_SIZE = 3;

        protected void setUp() throws Exception {
            this.poolMap = new PoolMap(this.getPoolType(), 3);
        }

        protected abstract PoolMap.PoolType getPoolType();

        protected void tearDown() throws Exception {
            this.poolMap.clear();
        }

        protected void runThread(final String randomKey, final String randomValue, final String expectedValue) throws InterruptedException {
            final AtomicBoolean matchFound = new AtomicBoolean(false);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    poolMap.put(randomKey, randomValue);
                    String actualValue = poolMap.get(randomKey);
                    matchFound.set(expectedValue == null ? actualValue == null : expectedValue.equals(actualValue));
                }
            });
            thread.start();
            thread.join();
            TestPoolType.assertTrue((boolean)matchFound.get());
        }
    }
}

