/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.BoundedConcurrentLinkedQueue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestBoundedConcurrentLinkedQueue {
    private static final int CAPACITY = 16;
    private BoundedConcurrentLinkedQueue<Long> queue;

    @Before
    public void setUp() throws Exception {
        this.queue = new BoundedConcurrentLinkedQueue(16L);
    }

    @Test
    public void testOfferAndPoll() throws Exception {
        for (long i = 1L; i <= 16L; ++i) {
            Assert.assertTrue((boolean)this.queue.offer(i));
            Assert.assertEquals((long)i, (long)this.queue.size());
            Assert.assertEquals((long)(16L - i), (long)this.queue.remainingCapacity());
        }
        Assert.assertFalse((boolean)this.queue.offer(0L));
        for (int i = 1; i <= 16; ++i) {
            long l = this.queue.poll();
            Assert.assertEquals((long)i, (long)l);
            Assert.assertEquals((long)(16 - i), (long)this.queue.size());
            Assert.assertEquals((long)i, (long)this.queue.remainingCapacity());
        }
        Assert.assertEquals(null, (Object)this.queue.poll());
    }

    @Test
    public void testDrain() throws Exception {
        for (long i = 1L; i <= 16L; ++i) {
            Assert.assertTrue((boolean)this.queue.offer(i));
            Assert.assertEquals((long)i, (long)this.queue.size());
            Assert.assertEquals((long)(16L - i), (long)this.queue.remainingCapacity());
        }
        Assert.assertFalse((boolean)this.queue.offer(0L));
        ArrayList list = new ArrayList();
        this.queue.drainTo(list);
        Assert.assertEquals(null, (Object)this.queue.poll());
        Assert.assertEquals((long)0L, (long)this.queue.size());
        Assert.assertEquals((long)16L, (long)this.queue.remainingCapacity());
    }

    @Test
    public void testClear() {
        for (long i = 1L; i <= 16L; ++i) {
            Assert.assertTrue((boolean)this.queue.offer(i));
            Assert.assertEquals((long)i, (long)this.queue.size());
            Assert.assertEquals((long)(16L - i), (long)this.queue.remainingCapacity());
        }
        Assert.assertFalse((boolean)this.queue.offer(0L));
        this.queue.clear();
        Assert.assertEquals(null, (Object)this.queue.poll());
        Assert.assertEquals((long)0L, (long)this.queue.size());
        Assert.assertEquals((long)16L, (long)this.queue.remainingCapacity());
    }

    @Test
    public void testMultiThread() throws InterruptedException {
        int offerThreadCount = 10;
        int pollThreadCount = 5;
        int duration = 5000;
        final AtomicBoolean stop = new AtomicBoolean(false);
        Thread[] offerThreads = new Thread[offerThreadCount];
        for (int i = 0; i < offerThreadCount; ++i) {
            offerThreads[i] = new Thread("offer-thread-" + i){

                @Override
                public void run() {
                    Random rand = new Random();
                    while (!stop.get()) {
                        TestBoundedConcurrentLinkedQueue.this.queue.offer(rand.nextLong());
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            };
        }
        Thread[] pollThreads = new Thread[pollThreadCount];
        for (int i = 0; i < pollThreadCount; ++i) {
            pollThreads[i] = new Thread("poll-thread-" + i){

                @Override
                public void run() {
                    while (!stop.get()) {
                        TestBoundedConcurrentLinkedQueue.this.queue.poll();
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            };
        }
        for (Thread t : offerThreads) {
            t.start();
        }
        for (Thread t : pollThreads) {
            t.start();
        }
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)duration) {
            Assert.assertTrue((this.queue.size() <= 16 ? 1 : 0) != 0);
            Thread.yield();
        }
        stop.set(true);
        for (Thread t : offerThreads) {
            t.join();
        }
        for (Thread t : pollThreads) {
            t.join();
        }
        Assert.assertTrue((this.queue.size() <= 16 ? 1 : 0) != 0);
    }
}

