/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.protobuf.generated.PingProtos;
import org.apache.hadoop.hbase.exceptions.HBaseException;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestProcedureProtos;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.AccessControlFilter;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestAccessController
extends SecureTestUtil {
    private static final Log LOG = LogFactory.getLog(TestAccessController.class);
    private static TableName TEST_TABLE;
    private static final HBaseTestingUtility TEST_UTIL;
    private static Configuration conf;
    private static Connection systemUserConnection;
    private static User SUPERUSER;
    private static User USER_ADMIN;
    private static User USER_RW;
    private static User USER_RO;
    private static User USER_OWNER;
    private static User USER_CREATE;
    private static User USER_NONE;
    private static User USER_ADMIN_CF;
    private static final String GROUP_ADMIN = "group_admin";
    private static final String GROUP_CREATE = "group_create";
    private static final String GROUP_READ = "group_read";
    private static final String GROUP_WRITE = "group_write";
    private static User USER_GROUP_ADMIN;
    private static User USER_GROUP_CREATE;
    private static User USER_GROUP_READ;
    private static User USER_GROUP_WRITE;
    private static TableName TEST_TABLE2;
    private static byte[] TEST_FAMILY;
    private static byte[] TEST_QUALIFIER;
    private static byte[] TEST_ROW;
    private static MasterCoprocessorEnvironment CP_ENV;
    private static AccessController ACCESS_CONTROLLER;
    private static RegionServerCoprocessorEnvironment RSCP_ENV;
    private static RegionCoprocessorEnvironment RCP_ENV;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TestAccessController.enableSecurity(conf);
        conf.set("hbase.coprocessor.region.classes", AccessController.class.getName());
        TestAccessController.verifyConfiguration(conf);
        conf.setBoolean("hbase.security.exec.permission.checks", true);
        TEST_UTIL.startMiniCluster();
        MasterCoprocessorHost cpHost = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterCoprocessorHost();
        cpHost.load(AccessController.class, 0, conf);
        ACCESS_CONTROLLER = (AccessController)cpHost.findCoprocessor(AccessController.class.getName());
        CP_ENV = cpHost.createEnvironment((Class)AccessController.class, (Coprocessor)ACCESS_CONTROLLER, 0, 1, conf);
        RegionServerCoprocessorHost rsHost = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getRegionServerCoprocessorHost();
        RSCP_ENV = rsHost.createEnvironment((Class)AccessController.class, (Coprocessor)ACCESS_CONTROLLER, 0, 1, conf);
        TEST_UTIL.waitUntilAllRegionsAssigned(AccessControlLists.ACL_TABLE_NAME);
        SUPERUSER = User.createUserForTesting(conf, "admin", new String[]{"supergroup"});
        USER_ADMIN = User.createUserForTesting(conf, "admin2", new String[0]);
        USER_RW = User.createUserForTesting(conf, "rwuser", new String[0]);
        USER_RO = User.createUserForTesting(conf, "rouser", new String[0]);
        USER_OWNER = User.createUserForTesting(conf, "owner", new String[0]);
        USER_CREATE = User.createUserForTesting(conf, "tbl_create", new String[0]);
        USER_NONE = User.createUserForTesting(conf, "nouser", new String[0]);
        USER_ADMIN_CF = User.createUserForTesting(conf, "col_family_admin", new String[0]);
        USER_GROUP_ADMIN = User.createUserForTesting(conf, "user_group_admin", new String[]{GROUP_ADMIN});
        USER_GROUP_CREATE = User.createUserForTesting(conf, "user_group_create", new String[]{GROUP_CREATE});
        USER_GROUP_READ = User.createUserForTesting(conf, "user_group_read", new String[]{GROUP_READ});
        USER_GROUP_WRITE = User.createUserForTesting(conf, "user_group_write", new String[]{GROUP_WRITE});
        systemUserConnection = TEST_UTIL.getConnection();
        TestAccessController.setUpTableAndUserPermissions();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TestAccessController.cleanUp();
        TEST_UTIL.shutdownMiniCluster();
    }

    private static void setUpTableAndUserPermissions() throws Exception {
        HTableDescriptor htd = new HTableDescriptor(TEST_TABLE);
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY);
        hcd.setMaxVersions(100);
        htd.addFamily(hcd);
        htd.setOwner(USER_OWNER);
        TestAccessController.createTable(TEST_UTIL, htd, (byte[][])new byte[][]{Bytes.toBytes("s")});
        Region region = TEST_UTIL.getHBaseCluster().getRegions(TEST_TABLE).get(0);
        RegionCoprocessorHost rcpHost = region.getCoprocessorHost();
        RCP_ENV = rcpHost.createEnvironment((Class)AccessController.class, (Coprocessor)ACCESS_CONTROLLER, 0, 1, conf);
        TestAccessController.grantGlobal(TEST_UTIL, USER_ADMIN.getShortName(), Permission.Action.ADMIN, Permission.Action.CREATE, Permission.Action.READ, Permission.Action.WRITE);
        TestAccessController.grantOnTable(TEST_UTIL, USER_RW.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ, Permission.Action.WRITE);
        TestAccessController.grantOnTable(TEST_UTIL, USER_CREATE.getShortName(), TEST_TABLE, null, null, Permission.Action.CREATE, Permission.Action.READ, Permission.Action.WRITE);
        TestAccessController.grantOnTable(TEST_UTIL, USER_RO.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
        TestAccessController.grantOnTable(TEST_UTIL, USER_ADMIN_CF.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.ADMIN, Permission.Action.CREATE);
        TestAccessController.grantGlobal(TEST_UTIL, AuthUtil.toGroupEntry(GROUP_ADMIN), Permission.Action.ADMIN);
        TestAccessController.grantGlobal(TEST_UTIL, AuthUtil.toGroupEntry(GROUP_CREATE), Permission.Action.CREATE);
        TestAccessController.grantGlobal(TEST_UTIL, AuthUtil.toGroupEntry(GROUP_READ), Permission.Action.READ);
        TestAccessController.grantGlobal(TEST_UTIL, AuthUtil.toGroupEntry(GROUP_WRITE), Permission.Action.WRITE);
        Assert.assertEquals((long)5L, (long)AccessControlLists.getTablePermissions(conf, TEST_TABLE).size());
        try {
            Assert.assertEquals((long)5L, (long)AccessControlClient.getUserPermissions(systemUserConnection, TEST_TABLE.toString()).size());
        }
        catch (Throwable e) {
            LOG.error((Object)"error during call of AccessControlClient.getUserPermissions. ", e);
        }
    }

    private static void cleanUp() throws Exception {
        try {
            TestAccessController.deleteTable(TEST_UTIL, TEST_TABLE);
        }
        catch (TableNotFoundException ex) {
            LOG.info((Object)("Test deleted table " + TEST_TABLE));
        }
        Assert.assertEquals((long)0L, (long)AccessControlLists.getTablePermissions(conf, TEST_TABLE).size());
        Assert.assertEquals((long)0L, (long)AccessControlLists.getNamespacePermissions(conf, TEST_TABLE.getNamespaceAsString()).size());
    }

    @Test
    public void testTableCreate() throws Exception {
        SecureTestUtil.AccessTestAction createTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HTableDescriptor htd = new HTableDescriptor(TableName.valueOf("testnewtable"));
                htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
                ACCESS_CONTROLLER.preCreateTable(ObserverContext.createAndPrepare(CP_ENV, null), htd, null);
                return null;
            }
        };
        TestAccessController.verifyAllowed(createTable, SUPERUSER, USER_ADMIN, USER_GROUP_CREATE);
        TestAccessController.verifyDenied(createTable, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_ADMIN, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test
    public void testTableModify() throws Exception {
        SecureTestUtil.AccessTestAction modifyTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HTableDescriptor htd = new HTableDescriptor(TEST_TABLE);
                htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
                htd.addFamily(new HColumnDescriptor("fam_" + User.getCurrent().getShortName()));
                ACCESS_CONTROLLER.preModifyTable(ObserverContext.createAndPrepare(CP_ENV, null), TEST_TABLE, htd);
                return null;
            }
        };
        TestAccessController.verifyAllowed(modifyTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, USER_GROUP_CREATE, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(modifyTable, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test
    public void testTableDelete() throws Exception {
        SecureTestUtil.AccessTestAction deleteTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDeleteTable(ObserverContext.createAndPrepare(CP_ENV, null), TEST_TABLE);
                return null;
            }
        };
        TestAccessController.verifyAllowed(deleteTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, USER_GROUP_CREATE, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(deleteTable, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test
    public void testTableTruncate() throws Exception {
        SecureTestUtil.AccessTestAction truncateTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preTruncateTable(ObserverContext.createAndPrepare(CP_ENV, null), TEST_TABLE);
                return null;
            }
        };
        TestAccessController.verifyAllowed(truncateTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, USER_GROUP_CREATE, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(truncateTable, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test
    public void testAddColumn() throws Exception {
        final HColumnDescriptor hcd = new HColumnDescriptor("fam_new");
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preAddColumn(ObserverContext.createAndPrepare(CP_ENV, null), TEST_TABLE, hcd);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, USER_GROUP_CREATE, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test
    public void testModifyColumn() throws Exception {
        final HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY);
        hcd.setMaxVersions(10);
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preModifyColumn(ObserverContext.createAndPrepare(CP_ENV, null), TEST_TABLE, hcd);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, USER_ADMIN_CF, USER_GROUP_CREATE, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test
    public void testDeleteColumn() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDeleteColumn(ObserverContext.createAndPrepare(CP_ENV, null), TEST_TABLE, TEST_FAMILY);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, USER_ADMIN_CF, USER_GROUP_CREATE, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test
    public void testTableDisable() throws Exception {
        SecureTestUtil.AccessTestAction disableTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDisableTable(ObserverContext.createAndPrepare(CP_ENV, null), TEST_TABLE);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction disableAclTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDisableTable(ObserverContext.createAndPrepare(CP_ENV, null), AccessControlLists.ACL_TABLE_NAME);
                return null;
            }
        };
        TestAccessController.verifyAllowed(disableTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, USER_GROUP_CREATE, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(disableTable, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
        TestAccessController.verifyDenied(disableAclTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_GROUP_CREATE, USER_GROUP_ADMIN, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test
    public void testTableEnable() throws Exception {
        SecureTestUtil.AccessTestAction enableTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preEnableTable(ObserverContext.createAndPrepare(CP_ENV, null), TEST_TABLE);
                return null;
            }
        };
        TestAccessController.verifyAllowed(enableTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, USER_GROUP_CREATE, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(enableTable, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test
    public void testAbortProcedure() throws Exception {
        TableName tableName = TableName.valueOf("testAbortProcedure");
        final ProcedureExecutor<MasterProcedureEnv> procExec = TEST_UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
        TestTableDDLProcedure proc = new TestTableDDLProcedure(procExec.getEnvironment(), tableName);
        proc.setOwner(USER_OWNER.getShortName());
        final long procId = procExec.submitProcedure(proc);
        SecureTestUtil.AccessTestAction abortProcedureAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preAbortProcedure(ObserverContext.createAndPrepare(CP_ENV, null), procExec, procId);
                return null;
            }
        };
        TestAccessController.verifyAllowed(abortProcedureAction, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyAllowed(abortProcedureAction, USER_OWNER);
        TestAccessController.verifyDenied(abortProcedureAction, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test
    public void testListProcedures() throws Exception {
        TableName tableName = TableName.valueOf("testAbortProcedure");
        ProcedureExecutor<MasterProcedureEnv> procExec = TEST_UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
        TestTableDDLProcedure proc = new TestTableDDLProcedure(procExec.getEnvironment(), tableName);
        proc.setOwner(USER_OWNER.getShortName());
        long procId = procExec.submitProcedure(proc);
        final List<ProcedureInfo> procInfoList = procExec.listProcedures();
        SecureTestUtil.AccessTestAction listProceduresAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ArrayList<ProcedureInfo> procInfoListClone = new ArrayList<ProcedureInfo>(procInfoList.size());
                for (ProcedureInfo pi : procInfoList) {
                    procInfoListClone.add(pi.clone());
                }
                ACCESS_CONTROLLER.postListProcedures(ObserverContext.createAndPrepare(CP_ENV, null), procInfoListClone);
                return null;
            }
        };
        TestAccessController.verifyAllowed(listProceduresAction, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyAllowed(listProceduresAction, USER_OWNER);
        TestAccessController.verifyIfNull(listProceduresAction, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test(timeout=180000L)
    public void testMove() throws Exception {
        List<HRegionLocation> regions;
        try (RegionLocator locator = systemUserConnection.getRegionLocator(TEST_TABLE);){
            regions = locator.getAllRegionLocations();
        }
        HRegionLocation location = regions.get(0);
        final HRegionInfo hri = location.getRegionInfo();
        final ServerName server = location.getServerName();
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preMove(ObserverContext.createAndPrepare(CP_ENV, null), hri, server, server);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test
    public void testAssign() throws Exception {
        List<HRegionLocation> regions;
        try (RegionLocator locator = systemUserConnection.getRegionLocator(TEST_TABLE);){
            regions = locator.getAllRegionLocations();
        }
        HRegionLocation location = regions.get(0);
        final HRegionInfo hri = location.getRegionInfo();
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preAssign(ObserverContext.createAndPrepare(CP_ENV, null), hri);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test
    public void testUnassign() throws Exception {
        List<HRegionLocation> regions;
        try (RegionLocator locator = systemUserConnection.getRegionLocator(TEST_TABLE);){
            regions = locator.getAllRegionLocations();
        }
        HRegionLocation location = regions.get(0);
        final HRegionInfo hri = location.getRegionInfo();
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preUnassign(ObserverContext.createAndPrepare(CP_ENV, null), hri, false);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test
    public void testRegionOffline() throws Exception {
        List<HRegionLocation> regions;
        try (RegionLocator locator = systemUserConnection.getRegionLocator(TEST_TABLE);){
            regions = locator.getAllRegionLocations();
        }
        HRegionLocation location = regions.get(0);
        final HRegionInfo hri = location.getRegionInfo();
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preRegionOffline(ObserverContext.createAndPrepare(CP_ENV, null), hri);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test
    public void testBalance() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preBalance(ObserverContext.createAndPrepare(CP_ENV, null));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test
    public void testBalanceSwitch() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preBalanceSwitch(ObserverContext.createAndPrepare(CP_ENV, null), true);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test
    public void testShutdown() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preShutdown(ObserverContext.createAndPrepare(CP_ENV, null));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test
    public void testStopMaster() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preStopMaster(ObserverContext.createAndPrepare(CP_ENV, null));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    private void verifyWrite(SecureTestUtil.AccessTestAction action) throws Exception {
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW, USER_GROUP_WRITE);
        TestAccessController.verifyDenied(action, USER_NONE, USER_RO, USER_GROUP_ADMIN, USER_GROUP_READ, USER_GROUP_CREATE);
    }

    @Test
    public void testSplit() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSplit(ObserverContext.createAndPrepare(RCP_ENV, null));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test
    public void testSplitWithSplitRow() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSplit(ObserverContext.createAndPrepare(RCP_ENV, null), TEST_ROW);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMergeRegions() throws Exception {
        TableName tname = TableName.valueOf("testMergeRegions");
        this.createTestTable(tname);
        try {
            final List<HRegion> regions = TEST_UTIL.getHBaseCluster().findRegionsForTable(tname);
            Assert.assertTrue((String)("not enough regions: " + regions.size()), (regions.size() >= 2 ? 1 : 0) != 0);
            SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    ACCESS_CONTROLLER.preMerge(ObserverContext.createAndPrepare(RSCP_ENV, null), (Region)regions.get(0), (Region)regions.get(1));
                    return null;
                }
            };
            TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
            TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        }
        finally {
            TEST_UTIL.deleteTable(tname);
        }
    }

    @Test
    public void testFlush() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preFlush(ObserverContext.createAndPrepare(RCP_ENV, null));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_GROUP_CREATE, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test
    public void testCompact() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preCompact(ObserverContext.createAndPrepare(RCP_ENV, null), null, null, ScanType.COMPACT_RETAIN_DELETES);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_GROUP_CREATE, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    private void verifyRead(SecureTestUtil.AccessTestAction action) throws Exception {
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW, USER_RO, USER_GROUP_READ);
        TestAccessController.verifyDenied(action, USER_NONE, USER_GROUP_CREATE, USER_GROUP_ADMIN, USER_GROUP_WRITE);
    }

    private void verifyReadWrite(SecureTestUtil.AccessTestAction action) throws Exception {
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW);
        TestAccessController.verifyDenied(action, USER_NONE, USER_RO, USER_GROUP_ADMIN, USER_GROUP_CREATE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test
    public void testRead() throws Exception {
        SecureTestUtil.AccessTestAction getAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Get g = new Get(TEST_ROW);
                g.addFamily(TEST_FAMILY);
                try (Connection conn = ConnectionFactory.createConnection(conf);
                     Table t = conn.getTable(TEST_TABLE);){
                    t.get(g);
                }
                return null;
            }
        };
        this.verifyRead(getAction);
        SecureTestUtil.AccessTestAction scanAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Object run() throws Exception {
                Scan s = new Scan();
                s.addFamily(TEST_FAMILY);
                try (Connection conn = ConnectionFactory.createConnection(conf);
                     Table t = conn.getTable(TEST_TABLE);
                     ResultScanner scanner = t.getScanner(s);){
                    Result r = scanner.next();
                    while (r != null) {
                        r = scanner.next();
                    }
                    scanner.close();
                    return null;
                }
            }
        };
        this.verifyRead(scanAction);
    }

    @Test
    public void testWrite() throws Exception {
        SecureTestUtil.AccessTestAction putAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Put p = new Put(TEST_ROW);
                p.add(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes(1));
                try (Connection conn = ConnectionFactory.createConnection(conf);
                     Table t = conn.getTable(TEST_TABLE);){
                    t.put(p);
                }
                return null;
            }
        };
        this.verifyWrite(putAction);
        SecureTestUtil.AccessTestAction deleteAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Delete d = new Delete(TEST_ROW);
                d.deleteFamily(TEST_FAMILY);
                try (Connection conn = ConnectionFactory.createConnection(conf);
                     Table t = conn.getTable(TEST_TABLE);){
                    t.delete(d);
                }
                return null;
            }
        };
        this.verifyWrite(deleteAction);
        SecureTestUtil.AccessTestAction incrementAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Increment inc = new Increment(TEST_ROW);
                inc.addColumn(TEST_FAMILY, TEST_QUALIFIER, 1L);
                try (Connection conn = ConnectionFactory.createConnection(conf);
                     Table t = conn.getTable(TEST_TABLE);){
                    t.increment(inc);
                }
                return null;
            }
        };
        this.verifyWrite(incrementAction);
    }

    @Test
    public void testReadWrite() throws Exception {
        SecureTestUtil.AccessTestAction checkAndDeleteAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Delete d = new Delete(TEST_ROW);
                d.deleteFamily(TEST_FAMILY);
                try (Connection conn = ConnectionFactory.createConnection(conf);
                     Table t = conn.getTable(TEST_TABLE);){
                    t.checkAndDelete(TEST_ROW, TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes("test_value"), d);
                }
                return null;
            }
        };
        this.verifyReadWrite(checkAndDeleteAction);
        SecureTestUtil.AccessTestAction checkAndPut = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Put p = new Put(TEST_ROW);
                p.add(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes(1));
                try (Connection conn = ConnectionFactory.createConnection(conf);
                     Table t = conn.getTable(TEST_TABLE);){
                    t.checkAndPut(TEST_ROW, TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes("test_value"), p);
                }
                return null;
            }
        };
        this.verifyReadWrite(checkAndPut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBulkLoad() throws Exception {
        try {
            FileSystem fs = TEST_UTIL.getTestFileSystem();
            final Path dir = TEST_UTIL.getDataTestDirOnTestFS("testBulkLoad");
            fs.mkdirs(dir);
            fs.setPermission(dir, FsPermission.valueOf((String)"-rwxrwxrwx"));
            SecureTestUtil.AccessTestAction bulkLoadAction = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    int numRows = 3;
                    byte[][][] hfileRanges = new byte[][][]{new byte[][]{{0}, {9}}};
                    Path bulkLoadBasePath = new Path(dir, new Path(User.getCurrent().getName()));
                    new BulkLoadHelper(bulkLoadBasePath).bulkLoadHFile(TEST_TABLE, TEST_FAMILY, TEST_QUALIFIER, hfileRanges, numRows);
                    return null;
                }
            };
            TestAccessController.verifyAllowed(bulkLoadAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_GROUP_CREATE);
            TestAccessController.verifyDenied(bulkLoadAction, USER_RW, USER_NONE, USER_RO, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_ADMIN);
        }
        finally {
            TEST_UTIL.getHBaseAdmin().disableTable(TEST_TABLE);
            TEST_UTIL.getHBaseAdmin().enableTable(TEST_TABLE);
        }
    }

    @Test
    public void testAppend() throws Exception {
        SecureTestUtil.AccessTestAction appendAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                byte[] row = TEST_ROW;
                byte[] qualifier = TEST_QUALIFIER;
                Put put = new Put(row);
                put.add(TEST_FAMILY, qualifier, Bytes.toBytes(1));
                Append append = new Append(row);
                append.add(TEST_FAMILY, qualifier, Bytes.toBytes(2));
                try (Connection conn = ConnectionFactory.createConnection(conf);
                     Table t = conn.getTable(TEST_TABLE);){
                    t.put(put);
                    t.append(append);
                }
                return null;
            }
        };
        TestAccessController.verifyAllowed(appendAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW, USER_GROUP_WRITE);
        TestAccessController.verifyDenied(appendAction, USER_RO, USER_NONE, USER_GROUP_CREATE, USER_GROUP_READ, USER_GROUP_ADMIN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGrantRevoke() throws Exception {
        SecureTestUtil.AccessTestAction grantAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection(conf);
                     Table acl = conn.getTable(AccessControlLists.ACL_TABLE_NAME);){
                    CoprocessorRpcChannel service = acl.coprocessorService(TEST_TABLE.getName());
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub(service);
                    ProtobufUtil.grant(null, protocol, USER_RO.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction revokeAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection(conf);
                     Table acl = conn.getTable(AccessControlLists.ACL_TABLE_NAME);){
                    CoprocessorRpcChannel service = acl.coprocessorService(TEST_TABLE.getName());
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub(service);
                    ProtobufUtil.revoke(null, protocol, USER_RO.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction getTablePermissionsAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection(conf);
                     Table acl = conn.getTable(AccessControlLists.ACL_TABLE_NAME);){
                    CoprocessorRpcChannel service = acl.coprocessorService(TEST_TABLE.getName());
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub(service);
                    ProtobufUtil.getUserPermissions(null, protocol, TEST_TABLE);
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction getGlobalPermissionsAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection(conf);
                     Table acl = conn.getTable(AccessControlLists.ACL_TABLE_NAME);){
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub(service);
                    ProtobufUtil.getUserPermissions(null, protocol);
                }
                return null;
            }
        };
        TestAccessController.verifyAllowed(grantAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(grantAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        try {
            TestAccessController.verifyAllowed(revokeAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
            TestAccessController.verifyDenied(revokeAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
            TestAccessController.verifyAllowed(getTablePermissionsAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
            TestAccessController.verifyDenied(getTablePermissionsAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
            TestAccessController.verifyAllowed(getGlobalPermissionsAction, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
            TestAccessController.verifyDenied(getGlobalPermissionsAction, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        }
        catch (Throwable throwable) {
            TestAccessController.grantOnTable(TEST_UTIL, USER_RO.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
            throw throwable;
        }
        TestAccessController.grantOnTable(TEST_UTIL, USER_RO.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostGrantRevoke() throws Exception {
        final TableName tableName = TableName.valueOf("TempTable");
        final byte[] family1 = Bytes.toBytes("f1");
        final byte[] family2 = Bytes.toBytes("f2");
        final byte[] qualifier = Bytes.toBytes("q");
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (admin.tableExists(tableName)) {
            TestAccessController.deleteTable(TEST_UTIL, tableName);
        }
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(family1));
        htd.addFamily(new HColumnDescriptor(family2));
        TestAccessController.createTable(TEST_UTIL, htd);
        try {
            User tblUser = User.createUserForTesting(TEST_UTIL.getConfiguration(), "tbluser", new String[0]);
            User gblUser = User.createUserForTesting(TEST_UTIL.getConfiguration(), "gbluser", new String[0]);
            SecureTestUtil.AccessTestAction putActionAll = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Put p = new Put(Bytes.toBytes("a"));
                    p.add(family1, qualifier, Bytes.toBytes("v1"));
                    p.add(family2, qualifier, Bytes.toBytes("v2"));
                    try (Connection conn = ConnectionFactory.createConnection(conf);
                         Table t = conn.getTable(tableName);){
                        t.put(p);
                    }
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction putAction1 = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Put p = new Put(Bytes.toBytes("a"));
                    p.add(family1, qualifier, Bytes.toBytes("v1"));
                    try (Connection conn = ConnectionFactory.createConnection(conf);
                         Table t = conn.getTable(tableName);){
                        t.put(p);
                    }
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction putAction2 = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Put p = new Put(Bytes.toBytes("a"));
                    p.add(family2, qualifier, Bytes.toBytes("v2"));
                    try (Connection conn = ConnectionFactory.createConnection(conf);
                         Table t = conn.getTable(tableName);){
                        t.put(p);
                    }
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction getActionAll = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Get g = new Get(TEST_ROW);
                    g.addFamily(family1);
                    g.addFamily(family2);
                    try (Connection conn = ConnectionFactory.createConnection(conf);
                         Table t = conn.getTable(tableName);){
                        t.get(g);
                    }
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction getAction1 = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Get g = new Get(TEST_ROW);
                    g.addFamily(family1);
                    try (Connection conn = ConnectionFactory.createConnection(conf);
                         Table t = conn.getTable(tableName);){
                        t.get(g);
                    }
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction getAction2 = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Get g = new Get(TEST_ROW);
                    g.addFamily(family2);
                    try (Connection conn = ConnectionFactory.createConnection(conf);
                         Table t = conn.getTable(tableName);){
                        t.get(g);
                    }
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction deleteActionAll = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Delete d = new Delete(TEST_ROW);
                    d.deleteFamily(family1);
                    d.deleteFamily(family2);
                    try (Connection conn = ConnectionFactory.createConnection(conf);
                         Table t = conn.getTable(tableName);){
                        t.delete(d);
                    }
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction deleteAction1 = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Delete d = new Delete(TEST_ROW);
                    d.deleteFamily(family1);
                    try (Connection conn = ConnectionFactory.createConnection(conf);
                         Table t = conn.getTable(tableName);){
                        t.delete(d);
                    }
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction deleteAction2 = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Delete d = new Delete(TEST_ROW);
                    d.deleteFamily(family2);
                    try (Connection conn = ConnectionFactory.createConnection(conf);
                         Table t = conn.getTable(tableName);){
                        t.delete(d);
                    }
                    return null;
                }
            };
            TestAccessController.verifyDenied(tblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyDenied(tblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyDenied(tblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.verifyDenied(gblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyDenied(gblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyDenied(gblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.grantGlobal(TEST_UTIL, gblUser.getShortName(), Permission.Action.READ);
            TestAccessController.grantOnTable(TEST_UTIL, tblUser.getShortName(), tableName, null, null, Permission.Action.READ);
            TestAccessController.verifyAllowed(tblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyDenied(tblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyDenied(tblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.verifyAllowed(gblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyDenied(gblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyDenied(gblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.grantGlobal(TEST_UTIL, gblUser.getShortName(), Permission.Action.WRITE);
            TestAccessController.grantOnTable(TEST_UTIL, tblUser.getShortName(), tableName, null, null, Permission.Action.WRITE);
            TestAccessController.verifyDenied(tblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyAllowed(tblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyAllowed(tblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.verifyDenied(gblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyAllowed(gblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyAllowed(gblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.revokeGlobal(TEST_UTIL, gblUser.getShortName(), new Permission.Action[0]);
            TestAccessController.revokeFromTable(TEST_UTIL, tblUser.getShortName(), tableName, null, null, new Permission.Action[0]);
            TestAccessController.verifyDenied(tblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyDenied(tblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyDenied(tblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.verifyDenied(gblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyDenied(gblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyDenied(gblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.grantGlobal(TEST_UTIL, gblUser.getShortName(), Permission.Action.READ);
            TestAccessController.grantOnTable(TEST_UTIL, tblUser.getShortName(), tableName, family1, null, Permission.Action.READ);
            TestAccessController.verifyAllowed(tblUser, getActionAll, getAction1);
            TestAccessController.verifyDenied(tblUser, getAction2);
            TestAccessController.verifyDenied(tblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyDenied(tblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.verifyAllowed(gblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyDenied(gblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyDenied(gblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.grantGlobal(TEST_UTIL, gblUser.getShortName(), Permission.Action.WRITE);
            TestAccessController.grantOnTable(TEST_UTIL, tblUser.getShortName(), tableName, family2, null, Permission.Action.WRITE);
            TestAccessController.verifyAllowed(tblUser, getActionAll, getAction1);
            TestAccessController.verifyAllowed(tblUser, putAction2, deleteAction2);
            TestAccessController.verifyDenied(tblUser, getAction2);
            TestAccessController.verifyDenied(tblUser, putActionAll, putAction1);
            TestAccessController.verifyDenied(tblUser, deleteActionAll, deleteAction1);
            TestAccessController.verifyDenied(gblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyAllowed(gblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyAllowed(gblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.revokeGlobal(TEST_UTIL, gblUser.getShortName(), new Permission.Action[0]);
            TestAccessController.revokeFromTable(TEST_UTIL, tblUser.getShortName(), tableName, family2, null, new Permission.Action[0]);
            TestAccessController.verifyAllowed(tblUser, getActionAll, getAction1);
            TestAccessController.verifyDenied(tblUser, getAction2);
            TestAccessController.verifyDenied(tblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyDenied(tblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.verifyDenied(gblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyDenied(gblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyDenied(gblUser, deleteActionAll, deleteAction1, deleteAction2);
        }
        finally {
            TestAccessController.deleteTable(TEST_UTIL, tableName);
        }
    }

    private boolean hasFoundUserPermission(UserPermission userPermission, List<UserPermission> perms) {
        return perms.contains((Object)userPermission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostGrantRevokeAtQualifierLevel() throws Exception {
        final TableName tableName = TableName.valueOf("testGrantRevokeAtQualifierLevel");
        final byte[] family1 = Bytes.toBytes("f1");
        byte[] family2 = Bytes.toBytes("f2");
        final byte[] qualifier = Bytes.toBytes("q");
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (admin.tableExists(tableName)) {
            TestAccessController.deleteTable(TEST_UTIL, tableName);
        }
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(family1));
        htd.addFamily(new HColumnDescriptor(family2));
        TestAccessController.createTable(TEST_UTIL, htd);
        try {
            User user = User.createUserForTesting(TEST_UTIL.getConfiguration(), "user", new String[0]);
            SecureTestUtil.AccessTestAction getQualifierAction = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Get g = new Get(TEST_ROW);
                    g.addColumn(family1, qualifier);
                    try (Connection conn = ConnectionFactory.createConnection(conf);
                         Table t = conn.getTable(tableName);){
                        t.get(g);
                    }
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction putQualifierAction = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Put p = new Put(TEST_ROW);
                    p.add(family1, qualifier, Bytes.toBytes("v1"));
                    try (Connection conn = ConnectionFactory.createConnection(conf);
                         Table t = conn.getTable(tableName);){
                        t.put(p);
                    }
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction deleteQualifierAction = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Delete d = new Delete(TEST_ROW);
                    d.deleteColumn(family1, qualifier);
                    try (Connection conn = ConnectionFactory.createConnection(conf);
                         Table t = conn.getTable(tableName);){
                        t.delete(d);
                    }
                    return null;
                }
            };
            TestAccessController.revokeFromTable(TEST_UTIL, user.getShortName(), tableName, family1, null, new Permission.Action[0]);
            TestAccessController.verifyDenied(user, getQualifierAction);
            TestAccessController.verifyDenied(user, putQualifierAction);
            TestAccessController.verifyDenied(user, deleteQualifierAction);
            TestAccessController.grantOnTable(TEST_UTIL, user.getShortName(), tableName, family1, qualifier, Permission.Action.READ);
            TestAccessController.verifyAllowed(user, getQualifierAction);
            TestAccessController.verifyDenied(user, putQualifierAction);
            TestAccessController.verifyDenied(user, deleteQualifierAction);
            TestAccessController.grantOnTable(TEST_UTIL, user.getShortName(), tableName, family1, qualifier, Permission.Action.WRITE);
            TestAccessController.verifyDenied(user, getQualifierAction);
            TestAccessController.verifyAllowed(user, putQualifierAction);
            TestAccessController.verifyAllowed(user, deleteQualifierAction);
            TestAccessController.grantOnTable(TEST_UTIL, user.getShortName(), tableName, family1, qualifier, Permission.Action.READ, Permission.Action.WRITE);
            TestAccessController.verifyAllowed(user, getQualifierAction);
            TestAccessController.verifyAllowed(user, putQualifierAction);
            TestAccessController.verifyAllowed(user, deleteQualifierAction);
            TestAccessController.revokeFromTable(TEST_UTIL, user.getShortName(), tableName, family1, qualifier, new Permission.Action[0]);
            TestAccessController.verifyDenied(user, getQualifierAction);
            TestAccessController.verifyDenied(user, putQualifierAction);
            TestAccessController.verifyDenied(user, deleteQualifierAction);
        }
        finally {
            TestAccessController.deleteTable(TEST_UTIL, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPermissionList() throws Exception {
        TableName tableName = TableName.valueOf("testPermissionList");
        byte[] family1 = Bytes.toBytes("f1");
        byte[] family2 = Bytes.toBytes("f2");
        byte[] qualifier = Bytes.toBytes("q");
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (admin.tableExists(tableName)) {
            TestAccessController.deleteTable(TEST_UTIL, tableName);
        }
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(family1));
        htd.addFamily(new HColumnDescriptor(family2));
        htd.setOwner(USER_OWNER);
        TestAccessController.createTable(TEST_UTIL, htd);
        try {
            AccessControlProtos.AccessControlService.BlockingInterface protocol;
            CoprocessorRpcChannel service;
            List<UserPermission> perms;
            try (Table acl = systemUserConnection.getTable(AccessControlLists.ACL_TABLE_NAME);){
                CoprocessorRpcChannel service2 = acl.coprocessorService(tableName.getName());
                AccessControlProtos.AccessControlService.BlockingInterface protocol2 = AccessControlProtos.AccessControlService.newBlockingStub(service2);
                perms = ProtobufUtil.getUserPermissions(null, protocol2, tableName);
            }
            UserPermission ownerperm = new UserPermission(Bytes.toBytes(USER_OWNER.getName()), tableName, null, Permission.Action.values());
            Assert.assertTrue((String)"Owner should have all permissions on table", (boolean)this.hasFoundUserPermission(ownerperm, perms));
            User user = User.createUserForTesting(TEST_UTIL.getConfiguration(), "user", new String[0]);
            byte[] userName = Bytes.toBytes(user.getShortName());
            UserPermission up = new UserPermission(userName, tableName, family1, qualifier, Permission.Action.READ);
            Assert.assertFalse((String)("User should not be granted permission: " + up.toString()), (boolean)this.hasFoundUserPermission(up, perms));
            TestAccessController.grantOnTable(TEST_UTIL, user.getShortName(), tableName, family1, qualifier, Permission.Action.READ);
            acl = systemUserConnection.getTable(AccessControlLists.ACL_TABLE_NAME);
            try {
                CoprocessorRpcChannel service3 = acl.coprocessorService(tableName.getName());
                AccessControlProtos.AccessControlService.BlockingInterface protocol3 = AccessControlProtos.AccessControlService.newBlockingStub(service3);
                perms = ProtobufUtil.getUserPermissions(null, protocol3, tableName);
            }
            finally {
                acl.close();
            }
            UserPermission upToVerify = new UserPermission(userName, tableName, family1, qualifier, Permission.Action.READ);
            Assert.assertTrue((String)("User should be granted permission: " + upToVerify.toString()), (boolean)this.hasFoundUserPermission(upToVerify, perms));
            upToVerify = new UserPermission(userName, tableName, family1, qualifier, Permission.Action.WRITE);
            Assert.assertFalse((String)("User should not be granted permission: " + upToVerify.toString()), (boolean)this.hasFoundUserPermission(upToVerify, perms));
            TestAccessController.grantOnTable(TEST_UTIL, user.getShortName(), tableName, family1, qualifier, Permission.Action.WRITE, Permission.Action.READ);
            acl = systemUserConnection.getTable(AccessControlLists.ACL_TABLE_NAME);
            try {
                service = acl.coprocessorService(tableName.getName());
                protocol = AccessControlProtos.AccessControlService.newBlockingStub(service);
                perms = ProtobufUtil.getUserPermissions(null, protocol, tableName);
            }
            finally {
                acl.close();
            }
            upToVerify = new UserPermission(userName, tableName, family1, qualifier, Permission.Action.WRITE, Permission.Action.READ);
            Assert.assertTrue((String)("User should be granted permission: " + upToVerify.toString()), (boolean)this.hasFoundUserPermission(upToVerify, perms));
            TestAccessController.revokeFromTable(TEST_UTIL, user.getShortName(), tableName, family1, qualifier, Permission.Action.WRITE, Permission.Action.READ);
            acl = systemUserConnection.getTable(AccessControlLists.ACL_TABLE_NAME);
            try {
                service = acl.coprocessorService(tableName.getName());
                protocol = AccessControlProtos.AccessControlService.newBlockingStub(service);
                perms = ProtobufUtil.getUserPermissions(null, protocol, tableName);
            }
            finally {
                acl.close();
            }
            Assert.assertFalse((String)("User should not be granted permission: " + upToVerify.toString()), (boolean)this.hasFoundUserPermission(upToVerify, perms));
            admin.disableTable(tableName);
            User newOwner = User.createUserForTesting(conf, "new_owner", new String[0]);
            htd.setOwner(newOwner);
            admin.modifyTable(tableName, htd);
            acl = systemUserConnection.getTable(AccessControlLists.ACL_TABLE_NAME);
            try {
                CoprocessorRpcChannel service4 = acl.coprocessorService(tableName.getName());
                AccessControlProtos.AccessControlService.BlockingInterface protocol4 = AccessControlProtos.AccessControlService.newBlockingStub(service4);
                perms = ProtobufUtil.getUserPermissions(null, protocol4, tableName);
            }
            finally {
                acl.close();
            }
            UserPermission newOwnerperm = new UserPermission(Bytes.toBytes(newOwner.getName()), tableName, null, Permission.Action.values());
            Assert.assertTrue((String)"New owner should have all permissions on table", (boolean)this.hasFoundUserPermission(newOwnerperm, perms));
        }
        finally {
            TestAccessController.deleteTable(TEST_UTIL, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlobalPermissionList() throws Exception {
        List<UserPermission> perms;
        try (Table acl = systemUserConnection.getTable(AccessControlLists.ACL_TABLE_NAME);){
            CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub(service);
            perms = ProtobufUtil.getUserPermissions(null, protocol);
        }
        UserPermission adminPerm = new UserPermission(Bytes.toBytes(USER_ADMIN.getShortName()), AccessControlLists.ACL_TABLE_NAME, null, null, Bytes.toBytes("ACRW"));
        Assert.assertTrue((String)"Only global users and user admin has permission on table _acl_ per setup", (perms.size() == 5 && this.hasFoundUserPermission(adminPerm, perms) ? 1 : 0) != 0);
    }

    private void verifyGlobal(SecureTestUtil.AccessTestAction action) throws Exception {
        TestAccessController.verifyAllowed(action, SUPERUSER);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_NONE, USER_RO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckPermissions() throws Exception {
        SecureTestUtil.AccessTestAction globalAdmin = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                SecureTestUtil.checkGlobalPerms(TEST_UTIL, Permission.Action.ADMIN);
                return null;
            }
        };
        this.verifyGlobal(globalAdmin);
        SecureTestUtil.AccessTestAction globalReadWrite = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                SecureTestUtil.checkGlobalPerms(TEST_UTIL, Permission.Action.READ, Permission.Action.WRITE);
                return null;
            }
        };
        this.verifyGlobal(globalReadWrite);
        final byte[] TEST_Q1 = Bytes.toBytes("q1");
        final byte[] TEST_Q2 = Bytes.toBytes("q2");
        User userTable = User.createUserForTesting(conf, "user_check_perms_table", new String[0]);
        User userColumn = User.createUserForTesting(conf, "user_check_perms_family", new String[0]);
        User userQualifier = User.createUserForTesting(conf, "user_check_perms_q", new String[0]);
        TestAccessController.grantOnTable(TEST_UTIL, userTable.getShortName(), TEST_TABLE, null, null, Permission.Action.READ);
        TestAccessController.grantOnTable(TEST_UTIL, userColumn.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
        TestAccessController.grantOnTable(TEST_UTIL, userQualifier.getShortName(), TEST_TABLE, TEST_FAMILY, TEST_Q1, Permission.Action.READ);
        try {
            SecureTestUtil.AccessTestAction tableRead = new SecureTestUtil.AccessTestAction(){

                @Override
                public Void run() throws Exception {
                    SecureTestUtil.checkTablePerms(TEST_UTIL, TEST_TABLE, null, null, Permission.Action.READ);
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction columnRead = new SecureTestUtil.AccessTestAction(){

                @Override
                public Void run() throws Exception {
                    SecureTestUtil.checkTablePerms(TEST_UTIL, TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction qualifierRead = new SecureTestUtil.AccessTestAction(){

                @Override
                public Void run() throws Exception {
                    SecureTestUtil.checkTablePerms(TEST_UTIL, TEST_TABLE, TEST_FAMILY, TEST_Q1, Permission.Action.READ);
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction multiQualifierRead = new SecureTestUtil.AccessTestAction(){

                @Override
                public Void run() throws Exception {
                    SecureTestUtil.checkTablePerms(TEST_UTIL, TEST_TABLE, new TablePermission(TEST_TABLE, TEST_FAMILY, TEST_Q1, Permission.Action.READ), new TablePermission(TEST_TABLE, TEST_FAMILY, TEST_Q2, Permission.Action.READ));
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction globalAndTableRead = new SecureTestUtil.AccessTestAction(){

                @Override
                public Void run() throws Exception {
                    SecureTestUtil.checkTablePerms(TEST_UTIL, TEST_TABLE, new Permission(Permission.Action.READ), new TablePermission(TEST_TABLE, null, (byte[])null, Permission.Action.READ));
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction noCheck = new SecureTestUtil.AccessTestAction(){

                @Override
                public Void run() throws Exception {
                    SecureTestUtil.checkTablePerms(TEST_UTIL, TEST_TABLE, new Permission[0]);
                    return null;
                }
            };
            TestAccessController.verifyAllowed(tableRead, SUPERUSER, userTable);
            TestAccessController.verifyDenied(tableRead, userColumn, userQualifier);
            TestAccessController.verifyAllowed(columnRead, SUPERUSER, userTable, userColumn);
            TestAccessController.verifyDenied(columnRead, userQualifier);
            TestAccessController.verifyAllowed(qualifierRead, SUPERUSER, userTable, userColumn, userQualifier);
            TestAccessController.verifyAllowed(multiQualifierRead, SUPERUSER, userTable, userColumn);
            TestAccessController.verifyDenied(multiQualifierRead, userQualifier);
            TestAccessController.verifyAllowed(globalAndTableRead, SUPERUSER);
            TestAccessController.verifyDenied(globalAndTableRead, userTable, userColumn, userQualifier);
            TestAccessController.verifyAllowed(noCheck, SUPERUSER, userTable, userColumn, userQualifier);
            SecureTestUtil.AccessTestAction familyReadWrite = new SecureTestUtil.AccessTestAction(){

                @Override
                public Void run() throws Exception {
                    SecureTestUtil.checkTablePerms(TEST_UTIL, TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ, Permission.Action.WRITE);
                    return null;
                }
            };
            TestAccessController.verifyAllowed(familyReadWrite, SUPERUSER, USER_OWNER, USER_CREATE, USER_RW);
            TestAccessController.verifyDenied(familyReadWrite, USER_NONE, USER_RO);
            AccessControlProtos.CheckPermissionsRequest checkRequest = AccessControlProtos.CheckPermissionsRequest.newBuilder().addPermission(AccessControlProtos.Permission.newBuilder().setType(AccessControlProtos.Permission.Type.Table).setTablePermission(AccessControlProtos.TablePermission.newBuilder().setTableName(ProtobufUtil.toProtoTableName(TEST_TABLE)).addAction(AccessControlProtos.Permission.Action.CREATE))).build();
            try (Table acl = systemUserConnection.getTable(AccessControlLists.ACL_TABLE_NAME);){
                CoprocessorRpcChannel channel = acl.coprocessorService(new byte[0]);
                AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub(channel);
                try {
                    protocol.checkPermissions(null, checkRequest);
                    Assert.fail((String)"this should have thrown CoprocessorException");
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            TestAccessController.revokeFromTable(TEST_UTIL, userTable.getShortName(), TEST_TABLE, null, null, Permission.Action.READ);
            TestAccessController.revokeFromTable(TEST_UTIL, userColumn.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
            TestAccessController.revokeFromTable(TEST_UTIL, userQualifier.getShortName(), TEST_TABLE, TEST_FAMILY, TEST_Q1, Permission.Action.READ);
            throw throwable;
        }
        TestAccessController.revokeFromTable(TEST_UTIL, userTable.getShortName(), TEST_TABLE, null, null, Permission.Action.READ);
        TestAccessController.revokeFromTable(TEST_UTIL, userColumn.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
        TestAccessController.revokeFromTable(TEST_UTIL, userQualifier.getShortName(), TEST_TABLE, TEST_FAMILY, TEST_Q1, Permission.Action.READ);
    }

    @Test
    public void testStopRegionServer() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preStopRegionServer(ObserverContext.createAndPrepare(RSCP_ENV, null));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test
    public void testRollWALWriterRequest() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preRollWALWriterRequest(ObserverContext.createAndPrepare(RSCP_ENV, null));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test
    public void testOpenRegion() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preOpen(ObserverContext.createAndPrepare(RCP_ENV, null));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER, USER_GROUP_CREATE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test
    public void testCloseRegion() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preClose(ObserverContext.createAndPrepare(RCP_ENV, null), false);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER, USER_GROUP_CREATE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test
    public void testSnapshot() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        final HTableDescriptor htd = admin.getTableDescriptor(TEST_TABLE);
        HBaseProtos.SnapshotDescription.Builder builder = HBaseProtos.SnapshotDescription.newBuilder();
        builder.setName(TEST_TABLE.getNameAsString() + "-snapshot");
        builder.setTable(TEST_TABLE.getNameAsString());
        final HBaseProtos.SnapshotDescription snapshot = builder.build();
        SecureTestUtil.AccessTestAction snapshotAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSnapshot(ObserverContext.createAndPrepare(CP_ENV, null), snapshot, htd);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction deleteAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDeleteSnapshot(ObserverContext.createAndPrepare(CP_ENV, null), snapshot);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction restoreAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preRestoreSnapshot(ObserverContext.createAndPrepare(CP_ENV, null), snapshot, htd);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction cloneAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preCloneSnapshot(ObserverContext.createAndPrepare(CP_ENV, null), null, null);
                return null;
            }
        };
        TestAccessController.verifyAllowed(snapshotAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(snapshotAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestAccessController.verifyAllowed(cloneAction, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(deleteAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestAccessController.verifyAllowed(restoreAction, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(restoreAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestAccessController.verifyAllowed(deleteAction, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(cloneAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test
    public void testSnapshotWithOwner() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        final HTableDescriptor htd = admin.getTableDescriptor(TEST_TABLE);
        HBaseProtos.SnapshotDescription.Builder builder = HBaseProtos.SnapshotDescription.newBuilder();
        builder.setName(TEST_TABLE.getNameAsString() + "-snapshot");
        builder.setTable(TEST_TABLE.getNameAsString());
        builder.setOwner(USER_OWNER.getName());
        final HBaseProtos.SnapshotDescription snapshot = builder.build();
        SecureTestUtil.AccessTestAction snapshotAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSnapshot(ObserverContext.createAndPrepare(CP_ENV, null), snapshot, htd);
                return null;
            }
        };
        TestAccessController.verifyAllowed(snapshotAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(snapshotAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        SecureTestUtil.AccessTestAction deleteAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDeleteSnapshot(ObserverContext.createAndPrepare(CP_ENV, null), snapshot);
                return null;
            }
        };
        TestAccessController.verifyAllowed(deleteAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(deleteAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        SecureTestUtil.AccessTestAction restoreAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preRestoreSnapshot(ObserverContext.createAndPrepare(CP_ENV, null), snapshot, htd);
                return null;
            }
        };
        TestAccessController.verifyAllowed(restoreAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(restoreAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        SecureTestUtil.AccessTestAction cloneAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preCloneSnapshot(ObserverContext.createAndPrepare(CP_ENV, null), null, null);
                return null;
            }
        };
        TestAccessController.verifyAllowed(cloneAction, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(cloneAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test
    public void testGlobalAuthorizationForNewRegisteredRS() throws Exception {
        List<HRegionLocation> regions;
        LOG.debug((Object)"Test for global authorization for a new registered RegionServer.");
        MiniHBaseCluster hbaseCluster = TEST_UTIL.getHBaseCluster();
        final HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor htd = new HTableDescriptor(TEST_TABLE2);
        htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
        TestAccessController.createTable(TEST_UTIL, htd);
        JVMClusterUtil.RegionServerThread newRsThread = hbaseCluster.startRegionServer();
        final HRegionServer newRs = newRsThread.getRegionServer();
        try (RegionLocator locator = systemUserConnection.getRegionLocator(TEST_TABLE2);){
            regions = locator.getAllRegionLocations();
        }
        HRegionLocation location = regions.get(0);
        final HRegionInfo hri = location.getRegionInfo();
        ServerName server = location.getServerName();
        try (final HTable table = (HTable)systemUserConnection.getTable(TEST_TABLE2);){
            SecureTestUtil.AccessTestAction moveAction = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    admin.move(hri.getEncodedNameAsBytes(), Bytes.toBytes(newRs.getServerName().getServerName()));
                    return null;
                }
            };
            SUPERUSER.runAs(moveAction);
            int RETRIES_LIMIT = 10;
            int retries = 0;
            while (newRs.getOnlineRegions(TEST_TABLE2).size() < 1 && retries < 10) {
                LOG.debug((Object)("Waiting for region to be opened. Already retried " + retries + " times."));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (++retries != 9) continue;
                Assert.fail((String)"Retry exhaust for waiting region to be opened.");
            }
            SecureTestUtil.AccessTestAction putAction = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Put put = new Put(Bytes.toBytes("test"));
                    put.add(TEST_FAMILY, Bytes.toBytes("qual"), Bytes.toBytes("value"));
                    table.put(put);
                    return null;
                }
            };
            USER_ADMIN.runAs(putAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableDescriptorsEnumeration() throws Exception {
        User TABLE_ADMIN = User.createUserForTesting(conf, "UserA", new String[0]);
        TestAccessController.grantOnTable(TEST_UTIL, TABLE_ADMIN.getShortName(), TEST_TABLE, null, null, Permission.Action.ADMIN);
        try {
            SecureTestUtil.AccessTestAction listTablesAction = new SecureTestUtil.AccessTestAction(){

                /*
                 * Exception decompiling
                 */
                @Override
                public Object run() throws Exception {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            };
            SecureTestUtil.AccessTestAction getTableDescAction = new SecureTestUtil.AccessTestAction(){

                /*
                 * Exception decompiling
                 */
                @Override
                public Object run() throws Exception {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            };
            TestAccessController.verifyAllowed(listTablesAction, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, TABLE_ADMIN, USER_GROUP_CREATE, USER_GROUP_ADMIN);
            TestAccessController.verifyIfEmptyList(listTablesAction, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
            TestAccessController.verifyAllowed(getTableDescAction, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, TABLE_ADMIN, USER_GROUP_CREATE, USER_GROUP_ADMIN);
            TestAccessController.verifyDenied(getTableDescAction, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
        }
        catch (Throwable throwable) {
            TestAccessController.revokeFromTable(TEST_UTIL, TABLE_ADMIN.getShortName(), TEST_TABLE, null, null, Permission.Action.ADMIN);
            throw throwable;
        }
        TestAccessController.revokeFromTable(TEST_UTIL, TABLE_ADMIN.getShortName(), TEST_TABLE, null, null, Permission.Action.ADMIN);
    }

    @Test
    public void testTableNameEnumeration() throws Exception {
        SecureTestUtil.AccessTestAction listTablesAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Connection unmanagedConnection = ConnectionFactory.createConnection(TEST_UTIL.getConfiguration());
                Admin admin = unmanagedConnection.getAdmin();
                try {
                    List<TableName> list = Arrays.asList(admin.listTableNames());
                    return list;
                }
                finally {
                    admin.close();
                    unmanagedConnection.close();
                }
            }
        };
        TestAccessController.verifyAllowed(listTablesAction, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_GROUP_CREATE, USER_GROUP_ADMIN, USER_GROUP_READ, USER_GROUP_WRITE);
        TestAccessController.verifyIfEmptyList(listTablesAction, USER_NONE);
    }

    @Test
    public void testTableDeletion() throws Exception {
        User TABLE_ADMIN = User.createUserForTesting(conf, "TestUser", new String[0]);
        final TableName tname = TableName.valueOf("testTableDeletion");
        this.createTestTable(tname);
        TestAccessController.grantOnTable(TEST_UTIL, TABLE_ADMIN.getShortName(), tname, null, null, Permission.Action.ADMIN);
        SecureTestUtil.AccessTestAction deleteTableAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Connection unmanagedConnection = ConnectionFactory.createConnection(TEST_UTIL.getConfiguration());
                Admin admin = unmanagedConnection.getAdmin();
                try {
                    SecureTestUtil.deleteTable(TEST_UTIL, admin, tname);
                }
                finally {
                    admin.close();
                    unmanagedConnection.close();
                }
                return null;
            }
        };
        TestAccessController.verifyDenied(deleteTableAction, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
        TestAccessController.verifyAllowed(deleteTableAction, TABLE_ADMIN);
    }

    private void createTestTable(TableName tname) throws Exception {
        HTableDescriptor htd = new HTableDescriptor(tname);
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY);
        hcd.setMaxVersions(100);
        htd.addFamily(hcd);
        htd.setOwner(USER_OWNER);
        TEST_UTIL.createTable(htd, (byte[][])new byte[][]{Bytes.toBytes("s")});
    }

    @Test
    public void testNamespaceUserGrant() throws Exception {
        SecureTestUtil.AccessTestAction getAction = new SecureTestUtil.AccessTestAction(){

            /*
             * Exception decompiling
             */
            @Override
            public Object run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        String namespace = TEST_TABLE.getNamespaceAsString();
        TestAccessController.grantOnNamespace(TEST_UTIL, USER_NONE.getShortName(), namespace, Permission.Action.READ);
        TestAccessController.verifyAllowed(getAction, USER_NONE);
        TestAccessController.revokeFromNamespace(TEST_UTIL, USER_NONE.getShortName(), namespace, Permission.Action.READ);
        TestAccessController.verifyDenied(getAction, USER_NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccessControlClientGrantRevoke() throws Exception {
        User testGrantRevoke = User.createUserForTesting(conf, "testGrantRevoke", new String[0]);
        SecureTestUtil.AccessTestAction getAction = new SecureTestUtil.AccessTestAction(){

            /*
             * Exception decompiling
             */
            @Override
            public Object run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        TestAccessController.verifyDenied(getAction, testGrantRevoke);
        String userName = testGrantRevoke.getShortName();
        try {
            TestAccessController.grantOnTableUsingAccessControlClient(TEST_UTIL, systemUserConnection, userName, TEST_TABLE, null, null, Permission.Action.READ);
        }
        catch (Throwable e) {
            LOG.error((Object)"error during call of AccessControlClient.grant. ", e);
        }
        try {
            TestAccessController.verifyAllowed(getAction, testGrantRevoke);
            try {
                TestAccessController.revokeFromTableUsingAccessControlClient(TEST_UTIL, systemUserConnection, userName, TEST_TABLE, null, null, Permission.Action.READ);
            }
            catch (Throwable e) {
                LOG.error((Object)"error during call of AccessControlClient.revoke ", e);
            }
            TestAccessController.verifyDenied(getAction, testGrantRevoke);
        }
        catch (Throwable throwable) {
            TestAccessController.revokeGlobal(TEST_UTIL, userName, Permission.Action.READ);
            throw throwable;
        }
        TestAccessController.revokeGlobal(TEST_UTIL, userName, Permission.Action.READ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccessControlClientGlobalGrantRevoke() throws Exception {
        User testGlobalGrantRevoke = User.createUserForTesting(conf, "testGlobalGrantRevoke", new String[0]);
        SecureTestUtil.AccessTestAction getAction = new SecureTestUtil.AccessTestAction(){

            /*
             * Exception decompiling
             */
            @Override
            public Object run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        TestAccessController.verifyDenied(getAction, testGlobalGrantRevoke);
        String userName = testGlobalGrantRevoke.getShortName();
        try {
            TestAccessController.grantGlobalUsingAccessControlClient(TEST_UTIL, systemUserConnection, userName, Permission.Action.READ);
        }
        catch (Throwable e) {
            LOG.error((Object)"error during call of AccessControlClient.grant. ", e);
        }
        try {
            TestAccessController.verifyAllowed(getAction, testGlobalGrantRevoke);
            try {
                TestAccessController.revokeGlobalUsingAccessControlClient(TEST_UTIL, systemUserConnection, userName, Permission.Action.READ);
            }
            catch (Throwable e) {
                LOG.error((Object)"error during call of AccessControlClient.revoke ", e);
            }
            TestAccessController.verifyDenied(getAction, testGlobalGrantRevoke);
        }
        catch (Throwable throwable) {
            TestAccessController.revokeGlobal(TEST_UTIL, userName, Permission.Action.READ);
            throw throwable;
        }
        TestAccessController.revokeGlobal(TEST_UTIL, userName, Permission.Action.READ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccessControlClientGrantRevokeOnNamespace() throws Exception {
        User testNS = User.createUserForTesting(conf, "testNS", new String[0]);
        SecureTestUtil.AccessTestAction getAction = new SecureTestUtil.AccessTestAction(){

            /*
             * Exception decompiling
             */
            @Override
            public Object run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        TestAccessController.verifyDenied(getAction, testNS);
        String userName = testNS.getShortName();
        String namespace = TEST_TABLE.getNamespaceAsString();
        try {
            TestAccessController.grantOnNamespaceUsingAccessControlClient(TEST_UTIL, systemUserConnection, userName, namespace, Permission.Action.READ);
        }
        catch (Throwable e) {
            LOG.error((Object)"error during call of AccessControlClient.grant. ", e);
        }
        try {
            TestAccessController.verifyAllowed(getAction, testNS);
            try {
                TestAccessController.revokeFromNamespaceUsingAccessControlClient(TEST_UTIL, systemUserConnection, userName, namespace, Permission.Action.READ);
            }
            catch (Throwable e) {
                LOG.error((Object)"error during call of AccessControlClient.revoke ", e);
            }
            TestAccessController.verifyDenied(getAction, testNS);
        }
        catch (Throwable throwable) {
            TestAccessController.revokeFromNamespace(TEST_UTIL, userName, namespace, Permission.Action.READ);
            throw throwable;
        }
        TestAccessController.revokeFromNamespace(TEST_UTIL, userName, namespace, Permission.Action.READ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoprocessorExec() throws Exception {
        for (JVMClusterUtil.RegionServerThread thread : TEST_UTIL.getMiniHBaseCluster().getRegionServerThreads()) {
            HRegionServer rs = thread.getRegionServer();
            for (Region region : rs.getOnlineRegions(TEST_TABLE)) {
                region.getCoprocessorHost().load(PingCoprocessor.class, 0x3FFFFFFF, conf);
            }
        }
        User userA = User.createUserForTesting(conf, "UserA", new String[0]);
        User userB = User.createUserForTesting(conf, "UserB", new String[0]);
        TestAccessController.grantOnTable(TEST_UTIL, userA.getShortName(), TEST_TABLE, null, null, Permission.Action.EXEC);
        try {
            SecureTestUtil.AccessTestAction execEndpointAction = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    try (Connection conn = ConnectionFactory.createConnection(conf);
                         Table t = conn.getTable(TEST_TABLE);){
                        CoprocessorRpcChannel service = t.coprocessorService(HConstants.EMPTY_BYTE_ARRAY);
                        PingCoprocessor.newBlockingStub(service).noop(null, PingProtos.NoopRequest.newBuilder().build());
                    }
                    return null;
                }
            };
            String namespace = TEST_TABLE.getNamespaceAsString();
            TestAccessController.grantOnNamespace(TEST_UTIL, userB.getShortName(), namespace, Permission.Action.EXEC);
            TestAccessController.verifyAllowed(execEndpointAction, userA, userB);
            TestAccessController.revokeFromNamespace(TEST_UTIL, userB.getShortName(), namespace, Permission.Action.EXEC);
            TestAccessController.verifyDenied(execEndpointAction, userB);
            TestAccessController.verifyAllowed(execEndpointAction, userA);
        }
        catch (Throwable throwable) {
            TestAccessController.revokeFromTable(TEST_UTIL, userA.getShortName(), TEST_TABLE, null, null, Permission.Action.EXEC);
            throw throwable;
        }
        TestAccessController.revokeFromTable(TEST_UTIL, userA.getShortName(), TEST_TABLE, null, null, Permission.Action.EXEC);
    }

    @Test
    public void testGetNamespacePermission() throws Exception {
        String namespace = "testGetNamespacePermission";
        NamespaceDescriptor desc = NamespaceDescriptor.create(namespace).build();
        TestAccessController.createNamespace(TEST_UTIL, desc);
        TestAccessController.grantOnNamespace(TEST_UTIL, USER_NONE.getShortName(), namespace, Permission.Action.READ);
        try {
            List<UserPermission> namespacePermissions = AccessControlClient.getUserPermissions(systemUserConnection, AccessControlLists.toNamespaceEntry(namespace));
            Assert.assertTrue((namespacePermissions != null ? 1 : 0) != 0);
            Assert.assertTrue((namespacePermissions.size() == 1 ? 1 : 0) != 0);
        }
        catch (Throwable thw) {
            throw new HBaseException(thw);
        }
        TestAccessController.deleteNamespace(TEST_UTIL, namespace);
    }

    @Test
    public void testTruncatePerms() throws Throwable {
        List<UserPermission> existingPerms = AccessControlClient.getUserPermissions(systemUserConnection, TEST_TABLE.getNameAsString());
        Assert.assertTrue((existingPerms != null ? 1 : 0) != 0);
        Assert.assertTrue((existingPerms.size() > 1 ? 1 : 0) != 0);
        try (Admin admin = systemUserConnection.getAdmin();){
            admin.disableTable(TEST_TABLE);
            admin.truncateTable(TEST_TABLE, true);
        }
        List<UserPermission> perms = AccessControlClient.getUserPermissions(systemUserConnection, TEST_TABLE.getNameAsString());
        Assert.assertTrue((perms != null ? 1 : 0) != 0);
        Assert.assertEquals((long)existingPerms.size(), (long)perms.size());
    }

    private PrivilegedAction<List<UserPermission>> getPrivilegedAction(final String regex) {
        return new PrivilegedAction<List<UserPermission>>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<UserPermission> run() {
                try (Connection conn = ConnectionFactory.createConnection(conf);){
                    List<UserPermission> list = AccessControlClient.getUserPermissions(conn, regex);
                    return list;
                }
                catch (Throwable e) {
                    LOG.error((Object)"error during call of AccessControlClient.getUserPermissions.", e);
                    return null;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccessControlClientUserPerms() throws Exception {
        TableName tname = TableName.valueOf("testAccessControlClientUserPerms");
        this.createTestTable(tname);
        try {
            String regex = tname.getNameWithNamespaceInclAsString();
            User testUserPerms = User.createUserForTesting(conf, "testUserPerms", new String[0]);
            Assert.assertEquals((long)0L, (long)testUserPerms.runAs(this.getPrivilegedAction(regex)).size());
            TestAccessController.grantOnTable(TEST_UTIL, testUserPerms.getShortName(), tname, null, null, Permission.Action.ADMIN);
            List<UserPermission> perms = testUserPerms.runAs(this.getPrivilegedAction(regex));
            Assert.assertNotNull(perms);
            Assert.assertEquals((long)2L, (long)perms.size());
        }
        finally {
            TestAccessController.deleteTable(TEST_UTIL, tname);
        }
    }

    @Test
    public void testAccessControllerUserPermsRegexHandling() throws Exception {
        User testRegexHandler = User.createUserForTesting(conf, "testRegexHandling", new String[0]);
        String REGEX_ALL_TABLES = ".*";
        String tableName = "testRegex";
        TableName table1 = TableName.valueOf("testRegex");
        byte[] family = Bytes.toBytes("f1");
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor htd = new HTableDescriptor(table1);
        htd.addFamily(new HColumnDescriptor(family));
        TestAccessController.createTable(TEST_UTIL, htd);
        String ns = "testNamespace";
        NamespaceDescriptor desc = NamespaceDescriptor.create(ns).build();
        TableName table2 = TableName.valueOf(ns, "testRegex");
        TestAccessController.createNamespace(TEST_UTIL, desc);
        htd = new HTableDescriptor(table2);
        htd.addFamily(new HColumnDescriptor(family));
        TestAccessController.createTable(TEST_UTIL, htd);
        String aclTableName = AccessControlLists.ACL_TABLE_NAME.getNameAsString();
        Assert.assertEquals((long)5L, (long)SUPERUSER.runAs(this.getPrivilegedAction(aclTableName)).size());
        Assert.assertEquals((long)0L, (long)testRegexHandler.runAs(this.getPrivilegedAction(aclTableName)).size());
        Assert.assertEquals((long)0L, (long)testRegexHandler.runAs(this.getPrivilegedAction(".*")).size());
        TestAccessController.grantOnTable(TEST_UTIL, testRegexHandler.getShortName(), table1, null, null, Permission.Action.ADMIN);
        Assert.assertEquals((long)2L, (long)testRegexHandler.runAs(this.getPrivilegedAction(".*")).size());
        TestAccessController.grantOnTable(TEST_UTIL, testRegexHandler.getShortName(), table2, null, null, Permission.Action.ADMIN);
        Assert.assertEquals((long)4L, (long)testRegexHandler.runAs(this.getPrivilegedAction(".*")).size());
        Assert.assertEquals((long)2L, (long)testRegexHandler.runAs(this.getPrivilegedAction("testRegex")).size());
        Assert.assertEquals((long)2L, (long)testRegexHandler.runAs(this.getPrivilegedAction(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR + ':' + "testRegex")).size());
        Assert.assertEquals((long)2L, (long)testRegexHandler.runAs(this.getPrivilegedAction(ns + ':' + "testRegex")).size());
        Assert.assertEquals((long)0L, (long)testRegexHandler.runAs(this.getPrivilegedAction("notMatchingAny")).size());
        TestAccessController.deleteTable(TEST_UTIL, table1);
        TestAccessController.deleteTable(TEST_UTIL, table2);
        TestAccessController.deleteNamespace(TEST_UTIL, ns);
    }

    private void verifyAnyCreate(SecureTestUtil.AccessTestAction action) throws Exception {
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_ADMIN_CF, USER_GROUP_CREATE);
        TestAccessController.verifyDenied(action, USER_NONE, USER_RO, USER_RW, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_ADMIN);
    }

    @Test
    public void testPrepareAndCleanBulkLoad() throws Exception {
        SecureTestUtil.AccessTestAction prepareBulkLoadAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.prePrepareBulkLoad(ObserverContext.createAndPrepare(RCP_ENV, null), null);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction cleanupBulkLoadAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preCleanupBulkLoad(ObserverContext.createAndPrepare(RCP_ENV, null), null);
                return null;
            }
        };
        this.verifyAnyCreate(prepareBulkLoadAction);
        this.verifyAnyCreate(cleanupBulkLoadAction);
    }

    @Test
    public void testReplicateLogEntries() throws Exception {
        SecureTestUtil.AccessTestAction replicateLogEntriesAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preReplicateLogEntries(ObserverContext.createAndPrepare(RSCP_ENV, null), null, null);
                ACCESS_CONTROLLER.postReplicateLogEntries(ObserverContext.createAndPrepare(RSCP_ENV, null), null, null);
                return null;
            }
        };
        TestAccessController.verifyAllowed(replicateLogEntriesAction, SUPERUSER, USER_ADMIN, USER_GROUP_WRITE);
        TestAccessController.verifyDenied(replicateLogEntriesAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER, USER_GROUP_READ, USER_GROUP_ADMIN, USER_GROUP_CREATE);
    }

    @Test
    public void testSetQuota() throws Exception {
        SecureTestUtil.AccessTestAction setUserQuotaAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSetUserQuota(ObserverContext.createAndPrepare(CP_ENV, null), null, null);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction setUserTableQuotaAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSetUserQuota(ObserverContext.createAndPrepare(CP_ENV, null), null, TEST_TABLE, null);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction setUserNamespaceQuotaAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSetUserQuota(ObserverContext.createAndPrepare(CP_ENV, null), null, (String)null, null);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction setTableQuotaAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSetTableQuota(ObserverContext.createAndPrepare(CP_ENV, null), TEST_TABLE, null);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction setNamespaceQuotaAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSetNamespaceQuota(ObserverContext.createAndPrepare(CP_ENV, null), null, null);
                return null;
            }
        };
        TestAccessController.verifyAllowed(setUserQuotaAction, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(setUserQuotaAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
        TestAccessController.verifyAllowed(setUserTableQuotaAction, SUPERUSER, USER_ADMIN, USER_OWNER);
        TestAccessController.verifyDenied(setUserTableQuotaAction, USER_CREATE, USER_RW, USER_RO, USER_NONE);
        TestAccessController.verifyAllowed(setUserNamespaceQuotaAction, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(setUserNamespaceQuotaAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
        TestAccessController.verifyAllowed(setTableQuotaAction, SUPERUSER, USER_ADMIN, USER_OWNER);
        TestAccessController.verifyDenied(setTableQuotaAction, USER_CREATE, USER_RW, USER_RO, USER_NONE);
        TestAccessController.verifyAllowed(setNamespaceQuotaAction, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(setNamespaceQuotaAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
    }

    static {
        Logger.getLogger(AccessController.class).setLevel(Level.TRACE);
        Logger.getLogger(AccessControlFilter.class).setLevel(Level.TRACE);
        Logger.getLogger(TableAuthManager.class).setLevel(Level.TRACE);
        TEST_TABLE = TableName.valueOf("testtable1");
        TEST_UTIL = new HBaseTestingUtility();
        TEST_TABLE2 = TableName.valueOf("testtable2");
        TEST_FAMILY = Bytes.toBytes("f1");
        TEST_QUALIFIER = Bytes.toBytes("q1");
        TEST_ROW = Bytes.toBytes("r1");
    }

    public static class PingCoprocessor
    extends PingProtos.PingService
    implements Coprocessor,
    CoprocessorService {
        @Override
        public void start(CoprocessorEnvironment env) throws IOException {
        }

        @Override
        public void stop(CoprocessorEnvironment env) throws IOException {
        }

        @Override
        public Service getService() {
            return this;
        }

        @Override
        public void ping(RpcController controller, PingProtos.PingRequest request, RpcCallback<PingProtos.PingResponse> callback) {
            callback.run((Object)PingProtos.PingResponse.newBuilder().setPong("Pong!").build());
        }

        @Override
        public void count(RpcController controller, PingProtos.CountRequest request, RpcCallback<PingProtos.CountResponse> callback) {
            callback.run((Object)PingProtos.CountResponse.newBuilder().build());
        }

        @Override
        public void increment(RpcController controller, PingProtos.IncrementCountRequest requet, RpcCallback<PingProtos.IncrementCountResponse> callback) {
            callback.run((Object)PingProtos.IncrementCountResponse.newBuilder().build());
        }

        @Override
        public void hello(RpcController controller, PingProtos.HelloRequest request, RpcCallback<PingProtos.HelloResponse> callback) {
            callback.run((Object)PingProtos.HelloResponse.newBuilder().setResponse("Hello!").build());
        }

        @Override
        public void noop(RpcController controller, PingProtos.NoopRequest request, RpcCallback<PingProtos.NoopResponse> callback) {
            callback.run((Object)PingProtos.NoopResponse.newBuilder().build());
        }
    }

    public class BulkLoadHelper {
        private final FileSystem fs = TestAccessController.access$1000().getTestFileSystem();
        private final Path loadPath;
        private final Configuration conf = TestAccessController.access$1000().getConfiguration();

        public BulkLoadHelper(Path loadPath) throws IOException {
            this.loadPath = loadPath = loadPath.makeQualified(this.fs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createHFile(Path path, byte[] family, byte[] qualifier, byte[] startKey, byte[] endKey, int numRows) throws IOException {
            long now = System.currentTimeMillis();
            try (Closeable writer = null;){
                HFileContext context = new HFileContextBuilder().build();
                writer = HFile.getWriterFactory(this.conf, new CacheConfig(this.conf)).withPath(this.fs, path).withFileContext(context).create();
                for (byte[] key : Bytes.iterateOnSplits(startKey, endKey, true, numRows - 2)) {
                    KeyValue kv = new KeyValue(key, family, qualifier, now, key);
                    writer.append(kv);
                }
            }
        }

        private void bulkLoadHFile(TableName tableName, byte[] family, byte[] qualifier, byte[][][] hfileRanges, int numRowsPerRange) throws Exception {
            Path familyDir = new Path(this.loadPath, Bytes.toString(family));
            this.fs.mkdirs(familyDir);
            int hfileIdx = 0;
            for (byte[][] range : hfileRanges) {
                byte[] from = range[0];
                byte[] to = range[1];
                this.createHFile(new Path(familyDir, "hfile_" + hfileIdx++), family, qualifier, from, to, numRowsPerRange);
            }
            this.setPermission(this.loadPath, FsPermission.valueOf((String)"-rwxrwxrwx"));
            try (Connection conn = ConnectionFactory.createConnection(this.conf);
                 HTable table = (HTable)conn.getTable(tableName);){
                TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
                LoadIncrementalHFiles loader = new LoadIncrementalHFiles(this.conf);
                loader.doBulkLoad(this.loadPath, table);
            }
        }

        public void setPermission(Path dir, FsPermission perm) throws IOException {
            if (!this.fs.getFileStatus(dir).isDirectory()) {
                this.fs.setPermission(dir, perm);
            } else {
                for (FileStatus el : this.fs.listStatus(dir)) {
                    this.fs.setPermission(el.getPath(), perm);
                    this.setPermission(el.getPath(), perm);
                }
            }
        }
    }

    public static class TestTableDDLProcedure
    extends Procedure<MasterProcedureEnv>
    implements TableProcedureInterface {
        private TableName tableName;

        public TestTableDDLProcedure() {
        }

        public TestTableDDLProcedure(MasterProcedureEnv env, TableName tableName) throws IOException {
            this.tableName = tableName;
            this.setTimeout(180000);
            this.setOwner(env.getRequestUser().getUGI().getShortUserName());
        }

        @Override
        public TableName getTableName() {
            return this.tableName;
        }

        @Override
        public TableProcedureInterface.TableOperationType getTableOperationType() {
            return null;
        }

        @Override
        protected boolean abort(MasterProcedureEnv env) {
            return true;
        }

        @Override
        protected void serializeStateData(OutputStream stream) throws IOException {
            TestProcedureProtos.TestTableDDLStateData.Builder testTableDDLMsg = TestProcedureProtos.TestTableDDLStateData.newBuilder().setTableName(this.tableName.getNameAsString());
            testTableDDLMsg.build().writeDelimitedTo(stream);
        }

        @Override
        protected void deserializeStateData(InputStream stream) throws IOException {
            TestProcedureProtos.TestTableDDLStateData testTableDDLMsg = TestProcedureProtos.TestTableDDLStateData.parseDelimitedFrom(stream);
            this.tableName = TableName.valueOf(testTableDDLMsg.getTableName());
        }

        @Override
        protected Procedure[] execute(MasterProcedureEnv env) {
            this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
            return null;
        }

        @Override
        protected void rollback(MasterProcedureEnv env) {
        }
    }
}

