/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import drill.shaded.hbase.guava.com.google.common.base.Strings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.SaslClient;
import org.apache.hadoop.hbase.security.AuthMethod;
import org.apache.hadoop.hbase.security.HBaseSaslRpcClient;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestHBaseSaslRpcClient {
    static final String DEFAULT_USER_NAME = "principal";
    static final String DEFAULT_USER_PASSWORD = "password";
    private static final Logger LOG;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @BeforeClass
    public static void before() {
        Logger.getRootLogger().setLevel(Level.DEBUG);
    }

    @Test
    public void testSaslQOPNotEmpty() throws Exception {
        Token<? extends TokenIdentifier> token = this.createTokenMockWithCredentials(DEFAULT_USER_NAME, DEFAULT_USER_PASSWORD);
        new HBaseSaslRpcClient(AuthMethod.DIGEST, token, "principal/host@DOMAIN.COM", false);
        Assert.assertTrue((boolean)SaslUtil.SASL_PROPS.get("javax.security.sasl.qop").equals(SaslUtil.QualityOfProtection.AUTHENTICATION.getSaslQop()));
        new HBaseSaslRpcClient(AuthMethod.DIGEST, token, "principal/host@DOMAIN.COM", false, "authentication");
        Assert.assertTrue((boolean)SaslUtil.SASL_PROPS.get("javax.security.sasl.qop").equals(SaslUtil.QualityOfProtection.AUTHENTICATION.getSaslQop()));
        new HBaseSaslRpcClient(AuthMethod.DIGEST, token, "principal/host@DOMAIN.COM", false, "privacy");
        Assert.assertTrue((boolean)SaslUtil.SASL_PROPS.get("javax.security.sasl.qop").equals(SaslUtil.QualityOfProtection.PRIVACY.getSaslQop()));
        new HBaseSaslRpcClient(AuthMethod.DIGEST, token, "principal/host@DOMAIN.COM", false, "integrity");
        Assert.assertTrue((boolean)SaslUtil.SASL_PROPS.get("javax.security.sasl.qop").equals(SaslUtil.QualityOfProtection.INTEGRITY.getSaslQop()));
        this.exception.expect(IllegalArgumentException.class);
        new HBaseSaslRpcClient(AuthMethod.DIGEST, token, "principal/host@DOMAIN.COM", false, "wrongvalue");
    }

    @Test
    public void testSaslClientCallbackHandler() throws UnsupportedCallbackException {
        Token<? extends TokenIdentifier> token = this.createTokenMock();
        Mockito.when((Object)token.getIdentifier()).thenReturn((Object)DEFAULT_USER_NAME.getBytes());
        Mockito.when((Object)token.getPassword()).thenReturn((Object)DEFAULT_USER_PASSWORD.getBytes());
        NameCallback nameCallback = (NameCallback)Mockito.mock(NameCallback.class);
        PasswordCallback passwordCallback = (PasswordCallback)Mockito.mock(PasswordCallback.class);
        RealmCallback realmCallback = (RealmCallback)Mockito.mock(RealmCallback.class);
        RealmChoiceCallback realmChoiceCallback = (RealmChoiceCallback)Mockito.mock(RealmChoiceCallback.class);
        Callback[] callbackArray = new Callback[]{nameCallback, passwordCallback, realmCallback, realmChoiceCallback};
        HBaseSaslRpcClient.SaslClientCallbackHandler saslClCallbackHandler = new HBaseSaslRpcClient.SaslClientCallbackHandler(token);
        saslClCallbackHandler.handle(callbackArray);
        ((NameCallback)Mockito.verify((Object)nameCallback)).setName(Matchers.anyString());
        ((RealmCallback)Mockito.verify((Object)realmCallback)).setText(Matchers.anyString());
        ((PasswordCallback)Mockito.verify((Object)passwordCallback)).setPassword((char[])Matchers.any(char[].class));
    }

    @Test
    public void testSaslClientCallbackHandlerWithException() {
        Token<? extends TokenIdentifier> token = this.createTokenMock();
        Mockito.when((Object)token.getIdentifier()).thenReturn((Object)DEFAULT_USER_NAME.getBytes());
        Mockito.when((Object)token.getPassword()).thenReturn((Object)DEFAULT_USER_PASSWORD.getBytes());
        HBaseSaslRpcClient.SaslClientCallbackHandler saslClCallbackHandler = new HBaseSaslRpcClient.SaslClientCallbackHandler(token);
        try {
            saslClCallbackHandler.handle(new Callback[]{(Callback)Mockito.mock(TextOutputCallback.class)});
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
        }
        catch (Exception ex) {
            Assert.fail((String)("testSaslClientCallbackHandlerWithException error : " + ex.getMessage()));
        }
    }

    @Test
    public void testHBaseSaslRpcClientCreation() throws Exception {
        Assert.assertFalse((boolean)this.assertSuccessCreationKerberosPrincipal(null));
        Assert.assertFalse((boolean)this.assertSuccessCreationKerberosPrincipal("DOMAIN.COM"));
        Assert.assertFalse((boolean)this.assertSuccessCreationKerberosPrincipal("principal/DOMAIN.COM"));
        if (!this.assertSuccessCreationKerberosPrincipal("principal/localhost@DOMAIN.COM")) {
            LOG.warn((Object)"Could not create a SASL client with valid Kerberos credential");
        }
        Assert.assertFalse((boolean)this.assertSuccessCreationDigestPrincipal(null, null));
        Assert.assertFalse((boolean)this.assertSuccessCreationDigestPrincipal("", ""));
        Assert.assertFalse((boolean)this.assertSuccessCreationDigestPrincipal("", null));
        Assert.assertFalse((boolean)this.assertSuccessCreationDigestPrincipal(null, ""));
        Assert.assertTrue((boolean)this.assertSuccessCreationDigestPrincipal(DEFAULT_USER_NAME, DEFAULT_USER_PASSWORD));
        Assert.assertFalse((boolean)this.assertSuccessCreationSimplePrincipal("", ""));
        Assert.assertFalse((boolean)this.assertSuccessCreationSimplePrincipal(null, null));
        Assert.assertFalse((boolean)this.assertSuccessCreationSimplePrincipal(DEFAULT_USER_NAME, DEFAULT_USER_PASSWORD));
        Assert.assertTrue((boolean)this.assertIOExceptionThenSaslClientIsNull(DEFAULT_USER_NAME, DEFAULT_USER_PASSWORD));
        Assert.assertTrue((boolean)this.assertIOExceptionWhenGetStreamsBeforeConnectCall(DEFAULT_USER_NAME, DEFAULT_USER_PASSWORD));
    }

    @Test
    public void testAuthMethodReadWrite() throws IOException {
        DataInputBuffer in = new DataInputBuffer();
        DataOutputBuffer out = new DataOutputBuffer();
        this.assertAuthMethodRead(in, AuthMethod.SIMPLE);
        this.assertAuthMethodRead(in, AuthMethod.KERBEROS);
        this.assertAuthMethodRead(in, AuthMethod.DIGEST);
        this.assertAuthMethodWrite(out, AuthMethod.SIMPLE);
        this.assertAuthMethodWrite(out, AuthMethod.KERBEROS);
        this.assertAuthMethodWrite(out, AuthMethod.DIGEST);
    }

    private void assertAuthMethodRead(DataInputBuffer in, AuthMethod authMethod) throws IOException {
        in.reset(new byte[]{authMethod.code}, 1);
        Assert.assertEquals((Object)((Object)authMethod), (Object)((Object)AuthMethod.read((DataInput)in)));
    }

    private void assertAuthMethodWrite(DataOutputBuffer out, AuthMethod authMethod) throws IOException {
        authMethod.write((DataOutput)out);
        Assert.assertEquals((long)authMethod.code, (long)out.getData()[0]);
        out.reset();
    }

    private boolean assertIOExceptionWhenGetStreamsBeforeConnectCall(String principal, String password) throws IOException {
        boolean inState = false;
        boolean outState = false;
        HBaseSaslRpcClient rpcClient = new HBaseSaslRpcClient(AuthMethod.DIGEST, this.createTokenMockWithCredentials(principal, password), principal, false){

            @Override
            public SaslClient createDigestSaslClient(String[] mechanismNames, String saslDefaultRealm, CallbackHandler saslClientCallbackHandler) throws IOException {
                return (SaslClient)Mockito.mock(SaslClient.class);
            }

            @Override
            public SaslClient createKerberosSaslClient(String[] mechanismNames, String userFirstPart, String userSecondPart) throws IOException {
                return (SaslClient)Mockito.mock(SaslClient.class);
            }
        };
        try {
            rpcClient.getInputStream((InputStream)Mockito.mock(InputStream.class));
        }
        catch (IOException ex) {
            inState = true;
        }
        try {
            rpcClient.getOutputStream((OutputStream)Mockito.mock(OutputStream.class));
        }
        catch (IOException ex) {
            outState = true;
        }
        return inState && outState;
    }

    private boolean assertIOExceptionThenSaslClientIsNull(String principal, String password) {
        try {
            new HBaseSaslRpcClient(AuthMethod.DIGEST, this.createTokenMockWithCredentials(principal, password), principal, false){

                @Override
                public SaslClient createDigestSaslClient(String[] mechanismNames, String saslDefaultRealm, CallbackHandler saslClientCallbackHandler) throws IOException {
                    return null;
                }

                @Override
                public SaslClient createKerberosSaslClient(String[] mechanismNames, String userFirstPart, String userSecondPart) throws IOException {
                    return null;
                }
            };
            return false;
        }
        catch (IOException ex) {
            return true;
        }
    }

    private boolean assertSuccessCreationKerberosPrincipal(String principal) {
        HBaseSaslRpcClient rpcClient = null;
        try {
            rpcClient = this.createSaslRpcClientForKerberos(principal);
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return rpcClient != null;
    }

    private boolean assertSuccessCreationDigestPrincipal(String principal, String password) {
        HBaseSaslRpcClient rpcClient = null;
        try {
            rpcClient = new HBaseSaslRpcClient(AuthMethod.DIGEST, this.createTokenMockWithCredentials(principal, password), principal, false);
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return rpcClient != null;
    }

    private boolean assertSuccessCreationSimplePrincipal(String principal, String password) {
        HBaseSaslRpcClient rpcClient = null;
        try {
            rpcClient = this.createSaslRpcClientSimple(principal, password);
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return rpcClient != null;
    }

    private HBaseSaslRpcClient createSaslRpcClientForKerberos(String principal) throws IOException {
        return new HBaseSaslRpcClient(AuthMethod.KERBEROS, this.createTokenMock(), principal, false);
    }

    private Token<? extends TokenIdentifier> createTokenMockWithCredentials(String principal, String password) throws IOException {
        Token<? extends TokenIdentifier> token = this.createTokenMock();
        if (!Strings.isNullOrEmpty(principal) && !Strings.isNullOrEmpty(password)) {
            Mockito.when((Object)token.getIdentifier()).thenReturn((Object)DEFAULT_USER_NAME.getBytes());
            Mockito.when((Object)token.getPassword()).thenReturn((Object)DEFAULT_USER_PASSWORD.getBytes());
        }
        return token;
    }

    private HBaseSaslRpcClient createSaslRpcClientSimple(String principal, String password) throws IOException {
        return new HBaseSaslRpcClient(AuthMethod.SIMPLE, this.createTokenMock(), principal, false);
    }

    private Token<? extends TokenIdentifier> createTokenMock() {
        return (Token)Mockito.mock(Token.class);
    }

    static {
        System.setProperty("java.security.krb5.realm", "DOMAIN.COM");
        System.setProperty("java.security.krb5.kdc", "DOMAIN.COM");
        LOG = Logger.getLogger(TestHBaseSaslRpcClient.class);
    }
}

