/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import drill.shaded.hbase.guava.com.google.common.util.concurrent.AbstractService;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.replication.ChainWALEntryFilter;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ScopeWALEntryFilter;
import org.apache.hadoop.hbase.replication.TableCfWALEntryFilter;
import org.apache.hadoop.hbase.replication.WALEntryFilter;

@InterfaceAudience.LimitedPrivate(value={"Replication"})
public abstract class BaseReplicationEndpoint
extends AbstractService
implements ReplicationEndpoint {
    protected ReplicationEndpoint.Context ctx;

    @Override
    public void init(ReplicationEndpoint.Context context) throws IOException {
        this.ctx = context;
    }

    @Override
    public WALEntryFilter getWALEntryfilter() {
        WALEntryFilter tableCfFilter;
        ArrayList<WALEntryFilter> filters = Lists.newArrayList();
        WALEntryFilter scopeFilter = this.getScopeWALEntryFilter();
        if (scopeFilter != null) {
            filters.add(scopeFilter);
        }
        if ((tableCfFilter = this.getTableCfWALEntryFilter()) != null) {
            filters.add(tableCfFilter);
        }
        return filters.isEmpty() ? null : new ChainWALEntryFilter(filters);
    }

    protected WALEntryFilter getScopeWALEntryFilter() {
        return new ScopeWALEntryFilter();
    }

    protected WALEntryFilter getTableCfWALEntryFilter() {
        return new TableCfWALEntryFilter(this.ctx.getReplicationPeer());
    }

    @Override
    public boolean canReplicateToSameCluster() {
        return false;
    }
}

