/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestRecoveredEdits {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestRecoveredEdits.class);
    @Rule
    public TestName testName = new TestName();

    @Test(timeout=60000L)
    public void testReplayWorksThoughLotsOfFlushing() throws IOException {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setInt("hbase.hregion.memstore.flush.size", 0x100000);
        String encodedRegionName = "4823016d8fca70b25503ee07f4c6d79f";
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(this.testName.getMethodName()));
        String columnFamily = "meta";
        byte[][] columnFamilyAsByteArray = new byte[][]{Bytes.toBytes("meta")};
        htd.addFamily(new HColumnDescriptor("meta"));
        HRegionInfo hri = new HRegionInfo(htd.getTableName()){
            private byte[] encodedRegionNameAsBytes;
            {
                this.encodedRegionNameAsBytes = null;
            }

            @Override
            public synchronized String getEncodedName() {
                return "4823016d8fca70b25503ee07f4c6d79f";
            }

            @Override
            public synchronized byte[] getEncodedNameAsBytes() {
                if (this.encodedRegionNameAsBytes == null) {
                    this.encodedRegionNameAsBytes = Bytes.toBytes(this.getEncodedName());
                }
                return this.encodedRegionNameAsBytes;
            }
        };
        Path hbaseRootDir = TEST_UTIL.getDataTestDir();
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        Path tableDir = FSUtils.getTableDir(hbaseRootDir, htd.getTableName());
        HRegionFileSystem hrfs = new HRegionFileSystem(TEST_UTIL.getConfiguration(), fs, tableDir, hri);
        if (fs.exists(hrfs.getRegionDir())) {
            LOG.info((Object)"Region directory already exists. Deleting.");
            fs.delete(hrfs.getRegionDir(), true);
        }
        HRegion region = HRegion.createHRegion(hri, hbaseRootDir, conf, htd, null);
        Assert.assertEquals((Object)"4823016d8fca70b25503ee07f4c6d79f", (Object)region.getRegionInfo().getEncodedName());
        List<String> storeFiles = region.getStoreFileList(columnFamilyAsByteArray);
        Assert.assertTrue((boolean)storeFiles.isEmpty());
        region.close();
        Path regionDir = HRegion.getRegionDir(hbaseRootDir, hri);
        Path recoveredEditsDir = WALSplitter.getRegionDirRecoveredEditsDir(regionDir);
        Path recoveredEditsFile = new Path(System.getProperty("test.build.classes", "target/test-classes"), "0000000000000016310");
        Path destination = new Path(recoveredEditsDir, recoveredEditsFile.getName());
        fs.copyToLocalFile(recoveredEditsFile, destination);
        Assert.assertTrue((boolean)fs.exists(destination));
        region = HRegion.openHRegion(region, null);
        Assert.assertEquals((Object)"4823016d8fca70b25503ee07f4c6d79f", (Object)region.getRegionInfo().getEncodedName());
        storeFiles = region.getStoreFileList(columnFamilyAsByteArray);
        Assert.assertTrue((String)("Files count=" + storeFiles.size()), (storeFiles.size() > 10 ? 1 : 0) != 0);
        int count = this.verifyAllEditsMadeItIn(fs, conf, recoveredEditsFile, region);
        LOG.info((Object)("Checked " + count + " edits made it in"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int verifyAllEditsMadeItIn(FileSystem fs, Configuration conf, Path edits, HRegion region) throws IOException {
        int count = 0;
        try (WAL.Reader reader = null;){
            WAL.Entry entry;
            reader = WALFactory.createReader(fs, edits, conf);
            while ((entry = reader.next()) != null) {
                WALKey key = entry.getKey();
                WALEdit val = entry.getEdit();
                ++count;
                if (!Bytes.equals(key.getEncodedRegionName(), region.getRegionInfo().getEncodedNameAsBytes())) continue;
                Cell previous = null;
                for (Cell cell : val.getCells()) {
                    if (CellUtil.matchingFamily(cell, WALEdit.METAFAMILY) || previous != null && CellComparator.compareRows(previous, cell) == 0) continue;
                    previous = cell;
                    Get g = new Get(CellUtil.cloneRow(cell));
                    Result r = region.get(g);
                    boolean found = false;
                    CellScanner scanner = r.cellScanner();
                    while (scanner.advance()) {
                        Cell current = scanner.current();
                        if (CellComparator.compare(cell, current, true) != 0) continue;
                        found = true;
                        break;
                    }
                    Assert.assertTrue((String)("Failed to find " + cell), (boolean)found);
                }
            }
        }
        return count;
    }
}

