/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapperStub;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestRSStatusServlet {
    private static final Log LOG = LogFactory.getLog(TestRSStatusServlet.class);
    private HRegionServer rs;
    private RSRpcServices rpcServices;
    static final int FAKE_IPC_PORT = 1585;
    static final int FAKE_WEB_PORT = 1586;
    private final ServerName fakeServerName = ServerName.valueOf("localhost", 1585, 11111L);
    private final AdminProtos.GetServerInfoResponse fakeResponse = ResponseConverter.buildGetServerInfoResponse(this.fakeServerName, 1586);
    private final ServerName fakeMasterAddress = ServerName.valueOf("localhost", 60010, 1212121212L);

    @Before
    public void setupBasicMocks() throws IOException, ServiceException {
        this.rs = (HRegionServer)Mockito.mock(HRegionServer.class);
        this.rpcServices = (RSRpcServices)Mockito.mock(RSRpcServices.class);
        ((HRegionServer)Mockito.doReturn((Object)HBaseConfiguration.create()).when((Object)this.rs)).getConfiguration();
        ((HRegionServer)Mockito.doReturn((Object)this.rpcServices).when((Object)this.rs)).getRSRpcServices();
        ((RSRpcServices)Mockito.doReturn((Object)this.fakeResponse).when((Object)this.rpcServices)).getServerInfo((RpcController)Mockito.any(), (AdminProtos.GetServerInfoRequest)Mockito.any());
        ZooKeeperWatcher zkw = (ZooKeeperWatcher)Mockito.mock(ZooKeeperWatcher.class);
        ((ZooKeeperWatcher)Mockito.doReturn((Object)"fakequorum").when((Object)zkw)).getQuorum();
        ((HRegionServer)Mockito.doReturn((Object)zkw).when((Object)this.rs)).getZooKeeper();
        LOG.warn((Object)"The hfile.block.cache.size is set to 0");
        CacheConfig cacheConf = (CacheConfig)Mockito.mock(CacheConfig.class);
        ((CacheConfig)Mockito.doReturn(null).when((Object)cacheConf)).getBlockCache();
        ((HRegionServer)Mockito.doReturn((Object)cacheConf).when((Object)this.rs)).getCacheConfig();
        MasterAddressTracker mat = (MasterAddressTracker)Mockito.mock(MasterAddressTracker.class);
        ((MasterAddressTracker)Mockito.doReturn((Object)this.fakeMasterAddress).when((Object)mat)).getMasterAddress();
        ((HRegionServer)Mockito.doReturn((Object)mat).when((Object)this.rs)).getMasterAddressTracker();
        MetricsRegionServer rms = (MetricsRegionServer)Mockito.mock(MetricsRegionServer.class);
        ((MetricsRegionServer)Mockito.doReturn((Object)new MetricsRegionServerWrapperStub()).when((Object)rms)).getRegionServerWrapper();
        ((HRegionServer)Mockito.doReturn((Object)rms).when((Object)this.rs)).getRegionServerMetrics();
    }

    @Test
    public void testBasic() throws IOException, ServiceException {
        new RSStatusTmpl().render(new StringWriter(), this.rs);
    }

    @Test
    public void testWithRegions() throws IOException, ServiceException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf("mytable"));
        ArrayList<HRegionInfo> regions = Lists.newArrayList(new HRegionInfo(htd.getTableName(), Bytes.toBytes("a"), Bytes.toBytes("d")), new HRegionInfo(htd.getTableName(), Bytes.toBytes("d"), Bytes.toBytes("z")));
        ((RSRpcServices)Mockito.doReturn((Object)ResponseConverter.buildGetOnlineRegionResponse(regions)).when((Object)this.rpcServices)).getOnlineRegion((RpcController)Mockito.any(), (AdminProtos.GetOnlineRegionRequest)Mockito.any());
        new RSStatusTmpl().render(new StringWriter(), this.rs);
    }
}

