/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestParallelPut {
    static final Log LOG = LogFactory.getLog(TestParallelPut.class);
    @Rule
    public TestName name = new TestName();
    private HRegion region = null;
    private static HBaseTestingUtility HBTU = new HBaseTestingUtility();
    private static final int THREADS100 = 100;
    static byte[] tableName;
    static final byte[] qual1;
    static final byte[] qual2;
    static final byte[] qual3;
    static final byte[] value1;
    static final byte[] value2;
    static final byte[] row;
    static final byte[] row2;

    @BeforeClass
    public static void beforeClass() {
        HBTU.getConfiguration().setInt("hbase.regionserver.handler.count", 100);
    }

    @Before
    public void setUp() throws Exception {
        tableName = Bytes.toBytes(this.name.getMethodName());
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentEdgeManagerTestHelper.reset();
        if (this.region != null) {
            this.region.close(true);
        }
    }

    public String getName() {
        return this.name.getMethodName();
    }

    @Test
    public void testPut() throws IOException {
        LOG.info((Object)"Starting testPut");
        this.region = this.initHRegion(tableName, this.getName(), new byte[][]{HBaseTestingUtility.fam1});
        long value = 1L;
        Put put = new Put(row);
        put.add(HBaseTestingUtility.fam1, qual1, Bytes.toBytes(value));
        this.region.put(put);
        TestParallelPut.assertGet(this.region, row, HBaseTestingUtility.fam1, qual1, Bytes.toBytes(value));
    }

    @Test
    public void testParallelPuts() throws IOException {
        int i;
        LOG.info((Object)"Starting testParallelPuts");
        this.region = this.initHRegion(tableName, this.getName(), new byte[][]{HBaseTestingUtility.fam1});
        int numOps = 1000;
        Putter[] all = new Putter[100];
        for (i = 0; i < 100; ++i) {
            all[i] = new Putter(this.region, i, numOps);
        }
        for (i = 0; i < 100; ++i) {
            all[i].start();
        }
        for (i = 0; i < 100; ++i) {
            try {
                all[i].join();
                continue;
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"testParallelPuts encountered InterruptedException. Ignoring....", (Throwable)e);
            }
        }
        LOG.info((Object)("testParallelPuts successfully verified " + numOps * 100 + " put operations."));
    }

    private static void assertGet(HRegion region, byte[] row, byte[] familiy, byte[] qualifier, byte[] value) throws IOException {
        Get get = new Get(row);
        get.addColumn(familiy, qualifier);
        Result result = region.get(get);
        Assert.assertEquals((long)1L, (long)result.size());
        Cell kv = result.rawCells()[0];
        byte[] r = CellUtil.cloneValue(kv);
        Assert.assertTrue((Bytes.compareTo(r, value) == 0 ? 1 : 0) != 0);
    }

    private HRegion initHRegion(byte[] tableName, String callingMethod, byte[] ... families) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(tableName));
        for (byte[] family : families) {
            htd.addFamily(new HColumnDescriptor(family));
        }
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        return HBTU.createLocalHRegion(info, htd);
    }

    static {
        qual1 = Bytes.toBytes("qual1");
        qual2 = Bytes.toBytes("qual2");
        qual3 = Bytes.toBytes("qual3");
        value1 = Bytes.toBytes("value1");
        value2 = Bytes.toBytes("value2");
        row = Bytes.toBytes("rowA");
        row2 = Bytes.toBytes("rowB");
    }

    public static class Putter
    extends Thread {
        private final HRegion region;
        private final int threadNumber;
        private final int numOps;
        private final Random rand = new Random();
        byte[] rowkey = null;

        public Putter(HRegion region, int threadNumber, int numOps) {
            this.region = region;
            this.threadNumber = threadNumber;
            this.numOps = numOps;
            this.rowkey = Bytes.toBytes((long)threadNumber);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            byte[] value = new byte[100];
            Mutation[] in = new Put[1];
            for (int i = 0; i < this.numOps; ++i) {
                this.rand.nextBytes(value);
                Put put = new Put(this.rowkey);
                put.add(HBaseTestingUtility.fam1, qual1, value);
                in[0] = put;
                try {
                    OperationStatus[] ret = this.region.batchMutate(in);
                    Assert.assertEquals((long)1L, (long)ret.length);
                    Assert.assertEquals((Object)((Object)HConstants.OperationStatusCode.SUCCESS), (Object)((Object)ret[0].getOperationStatusCode()));
                    TestParallelPut.assertGet(this.region, this.rowkey, HBaseTestingUtility.fam1, qual1, value);
                    continue;
                }
                catch (IOException e) {
                    Assert.assertTrue((String)("Thread id " + this.threadNumber + " operation " + i + " failed."), (boolean)false);
                }
            }
        }
    }
}

