/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetricsMasterWrapper;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Private
public class MetricsMasterWrapperImpl
implements MetricsMasterWrapper {
    private final HMaster master;

    public MetricsMasterWrapperImpl(HMaster master) {
        this.master = master;
    }

    @Override
    public double getAverageLoad() {
        return this.master.getAverageLoad();
    }

    @Override
    public String getClusterId() {
        return this.master.getClusterId();
    }

    @Override
    public String getZookeeperQuorum() {
        ZooKeeperWatcher zk = this.master.getZooKeeper();
        if (zk == null) {
            return "";
        }
        return zk.getQuorum();
    }

    @Override
    public String[] getCoprocessors() {
        return this.master.getMasterCoprocessors();
    }

    @Override
    public long getStartTime() {
        return this.master.getMasterStartTime();
    }

    @Override
    public long getActiveTime() {
        return this.master.getMasterActiveTime();
    }

    @Override
    public String getRegionServers() {
        ServerManager serverManager = this.master.getServerManager();
        if (serverManager == null) {
            return "";
        }
        return StringUtils.join(serverManager.getOnlineServers().keySet(), (String)";");
    }

    @Override
    public int getNumRegionServers() {
        ServerManager serverManager = this.master.getServerManager();
        if (serverManager == null) {
            return 0;
        }
        return serverManager.getOnlineServers().size();
    }

    @Override
    public String getDeadRegionServers() {
        ServerManager serverManager = this.master.getServerManager();
        if (serverManager == null) {
            return "";
        }
        return StringUtils.join(serverManager.getDeadServers().copyServerNames(), (String)";");
    }

    @Override
    public int getNumDeadRegionServers() {
        ServerManager serverManager = this.master.getServerManager();
        if (serverManager == null) {
            return 0;
        }
        return serverManager.getDeadServers().size();
    }

    @Override
    public String getServerName() {
        ServerName serverName = this.master.getServerName();
        if (serverName == null) {
            return "";
        }
        return serverName.getServerName();
    }

    @Override
    public boolean getIsActiveMaster() {
        return this.master.isActiveMaster();
    }
}

