/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import drill.shaded.hbase.guava.com.google.common.collect.ImmutableCollection;
import drill.shaded.hbase.guava.com.google.common.collect.ImmutableMap;
import drill.shaded.hbase.guava.com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.HRegionPartitioner;
import org.apache.hadoop.hbase.mapred.TableMap;
import org.apache.hadoop.hbase.mapred.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapred.TableReduce;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestTableMapReduceUtil {
    private static final Log LOG = LogFactory.getLog(TestTableMapReduceUtil.class);
    private static Table presidentsTable;
    private static final String TABLE_NAME = "People";
    private static final byte[] COLUMN_FAMILY;
    private static final byte[] COLUMN_QUALIFIER;
    private static ImmutableSet<String> presidentsRowKeys;
    private static Iterator<String> presidentNames;
    private static ImmutableSet<String> actorsRowKeys;
    private static Iterator<String> actorNames;
    private static String PRESIDENT_PATTERN;
    private static String ACTOR_PATTERN;
    private static ImmutableMap<String, ImmutableSet<String>> relation;
    private static final HBaseTestingUtility UTIL;

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster();
        presidentsTable = TestTableMapReduceUtil.createAndFillTable(TableName.valueOf(TABLE_NAME));
        UTIL.startMiniMapReduceCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniMapReduceCluster();
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws IOException {
        LOG.info((Object)"before");
        UTIL.ensureSomeRegionServersAvailable(1);
        LOG.info((Object)"before done");
    }

    public static Table createAndFillTable(TableName tableName) throws IOException {
        HTable table = UTIL.createTable(tableName, COLUMN_FAMILY);
        TestTableMapReduceUtil.createPutCommand(table);
        return table;
    }

    private static void createPutCommand(Table table) throws IOException {
        Put p;
        for (String president : presidentsRowKeys) {
            if (!presidentNames.hasNext()) continue;
            p = new Put(Bytes.toBytes(president));
            p.add(COLUMN_FAMILY, COLUMN_QUALIFIER, Bytes.toBytes(presidentNames.next()));
            table.put(p);
        }
        for (String actor : actorsRowKeys) {
            if (!actorNames.hasNext()) continue;
            p = new Put(Bytes.toBytes(actor));
            p.add(COLUMN_FAMILY, COLUMN_QUALIFIER, Bytes.toBytes(actorNames.next()));
            table.put(p);
        }
    }

    @Test
    public void shouldNumberOfReduceTaskNotExceedNumberOfRegionsForGivenTable() throws IOException {
        Assert.assertNotNull((Object)presidentsTable);
        Configuration cfg = UTIL.getConfiguration();
        JobConf jobConf = new JobConf(cfg);
        TableMapReduceUtil.setNumReduceTasks(TABLE_NAME, jobConf);
        TableMapReduceUtil.limitNumReduceTasks(TABLE_NAME, jobConf);
        TableMapReduceUtil.setScannerCaching(jobConf, 100);
        Assert.assertEquals((long)1L, (long)jobConf.getNumReduceTasks());
        Assert.assertEquals((long)100L, (long)jobConf.getInt("hbase.client.scanner.caching", 0));
        jobConf.setNumReduceTasks(10);
        TableMapReduceUtil.setNumMapTasks(TABLE_NAME, jobConf);
        TableMapReduceUtil.limitNumReduceTasks(TABLE_NAME, jobConf);
        Assert.assertEquals((long)1L, (long)jobConf.getNumReduceTasks());
    }

    @Test
    public void shouldNumberOfMapTaskNotExceedNumberOfRegionsForGivenTable() throws IOException {
        Configuration cfg = UTIL.getConfiguration();
        JobConf jobConf = new JobConf(cfg);
        TableMapReduceUtil.setNumReduceTasks(TABLE_NAME, jobConf);
        TableMapReduceUtil.limitNumMapTasks(TABLE_NAME, jobConf);
        Assert.assertEquals((long)1L, (long)jobConf.getNumMapTasks());
        jobConf.setNumMapTasks(10);
        TableMapReduceUtil.setNumMapTasks(TABLE_NAME, jobConf);
        TableMapReduceUtil.limitNumMapTasks(TABLE_NAME, jobConf);
        Assert.assertEquals((long)1L, (long)jobConf.getNumMapTasks());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shoudBeValidMapReduceEvaluation() throws Exception {
        Configuration cfg = UTIL.getConfiguration();
        JobConf jobConf = new JobConf(cfg);
        try {
            jobConf.setJobName("process row task");
            jobConf.setNumReduceTasks(1);
            TableMapReduceUtil.initTableMapJob(TABLE_NAME, new String(COLUMN_FAMILY), ClassificatorMapper.class, ImmutableBytesWritable.class, Put.class, jobConf);
            TableMapReduceUtil.initTableReduceJob(TABLE_NAME, ClassificatorRowReduce.class, jobConf);
            RunningJob job = JobClient.runJob((JobConf)jobConf);
            Assert.assertTrue((boolean)job.isSuccessful());
        }
        finally {
            if (jobConf != null) {
                FileUtil.fullyDelete((File)new File(jobConf.get("hadoop.tmp.dir")));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shoudBeValidMapReduceWithPartitionerEvaluation() throws IOException {
        Configuration cfg = UTIL.getConfiguration();
        JobConf jobConf = new JobConf(cfg);
        try {
            jobConf.setJobName("process row task");
            jobConf.setNumReduceTasks(2);
            TableMapReduceUtil.initTableMapJob(TABLE_NAME, new String(COLUMN_FAMILY), ClassificatorMapper.class, ImmutableBytesWritable.class, Put.class, jobConf);
            TableMapReduceUtil.initTableReduceJob(TABLE_NAME, ClassificatorRowReduce.class, jobConf, HRegionPartitioner.class);
            RunningJob job = JobClient.runJob((JobConf)jobConf);
            Assert.assertTrue((boolean)job.isSuccessful());
        }
        finally {
            if (jobConf != null) {
                FileUtil.fullyDelete((File)new File(jobConf.get("hadoop.tmp.dir")));
            }
        }
    }

    static {
        COLUMN_FAMILY = Bytes.toBytes("info");
        COLUMN_QUALIFIER = Bytes.toBytes("name");
        presidentsRowKeys = ImmutableSet.of("president1", "president2", "president3");
        presidentNames = ImmutableSet.of("John F. Kennedy", "George W. Bush", "Barack Obama").iterator();
        actorsRowKeys = ImmutableSet.of("actor1", "actor2");
        actorNames = ImmutableSet.of("Jack Nicholson", "Martin Freeman").iterator();
        PRESIDENT_PATTERN = "president";
        ACTOR_PATTERN = "actor";
        relation = ImmutableMap.of(PRESIDENT_PATTERN, presidentsRowKeys, ACTOR_PATTERN, actorsRowKeys);
        UTIL = new HBaseTestingUtility();
    }

    static class ClassificatorMapper
    extends MapReduceBase
    implements TableMap<ImmutableBytesWritable, Put> {
        ClassificatorMapper() {
        }

        public void map(ImmutableBytesWritable row, Result result, OutputCollector<ImmutableBytesWritable, Put> outCollector, Reporter reporter) throws IOException {
            String rowKey = Bytes.toString(result.getRow());
            ImmutableBytesWritable pKey = new ImmutableBytesWritable(Bytes.toBytes(PRESIDENT_PATTERN));
            ImmutableBytesWritable aKey = new ImmutableBytesWritable(Bytes.toBytes(ACTOR_PATTERN));
            ImmutableBytesWritable outKey = null;
            if (rowKey.startsWith(PRESIDENT_PATTERN)) {
                outKey = pKey;
            } else if (rowKey.startsWith(ACTOR_PATTERN)) {
                outKey = aKey;
            } else {
                throw new AssertionError((Object)"unexpected rowKey");
            }
            String name = Bytes.toString(result.getValue(COLUMN_FAMILY, COLUMN_QUALIFIER));
            outCollector.collect((Object)outKey, (Object)new Put(Bytes.toBytes("rowKey2")).add(COLUMN_FAMILY, COLUMN_QUALIFIER, Bytes.toBytes(name)));
        }
    }

    static class ClassificatorRowReduce
    extends MapReduceBase
    implements TableReduce<ImmutableBytesWritable, Put> {
        ClassificatorRowReduce() {
        }

        public void reduce(ImmutableBytesWritable key, Iterator<Put> values, OutputCollector<ImmutableBytesWritable, Put> output, Reporter reporter) throws IOException {
            String strKey = Bytes.toString(key.get());
            ArrayList<Put> result = new ArrayList<Put>();
            while (values.hasNext()) {
                result.add(values.next());
            }
            if (((ImmutableCollection)((Object)relation.keySet())).contains(strKey)) {
                Set set = (Set)relation.get(strKey);
                if (set != null) {
                    Assert.assertEquals((long)set.size(), (long)result.size());
                } else {
                    this.throwAccertionError("Test infrastructure error: set is null");
                }
            } else {
                this.throwAccertionError("Test infrastructure error: key not found in map");
            }
        }

        private void throwAccertionError(String errorMessage) throws AssertionError {
            throw new AssertionError((Object)errorMessage);
        }
    }
}

