/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.Message;
import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ipc.AbstractTestIPC;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.security.AuthMethod;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RPCTests.class, MediumTests.class})
public class TestRpcServerSlowConnectionSetup {
    private RpcServer server;
    private Socket socket;

    @Before
    public void setUp() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        this.server = new RpcServer(null, "testRpcServer", Lists.newArrayList(new RpcServer.BlockingServiceAndInterface(AbstractTestIPC.SERVICE, null)), new InetSocketAddress("localhost", 0), conf, new FifoRpcScheduler(conf, 1));
        this.server.start();
        this.socket = new Socket("localhost", this.server.getListenerAddress().getPort());
    }

    @After
    public void tearDown() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void test() throws IOException, InterruptedException {
        int rpcHeaderLen = HConstants.RPC_HEADER.length;
        byte[] preamble = new byte[rpcHeaderLen + 2];
        System.arraycopy(HConstants.RPC_HEADER, 0, preamble, 0, rpcHeaderLen);
        preamble[rpcHeaderLen] = 0;
        preamble[rpcHeaderLen + 1] = AuthMethod.SIMPLE.code;
        this.socket.getOutputStream().write(preamble, 0, rpcHeaderLen + 1);
        this.socket.getOutputStream().flush();
        Thread.sleep(5000L);
        this.socket.getOutputStream().write(preamble, rpcHeaderLen + 1, 1);
        this.socket.getOutputStream().flush();
        RPCProtos.ConnectionHeader header = RPCProtos.ConnectionHeader.newBuilder().setServiceName(TestRpcServiceProtos.TestProtobufRpcProto.getDescriptor().getFullName()).setVersionInfo(ProtobufUtil.getVersionInfo()).build();
        DataOutputStream dos = new DataOutputStream(this.socket.getOutputStream());
        dos.writeInt(header.getSerializedSize());
        header.writeTo(dos);
        dos.flush();
        int callId = 10;
        RPCProtos.RequestHeader requestHeader = RPCProtos.RequestHeader.newBuilder().setCallId(callId).setMethodName("ping").setRequestParam(true).build();
        dos.writeInt(IPCUtil.getTotalSizeWhenWrittenDelimited(new Message[]{requestHeader, TestProtos.EmptyRequestProto.getDefaultInstance()}));
        requestHeader.writeDelimitedTo(dos);
        TestProtos.EmptyRequestProto.getDefaultInstance().writeDelimitedTo(dos);
        dos.flush();
        DataInputStream dis = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        int size = dis.readInt();
        RPCProtos.ResponseHeader responseHeader = RPCProtos.ResponseHeader.parseDelimitedFrom(dis);
        Assert.assertEquals((long)callId, (long)responseHeader.getCallId());
        TestProtos.EmptyResponseProto.Builder builder = TestProtos.EmptyResponseProto.newBuilder();
        builder.mergeDelimitedFrom(dis);
        Assert.assertEquals((long)size, (long)IPCUtil.getTotalSizeWhenWrittenDelimited(new Message[]{responseHeader, builder.build()}));
    }
}

