/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import drill.shaded.hbase.guava.com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileReaderV2;
import org.apache.hadoop.hbase.io.hfile.HFileWriterV2;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.io.hfile.LruCachedBlock;
import org.apache.hadoop.hbase.io.hfile.TestHFileWriterV2;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={SmallTests.class})
@RunWith(value=Parameterized.class)
public class TestLazyDataBlockDecompression {
    private static final Log LOG = LogFactory.getLog(TestLazyDataBlockDecompression.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private FileSystem fs;
    @Parameterized.Parameter(value=0)
    public boolean cacheOnWrite;

    @Parameterized.Parameters
    public static Iterable<Object[]> data() {
        return Arrays.asList({false}, {true});
    }

    @Before
    public void setUp() throws IOException {
        CacheConfig.GLOBAL_BLOCK_CACHE_INSTANCE = null;
        this.fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
    }

    @After
    public void tearDown() {
        CacheConfig.GLOBAL_BLOCK_CACHE_INSTANCE = null;
        this.fs = null;
    }

    private static void writeHFile(Configuration conf, CacheConfig cc, FileSystem fs, Path path, HFileContext cxt, int entryCount) throws IOException {
        HFileWriterV2 writer = (HFileWriterV2)new HFileWriterV2.WriterFactoryV2(conf, cc).withPath(fs, path).withFileContext(cxt).create();
        Random rand = new Random(9713312L);
        byte[] family = Bytes.toBytes("f");
        byte[] qualifier = Bytes.toBytes("q");
        for (int i = 0; i < entryCount; ++i) {
            byte[] keyBytes = TestHFileWriterV2.randomOrderedKey(rand, i);
            byte[] valueBytes = TestHFileWriterV2.randomValue(rand);
            writer.append(new KeyValue(keyBytes, family, qualifier, valueBytes));
        }
        writer.close();
    }

    private static void cacheBlocks(Configuration conf, CacheConfig cacheConfig, FileSystem fs, Path path, HFileContext cxt) throws IOException {
        HFileBlock block;
        FSDataInputStreamWrapper fsdis = new FSDataInputStreamWrapper(fs, path);
        long fileSize = fs.getFileStatus(path).getLen();
        FixedFileTrailer trailer = FixedFileTrailer.readFromStream(fsdis.getStream(false), fileSize);
        HFileReaderV2 reader = new HFileReaderV2(path, trailer, fsdis, fileSize, cacheConfig, fsdis.getHfs(), conf);
        reader.loadFileInfo();
        long max = trailer.getLastDataBlockOffset();
        ArrayList<HFileBlock> blocks = new ArrayList<HFileBlock>(4);
        for (long offset = trailer.getFirstDataBlockOffset(); offset <= max; offset += (long)block.getOnDiskSizeWithHeader()) {
            block = reader.readBlock(offset, -1L, true, false, false, true, null, null);
            blocks.add(block);
        }
        LOG.info((Object)("read " + Iterables.toString(blocks)));
    }

    @Test
    public void testCompressionIncreasesEffectiveBlockCacheSize() throws Exception {
        int maxSize = 137625;
        Path hfilePath = new Path(TEST_UTIL.getDataTestDir(), "testCompressionIncreasesEffectiveBlockcacheSize");
        HFileContext context = new HFileContextBuilder().withCompression(Compression.Algorithm.GZ).build();
        LOG.info((Object)("context=" + context));
        Configuration lazyCompressDisabled = HBaseConfiguration.create(TEST_UTIL.getConfiguration());
        lazyCompressDisabled.setBoolean("hbase.rs.cacheblocksonwrite", this.cacheOnWrite);
        lazyCompressDisabled.setBoolean("hfile.block.bloom.cacheonwrite", this.cacheOnWrite);
        lazyCompressDisabled.setBoolean("hfile.block.index.cacheonwrite", this.cacheOnWrite);
        lazyCompressDisabled.setBoolean("hbase.block.data.cachecompressed", false);
        CacheConfig.GLOBAL_BLOCK_CACHE_INSTANCE = new LruBlockCache(maxSize, 65536L, false, lazyCompressDisabled);
        CacheConfig cc = new CacheConfig(lazyCompressDisabled);
        Assert.assertFalse((boolean)cc.shouldCacheDataCompressed());
        Assert.assertTrue((boolean)(cc.getBlockCache() instanceof LruBlockCache));
        LruBlockCache disabledBlockCache = (LruBlockCache)cc.getBlockCache();
        LOG.info((Object)("disabledBlockCache=" + disabledBlockCache));
        Assert.assertEquals((String)"test inconsistency detected.", (long)maxSize, (long)disabledBlockCache.getMaxSize());
        Assert.assertTrue((String)"eviction thread spawned unintentionally.", (disabledBlockCache.getEvictionThread() == null ? 1 : 0) != 0);
        Assert.assertEquals((String)"freshly created blockcache contains blocks.", (long)0L, (long)disabledBlockCache.getBlockCount());
        TestLazyDataBlockDecompression.writeHFile(lazyCompressDisabled, cc, this.fs, hfilePath, context, 2000);
        TestLazyDataBlockDecompression.cacheBlocks(lazyCompressDisabled, cc, this.fs, hfilePath, context);
        long disabledBlockCount = disabledBlockCache.getBlockCount();
        Assert.assertTrue((String)("blockcache should contain blocks. disabledBlockCount=" + disabledBlockCount), (disabledBlockCount > 0L ? 1 : 0) != 0);
        long disabledEvictedCount = disabledBlockCache.getStats().getEvictedCount();
        for (Map.Entry<BlockCacheKey, LruCachedBlock> e : disabledBlockCache.getMapForTests().entrySet()) {
            HFileBlock block = (HFileBlock)e.getValue().getBuffer();
            Assert.assertTrue((String)("found a packed block, block=" + block), (boolean)block.isUnpacked());
        }
        Configuration lazyCompressEnabled = HBaseConfiguration.create(TEST_UTIL.getConfiguration());
        lazyCompressEnabled.setBoolean("hbase.rs.cacheblocksonwrite", this.cacheOnWrite);
        lazyCompressEnabled.setBoolean("hfile.block.bloom.cacheonwrite", this.cacheOnWrite);
        lazyCompressEnabled.setBoolean("hfile.block.index.cacheonwrite", this.cacheOnWrite);
        lazyCompressEnabled.setBoolean("hbase.block.data.cachecompressed", true);
        CacheConfig.GLOBAL_BLOCK_CACHE_INSTANCE = new LruBlockCache(maxSize, 65536L, false, lazyCompressEnabled);
        cc = new CacheConfig(lazyCompressEnabled);
        Assert.assertTrue((String)"test improperly configured.", (boolean)cc.shouldCacheDataCompressed());
        Assert.assertTrue((boolean)(cc.getBlockCache() instanceof LruBlockCache));
        LruBlockCache enabledBlockCache = (LruBlockCache)cc.getBlockCache();
        LOG.info((Object)("enabledBlockCache=" + enabledBlockCache));
        Assert.assertEquals((String)"test inconsistency detected", (long)maxSize, (long)enabledBlockCache.getMaxSize());
        Assert.assertTrue((String)"eviction thread spawned unintentionally.", (enabledBlockCache.getEvictionThread() == null ? 1 : 0) != 0);
        Assert.assertEquals((String)"freshly created blockcache contains blocks.", (long)0L, (long)enabledBlockCache.getBlockCount());
        TestLazyDataBlockDecompression.cacheBlocks(lazyCompressEnabled, cc, this.fs, hfilePath, context);
        long enabledBlockCount = enabledBlockCache.getBlockCount();
        Assert.assertTrue((String)("blockcache should contain blocks. enabledBlockCount=" + enabledBlockCount), (enabledBlockCount > 0L ? 1 : 0) != 0);
        long enabledEvictedCount = enabledBlockCache.getStats().getEvictedCount();
        int candidatesFound = 0;
        for (Map.Entry<BlockCacheKey, LruCachedBlock> e : enabledBlockCache.getMapForTests().entrySet()) {
            ++candidatesFound;
            HFileBlock block = (HFileBlock)e.getValue().getBuffer();
            if (!cc.shouldCacheCompressed(block.getBlockType().getCategory())) continue;
            Assert.assertFalse((String)("found an unpacked block, block=" + block + ", block buffer capacity=" + block.getBufferWithoutHeader().capacity()), (boolean)block.isUnpacked());
        }
        Assert.assertTrue((String)"did not find any candidates for compressed caching. Invalid test.", (candidatesFound > 0 ? 1 : 0) != 0);
        LOG.info((Object)("disabledBlockCount=" + disabledBlockCount + ", enabledBlockCount=" + enabledBlockCount));
        Assert.assertTrue((String)("enabling compressed data blocks should increase the effective cache size. disabledBlockCount=" + disabledBlockCount + ", enabledBlockCount=" + enabledBlockCount), (disabledBlockCount < enabledBlockCount ? 1 : 0) != 0);
        LOG.info((Object)("disabledEvictedCount=" + disabledEvictedCount + ", enabledEvictedCount=" + enabledEvictedCount));
        Assert.assertTrue((String)("enabling compressed data blocks should reduce the number of evictions. disabledEvictedCount=" + disabledEvictedCount + ", enabledEvictedCount=" + enabledEvictedCount), (enabledEvictedCount < disabledEvictedCount ? 1 : 0) != 0);
    }
}

