/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSingleColumnValueExcludeFilter {
    private static final byte[] ROW = Bytes.toBytes("test");
    private static final byte[] COLUMN_FAMILY = Bytes.toBytes("test");
    private static final byte[] COLUMN_QUALIFIER = Bytes.toBytes("foo");
    private static final byte[] COLUMN_QUALIFIER_2 = Bytes.toBytes("foo_2");
    private static final byte[] VAL_1 = Bytes.toBytes("a");
    private static final byte[] VAL_2 = Bytes.toBytes("ab");

    @Test
    public void testFilterKeyValue() throws Exception {
        SingleColumnValueExcludeFilter filter = new SingleColumnValueExcludeFilter(COLUMN_FAMILY, COLUMN_QUALIFIER, CompareFilter.CompareOp.EQUAL, VAL_1);
        ArrayList<Cell> kvs = new ArrayList<Cell>();
        KeyValue kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_2, VAL_1);
        kvs.add(new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_2, VAL_1));
        kvs.add(new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_1));
        kvs.add(new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_2, VAL_1));
        ((Filter)filter).filterRowCells(kvs);
        Assert.assertEquals((String)"resultSize", (long)kvs.size(), (long)2L);
        Assert.assertTrue((String)"leftKV1", (KeyValue.COMPARATOR.compare((Cell)kvs.get(0), kv) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"leftKV2", (KeyValue.COMPARATOR.compare((Cell)kvs.get(1), kv) == 0 ? 1 : 0) != 0);
        Assert.assertFalse((String)"allRemainingWhenMatch", (boolean)((Filter)filter).filterAllRemaining());
        ((Filter)filter).reset();
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_2, VAL_1);
        Assert.assertTrue((String)"otherColumn", (((Filter)filter).filterKeyValue(kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_2);
        Assert.assertTrue((String)"testedMismatch", (((Filter)filter).filterKeyValue(kv) == Filter.ReturnCode.NEXT_ROW ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_2, VAL_1);
        Assert.assertTrue((String)"otherColumn", (((Filter)filter).filterKeyValue(kv) == Filter.ReturnCode.NEXT_ROW ? 1 : 0) != 0);
    }
}

