/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TestFromClientSide;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class})
public class TestIncrementsFromClientSide {
    final Log LOG = LogFactory.getLog(this.getClass());
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] ROW = Bytes.toBytes("testRow");
    private static byte[] FAMILY = Bytes.toBytes("testFamily");
    protected static int SLAVES = 1;
    @Rule
    public TestName name = new TestName();

    public static Collection<Object[]> data() {
        return Arrays.asList({Boolean.FALSE}, {Boolean.TRUE});
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testIncrementWithDeletes() throws Exception {
        this.LOG.info((Object)("Starting " + this.name.getMethodName()));
        TableName TABLENAME = TableName.valueOf(TestIncrementsFromClientSide.filterStringSoTableNameSafe(this.name.getMethodName()));
        HTable ht = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[] COLUMN = Bytes.toBytes("column");
        ht.incrementColumnValue(ROW, FAMILY, COLUMN, 5L);
        TEST_UTIL.flush(TABLENAME);
        Delete del = new Delete(ROW);
        ht.delete(del);
        ht.incrementColumnValue(ROW, FAMILY, COLUMN, 5L);
        Get get = new Get(ROW);
        Result r = ht.get(get);
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertEquals((long)5L, (long)Bytes.toLong(r.getValue(FAMILY, COLUMN)));
    }

    @Test
    public void testIncrementingInvalidValue() throws Exception {
        this.LOG.info((Object)("Starting " + this.name.getMethodName()));
        TableName TABLENAME = TableName.valueOf(TestIncrementsFromClientSide.filterStringSoTableNameSafe(this.name.getMethodName()));
        HTable ht = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[] COLUMN = Bytes.toBytes("column");
        Put p = new Put(ROW);
        p.add(FAMILY, COLUMN, Bytes.toBytes(5));
        ht.put(p);
        try {
            ht.incrementColumnValue(ROW, FAMILY, COLUMN, 5L);
            Assert.fail((String)"Should have thrown DoNotRetryIOException");
        }
        catch (DoNotRetryIOException doNotRetryIOException) {
            // empty catch block
        }
        Increment inc = new Increment(ROW);
        inc.addColumn(FAMILY, COLUMN, 5L);
        try {
            ht.increment(inc);
            Assert.fail((String)"Should have thrown DoNotRetryIOException");
        }
        catch (DoNotRetryIOException doNotRetryIOException) {
            // empty catch block
        }
    }

    @Test
    public void testIncrementInvalidArguments() throws Exception {
        this.LOG.info((Object)("Starting " + this.name.getMethodName()));
        TableName TABLENAME = TableName.valueOf(TestIncrementsFromClientSide.filterStringSoTableNameSafe(this.name.getMethodName()));
        HTable ht = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[] COLUMN = Bytes.toBytes("column");
        try {
            ht.incrementColumnValue(null, FAMILY, COLUMN, 5L);
            Assert.fail((String)"Should have thrown IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            ht.incrementColumnValue(ROW, null, COLUMN, 5L);
            Assert.fail((String)"Should have thrown IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            ht.incrementColumnValue(ROW, FAMILY, null, 5L);
            Assert.fail((String)"Should have thrown IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Increment incNoRow = new Increment((byte[])null);
            incNoRow.addColumn(FAMILY, COLUMN, 5L);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException incNoRow) {
        }
        catch (NullPointerException incNoRow) {
            // empty catch block
        }
        try {
            Increment incNoFamily = new Increment(ROW);
            incNoFamily.addColumn(null, COLUMN, 5L);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException incNoFamily) {
            // empty catch block
        }
        try {
            Increment incNoQualifier = new Increment(ROW);
            incNoQualifier.addColumn(FAMILY, null, 5L);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIncrementOutOfOrder() throws Exception {
        this.LOG.info((Object)("Starting " + this.name.getMethodName()));
        TableName TABLENAME = TableName.valueOf(TestIncrementsFromClientSide.filterStringSoTableNameSafe(this.name.getMethodName()));
        HTable ht = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes("B"), Bytes.toBytes("A"), Bytes.toBytes("C")};
        Increment inc = new Increment(ROW);
        for (int i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], 1L);
        }
        ht.increment(inc);
        Get get = new Get(ROW);
        Result r = ht.get(get);
        Cell[] kvs = r.rawCells();
        Assert.assertEquals((long)3L, (long)kvs.length);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[0], ROW, FAMILY, QUALIFIERS[1], 1L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[1], ROW, FAMILY, QUALIFIERS[0], 1L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[2], ROW, FAMILY, QUALIFIERS[2], 1L);
        inc = new Increment(ROW);
        for (int i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], 1L);
        }
        ht.increment(inc);
        r = ht.get(get);
        kvs = r.rawCells();
        Assert.assertEquals((long)3L, (long)kvs.length);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[0], ROW, FAMILY, QUALIFIERS[1], 2L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[1], ROW, FAMILY, QUALIFIERS[0], 2L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[2], ROW, FAMILY, QUALIFIERS[2], 2L);
    }

    @Test
    public void testIncrementOnSameColumn() throws Exception {
        this.LOG.info((Object)("Starting " + this.name.getMethodName()));
        byte[] TABLENAME = Bytes.toBytes(TestIncrementsFromClientSide.filterStringSoTableNameSafe(this.name.getMethodName()));
        HTable ht = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes("A"), Bytes.toBytes("B"), Bytes.toBytes("C")};
        Increment inc = new Increment(ROW);
        for (int i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], 1L);
            inc.addColumn(FAMILY, QUALIFIERS[i], 1L);
        }
        ht.increment(inc);
        Get get = new Get(ROW);
        Result r = ht.get(get);
        Cell[] kvs = r.rawCells();
        Assert.assertEquals((long)3L, (long)kvs.length);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[0], ROW, FAMILY, QUALIFIERS[0], 1L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[1], ROW, FAMILY, QUALIFIERS[1], 1L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[2], ROW, FAMILY, QUALIFIERS[2], 1L);
        inc = new Increment(ROW);
        for (int i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], 1L);
            inc.addColumn(FAMILY, QUALIFIERS[i], 1L);
        }
        ht.increment(inc);
        r = ht.get(get);
        kvs = r.rawCells();
        Assert.assertEquals((long)3L, (long)kvs.length);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[0], ROW, FAMILY, QUALIFIERS[0], 2L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[1], ROW, FAMILY, QUALIFIERS[1], 2L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[2], ROW, FAMILY, QUALIFIERS[2], 2L);
        ht.close();
    }

    @Test
    public void testIncrement() throws Exception {
        int i;
        this.LOG.info((Object)("Starting " + this.name.getMethodName()));
        TableName TABLENAME = TableName.valueOf(TestIncrementsFromClientSide.filterStringSoTableNameSafe(this.name.getMethodName()));
        HTable ht = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[][] ROWS = new byte[][]{Bytes.toBytes("a"), Bytes.toBytes("b"), Bytes.toBytes("c"), Bytes.toBytes("d"), Bytes.toBytes("e"), Bytes.toBytes("f"), Bytes.toBytes("g"), Bytes.toBytes("h"), Bytes.toBytes("i")};
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes("a"), Bytes.toBytes("b"), Bytes.toBytes("c"), Bytes.toBytes("d"), Bytes.toBytes("e"), Bytes.toBytes("f"), Bytes.toBytes("g"), Bytes.toBytes("h"), Bytes.toBytes("i")};
        ht.incrementColumnValue(ROW, FAMILY, QUALIFIERS[0], 1L);
        ht.incrementColumnValue(ROW, FAMILY, QUALIFIERS[1], 2L);
        ht.incrementColumnValue(ROW, FAMILY, QUALIFIERS[2], 3L);
        ht.incrementColumnValue(ROW, FAMILY, QUALIFIERS[3], 4L);
        Increment inc = new Increment(ROW);
        inc.addColumn(FAMILY, QUALIFIERS[1], 1L);
        inc.addColumn(FAMILY, QUALIFIERS[3], 1L);
        inc.addColumn(FAMILY, QUALIFIERS[4], 1L);
        ht.increment(inc);
        Get get = new Get(ROW);
        Result r = ht.get(get);
        Cell[] kvs = r.rawCells();
        Assert.assertEquals((long)5L, (long)kvs.length);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[0], ROW, FAMILY, QUALIFIERS[0], 1L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[1], ROW, FAMILY, QUALIFIERS[1], 3L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[2], ROW, FAMILY, QUALIFIERS[2], 3L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[3], ROW, FAMILY, QUALIFIERS[3], 5L);
        TestIncrementsFromClientSide.assertIncrementKey(kvs[4], ROW, FAMILY, QUALIFIERS[4], 1L);
        inc = new Increment(ROWS[0]);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], i + 1);
        }
        ht.increment(inc);
        get = new Get(ROWS[0]);
        r = ht.get(get);
        kvs = r.rawCells();
        Assert.assertEquals((long)QUALIFIERS.length, (long)kvs.length);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            TestIncrementsFromClientSide.assertIncrementKey(kvs[i], ROWS[0], FAMILY, QUALIFIERS[i], i + 1);
        }
        inc = new Increment(ROWS[0]);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], i + 1);
        }
        ht.increment(inc);
        r = ht.get(get);
        kvs = r.rawCells();
        Assert.assertEquals((long)QUALIFIERS.length, (long)kvs.length);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            TestIncrementsFromClientSide.assertIncrementKey(kvs[i], ROWS[0], FAMILY, QUALIFIERS[i], 2 * (i + 1));
        }
        inc = new Increment(ROWS[0]);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], 0L);
        }
        ht.increment(inc);
        r = ht.get(get);
        kvs = r.rawCells();
        Assert.assertEquals((long)QUALIFIERS.length, (long)kvs.length);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            TestIncrementsFromClientSide.assertIncrementKey(kvs[i], ROWS[0], FAMILY, QUALIFIERS[i], 2 * (i + 1));
        }
    }

    static void assertIncrementKey(Cell key, byte[] row, byte[] family, byte[] qualifier, long value) throws Exception {
        TestFromClientSide.assertIncrementKey(key, row, family, qualifier, value);
    }

    public static String filterStringSoTableNameSafe(String str) {
        return str.replaceAll("\\[fast\\=(.*)\\]", ".FAST.is.$1");
    }
}

