/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.DelegatingRpcScheduler;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.SimpleRpcSchedulerFactory;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMetaTableAccessor {
    private static final Log LOG = LogFactory.getLog(TestMetaTableAccessor.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static Connection connection;
    private Random random = new Random();

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster(3);
        Configuration c = new Configuration(UTIL.getConfiguration());
        c.setLong("hbase.client.pause", 1000L);
        c.setInt("hbase.client.retries.number", 10);
        connection = ConnectionFactory.createConnection(c);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        connection.close();
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRetrying() throws IOException, InterruptedException {
        TableName name = TableName.valueOf("testRetrying");
        LOG.info((Object)("Started " + name));
        HTable t = UTIL.createMultiRegionTable(name, HConstants.CATALOG_FAMILY);
        int regionCount = -1;
        try (RegionLocator r = t.getRegionLocator();){
            regionCount = r.getStartKeys().length;
        }
        final List<HRegionInfo> regions = TestMetaTableAccessor.testGettingTableRegions(connection, name, regionCount);
        MetaTask reader = new MetaTask(connection, "reader"){

            @Override
            void metaTask() throws Throwable {
                TestMetaTableAccessor.testGetRegion(this.connection, (HRegionInfo)regions.get(0));
                LOG.info((Object)("Read " + ((HRegionInfo)regions.get(0)).getEncodedName()));
            }
        };
        MetaTask writer = new MetaTask(connection, "writer"){

            @Override
            void metaTask() throws Throwable {
                MetaTableAccessor.addRegionToMeta(this.connection, (HRegionInfo)regions.get(0));
                LOG.info((Object)("Wrote " + ((HRegionInfo)regions.get(0)).getEncodedName()));
            }
        };
        reader.start();
        writer.start();
        long timeOut = 180000L;
        long startTime = System.currentTimeMillis();
        try {
            Assert.assertTrue((boolean)reader.isProgressing());
            Assert.assertTrue((boolean)writer.isProgressing());
            for (int i = 0; i < 2; ++i) {
                LOG.info((Object)("Restart=" + i));
                UTIL.ensureSomeRegionServersAvailable(2);
                int index = -1;
                while ((index = UTIL.getMiniHBaseCluster().getServerWithMeta()) == -1 && startTime + 180000L < System.currentTimeMillis()) {
                }
                if (index == -1) continue;
                UTIL.getMiniHBaseCluster().abortRegionServer(index);
                UTIL.getMiniHBaseCluster().waitOnRegionServer(index);
            }
            Assert.assertTrue((String)("reader: " + reader.toString()), (boolean)reader.isProgressing());
            Assert.assertTrue((String)("writer: " + writer.toString()), (boolean)writer.isProgressing());
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            reader.stop = true;
            writer.stop = true;
            reader.join();
            writer.join();
            t.close();
        }
        long exeTime = System.currentTimeMillis() - startTime;
        Assert.assertTrue((String)("Timeout: test took " + exeTime / 1000L + " sec"), (exeTime < 180000L ? 1 : 0) != 0);
    }

    @Test
    public void testGetRegionsCatalogTables() throws IOException, InterruptedException {
        List<HRegionInfo> regions = MetaTableAccessor.getTableRegions(UTIL.getZooKeeperWatcher(), connection, TableName.META_TABLE_NAME);
        Assert.assertTrue((regions.size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((MetaTableAccessor.getTableRegionsAndLocations(UTIL.getZooKeeperWatcher(), connection, TableName.META_TABLE_NAME).size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testTableExists() throws IOException {
        TableName name = TableName.valueOf("testTableExists");
        Assert.assertFalse((boolean)MetaTableAccessor.tableExists(connection, name));
        UTIL.createTable(name, HConstants.CATALOG_FAMILY);
        Assert.assertTrue((boolean)MetaTableAccessor.tableExists(connection, name));
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        admin.disableTable(name);
        admin.deleteTable(name);
        Assert.assertFalse((boolean)MetaTableAccessor.tableExists(connection, name));
        Assert.assertTrue((boolean)MetaTableAccessor.tableExists(connection, TableName.META_TABLE_NAME));
    }

    @Test
    public void testGetRegion() throws IOException, InterruptedException {
        String name = "testGetRegion";
        LOG.info((Object)"Started testGetRegion");
        Pair<HRegionInfo, ServerName> pair = MetaTableAccessor.getRegion(connection, Bytes.toBytes("nonexistent-region"));
        Assert.assertNull(pair);
        LOG.info((Object)"Finished testGetRegion");
    }

    @Test
    public void testScanMetaForTable() throws IOException, InterruptedException {
        TableName name = TableName.valueOf("testScanMetaForTable");
        LOG.info((Object)("Started " + name));
        UTIL.createTable(name, HConstants.CATALOG_FAMILY);
        TableName greaterName = TableName.valueOf("testScanMetaForTablf");
        UTIL.createTable(greaterName, HConstants.CATALOG_FAMILY);
        Assert.assertEquals((long)1L, (long)MetaTableAccessor.getTableRegions(UTIL.getZooKeeperWatcher(), connection, name).size());
        Assert.assertEquals((long)1L, (long)MetaTableAccessor.getTableRegions(UTIL.getZooKeeperWatcher(), connection, greaterName).size());
    }

    private static List<HRegionInfo> testGettingTableRegions(Connection connection, TableName name, int regionCount) throws IOException, InterruptedException {
        List<HRegionInfo> regions = MetaTableAccessor.getTableRegions(UTIL.getZooKeeperWatcher(), connection, name);
        Assert.assertEquals((long)regionCount, (long)regions.size());
        Pair<HRegionInfo, ServerName> pair = MetaTableAccessor.getRegion(connection, regions.get(0).getRegionName());
        Assert.assertEquals((Object)regions.get(0).getEncodedName(), (Object)pair.getFirst().getEncodedName());
        return regions;
    }

    private static void testGetRegion(Connection connection, HRegionInfo region) throws IOException, InterruptedException {
        Pair<HRegionInfo, ServerName> pair = MetaTableAccessor.getRegion(connection, region.getRegionName());
        Assert.assertEquals((Object)region.getEncodedName(), (Object)pair.getFirst().getEncodedName());
    }

    @Test
    public void testParseReplicaIdFromServerColumn() {
        String column1 = "server";
        Assert.assertEquals((long)0L, (long)MetaTableAccessor.parseReplicaIdFromServerColumn(Bytes.toBytes(column1)));
        String column2 = column1 + '_';
        Assert.assertEquals((long)-1L, (long)MetaTableAccessor.parseReplicaIdFromServerColumn(Bytes.toBytes(column2)));
        String column3 = column2 + "00";
        Assert.assertEquals((long)-1L, (long)MetaTableAccessor.parseReplicaIdFromServerColumn(Bytes.toBytes(column3)));
        String column4 = column3 + "2A";
        Assert.assertEquals((long)42L, (long)MetaTableAccessor.parseReplicaIdFromServerColumn(Bytes.toBytes(column4)));
        String column5 = column4 + "2A";
        Assert.assertEquals((long)-1L, (long)MetaTableAccessor.parseReplicaIdFromServerColumn(Bytes.toBytes(column5)));
        String column6 = "serverstartcode";
        Assert.assertEquals((long)-1L, (long)MetaTableAccessor.parseReplicaIdFromServerColumn(Bytes.toBytes(column6)));
    }

    @Test
    public void testMetaReaderGetColumnMethods() {
        Assert.assertArrayEquals((byte[])HConstants.SERVER_QUALIFIER, (byte[])MetaTableAccessor.getServerColumn(0));
        Assert.assertArrayEquals((byte[])Bytes.toBytes("server_002A"), (byte[])MetaTableAccessor.getServerColumn(42));
        Assert.assertArrayEquals((byte[])HConstants.STARTCODE_QUALIFIER, (byte[])MetaTableAccessor.getStartCodeColumn(0));
        Assert.assertArrayEquals((byte[])Bytes.toBytes("serverstartcode_002A"), (byte[])MetaTableAccessor.getStartCodeColumn(42));
        Assert.assertArrayEquals((byte[])HConstants.SEQNUM_QUALIFIER, (byte[])MetaTableAccessor.getSeqNumColumn(0));
        Assert.assertArrayEquals((byte[])Bytes.toBytes("seqnumDuringOpen_002A"), (byte[])MetaTableAccessor.getSeqNumColumn(42));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaLocationsForRegionReplicas() throws IOException {
        ServerName serverName0 = ServerName.valueOf("foo", 60010, this.random.nextLong());
        ServerName serverName1 = ServerName.valueOf("bar", 60010, this.random.nextLong());
        ServerName serverName100 = ServerName.valueOf("baz", 60010, this.random.nextLong());
        long regionId = System.currentTimeMillis();
        HRegionInfo primary = new HRegionInfo(TableName.valueOf("table_foo"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, regionId, 0);
        HRegionInfo replica1 = new HRegionInfo(TableName.valueOf("table_foo"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, regionId, 1);
        HRegionInfo replica100 = new HRegionInfo(TableName.valueOf("table_foo"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, regionId, 100);
        long seqNum0 = this.random.nextLong();
        long seqNum1 = this.random.nextLong();
        long seqNum100 = this.random.nextLong();
        try (Table meta = MetaTableAccessor.getMetaHTable(connection);){
            MetaTableAccessor.updateRegionLocation(connection, primary, serverName0, seqNum0, -1L);
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName0, seqNum0, 0, true);
            MetaTableAccessor.updateRegionLocation(connection, replica1, serverName1, seqNum1, -1L);
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName0, seqNum0, 0, true);
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName1, seqNum1, 1, true);
            MetaTableAccessor.updateRegionLocation(connection, replica100, serverName100, seqNum100, -1L);
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName0, seqNum0, 0, true);
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName1, seqNum1, 1, true);
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName100, seqNum100, 100, true);
        }
    }

    public static void assertMetaLocation(Table meta, byte[] row, ServerName serverName, long seqNum, int replicaId, boolean checkSeqNum) throws IOException {
        Get get = new Get(row);
        Result result = meta.get(get);
        Assert.assertTrue((boolean)Bytes.equals(result.getValue(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn(replicaId)), Bytes.toBytes(serverName.getHostAndPort())));
        Assert.assertTrue((boolean)Bytes.equals(result.getValue(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn(replicaId)), Bytes.toBytes(serverName.getStartcode())));
        if (checkSeqNum) {
            Assert.assertTrue((boolean)Bytes.equals(result.getValue(HConstants.CATALOG_FAMILY, MetaTableAccessor.getSeqNumColumn(replicaId)), Bytes.toBytes(seqNum)));
        }
    }

    public static void assertEmptyMetaLocation(Table meta, byte[] row, int replicaId) throws IOException {
        Get get = new Get(row);
        Result result = meta.get(get);
        Cell serverCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn(replicaId));
        Cell startCodeCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn(replicaId));
        Assert.assertNotNull((Object)serverCell);
        Assert.assertNotNull((Object)startCodeCell);
        Assert.assertEquals((long)0L, (long)serverCell.getValueLength());
        Assert.assertEquals((long)0L, (long)startCodeCell.getValueLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaLocationForRegionReplicasIsAddedAtTableCreation() throws IOException {
        long regionId = System.currentTimeMillis();
        HRegionInfo primary = new HRegionInfo(TableName.valueOf("table_foo"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, regionId, 0);
        try (Table meta = MetaTableAccessor.getMetaHTable(connection);){
            ArrayList<HRegionInfo> regionInfos = Lists.newArrayList(primary);
            MetaTableAccessor.addRegionsToMeta(connection, regionInfos, 3);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, primary.getRegionName(), 1);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, primary.getRegionName(), 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaLocationForRegionReplicasIsAddedAtRegionSplit() throws IOException {
        long regionId = System.currentTimeMillis();
        ServerName serverName0 = ServerName.valueOf("foo", 60010, this.random.nextLong());
        HRegionInfo parent = new HRegionInfo(TableName.valueOf("table_foo"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, regionId, 0);
        HRegionInfo splitA = new HRegionInfo(TableName.valueOf("table_foo"), HConstants.EMPTY_START_ROW, Bytes.toBytes("a"), false, regionId + 1L, 0);
        HRegionInfo splitB = new HRegionInfo(TableName.valueOf("table_foo"), Bytes.toBytes("a"), HConstants.EMPTY_END_ROW, false, regionId + 1L, 0);
        try (Table meta = MetaTableAccessor.getMetaHTable(connection);){
            ArrayList<HRegionInfo> regionInfos = Lists.newArrayList(parent);
            MetaTableAccessor.addRegionsToMeta(connection, regionInfos, 3);
            MetaTableAccessor.splitRegion(connection, parent, splitA, splitB, serverName0, 3);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, splitA.getRegionName(), 1);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, splitA.getRegionName(), 2);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, splitB.getRegionName(), 1);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, splitB.getRegionName(), 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaLocationForRegionReplicasIsAddedAtRegionMerge() throws IOException {
        long regionId = System.currentTimeMillis();
        ServerName serverName0 = ServerName.valueOf("foo", 60010, this.random.nextLong());
        HRegionInfo parentA = new HRegionInfo(TableName.valueOf("table_foo"), Bytes.toBytes("a"), HConstants.EMPTY_END_ROW, false, regionId, 0);
        HRegionInfo parentB = new HRegionInfo(TableName.valueOf("table_foo"), HConstants.EMPTY_START_ROW, Bytes.toBytes("a"), false, regionId, 0);
        HRegionInfo merged = new HRegionInfo(TableName.valueOf("table_foo"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, regionId + 1L, 0);
        try (Table meta = MetaTableAccessor.getMetaHTable(connection);){
            ArrayList<HRegionInfo> regionInfos = Lists.newArrayList(parentA, parentB);
            MetaTableAccessor.addRegionsToMeta(connection, regionInfos, 3);
            MetaTableAccessor.mergeRegions(connection, merged, parentA, parentB, serverName0, 3, Long.MAX_VALUE);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, merged.getRegionName(), 1);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, merged.getRegionName(), 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMastersSystemTimeIsUsedInUpdateLocations() throws IOException {
        long regionId = System.currentTimeMillis();
        HRegionInfo regionInfo = new HRegionInfo(TableName.valueOf("table_foo"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, regionId, 0);
        ServerName sn = ServerName.valueOf("bar", 0, 0L);
        try (Table meta = MetaTableAccessor.getMetaHTable(connection);){
            ArrayList<HRegionInfo> regionInfos = Lists.newArrayList(regionInfo);
            MetaTableAccessor.addRegionsToMeta(connection, regionInfos, 1);
            long masterSystemTime = EnvironmentEdgeManager.currentTime() + 123456789L;
            MetaTableAccessor.updateRegionLocation(connection, regionInfo, sn, 1L, masterSystemTime);
            Get get = new Get(regionInfo.getRegionName());
            Result result = meta.get(get);
            Cell serverCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn(0));
            Cell startCodeCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn(0));
            Cell seqNumCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getSeqNumColumn(0));
            Assert.assertNotNull((Object)serverCell);
            Assert.assertNotNull((Object)startCodeCell);
            Assert.assertNotNull((Object)seqNumCell);
            Assert.assertTrue((serverCell.getValueLength() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((startCodeCell.getValueLength() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((seqNumCell.getValueLength() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((long)masterSystemTime, (long)serverCell.getTimestamp());
            Assert.assertEquals((long)masterSystemTime, (long)startCodeCell.getTimestamp());
            Assert.assertEquals((long)masterSystemTime, (long)seqNumCell.getTimestamp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMastersSystemTimeIsUsedInMergeRegions() throws IOException {
        long regionId = System.currentTimeMillis();
        HRegionInfo regionInfoA = new HRegionInfo(TableName.valueOf("table_foo"), HConstants.EMPTY_START_ROW, new byte[]{97}, false, regionId, 0);
        HRegionInfo regionInfoB = new HRegionInfo(TableName.valueOf("table_foo"), new byte[]{97}, HConstants.EMPTY_END_ROW, false, regionId, 0);
        HRegionInfo mergedRegionInfo = new HRegionInfo(TableName.valueOf("table_foo"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, regionId, 0);
        ServerName sn = ServerName.valueOf("bar", 0, 0L);
        try (Table meta = MetaTableAccessor.getMetaHTable(connection);){
            ArrayList<HRegionInfo> regionInfos = Lists.newArrayList(regionInfoA, regionInfoB);
            MetaTableAccessor.addRegionsToMeta(connection, regionInfos, 1);
            long serverNameTime = EnvironmentEdgeManager.currentTime() + 100000000L;
            long masterSystemTime = EnvironmentEdgeManager.currentTime() + 123456789L;
            MetaTableAccessor.updateRegionLocation(connection, regionInfoA, sn, 1L, serverNameTime);
            Get get = new Get(mergedRegionInfo.getRegionName());
            Result result = meta.get(get);
            Cell serverCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn(0));
            Assert.assertNotNull((Object)serverCell);
            Assert.assertEquals((long)serverNameTime, (long)serverCell.getTimestamp());
            MetaTableAccessor.mergeRegions(connection, mergedRegionInfo, regionInfoA, regionInfoB, sn, 1, masterSystemTime);
            result = meta.get(get);
            serverCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn(0));
            Cell startCodeCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn(0));
            Cell seqNumCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getSeqNumColumn(0));
            Assert.assertNull((Object)serverCell);
            Assert.assertNull((Object)startCodeCell);
            Assert.assertNull((Object)seqNumCell);
        }
    }

    @Test
    public void testMetaUpdatesGoToPriorityQueue() throws Exception {
        Configuration c = UTIL.getConfiguration();
        c.set("hbase.region.server.rpc.scheduler.factory.class", SpyingRpcSchedulerFactory.class.getName());
        TestMetaTableAccessor.afterClass();
        TestMetaTableAccessor.beforeClass();
        TableName tableName = TableName.valueOf("foo");
        try (Admin admin = connection.getAdmin();
             RegionLocator rl = connection.getRegionLocator(tableName);){
            UTIL.createTable(tableName, "cf1");
            HRegionLocation loc = rl.getAllRegionLocations().get(0);
            HRegionInfo parent = loc.getRegionInfo();
            long rid = 1000L;
            byte[] splitKey = Bytes.toBytes("a");
            HRegionInfo splitA = new HRegionInfo(parent.getTable(), parent.getStartKey(), splitKey, false, rid);
            HRegionInfo splitB = new HRegionInfo(parent.getTable(), splitKey, parent.getEndKey(), false, rid);
            MiniHBaseCluster cluster = UTIL.getMiniHBaseCluster();
            int rsIndex = cluster.getServerWithMeta();
            HRegionServer rs = rsIndex >= 0 ? cluster.getRegionServer(rsIndex) : cluster.getMaster();
            SpyingRpcScheduler scheduler = (SpyingRpcScheduler)rs.getRpcServer().getScheduler();
            long prevCalls = scheduler.numPriorityCalls;
            MetaTableAccessor.splitRegion(connection, parent, splitA, splitB, loc.getServerName(), 1);
            Assert.assertTrue((prevCalls < scheduler.numPriorityCalls ? 1 : 0) != 0);
        }
    }

    public static class SpyingRpcScheduler
    extends DelegatingRpcScheduler {
        long numPriorityCalls = 0L;

        public SpyingRpcScheduler(RpcScheduler delegate) {
            super(delegate);
        }

        @Override
        public void dispatch(CallRunner task) throws IOException, InterruptedException {
            int priority = task.getCall().getPriority();
            if (priority > 10) {
                ++this.numPriorityCalls;
            }
            super.dispatch(task);
        }
    }

    public static class SpyingRpcSchedulerFactory
    extends SimpleRpcSchedulerFactory {
        @Override
        public RpcScheduler create(Configuration conf, PriorityFunction priority, Abortable server) {
            RpcScheduler delegate = super.create(conf, priority, server);
            return new SpyingRpcScheduler(delegate);
        }
    }

    static abstract class MetaTask
    extends Thread {
        boolean stop = false;
        int count = 0;
        Throwable t = null;
        final Connection connection;

        MetaTask(Connection connection, String name) {
            super(name);
            this.connection = connection;
        }

        @Override
        public void run() {
            try {
                while (!this.stop) {
                    LOG.info((Object)("Before " + this.getName() + ", count=" + this.count));
                    this.metaTask();
                    ++this.count;
                    LOG.info((Object)("After " + this.getName() + ", count=" + this.count));
                    Thread.sleep(100L);
                }
            }
            catch (Throwable t) {
                LOG.info((Object)(this.getName() + " failed"), t);
                this.t = t;
            }
        }

        boolean isProgressing() throws InterruptedException {
            int currentCount = this.count;
            while (currentCount == this.count) {
                if (!this.isAlive()) {
                    return false;
                }
                if (this.t != null) {
                    return false;
                }
                Thread.sleep(10L);
            }
            return true;
        }

        @Override
        public String toString() {
            return "count=" + this.count + ", t=" + (this.t == null ? "null" : this.t.toString());
        }

        abstract void metaTask() throws Throwable;
    }
}

