/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JenkinsHash;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.io.DataInputBuffer;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HRegionInfo
implements Comparable<HRegionInfo> {
    @Deprecated
    public static final byte VERSION = 1;
    private static final Log LOG = LogFactory.getLog(HRegionInfo.class);
    private static final int ENC_SEPARATOR = 46;
    public static final int MD5_HEX_LENGTH = 32;
    public static final String ENCODED_REGION_NAME_REGEX = "(?:[a-f0-9]+)";
    public static final String REPLICA_ID_FORMAT = "%04X";
    public static final byte REPLICA_ID_DELIMITER = 95;
    private static final int MAX_REPLICA_ID = 65535;
    public static final int DEFAULT_REPLICA_ID = 0;
    static final Pattern ENCODED_REGION_PATTERN = Pattern.compile("[a-fA-F0-9]{32}");
    private byte[] endKey = HConstants.EMPTY_BYTE_ARRAY;
    private boolean offLine = false;
    private long regionId = -1L;
    private transient byte[] regionName = HConstants.EMPTY_BYTE_ARRAY;
    private boolean split = false;
    private byte[] startKey = HConstants.EMPTY_BYTE_ARRAY;
    private int hashCode = -1;
    public static final String NO_HASH = null;
    private String encodedName = null;
    private byte[] encodedNameAsBytes = null;
    private int replicaId = 0;
    private TableName tableName = null;
    public static final HRegionInfo FIRST_META_REGIONINFO = new HRegionInfo(1L, TableName.META_TABLE_NAME);

    public static boolean isEncodedName(byte[] regionName) {
        return regionName != null && HRegionInfo.isEncodedName(Bytes.toString(regionName));
    }

    public static boolean isEncodedName(String regionName) {
        return regionName != null && ENCODED_REGION_PATTERN.matcher(regionName).matches();
    }

    private static boolean hasEncodedName(byte[] regionName) {
        return regionName.length >= 1 && regionName[regionName.length - 1] == 46;
    }

    public static String encodeRegionName(byte[] regionName) {
        String encodedName;
        if (HRegionInfo.hasEncodedName(regionName)) {
            encodedName = Bytes.toString(regionName, regionName.length - 32 - 1, 32);
        } else {
            int hashVal = Math.abs(JenkinsHash.getInstance().hash(regionName, regionName.length, 0));
            encodedName = String.valueOf(hashVal);
        }
        return encodedName;
    }

    public String getShortNameToLog() {
        return HRegionInfo.prettyPrint(this.getEncodedName());
    }

    public static String prettyPrint(String encodedRegionName) {
        if (encodedRegionName.equals("1028785192")) {
            return encodedRegionName + "/hbase:meta";
        }
        return encodedRegionName;
    }

    private void setHashCode() {
        int result = Arrays.hashCode(this.regionName);
        result = (int)((long)result ^ this.regionId);
        result ^= Arrays.hashCode(this.startKey);
        result ^= Arrays.hashCode(this.endKey);
        result ^= Boolean.valueOf(this.offLine).hashCode();
        result ^= Arrays.hashCode(this.tableName.getName());
        this.hashCode = result ^= this.replicaId;
    }

    private HRegionInfo(long regionId, TableName tableName) {
        this(regionId, tableName, 0);
    }

    public HRegionInfo(long regionId, TableName tableName, int replicaId) {
        this.regionId = regionId;
        this.tableName = tableName;
        this.replicaId = replicaId;
        this.regionName = HRegionInfo.createRegionName(tableName, null, regionId, replicaId, false);
        this.setHashCode();
    }

    @Deprecated
    public HRegionInfo() {
    }

    public HRegionInfo(TableName tableName) {
        this(tableName, null, null);
    }

    public HRegionInfo(TableName tableName, byte[] startKey, byte[] endKey) throws IllegalArgumentException {
        this(tableName, startKey, endKey, false);
    }

    public HRegionInfo(TableName tableName, byte[] startKey, byte[] endKey, boolean split) throws IllegalArgumentException {
        this(tableName, startKey, endKey, split, System.currentTimeMillis());
    }

    public HRegionInfo(TableName tableName, byte[] startKey, byte[] endKey, boolean split, long regionid) throws IllegalArgumentException {
        this(tableName, startKey, endKey, split, regionid, 0);
    }

    public HRegionInfo(TableName tableName, byte[] startKey, byte[] endKey, boolean split, long regionid, int replicaId) throws IllegalArgumentException {
        if (tableName == null) {
            throw new IllegalArgumentException("TableName cannot be null");
        }
        this.tableName = tableName;
        this.offLine = false;
        this.regionId = regionid;
        this.replicaId = replicaId;
        if (this.replicaId > 65535) {
            throw new IllegalArgumentException("ReplicaId cannot be greater than65535");
        }
        this.regionName = HRegionInfo.createRegionName(this.tableName, startKey, this.regionId, replicaId, true);
        this.split = split;
        this.endKey = endKey == null ? HConstants.EMPTY_END_ROW : (byte[])endKey.clone();
        this.startKey = startKey == null ? HConstants.EMPTY_START_ROW : (byte[])startKey.clone();
        this.tableName = tableName;
        this.setHashCode();
    }

    public HRegionInfo(HRegionInfo other) {
        this.endKey = other.getEndKey();
        this.offLine = other.isOffline();
        this.regionId = other.getRegionId();
        this.regionName = other.getRegionName();
        this.split = other.isSplit();
        this.startKey = other.getStartKey();
        this.hashCode = other.hashCode();
        this.encodedName = other.getEncodedName();
        this.tableName = other.tableName;
        this.replicaId = other.replicaId;
    }

    public HRegionInfo(HRegionInfo other, int replicaId) {
        this(other);
        this.replicaId = replicaId;
        this.setHashCode();
    }

    public static byte[] createRegionName(TableName tableName, byte[] startKey, long regionid, boolean newFormat) {
        return HRegionInfo.createRegionName(tableName, startKey, Long.toString(regionid), newFormat);
    }

    public static byte[] createRegionName(TableName tableName, byte[] startKey, String id, boolean newFormat) {
        return HRegionInfo.createRegionName(tableName, startKey, Bytes.toBytes(id), newFormat);
    }

    public static byte[] createRegionName(TableName tableName, byte[] startKey, long regionid, int replicaId, boolean newFormat) {
        return HRegionInfo.createRegionName(tableName, startKey, Bytes.toBytes(Long.toString(regionid)), replicaId, newFormat);
    }

    public static byte[] createRegionName(TableName tableName, byte[] startKey, byte[] id, boolean newFormat) {
        return HRegionInfo.createRegionName(tableName, startKey, id, 0, newFormat);
    }

    public static byte[] createRegionName(TableName tableName, byte[] startKey, byte[] id, int replicaId, boolean newFormat) {
        int len = tableName.getName().length + 2 + id.length + (startKey == null ? 0 : startKey.length);
        if (newFormat) {
            len += 34;
        }
        byte[] replicaIdBytes = null;
        if (replicaId > 0) {
            replicaIdBytes = Bytes.toBytes(String.format(REPLICA_ID_FORMAT, replicaId));
            len += 1 + replicaIdBytes.length;
        }
        byte[] b = new byte[len];
        int offset = tableName.getName().length;
        System.arraycopy(tableName.getName(), 0, b, 0, offset);
        b[offset++] = 44;
        if (startKey != null && startKey.length > 0) {
            System.arraycopy(startKey, 0, b, offset, startKey.length);
            offset += startKey.length;
        }
        b[offset++] = 44;
        System.arraycopy(id, 0, b, offset, id.length);
        offset += id.length;
        if (replicaIdBytes != null) {
            b[offset++] = 95;
            System.arraycopy(replicaIdBytes, 0, b, offset, replicaIdBytes.length);
            offset += replicaIdBytes.length;
        }
        if (newFormat) {
            String md5Hash = MD5Hash.getMD5AsHex(b, 0, offset);
            byte[] md5HashBytes = Bytes.toBytes(md5Hash);
            if (md5HashBytes.length != 32) {
                LOG.error((Object)("MD5-hash length mismatch: Expected=32; Got=" + md5HashBytes.length));
            }
            b[offset++] = 46;
            System.arraycopy(md5HashBytes, 0, b, offset, 32);
            offset += 32;
            b[offset++] = 46;
        }
        return b;
    }

    public static String getTableName(String tableOrRegionName) {
        int offset = tableOrRegionName.indexOf(44);
        return offset != -1 ? tableOrRegionName.substring(0, offset) : tableOrRegionName;
    }

    @Deprecated
    public static byte[] getTableName(byte[] regionName) {
        int offset = -1;
        for (int i = 0; i < regionName.length; ++i) {
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            offset = regionName.length;
        }
        byte[] buff = new byte[offset];
        System.arraycopy(regionName, 0, buff, 0, offset);
        return buff;
    }

    public static TableName getTable(byte[] regionName) {
        return TableName.valueOf(HRegionInfo.getTableName(regionName));
    }

    public static byte[] getStartKey(byte[] regionName) throws IOException {
        return HRegionInfo.parseRegionName(regionName)[1];
    }

    public static byte[][] parseRegionName(byte[] regionName) throws IOException {
        int offset = -1;
        for (int i = 0; i < regionName.length; ++i) {
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            throw new IOException("Invalid regionName format: " + Bytes.toStringBinary(regionName));
        }
        byte[] tableName = new byte[offset];
        System.arraycopy(regionName, 0, tableName, 0, offset);
        offset = -1;
        int endOffset = regionName.length;
        if (regionName.length > 34 && regionName[regionName.length - 1] == 46 && regionName[regionName.length - 32 - 2] == 46) {
            endOffset = endOffset - 32 - 2;
        }
        byte[] replicaId = null;
        int idEndOffset = endOffset;
        for (int i = endOffset - 1; i > 0; --i) {
            if (regionName[i] == 95) {
                replicaId = new byte[endOffset - i - 1];
                System.arraycopy(regionName, i + 1, replicaId, 0, endOffset - i - 1);
                idEndOffset = i;
            }
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            throw new IOException("Invalid regionName format: " + Bytes.toStringBinary(regionName));
        }
        byte[] startKey = HConstants.EMPTY_BYTE_ARRAY;
        if (offset != tableName.length + 1) {
            startKey = new byte[offset - tableName.length - 1];
            System.arraycopy(regionName, tableName.length + 1, startKey, 0, offset - tableName.length - 1);
        }
        byte[] id = new byte[idEndOffset - offset - 1];
        System.arraycopy(regionName, offset + 1, id, 0, idEndOffset - offset - 1);
        byte[][] elements = new byte[replicaId == null ? 3 : 4][];
        elements[0] = tableName;
        elements[1] = startKey;
        elements[2] = id;
        if (replicaId != null) {
            elements[3] = replicaId;
        }
        return elements;
    }

    public long getRegionId() {
        return this.regionId;
    }

    public byte[] getRegionName() {
        return this.regionName;
    }

    public String getRegionNameAsString() {
        if (HRegionInfo.hasEncodedName(this.regionName)) {
            return Bytes.toStringBinary(this.regionName);
        }
        return Bytes.toStringBinary(this.regionName) + "." + this.getEncodedName();
    }

    public synchronized String getEncodedName() {
        if (this.encodedName == null) {
            this.encodedName = HRegionInfo.encodeRegionName(this.regionName);
        }
        return this.encodedName;
    }

    public synchronized byte[] getEncodedNameAsBytes() {
        if (this.encodedNameAsBytes == null) {
            this.encodedNameAsBytes = Bytes.toBytes(this.getEncodedName());
        }
        return this.encodedNameAsBytes;
    }

    public byte[] getStartKey() {
        return this.startKey;
    }

    public byte[] getEndKey() {
        return this.endKey;
    }

    @Deprecated
    public byte[] getTableName() {
        return this.getTable().toBytes();
    }

    public TableName getTable() {
        if (this.tableName == null || this.tableName.getName().length == 0) {
            this.tableName = HRegionInfo.getTable(this.getRegionName());
        }
        return this.tableName;
    }

    public boolean containsRange(byte[] rangeStartKey, byte[] rangeEndKey) {
        if (Bytes.compareTo(rangeStartKey, rangeEndKey) > 0) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary(rangeStartKey) + " > " + Bytes.toStringBinary(rangeEndKey));
        }
        boolean firstKeyInRange = Bytes.compareTo(rangeStartKey, this.startKey) >= 0;
        boolean lastKeyInRange = Bytes.compareTo(rangeEndKey, this.endKey) < 0 || Bytes.equals(this.endKey, HConstants.EMPTY_BYTE_ARRAY);
        return firstKeyInRange && lastKeyInRange;
    }

    public boolean containsRow(byte[] row) {
        return Bytes.compareTo(row, this.startKey) >= 0 && (Bytes.compareTo(row, this.endKey) < 0 || Bytes.equals(this.endKey, HConstants.EMPTY_BYTE_ARRAY));
    }

    public boolean isMetaTable() {
        return this.isMetaRegion();
    }

    public boolean isMetaRegion() {
        return this.tableName.equals(FIRST_META_REGIONINFO.getTable());
    }

    public boolean isSystemTable() {
        return this.tableName.isSystemTable();
    }

    public boolean isSplit() {
        return this.split;
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    public boolean isOffline() {
        return this.offLine;
    }

    public void setOffline(boolean offLine) {
        this.offLine = offLine;
    }

    public boolean isSplitParent() {
        if (!this.isSplit()) {
            return false;
        }
        if (!this.isOffline()) {
            LOG.warn((Object)("Region is split but NOT offline: " + this.getRegionNameAsString()));
        }
        return true;
    }

    public int getReplicaId() {
        return this.replicaId;
    }

    public String toString() {
        return "{ENCODED => " + this.getEncodedName() + ", " + "NAME" + " => '" + Bytes.toStringBinary(this.regionName) + "', STARTKEY => '" + Bytes.toStringBinary(this.startKey) + "', ENDKEY => '" + Bytes.toStringBinary(this.endKey) + "'" + (this.isOffline() ? ", OFFLINE => true" : "") + (this.isSplit() ? ", SPLIT => true" : "") + (this.replicaId > 0 ? ", REPLICA_ID => " + this.replicaId : "") + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof HRegionInfo)) {
            return false;
        }
        return this.compareTo((HRegionInfo)o) == 0;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Deprecated
    public byte getVersion() {
        return 1;
    }

    @Deprecated
    public void write(DataOutput out) throws IOException {
        out.writeByte(this.getVersion());
        Bytes.writeByteArray(out, this.endKey);
        out.writeBoolean(this.offLine);
        out.writeLong(this.regionId);
        Bytes.writeByteArray(out, this.regionName);
        out.writeBoolean(this.split);
        Bytes.writeByteArray(out, this.startKey);
        Bytes.writeByteArray(out, this.tableName.getName());
        out.writeInt(this.hashCode);
    }

    @Deprecated
    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version == 0) {
            this.endKey = Bytes.readByteArray(in);
            this.offLine = in.readBoolean();
            this.regionId = in.readLong();
            this.regionName = Bytes.readByteArray(in);
            this.split = in.readBoolean();
            this.startKey = Bytes.readByteArray(in);
            try {
                HTableDescriptor htd = new HTableDescriptor();
                htd.readFields(in);
                this.tableName = htd.getTableName();
            }
            catch (EOFException eofe) {
                throw new IOException("HTD not found in input buffer", eofe);
            }
            this.hashCode = in.readInt();
        } else if (this.getVersion() == version) {
            this.endKey = Bytes.readByteArray(in);
            this.offLine = in.readBoolean();
            this.regionId = in.readLong();
            this.regionName = Bytes.readByteArray(in);
            this.split = in.readBoolean();
            this.startKey = Bytes.readByteArray(in);
            this.tableName = TableName.valueOf(Bytes.readByteArray(in));
            this.hashCode = in.readInt();
        } else {
            throw new IOException(String.format("Non-migratable/unknown version = %d, possible values are 0 and %d", version, this.getVersion()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private void readFields(byte[] bytes, int offset, int len) throws IOException {
        if (bytes == null || len <= 0) {
            throw new IllegalArgumentException("Can't build a writable with empty bytes array");
        }
        try (DataInputBuffer in = new DataInputBuffer();){
            in.reset(bytes, offset, len);
            this.readFields((DataInput)in);
        }
    }

    @Override
    public int compareTo(HRegionInfo o) {
        if (o == null) {
            return 1;
        }
        int result = this.tableName.compareTo(o.tableName);
        if (result != 0) {
            return result;
        }
        result = Bytes.compareTo(this.startKey, o.startKey);
        if (result != 0) {
            return result;
        }
        result = Bytes.compareTo(this.endKey, o.endKey);
        if (result != 0) {
            if (this.getStartKey().length != 0 && this.getEndKey().length == 0) {
                return 1;
            }
            if (o.getStartKey().length != 0 && o.getEndKey().length == 0) {
                return -1;
            }
            return result;
        }
        if (this.regionId > o.regionId) {
            return 1;
        }
        if (this.regionId < o.regionId) {
            return -1;
        }
        int replicaDiff = this.getReplicaId() - o.getReplicaId();
        if (replicaDiff != 0) {
            return replicaDiff;
        }
        if (this.offLine == o.offLine) {
            return 0;
        }
        if (this.offLine) {
            return -1;
        }
        return 1;
    }

    public KeyValue.KVComparator getComparator() {
        return this.isMetaRegion() ? KeyValue.META_COMPARATOR : KeyValue.COMPARATOR;
    }

    HBaseProtos.RegionInfo convert() {
        return HRegionInfo.convert(this);
    }

    public static HBaseProtos.RegionInfo convert(HRegionInfo info) {
        if (info == null) {
            return null;
        }
        HBaseProtos.RegionInfo.Builder builder = HBaseProtos.RegionInfo.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(info.getTable()));
        builder.setRegionId(info.getRegionId());
        if (info.getStartKey() != null) {
            builder.setStartKey(ByteStringer.wrap(info.getStartKey()));
        }
        if (info.getEndKey() != null) {
            builder.setEndKey(ByteStringer.wrap(info.getEndKey()));
        }
        builder.setOffline(info.isOffline());
        builder.setSplit(info.isSplit());
        builder.setReplicaId(info.getReplicaId());
        return builder.build();
    }

    public static HRegionInfo convert(HBaseProtos.RegionInfo proto) {
        if (proto == null) {
            return null;
        }
        TableName tableName = ProtobufUtil.toTableName(proto.getTableName());
        if (tableName.equals(TableName.META_TABLE_NAME)) {
            return RegionReplicaUtil.getRegionInfoForReplica(FIRST_META_REGIONINFO, proto.getReplicaId());
        }
        long regionId = proto.getRegionId();
        int replicaId = proto.hasReplicaId() ? proto.getReplicaId() : 0;
        byte[] startKey = null;
        byte[] endKey = null;
        if (proto.hasStartKey()) {
            startKey = proto.getStartKey().toByteArray();
        }
        if (proto.hasEndKey()) {
            endKey = proto.getEndKey().toByteArray();
        }
        boolean split = false;
        if (proto.hasSplit()) {
            split = proto.getSplit();
        }
        HRegionInfo hri = new HRegionInfo(tableName, startKey, endKey, split, regionId, replicaId);
        if (proto.hasOffline()) {
            hri.setOffline(proto.getOffline());
        }
        return hri;
    }

    public byte[] toByteArray() {
        byte[] bytes = this.convert().toByteArray();
        return ProtobufUtil.prependPBMagic(bytes);
    }

    public static HRegionInfo parseFromOrNull(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return HRegionInfo.parseFromOrNull(bytes, 0, bytes.length);
    }

    public static HRegionInfo parseFromOrNull(byte[] bytes, int offset, int len) {
        if (bytes == null || len <= 0) {
            return null;
        }
        try {
            return HRegionInfo.parseFrom(bytes, offset, len);
        }
        catch (DeserializationException e) {
            return null;
        }
    }

    public static HRegionInfo parseFrom(byte[] bytes) throws DeserializationException {
        if (bytes == null) {
            return null;
        }
        return HRegionInfo.parseFrom(bytes, 0, bytes.length);
    }

    public static HRegionInfo parseFrom(byte[] bytes, int offset, int len) throws DeserializationException {
        if (ProtobufUtil.isPBMagicPrefix(bytes, offset, len)) {
            int pblen = ProtobufUtil.lengthOfPBMagic();
            try {
                HBaseProtos.RegionInfo.Builder builder = HBaseProtos.RegionInfo.newBuilder();
                ProtobufUtil.mergeFrom((Message.Builder)builder, bytes, pblen + offset, len - pblen);
                HBaseProtos.RegionInfo ri = builder.build();
                return HRegionInfo.convert(ri);
            }
            catch (IOException e) {
                throw new DeserializationException(e);
            }
        }
        try {
            HRegionInfo hri = new HRegionInfo();
            hri.readFields(bytes, offset, len);
            return hri;
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
    }

    public byte[] toDelimitedByteArray() throws IOException {
        return ProtobufUtil.toDelimitedByteArray((Message)this.convert());
    }

    @Deprecated
    public static Pair<HRegionInfo, ServerName> getHRegionInfoAndServerName(Result r) {
        HRegionInfo info = HRegionInfo.getHRegionInfo(r, HConstants.REGIONINFO_QUALIFIER);
        ServerName sn = HRegionInfo.getServerName(r);
        return new Pair<HRegionInfo, ServerName>(info, sn);
    }

    @Deprecated
    public static HRegionInfo getHRegionInfo(Result data) {
        return HRegionInfo.getHRegionInfo(data, HConstants.REGIONINFO_QUALIFIER);
    }

    @Deprecated
    public static PairOfSameType<HRegionInfo> getDaughterRegions(Result data) throws IOException {
        HRegionInfo splitA = HRegionInfo.getHRegionInfo(data, HConstants.SPLITA_QUALIFIER);
        HRegionInfo splitB = HRegionInfo.getHRegionInfo(data, HConstants.SPLITB_QUALIFIER);
        return new PairOfSameType<HRegionInfo>(splitA, splitB);
    }

    @Deprecated
    public static PairOfSameType<HRegionInfo> getMergeRegions(Result data) throws IOException {
        HRegionInfo mergeA = HRegionInfo.getHRegionInfo(data, HConstants.MERGEA_QUALIFIER);
        HRegionInfo mergeB = HRegionInfo.getHRegionInfo(data, HConstants.MERGEB_QUALIFIER);
        return new PairOfSameType<HRegionInfo>(mergeA, mergeB);
    }

    @Deprecated
    public static HRegionInfo getHRegionInfo(Result r, byte[] qualifier) {
        Cell cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, qualifier);
        if (cell == null) {
            return null;
        }
        return HRegionInfo.parseFromOrNull(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    @Deprecated
    public static ServerName getServerName(Result r) {
        Cell cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
        if (cell == null || cell.getValueLength() == 0) {
            return null;
        }
        String hostAndPort = Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
        cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER);
        if (cell == null || cell.getValueLength() == 0) {
            return null;
        }
        try {
            return ServerName.valueOf(hostAndPort, Bytes.toLong(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Ignoring invalid region for server " + hostAndPort + "; cell=" + cell), (Throwable)e);
            return null;
        }
    }

    @Deprecated
    public static long getSeqNumDuringOpen(Result r) {
        Cell cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, HConstants.SEQNUM_QUALIFIER);
        if (cell == null || cell.getValueLength() == 0) {
            return -1L;
        }
        return Bytes.toLong(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    public static HRegionInfo parseFrom(DataInputStream in) throws IOException {
        int read;
        int pblen = ProtobufUtil.lengthOfPBMagic();
        byte[] pbuf = new byte[pblen];
        if (in.markSupported()) {
            in.mark(pblen);
        }
        if ((read = in.read(pbuf)) != pblen) {
            throw new IOException("read=" + read + ", wanted=" + pblen);
        }
        if (ProtobufUtil.isPBMagicPrefix(pbuf)) {
            return HRegionInfo.convert(HBaseProtos.RegionInfo.parseDelimitedFrom(in));
        }
        if (in.markSupported()) {
            in.reset();
            HRegionInfo hri = new HRegionInfo();
            hri.readFields(in);
            return hri;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(pbuf);
        SequenceInputStream sis = new SequenceInputStream(bais, in);
        HRegionInfo hri = new HRegionInfo();
        hri.readFields(new DataInputStream(sis));
        return hri;
    }

    public static byte[] toDelimitedByteArray(HRegionInfo ... infos) throws IOException {
        byte[][] bytes = new byte[infos.length][];
        int size = 0;
        for (int i = 0; i < infos.length; ++i) {
            bytes[i] = infos[i].toDelimitedByteArray();
            size += bytes[i].length;
        }
        byte[] result = new byte[size];
        int offset = 0;
        for (byte[] b : bytes) {
            System.arraycopy(b, 0, result, offset, b.length);
            offset += b.length;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HRegionInfo> parseDelimitedFrom(byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            throw new IllegalArgumentException("Can't build an object with empty bytes array");
        }
        ArrayList<HRegionInfo> hris = new ArrayList<HRegionInfo>();
        try (DataInputBuffer in = new DataInputBuffer();){
            in.reset(bytes, offset, length);
            while (in.available() > 0) {
                HRegionInfo hri = HRegionInfo.parseFrom((DataInputStream)in);
                hris.add(hri);
            }
        }
        return hris;
    }

    public static boolean areAdjacent(HRegionInfo regionA, HRegionInfo regionB) {
        if (regionA == null || regionB == null) {
            throw new IllegalArgumentException("Can't check whether adjacent for null region");
        }
        HRegionInfo a = regionA;
        HRegionInfo b = regionB;
        if (Bytes.compareTo(a.getStartKey(), b.getStartKey()) > 0) {
            a = regionB;
            b = regionA;
        }
        return Bytes.compareTo(a.getEndKey(), b.getStartKey()) == 0;
    }
}

